package de.cidaas.jwt;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

import org.bouncycastle.util.io.pem.PemReader;

public class RSAKeyHelper {

	public static RSAPrivateKey parsePrivateKey(String content) throws Exception {
		try {
			PemReader privateKeyPemReader = new PemReader(new BufferedReader(new StringReader(content)));
			RSAPrivateKey privateKey = (RSAPrivateKey) RsaUtils
					.bytesToPrivateKey(privateKeyPemReader.readPemObject().getContent());
			privateKeyPemReader.close();
			return privateKey;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	public static RSAPublicKey parsePublicKey(String content) throws IOException, GeneralSecurityException {
		try {
			PemReader publicKeyPemReader = new PemReader(new BufferedReader(new StringReader(content)));
			RSAPublicKey publicKey = (RSAPublicKey) RsaUtils
					.bytesToPublicKey(publicKeyPemReader.readPemObject().getContent());
			publicKeyPemReader.close();
			return publicKey;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	public static RSAPrivateKey getPrivateKey(String filename) throws IOException, GeneralSecurityException {
		try {
			PemReader privateKeyPemReader = new PemReader(new BufferedReader(new FileReader(filename)));
			RSAPrivateKey privateKey = (RSAPrivateKey) RsaUtils
					.bytesToPrivateKey(privateKeyPemReader.readPemObject().getContent());
			privateKeyPemReader.close();
			return privateKey;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	public static RSAPublicKey getPublicKey(String filename) throws IOException, GeneralSecurityException {
		try {
			PemReader publicKeyPemReader = new PemReader(new BufferedReader(new FileReader(filename)));
			RSAPublicKey publicKey = (RSAPublicKey) RsaUtils
					.bytesToPublicKey(publicKeyPemReader.readPemObject().getContent());
			publicKeyPemReader.close();
			return publicKey;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}

	}
}
