/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.jwt.JWS;
import de.cidaas.jwt.TokenTypes;
import de.cidaas.oauth.model.TokenIntrospectionRequest;
import de.cidaas.oauth.model.TokenIntrospectionResponse;
import de.cidaas.oauth.util.CidaasConfigResolver;
import de.cidaas.oauth.util.OpenIdConfiguration;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ValidateToken {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateToken.class);
    private JWS jws;
    private ObjectMapper om = this.om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    private static ValidateToken _validateToken;

    public static synchronized ValidateToken getInstance() {
        if (_validateToken == null) {
            _validateToken = new ValidateToken();
        }
        return _validateToken;
    }

    public ValidateToken() {
        this.jws = new JWS();
    }

    public TokenIntrospectionResponse validateAccessToken(TokenIntrospectionRequest tokenInfo) {
        TokenIntrospectionResponse tokenIntrospectionResponse = new TokenIntrospectionResponse();
        if (StringUtils.isEmpty((Object)tokenInfo.getToken())) {
            tokenIntrospectionResponse.setActive(false);
            return tokenIntrospectionResponse;
        }
        if (this.jws.getTokenType(tokenInfo.getToken()) == TokenTypes.JWS) {
            return this.validateTokenInRemote(tokenInfo);
        }
        if (this.jws.getTokenType(tokenInfo.getToken()) == TokenTypes.JWE) {
            return this.validateTokenInRemote(tokenInfo);
        }
        return this.validateTokenInRemote(tokenInfo);
    }

    private TokenIntrospectionResponse validateTokenInRemote(TokenIntrospectionRequest tokenInfo) {
        TokenIntrospectionResponse tokenIntrospectionResponse = new TokenIntrospectionResponse();
        try {
            CidaasConfigResolver cidaasConfigResolver = CidaasConfigResolver.getInstance();
            OpenIdConfiguration openIdConfiguration = cidaasConfigResolver.openIdConfiguration;
            tokenInfo.setClient_id(cidaasConfigResolver.client_id);
            tokenInfo.setClient_secret(cidaasConfigResolver.client_secret);
            HttpPost resetPost = new HttpPost(new URI(openIdConfiguration.getIntrospection_endpoint()));
            if (tokenInfo != null) {
                StringEntity se = new StringEntity(this.om.writeValueAsString((Object)tokenInfo), ContentType.APPLICATION_JSON);
                resetPost.setEntity((HttpEntity)se);
                resetPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            }
            CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)resetPost);
            int responseStatusCode = response.getStatusLine().getStatusCode();
            String tokenValidationResponse = "";
            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuffer resultData = new StringBuffer();
                String line = "";
                while ((line = rd.readLine()) != null) {
                    resultData.append(line);
                }
                tokenValidationResponse = resultData.toString();
                LOG.info("Token validation Response : {}", (Object)tokenValidationResponse);
            }
            if (responseStatusCode == 200) {
                return (TokenIntrospectionResponse)this.om.readValue(tokenValidationResponse, TokenIntrospectionResponse.class);
            }
            LOG.error("Non Success status code from Introspection Endpoint.");
        }
        catch (Exception ex) {
            LOG.error("Exception at getUserInfoByToken {}", (Throwable)ex);
        }
        return tokenIntrospectionResponse;
    }
}

