/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class KeycloakPublicKeyService {
    @Value(value="${keycloak.publicCertsUrl}")
    private String certificatesUrl;
    @Autowired
    ObjectMapper objectMapper;

    @Cacheable(value={"keycloakPublicKeys"})
    public PublicKey publicKey(String keyId) throws Exception {
        Map keys = (Map)this.objectMapper.readValue(new URL(this.certificatesUrl).openStream(), Map.class);
        Map keyInfo = ((List)keys.get("keys")).stream().filter(e -> keyId.equals(e.get("kid"))).findFirst().get();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        String modulusBase64 = (String)keyInfo.get("n");
        String exponentBase64 = (String)keyInfo.get("e");
        Base64.Decoder urlDecoder = Base64.getUrlDecoder();
        BigInteger modulus = new BigInteger(1, urlDecoder.decode(modulusBase64));
        BigInteger publicExponent = new BigInteger(1, urlDecoder.decode(exponentBase64));
        return keyFactory.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
    }
}

