package de.cidaas.oauth.model;

/**
 * The Class OAuthUser.
 *
 * @author Michael Scheuner
 */
public class OAuthUser {

	/** The oauth token. */
	final private String oauthToken;

	/** The user id. */
	final private String userId;

	/**
	 * Instantiates a new o auth user.
	 *
	 * @param oauthToken
	 *          the oauth token
	 * @param userId
	 *          the user id
	 */
	public OAuthUser(String oauthToken, String userId) {
		this.oauthToken = oauthToken;
		this.userId = userId;
	}

	/**
	 * Gets the oauth token.
	 *
	 * @return the oauth token
	 */
	public String getOauthToken() {
		return oauthToken;
	}

	/**
	 * Gets the user id.
	 *
	 * @return the user id
	 */
	public String getUserId() {
		return userId;
	}

}