package de.cidaas.oauth.interceptor;

import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.error.OAuthError;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.AbstractValidator;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

public class BearerHeaderOAuthValidator extends AbstractValidator<HttpServletRequest>{
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.oltu.oauth2.common.validators.AbstractValidator#
	 * validateContentType(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.oltu.oauth2.common.validators.AbstractValidator#
	 * validateMethod( javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.oltu.oauth2.common.validators.AbstractValidator#
	 * validateRequiredParameters(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
		boolean cidaasStyle = false;
		// Check if there is the Authorization Header
		String authzHeader = request.getHeader(OAuth.HeaderType.AUTHORIZATION);
		if (OAuthUtils.isEmpty(authzHeader)) {
			authzHeader = request.getHeader(Constants.get_tokenKey());
			if (OAuthUtils.isEmpty(authzHeader)) {
				throw OAuthProblemException.error("", "Missing authorization header.");
			}
			cidaasStyle = true;
		}

		if (!cidaasStyle) {
			// See if the authorization method is set to OAuth
			String authzMethod = OAuthUtils.getAuthzMethod(authzHeader);
			if (!OAuth.OAUTH_HEADER_NAME.equals(authzMethod)) {
				throw OAuthProblemException.error("", "Incorrect authorization method.");
			}

			// Get the header field
			String headerField = OAuthUtils.getAuthHeaderField(authzHeader);
			if (OAuthUtils.isEmpty(headerField)) {
				throw OAuthProblemException.error(OAuthError.TokenResponse.INVALID_REQUEST,
						"Missing required parameter.");
			}
		}

		// Check if this OAuth 1.0 or OAuth 2.0
		Map<String, String> values = OAuthUtils.decodeOAuthHeader(authzHeader);
		String oauthVersionDiff = values.get(OAuth.OAUTH_VERSION_DIFFER);
		if (!OAuthUtils.isEmpty(oauthVersionDiff)) {
			throw OAuthProblemException.error(OAuthError.TokenResponse.INVALID_REQUEST,
					"Incorrect OAuth version. Found OAuth V1.0.");
		}
	}
}
