package de.cidaas.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.cidaas.oauth.util.DecodeToken;

@Service
public class TokenAuthenticationProvider implements AuthenticationProvider {

	@Override
	public Authentication authenticate(Authentication authentication) throws AuthenticationException {
		if (!supports(authentication.getClass())) {
			return null;
		}

		TokenAuthentication tokenAuthentication = (TokenAuthentication) authentication;
		String userDetails = DecodeToken.getUserInfo(tokenAuthentication.getToken());
		Map<String, String> map = null;
		try {
			map = new ObjectMapper().readValue(userDetails, Map.class);
		} catch (JsonParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JsonMappingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();

		if (map.containsKey("roles")) {
//
//			Object role = map.get("roles");
//
//			authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
			if (map.containsKey("roles")) {

				Object rolesObj = map.get("roles");				
				String roles=rolesObj.toString().replace("[", "").replace("]", "");
				final String[] roleList=roles.split(",");
				for (String value : roleList) {
					authorities.add(new SimpleGrantedAuthority("ROLE_" +value.trim()));
				}
								
			}

		} else {

			if (map.containsKey("scopes")) {

				Object scopeObj = map.get("scopes");				
				String scopes=scopeObj.toString().replace("[", "").replace("]", "");
				final String[] scopeList=scopes.split(",");
				for (String value : scopeList) {
					authorities.add(new SimpleGrantedAuthority(value.trim()));
				}
								
			}
		}

		tokenAuthentication.setDetails(map);
		tokenAuthentication.setAuthorities(authorities);
		tokenAuthentication.setPrincipal(userDetails);
		tokenAuthentication.setName(map.get("given_name"));
		tokenAuthentication.setAuthenticated(true);

		return tokenAuthentication;
	}

	public <T> List<T> getValues(Map<?, T> map) {
		return new ArrayList<>(map.values());
	}

	@Override
	public boolean supports(Class<?> arg0) {
		return (TokenAuthentication.class.isAssignableFrom(arg0));
	}
}
