package de.cidaas.oauth.interceptor;

import java.net.URI;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.cidaas.jwt.JWS;
import de.cidaas.jwt.TokenTypes;
import de.cidaas.oauth.cache.LRUCache;
import de.cidaas.oauth.model.TokenIntrospectionRequest;
import de.cidaas.oauth.model.TokenIntrospectionResponse;
import de.cidaas.oauth.util.OpenIdConfiguration;
import de.cidaas.oauth.util.CidaasConfigResolver;

public class ValidateToken {
	private static final Logger LOG = LoggerFactory.getLogger(TokenHelper.class);
	LRUCache tokenCache = LRUCache.getInstance();

	private JWS jws;
	private ObjectMapper om;

	private static ValidateToken _validateToken;

	public static synchronized ValidateToken getInstance() {
		if (_validateToken == null) {
			_validateToken = new ValidateToken();
		}
		return _validateToken;
	}

	public ValidateToken() {
		om = new ObjectMapper();
		om = om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		om = om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
		jws = new JWS();
	}

	public TokenIntrospectionResponse validateAccessToken(TokenIntrospectionRequest tokenInfo) {

		TokenIntrospectionResponse tokenIntrospectionResponse = new TokenIntrospectionResponse();

		if (StringUtils.isEmpty(tokenInfo.getToken())) {
			tokenIntrospectionResponse.setActive(false);
			return tokenIntrospectionResponse;
		}

		if (jws.getTokenType(tokenInfo.getToken()) == TokenTypes.JWS) {
			return validateTokenInRemote(tokenInfo);
		} else if (jws.getTokenType(tokenInfo.getToken()) == TokenTypes.JWE) {
			return validateTokenInRemote(tokenInfo);
		} else {
			return validateTokenInRemote(tokenInfo);
		}

	}

	private TokenIntrospectionResponse validateTokenInRemote(TokenIntrospectionRequest tokenInfo) {

		TokenIntrospectionResponse tokenIntrospectionResponse = new TokenIntrospectionResponse();
		try {

			OpenIdConfiguration openIdConfiguration = CidaasConfigResolver.getInstance().openIdConfiguration;

			HttpPost resetPost = new HttpPost(new URI(openIdConfiguration.getIntrospection_endpoint()));

			resetPost.addHeader("Authorization ", "Bearer " + tokenInfo.getToken());

			if (tokenInfo != null) {
				StringEntity se = new StringEntity(om.writeValueAsString(tokenInfo), ContentType.APPLICATION_JSON);
				resetPost.setEntity(se);
				resetPost.addHeader(HTTP.CONTENT_TYPE, "application/json; charset=UTF-8");
			}

			HttpResponse response = HttpClientBuilder.create().build().execute(resetPost);
			int responseStatusCode = response.getStatusLine().getStatusCode();

			if (responseStatusCode == HttpStatus.SC_OK) {
				return om.readValue(response.getEntity().getContent(), TokenIntrospectionResponse.class);
			} else {
				LOG.error("Non Success status code from Introspection Endpoint.");
			}
		} catch (Exception ex) {
			LOG.error("Exception at getUserInfoByToken {}", ex);
		}
		return tokenIntrospectionResponse;
	}

}
