/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.control;

import de.carne.boot.logging.Log;
import de.carne.boot.logging.LogLevel;
import de.carne.jfx.scene.control.AlertsI18N;
import de.carne.jfx.scene.control.DialogHelper;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.eclipse.jdt.annotation.Nullable;

public final class Alerts {
    private static Log LOG = new Log();

    private Alerts() {
    }

    public static Alert unexpected(Throwable throwable) {
        return Alerts.error(Alert.AlertType.ERROR, AlertsI18N.formatSTR_MESSAGE_UNEXPECTED_ERROR(new Object[0]), throwable);
    }

    public static Alert error(Alert.AlertType type, String message, Throwable throwable) {
        Alerts.logAlertMessage(type, message, throwable);
        Alert alert = new Alert(type, message, new ButtonType[]{ButtonType.OK});
        alert.setHeaderText(AlertsI18N.formatSTR_MESSAGE_APPLICATION_ERROR(new Object[0]));
        return DialogHelper.setExceptionContent(alert, throwable);
    }

    public static Alert message(Alert.AlertType type, String message, ButtonType ... buttons) {
        return new Alert(type, message, buttons);
    }

    public static Alert logs(Alert.AlertType type, String message, Collection<LogRecord> logs) {
        Alerts.logAlertMessage(type, message, null);
        Alert alert = new Alert(type, message, new ButtonType[]{ButtonType.OK});
        alert.setHeaderText(AlertsI18N.formatSTR_MESSAGE_APPLICATION_ERROR(new Object[0]));
        return DialogHelper.setLogRecordsContent(alert, logs);
    }

    private static void logAlertMessage(Alert.AlertType type, String message, @Nullable Throwable throwable) {
        if (Alert.AlertType.ERROR.equals((Object)type)) {
            LOG.log((Level)LogLevel.LEVEL_ERROR, throwable, message, new Object[0]);
        } else if (Alert.AlertType.WARNING.equals((Object)type)) {
            LOG.log((Level)LogLevel.LEVEL_WARNING, throwable, message, new Object[0]);
        } else if (Alert.AlertType.INFORMATION.equals((Object)type)) {
            LOG.log((Level)LogLevel.LEVEL_INFO, throwable, message, new Object[0]);
        }
    }
}

