/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.application;

import de.carne.boot.Exceptions;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.image.Image;

public final class PlatformHelper {
    private static final Image[] EMPTY_ICONS = new Image[0];

    private PlatformHelper() {
    }

    public static Runnable runLaterRunnable(Runnable runnable) {
        return () -> {
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                CountDownLatch latch = new CountDownLatch(1);
                Platform.runLater(() -> {
                    try {
                        runnable.run();
                    }
                    finally {
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Exceptions.ignore((Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    public static <R> R runLater(Supplier<R> supplier) {
        R result;
        if (Platform.isFxApplicationThread()) {
            result = supplier.get();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<Object> resultHolder = new AtomicReference<Object>(null);
            Platform.runLater(() -> {
                try {
                    resultHolder.set(supplier.get());
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Exceptions.ignore((Throwable)e);
                Thread.currentThread().interrupt();
            }
            result = resultHolder.get();
        }
        return result;
    }

    public static void runLater(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                try {
                    runnable.run();
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Exceptions.ignore((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static Image[] stageIcons(Image ... icons) {
        if (de.carne.boot.platform.Platform.IS_MACOS) {
            return EMPTY_ICONS;
        }
        return icons;
    }

    public static Collection<Image> stageIcons(Collection<Image> icons) {
        if (de.carne.boot.platform.Platform.IS_MACOS) {
            return Collections.emptyList();
        }
        return icons;
    }
}

