/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.stage.logview;

import de.carne.check.Nullable;
import de.carne.jfx.application.PlatformHelper;
import de.carne.jfx.scene.control.Alerts;
import de.carne.jfx.scene.control.cell.ImageViewTableCell;
import de.carne.jfx.stage.StageController;
import de.carne.jfx.stage.logview.LogRecordDate;
import de.carne.jfx.stage.logview.LogRecordModel;
import de.carne.jfx.stage.logview.LogViewI18N;
import de.carne.jfx.util.FileChooserHelper;
import de.carne.util.logging.Log;
import de.carne.util.logging.LogBuffer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

public class LogViewController
extends StageController {
    private static final Log LOG = new Log();
    private final Handler logHandler = new Handler(){

        @Override
        public void publish(@Nullable LogRecord record) {
            if (record != null) {
                PlatformHelper.runLater(() -> LogViewController.this.onPublish(record));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    private final ChangeListener<Boolean> toggleListener = (p, o, n) -> this.onToggled((boolean)n);
    @Nullable
    private BooleanProperty toggleProperty = null;
    @FXML
    private TableView<LogRecordModel> ctlLogRecords;
    @FXML
    private TableColumn<LogRecordModel, Image> ctlLogRecordLevel;
    @FXML
    private TableColumn<LogRecordModel, LogRecordDate> ctlLogRecordTime;
    @FXML
    private TableColumn<LogRecordModel, String> ctlLogRecordThread;
    @FXML
    private TableColumn<LogRecordModel, String> ctlLogRecordMessage;

    @FXML
    private void onCmdClear(ActionEvent evt) {
        LogBuffer.clear((Logger)LOG.getLogger());
        this.ctlLogRecords.getItems().clear();
        LOG.notice("Log buffer cleared", new Object[0]);
    }

    @FXML
    private void onCmdExport(ActionEvent evt) {
        FileChooser chooser = new FileChooser();
        ArrayList<FileChooser.ExtensionFilter> extensionFilters = new ArrayList<FileChooser.ExtensionFilter>();
        extensionFilters.add(FileChooserHelper.filterFromString(LogViewI18N.formatSTR_FILTER_LOGFILES(new Object[0])));
        extensionFilters.add(FileChooserHelper.filterFromString(LogViewI18N.formatSTR_FILTER_TXTFILES(new Object[0])));
        extensionFilters.add(FileChooserHelper.filterFromString(LogViewI18N.formatSTR_FILTER_ALLFILES(new Object[0])));
        chooser.getExtensionFilters().addAll(extensionFilters);
        chooser.setSelectedExtensionFilter((FileChooser.ExtensionFilter)extensionFilters.get(0));
        File file = chooser.showSaveDialog((Window)this.getUI());
        if (file != null) {
            LOG.info("Exporting log buffer to file: ''{0}''...", new Object[]{file});
            try {
                LogBuffer.exportTo((Logger)LOG.getLogger(), (File)file);
            }
            catch (IOException e) {
                Alerts.unexpected(e).showAndWait();
            }
        }
    }

    @FXML
    private void onCmdClose(ActionEvent evt) {
        this.close(false);
    }

    @Nullable
    Void onPublish(LogRecord record) {
        ObservableList records = this.ctlLogRecords.getItems();
        while (records.size() >= LogBuffer.BUFFER_LIMIT) {
            records.remove(0);
        }
        records.add((Object)new LogRecordModel(record));
        int selectedIndex = this.ctlLogRecords.getSelectionModel().getSelectedIndex();
        int n = selectedIndex = selectedIndex < 0 ? 0 : selectedIndex + 1;
        if (selectedIndex + 1 == records.size()) {
            this.ctlLogRecords.getSelectionModel().select(selectedIndex);
            this.ctlLogRecords.scrollTo(selectedIndex);
        }
        return null;
    }

    private void onShowingChanged(boolean showing) {
        if (showing) {
            LogBuffer.addHandler((Logger)LOG.getLogger(), (Handler)this.logHandler);
        } else {
            LogBuffer.removeHandler((Logger)LOG.getLogger(), (Handler)this.logHandler);
            this.setToggle(null);
        }
    }

    private void onToggled(boolean selected) {
        if (!selected) {
            this.close(false);
        }
    }

    @Override
    protected StageStyle getStyle() {
        return StageStyle.UTILITY;
    }

    @Override
    protected Modality getModality() {
        return Modality.NONE;
    }

    @Override
    protected void setupStage(Stage stage) {
        stage.setTitle(LogViewI18N.formatSTR_STAGE_TITLE(new Object[0]));
        this.ctlLogRecordLevel.setCellFactory(ImageViewTableCell.forTableColumn());
        this.ctlLogRecordLevel.setCellValueFactory((Callback)new PropertyValueFactory("level"));
        this.ctlLogRecordTime.setCellValueFactory((Callback)new PropertyValueFactory("time"));
        this.ctlLogRecordThread.setCellValueFactory((Callback)new PropertyValueFactory("thread"));
        this.ctlLogRecordMessage.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        stage.showingProperty().addListener((p, o, n) -> this.onShowingChanged((boolean)n));
    }

    public LogViewController setToggle(@Nullable BooleanProperty toggleProperty) {
        BooleanProperty newToggleProperty;
        BooleanProperty oldToggleProperty = this.toggleProperty;
        if (oldToggleProperty != null) {
            oldToggleProperty.removeListener(this.toggleListener);
        }
        if ((newToggleProperty = (this.toggleProperty = toggleProperty)) != null) {
            newToggleProperty.addListener(this.toggleListener);
        }
        return this;
    }
}

