/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.fxml;

import de.carne.check.Check;
import de.carne.check.Nullable;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.stage.Window;

public abstract class FXMLController<U> {
    private static final Log LOG = new Log();
    private static final Pattern CONTROLLER_NAME_PATTERN = Pattern.compile("^(.*)\\.(.+)Controller$");
    @Nullable
    private ResourceBundle resources = null;
    @Nullable
    private U ui = null;

    final void setResources(ResourceBundle resources) {
        this.resources = resources;
    }

    protected final ResourceBundle getResources() {
        return (ResourceBundle)Check.nonNull((Object)this.resources);
    }

    final void setUI(U ui) {
        this.ui = ui;
    }

    public final U getUI() {
        return (U)Check.nonNull(this.ui);
    }

    public abstract Window getWindow();

    protected static <U, C extends FXMLController<U>> C loadUI(@Nullable Window owner, Function<C, U> uiFactory, Class<C> controllerClass) throws IOException {
        String controllerName = controllerClass.getName();
        LOG.debug("Loading UI for controller: {0}", new Object[]{controllerName});
        Matcher controllerNameMatcher = CONTROLLER_NAME_PATTERN.matcher(controllerName);
        if (!controllerNameMatcher.find()) {
            throw new IllegalArgumentException("Invalid controller class name: " + controllerName);
        }
        String baseName = controllerNameMatcher.group(2);
        String fxmlResourceName = baseName + ".fxml";
        String packageName = controllerNameMatcher.group(1);
        String bundleName = packageName + "." + baseName + "I18N";
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        FXMLLoader loader = new FXMLLoader(Objects.requireNonNull(controllerClass.getResource(fxmlResourceName)), bundle);
        Parent fxmlRoot = (Parent)loader.load();
        FXMLController controller = (FXMLController)loader.getController();
        controller.setResources(loader.getResources());
        U ui = uiFactory.apply(controller);
        controller.setUI(ui);
        controller.setupUI(owner, ui, fxmlRoot);
        return (C)controller;
    }

    protected abstract void setupUI(@Nullable Window var1, U var2, Parent var3);
}

