/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.ApplicationLoader;
import de.carne.check.Nullable;
import de.carne.util.Exceptions;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class AboutInfo {
    public static final String PROJECT_ID;
    public static final String PROJECT_NAME;
    public static final String PROJECT_VERSION;
    public static final String PROJECT_BUILD;

    private AboutInfo() {
    }

    private static String getAttributeValue(@Nullable Attributes attributes, String name) {
        String value = attributes != null ? attributes.getValue(name) : null;
        return value != null ? value : "?";
    }

    static {
        Attributes attributes = null;
        try (JarFile codeJar = ApplicationLoader.getApplicationJarFile();){
            Manifest manifest;
            if (codeJar != null && (manifest = codeJar.getManifest()) != null) {
                attributes = manifest.getMainAttributes();
            }
        }
        catch (Exception e) {
            Exceptions.warn(e);
        }
        PROJECT_ID = AboutInfo.getAttributeValue(attributes, "X-Version-ProjectId");
        PROJECT_NAME = AboutInfo.getAttributeValue(attributes, "X-Version-ProjectName");
        PROJECT_VERSION = AboutInfo.getAttributeValue(attributes, "X-Version-ProjectVersion");
        PROJECT_BUILD = AboutInfo.getAttributeValue(attributes, "X-Version-ProjectBuild");
    }
}

