/*
 * Copyright (c) 2016 Holger de Carne and contributors, All Rights Reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser Public License for more details.
 *
 * You should have received a copy of the GNU Lesser Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.carne.nio.compression.deflate;

/**
 * Supported Deflate modes.
 */
public enum DeflateMode {

	/**
	 * Process zlib data stream (only for decoding).
	 */
	FORMAT_ZLIB,

	/**
	 * Process NSIS data stream (only for decoding).
	 */
	FORMAT_NSIS,

	/**
	 * Use 64k history.
	 */
	OPTION_HISTORY64K,

	/**
	 * Do not reset history during encoding/decoding.
	 */
	OPTION_KEEP_HISTORY,

	/**
	 * Restart block processing after EOS.
	 */
	OPTION_RESTART_AFTER_EOS

}
