/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

class PropertiesPreferences
extends AbstractPreferences {
    private static final Log LOG = new Log(PropertiesPreferences.class);
    private static final String KEY_SEPARATOR = "/";
    private final Path propertiesPath;
    private Properties properties;

    PropertiesPreferences(Path propertiesPath) {
        super(null, "");
        this.propertiesPath = propertiesPath.toAbsolutePath();
        this.properties = PropertiesPreferences.loadProperties(this.propertiesPath);
    }

    private PropertiesPreferences(PropertiesPreferences parent, String name) {
        super(parent, name);
        this.propertiesPath = parent.propertiesPath;
        this.properties = parent.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putSpi(String key, String value) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.put(this.nodePath() + key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getSpi(String key) {
        String value;
        Properties properties = this.properties;
        synchronized (properties) {
            value = this.properties.getProperty(this.nodePath() + key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeSpi(String key) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.remove(this.nodePath() + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        Properties properties = this.properties;
        synchronized (properties) {
            PropertiesPreferences.removeNodePath(this.properties, this.nodePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] keysSpi() throws BackingStoreException {
        String[] keys;
        Properties properties = this.properties;
        synchronized (properties) {
            keys = PropertiesPreferences.getNodeKeys(this.properties, this.nodePath());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        String[] children;
        Properties properties = this.properties;
        synchronized (properties) {
            children = PropertiesPreferences.getNodeChildren(this.properties, this.nodePath());
        }
        return children;
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new PropertiesPreferences(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        Properties properties = this.properties;
        synchronized (properties) {
            PropertiesPreferences.mergeProperties(this.properties, this.nodePath(), this.propertiesPath);
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    private static void mergeProperties(Properties properties, String nodePath, Path propertiesPath) throws BackingStoreException {
        LOG.info(null, "Merging preferences ''{0}'' to: ''{1}''", nodePath, propertiesPath);
        try {
            Files.createDirectories(propertiesPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        Properties mergedProperties = new Properties();
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            try (InputStream propertiesStream = Files.newInputStream(propertiesPath, StandardOpenOption.READ);){
                mergedProperties.load(propertiesStream);
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
        PropertiesPreferences.removeNodePath(mergedProperties, nodePath);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (PropertiesPreferences.getNodeKey(nodePath, key) == null) continue;
            mergedProperties.put(key, entry.getValue());
        }
        try (OutputStream propertiesStream = Files.newOutputStream(propertiesPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            mergedProperties.store(propertiesStream, null);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    private static Properties loadProperties(Path propertiesPath) {
        Properties properties = new Properties();
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            LOG.info(null, "Loading preferences from: ''{0}''", propertiesPath);
            try (InputStream propertiesStream = Files.newInputStream(propertiesPath, StandardOpenOption.READ);){
                properties.load(propertiesStream);
            }
            catch (IOException e) {
                LOG.warning(e, null, "Unable to load preferences from: ''{0}''", propertiesPath);
            }
        }
        return properties;
    }

    private static void removeNodePath(Properties properties, String nodePath) {
        Iterator<Object> keyIterator = properties.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next().toString();
            if (PropertiesPreferences.getNodeKey(nodePath, key) == null) continue;
            keyIterator.remove();
        }
    }

    private static String[] getNodeChildren(Properties properties, String nodePath) {
        HashSet<String> nodeChildren = new HashSet<String>(properties.size());
        Iterator<Object> keyIterator = properties.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next().toString();
            String nodeChild = PropertiesPreferences.getNodeChild(nodePath, key);
            if (nodeChild == null) continue;
            nodeChildren.add(nodeChild);
        }
        return nodeChildren.toArray(new String[nodeChildren.size()]);
    }

    private static String getNodeChild(String nodePath, String key) {
        int childEndIndex;
        String nodeChild = null;
        if (key.startsWith(nodePath) && (childEndIndex = key.indexOf(KEY_SEPARATOR, nodePath.length())) > 0) {
            nodeChild = key.substring(nodePath.length(), childEndIndex);
        }
        return nodeChild;
    }

    private static String[] getNodeKeys(Properties properties, String nodePath) {
        ArrayList<String> nodeKeys = new ArrayList<String>(properties.size());
        Iterator<Object> keyIterator = properties.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next().toString();
            String nodeKey = PropertiesPreferences.getNodeKey(nodePath, key);
            if (nodeKey == null) continue;
            nodeKeys.add(nodeKey);
        }
        return nodeKeys.toArray(new String[nodeKeys.size()]);
    }

    private static String getNodeKey(String nodePath, String key) {
        String nodeKey = null;
        if (key.startsWith(nodePath) && key.indexOf(KEY_SEPARATOR, nodePath.length()) < 0) {
            nodeKey = key.substring(nodePath.length());
        }
        return nodeKey;
    }

    private String nodePath() {
        return this.absolutePath() + KEY_SEPARATOR;
    }
}

