/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.Strings;
import de.carne.util.prefs.Preference;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;

public final class DirectoryPreference
extends Preference {
    public DirectoryPreference(String key) {
        super(key);
    }

    public File getAsFile(Preferences preferences) {
        return this.getAsFile(preferences, null);
    }

    public File getAsFile(Preferences preferences, File defaultDirectory) {
        Path path = this.getAsPath(preferences);
        return path != null ? path.toFile() : defaultDirectory;
    }

    public Path getAsPath(Preferences preferences) {
        return this.getAsPath(preferences, null);
    }

    public Path getAsPath(Preferences preferences, Path defaultDirectory) {
        assert (preferences != null);
        String pathString = preferences.get(this.key(), null);
        Path path = null;
        if (Strings.notEmpty(pathString)) {
            try {
                path = Paths.get(pathString, new String[0]).toAbsolutePath();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return path;
    }

    public void set(Preferences preferences, File directory) {
        this.set(preferences, directory != null ? directory.toPath() : null);
    }

    public void set(Preferences preferences, Path directory) {
        assert (preferences != null);
        if (directory != null) {
            preferences.put(this.key(), directory.toString());
        } else {
            preferences.remove(this.key());
        }
    }

    public void setFromFile(Preferences preferences, File file) {
        this.setFromFile(preferences, file != null ? file.toPath() : null);
    }

    public void setFromFile(Preferences preferences, Path file) {
        assert (preferences != null);
        if (file != null) {
            preferences.put(this.key(), file.getParent().toString());
        } else {
            preferences.remove(this.key());
        }
    }
}

