/*
 * Decompiled with CFR 0.152.
 */
package de.carne;

import de.carne.ApplicationLoader;
import de.carne.Main;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public abstract class MainLoader
implements Main {
    public static void main(String[] args) {
        int status = -1;
        try {
            status = MainLoader.init().newInstance().run(args);
        }
        catch (Throwable e) {
            MainLoader.printUncaughtException(e);
        }
        System.exit(status);
    }

    public static Class<? extends Main> init() {
        Class<Main> mainClass;
        try (InputStream initStream = ApplicationLoader.class.getResourceAsStream("Main");
             BufferedReader initReader = new BufferedReader(new InputStreamReader(initStream, StandardCharsets.UTF_8));){
            String propertyLine;
            String mainClassName = initReader.readLine();
            while ((propertyLine = initReader.readLine()) != null) {
                int splitIndex = propertyLine.indexOf(61);
                assert (splitIndex > 0);
                String propertyKey = propertyLine.substring(0, splitIndex).trim();
                String propertyValue = propertyLine.substring(splitIndex + 1).trim();
                System.setProperty(propertyKey, propertyValue);
            }
            mainClass = Class.forName(mainClassName).asSubclass(Main.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mainClass;
    }

    public static void printUncaughtException(Throwable cause) {
        MainLoader.printUncaughtException(System.err, cause);
    }

    public static void printUncaughtException(PrintStream ps, Throwable cause) {
        assert (cause != null);
        MainLoader.printCause(ps, cause);
        MainLoader.printThreads(ps);
        MainLoader.printRuntime(ps);
        MainLoader.printSystemProperties(ps);
        ps.print("--- End ---");
    }

    private static void printCause(PrintStream ps, Throwable cause) {
        String exceptionName = cause.getClass().getName();
        String threadName = Thread.currentThread().toString();
        ps.println("--- Unhandled exception '" + exceptionName + "' caught in thread '" + threadName + "' ---");
        cause.printStackTrace(ps);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement catchedAt = null;
        for (StackTraceElement caller : stackTrace) {
            if (caller.getClass().equals(MainLoader.class)) break;
            catchedAt = caller;
        }
        if (catchedAt != null) {
            ps.print("catched at ");
            ps.println(catchedAt);
        }
    }

    private static void printThreads(PrintStream ps) {
        Map<Thread, StackTraceElement[]> stackTraceMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> stackTraceEntry : stackTraceMap.entrySet()) {
            StackTraceElement[] stackTrace;
            Thread thread = stackTraceEntry.getKey();
            if (thread.equals(Thread.currentThread())) continue;
            String threadName = thread.toString();
            ps.println("--- Thread '" + threadName + "' running ---");
            for (StackTraceElement caller : stackTrace = stackTraceEntry.getValue()) {
                ps.println("\tat " + caller);
            }
        }
    }

    private static void printRuntime(PrintStream ps) {
        ps.println("--- Runtime ---");
        Runtime rt = Runtime.getRuntime();
        ps.println("\tavailableProcessors = " + rt.availableProcessors());
        ps.println("\tfreeMemory = " + rt.freeMemory());
        ps.println("\ttotalMemory = " + rt.totalMemory());
        ps.println("\tmaxMemory = " + rt.maxMemory());
    }

    private static void printSystemProperties(PrintStream ps) {
        ps.println("--- System properties ---");
        Properties properties = System.getProperties();
        ArrayList<String> keys = new ArrayList<String>(properties.stringPropertyNames());
        Collections.sort(keys);
        for (String key : keys) {
            String value = MainLoader.encodeString(properties.getProperty(key));
            ps.println("\t" + key + " = " + value);
        }
    }

    private static final String encodeString(String s) {
        StringBuilder encoded = new StringBuilder();
        block7: for (int cIndex = 0; cIndex < s.length(); ++cIndex) {
            char c = s.charAt(cIndex);
            switch (c) {
                case '\u0000': {
                    encoded.append("\\0");
                    continue block7;
                }
                case '\t': {
                    encoded.append("\\t");
                    continue block7;
                }
                case '\n': {
                    encoded.append("\\n");
                    continue block7;
                }
                case '\r': {
                    encoded.append("\\r");
                    continue block7;
                }
                case '\\': {
                    encoded.append("\\\\");
                    continue block7;
                }
                default: {
                    encoded.append(c);
                }
            }
        }
        return encoded.toString();
    }
}

