/*
 * Decompiled with CFR 0.152.
 */
package de.carne;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ApplicationLoader
extends URLClassLoader {
    private static final boolean DEBUG;
    private static final HashMap<String, URLStreamHandlerFactory> URL_STREAM_HANDLER_FACTORY_MAP;
    private static final String PROTOCOL_RESOURCE = "resource";
    private static final URLStreamHandlerFactory URL_STREAM_HANDLER_FACTORY;
    private static Path CODE_PATH;
    private static final URL[] RESOURCE_URLS;
    private static final String THIS_CLASS;
    private static String[] SYSTEM_CLASSES;
    private ClassLoader systemClassloader = ApplicationLoader.getSystemClassLoader();
    private static final String MAIN_CLASS;

    public static void registerURLStreamHandlerFactory(String protocol, URLStreamHandlerFactory factory) {
        assert (protocol != null);
        assert (factory != null);
        if (DEBUG) {
            System.out.println("Loader: Registering URL protocol: " + protocol);
        }
        URL_STREAM_HANDLER_FACTORY_MAP.put(protocol, factory);
    }

    static URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandlerFactory factory = URL_STREAM_HANDLER_FACTORY_MAP.get(protocol);
        return factory != null ? factory.createURLStreamHandler(protocol) : null;
    }

    public static JarFile getCodeJar() throws IOException {
        JarFile codeJar = null;
        if (CODE_PATH != null && Files.isRegularFile(CODE_PATH, new LinkOption[0])) {
            codeJar = new JarFile(CODE_PATH.toFile());
        }
        return codeJar;
    }

    public static URL getDirectURL(URL u) {
        return u != null && PROTOCOL_RESOURCE.equals(u.getProtocol()) ? ApplicationLoader.class.getResource(u.getFile()) : u;
    }

    private ApplicationLoader() {
        super(RESOURCE_URLS, RESOURCE_URLS.length > 1 ? null : ApplicationLoader.getSystemClassLoader());
    }

    public static void main(String[] args) {
        try (ApplicationLoader classLoader = new ApplicationLoader();){
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> mainClass = classLoader.loadClass(MAIN_CLASS);
            Method main = mainClass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static URLStreamHandler createResourceURLStreamHandler(String protocol) {
        URLStreamHandler handler = null;
        if (PROTOCOL_RESOURCE.equals(protocol)) {
            handler = new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return ApplicationLoader.openResourceConnection(u);
                }
            };
        }
        return handler;
    }

    static URLConnection openResourceConnection(URL u) {
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return ApplicationLoader.getResourceInputStream(this.getURL());
            }
        };
    }

    static InputStream getResourceInputStream(URL u) throws IOException {
        InputStream resourceStream = ApplicationLoader.class.getResourceAsStream(u.getFile());
        if (resourceStream == null) {
            throw new FileNotFoundException("Unknown resource: " + u);
        }
        return resourceStream;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean useSystemClassLoader = false;
        for (String systemClassPrefix : SYSTEM_CLASSES) {
            if (!name.startsWith(systemClassPrefix)) continue;
            useSystemClassLoader = true;
            break;
        }
        return useSystemClassLoader ? this.systemClassloader.loadClass(name) : super.loadClass(name);
    }

    static {
        Path codePath;
        DEBUG = System.getProperty(ApplicationLoader.class.getName() + ".DEBUG") != null;
        URL_STREAM_HANDLER_FACTORY_MAP = new HashMap();
        URL_STREAM_HANDLER_FACTORY = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                return ApplicationLoader.createResourceURLStreamHandler(protocol);
            }
        };
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                return ApplicationLoader.createURLStreamHandler(protocol);
            }
        });
        ApplicationLoader.registerURLStreamHandlerFactory(PROTOCOL_RESOURCE, URL_STREAM_HANDLER_FACTORY);
        ClassLoader.registerAsParallelCapable();
        try {
            URL codeURL = ApplicationLoader.class.getProtectionDomain().getCodeSource().getLocation();
            if (DEBUG) {
                System.out.println("Loader: Code source URL: " + codeURL);
            }
            URI codeURI = codeURL.toURI();
            if (DEBUG) {
                System.out.println("Loader: Code source URI: " + codeURI);
            }
            codePath = Paths.get(codeURI);
            if (DEBUG) {
                System.out.println("Loader: Code source path: " + codePath);
            }
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        CODE_PATH = codePath;
        ArrayList<URL> libURLs = new ArrayList<URL>();
        try (JarFile codeJar = ApplicationLoader.getCodeJar();){
            if (codeJar != null) {
                libURLs.add(new URL("resource:/"));
                if (DEBUG) {
                    System.out.println("Loader: Adding internal JARs to classpath...");
                }
                Iterator jarEntries = codeJar.stream().filter(e -> e.getName().endsWith(".jar")).iterator();
                while (jarEntries.hasNext()) {
                    String jarEntryName = ((JarEntry)jarEntries.next()).getName();
                    if (DEBUG) {
                        System.out.println("Loader: Adding internal JAR: " + jarEntryName);
                    }
                    libURLs.add(new URL("jar:resource:/" + jarEntryName + "!/"));
                }
            }
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        RESOURCE_URLS = libURLs.toArray(new URL[libURLs.size()]);
        THIS_CLASS = ApplicationLoader.class.getName();
        SYSTEM_CLASSES = new String[]{THIS_CLASS, "de.carne.util.logging"};
        MAIN_CLASS = ApplicationLoader.class.getPackage().getName() + ".MainLoader";
    }
}

