/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.messaging.jms.JMSMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class JMSBytesMessage
extends JMSMessage
implements BytesMessage {
    private byte[] body;
    @Transient
    private ByteArrayInputStream bin;
    @Transient
    private ByteArrayOutputStream bout;

    public long getBodyLength() throws JMSException {
        return this.body.length;
    }

    private ByteArrayInputStream getByteIn() {
        if (this.bin == null) {
            this.bin = new ByteArrayInputStream(this.body);
        }
        return this.bin;
    }

    private ByteArrayOutputStream getBout() {
        if (this.bout == null) {
            this.bout = new ByteArrayOutputStream();
        }
        return this.bout;
    }

    public boolean readBoolean() throws JMSException {
        return this.getByteIn().read() == 1;
    }

    public byte readByte() throws JMSException {
        return (byte)this.getByteIn().read();
    }

    public int readUnsignedByte() throws JMSException {
        return (byte)this.getByteIn().read();
    }

    public short readShort() throws JMSException {
        return (short)this.getByteIn().read();
    }

    public int readUnsignedShort() throws JMSException {
        return (short)this.getByteIn().read();
    }

    public char readChar() throws JMSException {
        return (char)this.getByteIn().read();
    }

    public int readInt() throws JMSException {
        return this.getByteIn().read();
    }

    public long readLong() throws JMSException {
        return (long)this.getByteIn().read() << 32 | (long)this.getByteIn().read();
    }

    public float readFloat() throws JMSException {
        return 0.0f;
    }

    public double readDouble() throws JMSException {
        return 0.0;
    }

    public String readUTF() throws JMSException {
        return null;
    }

    public int readBytes(byte[] value) throws JMSException {
        try {
            return this.getByteIn().read(value);
        }
        catch (IOException e) {
            throw new JMSException("error");
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        return this.getByteIn().read(value, 0, length);
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (value) {
            this.getBout().write(1);
        } else {
            this.getBout().write(0);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.getBout().write(value);
    }

    public void writeShort(short value) throws JMSException {
        this.getBout().write(value);
    }

    public void writeChar(char value) throws JMSException {
        this.getBout().write(value);
    }

    public void writeInt(int value) throws JMSException {
        this.getBout().write(value);
    }

    public void writeLong(long value) throws JMSException {
    }

    public void writeFloat(float value) throws JMSException {
    }

    public void writeDouble(double value) throws JMSException {
    }

    public void writeUTF(String value) throws JMSException {
    }

    public void writeBytes(byte[] value) throws JMSException {
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
    }

    public void writeObject(Object value) throws JMSException {
    }

    public void reset() throws JMSException {
    }
}

