/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.MongoType;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.Query;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class MongoFieldImpl<T>
implements MongoField<T> {
    private Query<T> query;
    private MorphiumObjectMapper mapper;
    private String fldStr;
    private FilterExpression fe;

    public MongoFieldImpl() {
    }

    public MongoFieldImpl(Query<T> q, MorphiumObjectMapper map) {
        this.query = q;
        this.mapper = map;
    }

    @Override
    public String getFieldString() {
        return this.fldStr;
    }

    @Override
    public void setFieldString(String fldStr) {
        this.fe = new FilterExpression();
        this.fe.setField(fldStr);
        this.fldStr = fldStr;
    }

    @Override
    public MorphiumObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setMapper(MorphiumObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Query<T> all(List<Object> val) {
        this.add("$all", val);
        return this.query;
    }

    @Override
    public Query<T> eq(Object val) {
        val = this.checkValue(val);
        this.fe.setValue(val);
        this.fe.setField(this.mapper.getMorphium().getARHelper().getFieldName(this.query.getType(), this.fldStr));
        this.query.addChild(this.fe);
        return this.query;
    }

    private Object checkValue(Object val) {
        if (val != null) {
            Class<?> cls = val.getClass();
            Field field = this.mapper.getMorphium().getARHelper().getField(this.query.getType(), this.fldStr);
            if ((this.mapper.getMorphium().getARHelper().isAnnotationPresentInHierarchy(cls, Entity.class) || val instanceof MorphiumId) && field.isAnnotationPresent(Reference.class)) {
                Object id;
                if (val instanceof MorphiumId) {
                    id = new ObjectId(val.toString());
                } else if (val.getClass().isEnum()) {
                    id = ((Enum)val).name();
                } else {
                    id = this.mapper.getMorphium().getARHelper().getId(val);
                    if (id instanceof MorphiumId) {
                        id = new ObjectId(id.toString());
                    }
                }
                val = id;
                if (Map.class.isAssignableFrom(field.getType()) || Collection.class.isAssignableFrom(field.getType()) || List.class.isAssignableFrom(field.getType())) {
                    this.fldStr = this.fldStr + ".refid";
                }
            }
            if (field != null) {
                if (val instanceof MorphiumId && field.getType().equals(String.class)) {
                    val = val.toString();
                } else if (val instanceof String && field.getType().equals(MorphiumId.class)) {
                    try {
                        val = new MorphiumId((String)val);
                    }
                    catch (Exception exception) {}
                } else if (val.getClass().isEnum()) {
                    val = ((Enum)val).name();
                }
            }
        }
        return val;
    }

    private void add(String op, Object value) {
        this.fe.setField(this.mapper.getMorphium().getARHelper().getFieldName(this.query.getType(), this.fldStr));
        FilterExpression child = new FilterExpression();
        child.setField(op);
        child.setValue(value);
        this.fe.addChild(child);
        this.query.addChild(this.fe);
    }

    private void add(List<FilterExpression> expressionList) {
        this.fe.setField(this.mapper.getMorphium().getARHelper().getFieldName(this.query.getType(), this.fldStr));
        this.fe.setChildren(expressionList);
        this.query.addChild(this.fe);
    }

    @Override
    public Query<T> ne(Object val) {
        val = this.checkValue(val);
        this.add("$ne", val);
        return this.query;
    }

    @Override
    public Query<T> size(int val) {
        this.add("$size", val);
        return this.query;
    }

    @Override
    public Query<T> lt(Object val) {
        val = this.checkValue(val);
        this.add("$lt", val);
        return this.query;
    }

    @Override
    public Query<T> lte(Object val) {
        val = this.checkValue(val);
        this.add("$lte", val);
        return this.query;
    }

    @Override
    public Query<T> gt(Object val) {
        val = this.checkValue(val);
        this.add("$gt", val);
        return this.query;
    }

    @Override
    public Query<T> gte(Object val) {
        val = this.checkValue(val);
        this.add("$gte", val);
        return this.query;
    }

    @Override
    public Query<T> exists() {
        this.add("$exists", true);
        return this.query;
    }

    @Override
    public Query<T> notExists() {
        this.add("$exists", false);
        return this.query;
    }

    @Override
    public Query<T> mod(int base, int val) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        lst.add(base);
        lst.add(val);
        this.add("$mod", lst);
        return this.query;
    }

    @Override
    public Query<T> matches(Pattern p) {
        this.fe.setValue(p);
        this.fe.setField(this.mapper.getMorphium().getARHelper().getFieldName(this.query.getType(), this.fldStr));
        this.query.addChild(this.fe);
        return this.query;
    }

    @Override
    public Query<T> matches(String ptrn) {
        return this.matches(Pattern.compile(ptrn));
    }

    @Override
    public Query<T> type(MongoType t) {
        this.add("$type", t.getNumber());
        return this.query;
    }

    @Override
    public Query<T> in(Collection<?> vals) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object v : vals) {
            lst.add(this.checkValue(v));
        }
        this.add("$in", lst);
        return this.query;
    }

    @Override
    public Query<T> nin(Collection<?> vals) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object v : vals) {
            lst.add(this.checkValue(v));
        }
        this.add("$nin", lst);
        return this.query;
    }

    @Override
    public Query<T> near(double x, double y) {
        ArrayList<Double> lst = new ArrayList<Double>();
        lst.add(x);
        lst.add(y);
        this.add("$near", lst);
        return this.query;
    }

    @Override
    public Query<T> nearSphere(double x, double y) {
        ArrayList<Double> lst = new ArrayList<Double>();
        lst.add(x);
        lst.add(y);
        this.add("$nearSphere", lst);
        return this.query;
    }

    @Override
    public Query<T> box(double x, double y, double x2, double y2) {
        ArrayList<Object> lst = new ArrayList<Object>();
        ArrayList<Double> p1 = new ArrayList<Double>();
        p1.add(x);
        p1.add(y);
        ArrayList<Double> p2 = new ArrayList<Double>();
        p2.add(x2);
        p2.add(y2);
        lst.add(p1);
        lst.add(p2);
        this.createFilterExpressionList(lst, "$box");
        return this.query;
    }

    private void createFilterExpressionList(List<Object> lst, String type) {
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression withinExpression = new FilterExpression();
        withinExpression.setField("$within");
        HashMap<String, List<Object>> box = new HashMap<String, List<Object>>();
        box.put(type, lst);
        withinExpression.setValue(box);
        expressionList.add(withinExpression);
        this.add(expressionList);
    }

    @Override
    public Query<T> polygon(double ... p) {
        if (p.length % 2 == 1) {
            throw new IllegalArgumentException("Need a list of coordinates: x,y, x1,y1, x2,y2....");
        }
        ArrayList<Object> lst = new ArrayList<Object>();
        for (int i = 0; i < p.length; i += 2) {
            ArrayList<Double> p1 = new ArrayList<Double>();
            p1.add(p[i]);
            p1.add(p[i + 1]);
            lst.add(p1);
        }
        this.createFilterExpressionList(lst, "$polygon");
        return this.query;
    }

    @Override
    public Query<T> center(double x, double y, double r) {
        ArrayList<Serializable> lst = new ArrayList<Serializable>();
        ArrayList<Double> p1 = new ArrayList<Double>();
        p1.add(x);
        p1.add(y);
        lst.add(p1);
        lst.add(Double.valueOf(r));
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression withinExpression = new FilterExpression();
        withinExpression.setField("$within");
        HashMap<String, ArrayList<Serializable>> cnt = new HashMap<String, ArrayList<Serializable>>();
        cnt.put("$center", lst);
        withinExpression.setValue(cnt);
        expressionList.add(withinExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> centerSphere(double x, double y, double r) {
        ArrayList<Serializable> lst = new ArrayList<Serializable>();
        ArrayList<Double> p1 = new ArrayList<Double>();
        p1.add(x);
        p1.add(y);
        lst.add(p1);
        lst.add(Double.valueOf(r));
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression withinExpression = new FilterExpression();
        withinExpression.setField("$within");
        HashMap<String, ArrayList<Serializable>> cnt = new HashMap<String, ArrayList<Serializable>>();
        cnt.put("$centerSphere", lst);
        withinExpression.setValue(cnt);
        expressionList.add(withinExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> nearSphere(double x, double y, double maxDistance) {
        ArrayList<Double> location = new ArrayList<Double>();
        location.add(x);
        location.add(y);
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$nearSphere");
        nearExpression.setValue(location);
        expressionList.add(nearExpression);
        FilterExpression maxDistanceExpression = new FilterExpression();
        maxDistanceExpression.setField("$maxDistance");
        maxDistanceExpression.setValue(maxDistance);
        expressionList.add(maxDistanceExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> near(double x, double y, double maxDistance) {
        ArrayList<Double> location = new ArrayList<Double>();
        location.add(x);
        location.add(y);
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$near");
        nearExpression.setValue(location);
        expressionList.add(nearExpression);
        FilterExpression maxDistanceExpression = new FilterExpression();
        maxDistanceExpression.setField("$maxDistance");
        maxDistanceExpression.setValue(maxDistance);
        expressionList.add(maxDistanceExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(Query<T> q) {
        this.query = q;
    }
}

