/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import com.rits.cloning.Cloner;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.FunctionNotSupportedException;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.StoreBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.inmem.InMemTransactionContext;
import de.caluga.morphium.driver.mongodb.Maximums;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDriver
implements MorphiumDriver {
    private final Logger log = LoggerFactory.getLogger(InMemoryDriver.class);
    private final Map<String, Map<String, List<Map<String, Object>>>> database = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    private ThreadLocal<InMemTransactionContext> currentTransaction = new ThreadLocal();
    private final AtomicLong txn = new AtomicLong();
    private Map<String, List<DriverTailableIterationCallback>> watchersByDb = new ConcurrentHashMap<String, List<DriverTailableIterationCallback>>();

    @Override
    public List<String> listDatabases() {
        Vector<String> lst = new Vector<String>();
        lst.addAll(this.database.keySet());
        return lst;
    }

    @Override
    public List<String> listCollections(String db, String pattern) {
        Set<String> collections = this.database.get(db).keySet();
        Vector<String> ret = new Vector<String>();
        if (pattern == null) {
            ret.addAll(collections);
        } else {
            for (String col : ret) {
                if (!col.matches(pattern)) continue;
                ret.add(col);
            }
        }
        return ret;
    }

    public void resetData() {
        this.database.clear();
        this.currentTransaction.remove();
    }

    @Override
    public void setCredentials(String db, String login, char[] pwd) {
    }

    @Override
    public int getDefaultWriteTimeout() {
        return 0;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
    }

    @Override
    public boolean isReplicaset() {
        return false;
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public boolean isDefaultFsync() {
        return false;
    }

    @Override
    public void setDefaultFsync(boolean j) {
    }

    @Override
    public String[] getHostSeed() {
        return new String[0];
    }

    @Override
    public void setHostSeed(String ... host) {
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return 0;
    }

    @Override
    public void setMaxConnectionsPerHost(int mx) {
    }

    @Override
    public int getMinConnectionsPerHost() {
        return 0;
    }

    @Override
    public void setMinConnectionsPerHost(int mx) {
    }

    @Override
    public int getMaxConnectionLifetime() {
        return 0;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return 0;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
    }

    @Override
    public int getSocketTimeout() {
        return 0;
    }

    @Override
    public void setSocketTimeout(int timeout) {
    }

    @Override
    public int getConnectionTimeout() {
        return 0;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
    }

    @Override
    public int getDefaultW() {
        return 0;
    }

    @Override
    public void setDefaultW(int w) {
    }

    @Override
    public int getMaxBlockintThreadMultiplier() {
        return 0;
    }

    @Override
    public int getHeartbeatFrequency() {
        return 0;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
    }

    @Override
    public void setCredentials(Map<String, String[]> credentials) {
    }

    @Override
    public int getHeartbeatSocketTimeout() {
        return 0;
    }

    @Override
    public void setHeartbeatSocketTimeout(int heartbeatSocketTimeout) {
    }

    @Override
    public boolean isUseSSL() {
        return false;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
    }

    @Override
    public boolean isDefaultJ() {
        return false;
    }

    @Override
    public void setDefaultJ(boolean j) {
    }

    @Override
    public int getWriteTimeout() {
        return 0;
    }

    @Override
    public void setWriteTimeout(int writeTimeout) {
    }

    @Override
    public int getLocalThreshold() {
        return 0;
    }

    @Override
    public void setLocalThreshold(int thr) {
    }

    @Override
    public void setMaxBlockingThreadMultiplier(int m) {
    }

    @Override
    public void heartBeatFrequency(int t) {
    }

    @Override
    public void heartBeatSocketTimeout(int t) {
    }

    @Override
    public void useSsl(boolean ssl) {
    }

    @Override
    public void connect() {
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
    }

    @Override
    public void connect(String replicasetName) {
    }

    @Override
    public Maximums getMaximums() {
        Maximums ret = new Maximums();
        ret.setMaxBsonSize(10000);
        ret.setMaxMessageSize(10000);
        ret.setMaxWriteBatchSize(100);
        return ret;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public int getRetriesOnNetworkError() {
        return 0;
    }

    @Override
    public void setRetriesOnNetworkError(int r) {
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return 0;
    }

    @Override
    public void setSleepBetweenErrorRetries(int s) {
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, Object> getReplsetStatus() {
        return new HashMap<String, Object>();
    }

    @Override
    public Map<String, Object> getDBStats(String db) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("collections", this.getDB(db).size());
        return ret;
    }

    @Override
    public Map<String, Object> getOps(long threshold) {
        throw new RuntimeException("not working on memory");
    }

    @Override
    public Map<String, Object> runCommand(String db, Map<String, Object> cmd) {
        throw new RuntimeException("not working on memory");
    }

    private boolean matchesQuery(Map<String, Object> query, Map<String, Object> toCheck) {
        Iterator<String> iterator;
        if (query.isEmpty()) {
            return true;
        }
        if (query.containsKey("$where")) {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.getContext().setAttribute("obj", toCheck, 100);
            engine.getContext().setAttribute("this", toCheck, 100);
            try {
                Object result = engine.eval((String)query.get("$where"));
                if (result == null || result.equals(Boolean.FALSE)) {
                    return false;
                }
            }
            catch (ScriptException result) {
                // empty catch block
            }
        }
        if ((iterator = query.keySet().iterator()).hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "$and": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (this.matchesQuery(q, toCheck)) continue;
                        return false;
                    }
                    return true;
                }
                case "$or": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (!this.matchesQuery(q, toCheck)) continue;
                        return true;
                    }
                    return false;
                }
            }
            if (query.get(key) instanceof Map) {
                String k;
                Map q = (Map)query.get(key);
                assert (q.size() == 1);
                switch (k = (String)q.keySet().iterator().next()) {
                    case "$lt": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) < 0;
                    }
                    case "$lte": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) <= 0;
                    }
                    case "$gt": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) > 0;
                    }
                    case "$gte": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) >= 0;
                    }
                    case "$mod": {
                        Number n = (Number)toCheck.get(key);
                        List arr = (List)q.get(k);
                        int div = (Integer)arr.get(0);
                        int rem = (Integer)arr.get(1);
                        return n.intValue() % div == rem;
                    }
                    case "$ne": {
                        boolean contains = false;
                        if (toCheck.get(key) instanceof List) {
                            for (Object o : (List)toCheck.get(key)) {
                                if (o == null || q.get(k) == null || !o.equals(q.get(k))) continue;
                                contains = true;
                                break;
                            }
                            return !contains;
                        }
                        if (toCheck.get(key) == null && q.get(k) != null) {
                            return true;
                        }
                        if (toCheck.get(key) == null && q.get(k) == null) {
                            return false;
                        }
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) != 0;
                    }
                    case "$exists": {
                        boolean exists = toCheck.containsKey(key);
                        if (q.get(k).equals(Boolean.TRUE) || q.get(k).equals("true") || q.get(k).equals(1)) {
                            return exists;
                        }
                        return !exists;
                    }
                    case "$nin": {
                        boolean found = false;
                        for (Object v : (List)q.get(k)) {
                            if (!toCheck.get(key).equals(v)) continue;
                            found = true;
                        }
                        return !found;
                    }
                    case "$in": {
                        for (Object v : (List)q.get(k)) {
                            if (!toCheck.get(key).equals(v)) continue;
                            return true;
                        }
                        return false;
                    }
                }
                throw new RuntimeException("Unknown Operator " + k);
            }
            assert (query.size() == 1);
            if (toCheck.get(key) instanceof MorphiumId || toCheck.get(key) instanceof ObjectId) {
                return toCheck.get(key).toString().equals(query.get(key).toString());
            }
            if (toCheck.get(key) == null && query.get(key) != null) {
                return false;
            }
            if (toCheck.get(key) == null && query.get(key) == null) {
                return true;
            }
            return toCheck.get(key).equals(query.get(key));
        }
        return false;
    }

    @Override
    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Map<String, Object> findMetaData) throws MorphiumDriverException {
        MorphiumCursor<InMemoryCursor> crs = new MorphiumCursor<InMemoryCursor>();
        crs.setBatchSize(batchSize);
        crs.setCursorId(System.currentTimeMillis());
        InMemoryCursor inCrs = new InMemoryCursor();
        inCrs.skip = skip;
        inCrs.limit = limit;
        inCrs.batchSize = batchSize;
        if (batchSize == 0) {
            inCrs.batchSize = 1000;
        }
        inCrs.setCollection(collection);
        inCrs.setDb(db);
        inCrs.setProjection(projection);
        inCrs.setQuery(query);
        inCrs.setFindMetaData(findMetaData);
        inCrs.setReadPreference(readPreference);
        inCrs.setSort(sort);
        crs.setInternalCursorObject(inCrs);
        int l = batchSize;
        if (limit != 0 && limit < batchSize) {
            l = limit;
        }
        List<Map<String, Object>> res = this.find(db, collection, query, sort, projection, skip, l, batchSize, readPreference, findMetaData);
        crs.setBatch(res);
        if (res.size() < batchSize) {
            crs.setInternalCursorObject(null);
        } else {
            inCrs.dataRead = res.size();
        }
        return crs;
    }

    @Override
    public void watch(String db, int timeout, boolean fullDocumentOnUpdate, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        this.watchersByDb.putIfAbsent(db, new Vector());
        this.watchersByDb.get(db).add(cb);
    }

    @Override
    public void watch(String db, String collection, int timeout, boolean fullDocumentOnUpdate, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        String key = db + "." + collection;
        this.watchersByDb.putIfAbsent(key, new Vector());
        this.watchersByDb.get(key).add(cb);
    }

    @Override
    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        MorphiumCursor<InMemoryCursor> next = new MorphiumCursor<InMemoryCursor>();
        next.setCursorId(crs.getCursorId());
        InMemoryCursor oldCrs = (InMemoryCursor)crs.getInternalCursorObject();
        if (oldCrs == null) {
            return null;
        }
        InMemoryCursor inCrs = new InMemoryCursor();
        inCrs.setReadPreference(oldCrs.getReadPreference());
        inCrs.setFindMetaData(oldCrs.getFindMetaData());
        inCrs.setDb(oldCrs.getDb());
        inCrs.setQuery(oldCrs.getQuery());
        inCrs.setCollection(oldCrs.getCollection());
        inCrs.setProjection(oldCrs.getProjection());
        inCrs.setBatchSize(oldCrs.getBatchSize());
        inCrs.setLimit(oldCrs.getLimit());
        inCrs.setSort(oldCrs.getSort());
        inCrs.skip = oldCrs.getDataRead() + 1;
        int limit = oldCrs.getBatchSize();
        if (oldCrs.getLimit() != 0 && oldCrs.getDataRead() + oldCrs.getBatchSize() > oldCrs.getLimit()) {
            limit = oldCrs.getLimit() - oldCrs.getDataRead();
        }
        List<Map<String, Object>> res = this.find(inCrs.getDb(), inCrs.getCollection(), inCrs.getQuery(), inCrs.getSort(), inCrs.getProjection(), inCrs.getSkip(), limit, inCrs.getBatchSize(), inCrs.getReadPreference(), inCrs.getFindMetaData());
        next.setBatch(res);
        if (res.size() < inCrs.getBatchSize()) {
            next.setInternalCursorObject(null);
        } else {
            inCrs.setDataRead(oldCrs.getDataRead() + res.size());
            next.setInternalCursorObject(inCrs);
        }
        return next;
    }

    @Override
    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference rp, Map<String, Object> findMetaData) throws MorphiumDriverException {
        return this.find(db, collection, query, sort, projection, skip, limit, false);
    }

    private List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, boolean internal) throws MorphiumDriverException {
        Vector<Map<String, Object>> data = new Vector<Map<String, Object>>(this.getCollection(db, collection));
        Vector<Map<String, Object>> ret = new Vector<Map<String, Object>>();
        int count = 0;
        if (sort != null) {
            data.sort((o1, o2) -> {
                for (String f : sort.keySet()) {
                    if (o1.get(f).equals(o2.get(f))) continue;
                    return ((Comparable)o1.get(f)).compareTo(o2.get(f)) * (Integer)sort.get(f);
                }
                return 0;
            });
        }
        for (int i = 0; i < data.size(); ++i) {
            Map o = (Map)data.get(i);
            if (++count < skip) continue;
            if (this.matchesQuery(query, o)) {
                ret.add(internal ? o : new HashMap(o));
            }
            if (limit > 0 && ret.size() >= limit) break;
        }
        return ret;
    }

    @Override
    public long count(String db, String collection, Map<String, Object> query, ReadPreference rp) {
        List<Map<String, Object>> data = this.getCollection(db, collection);
        if (query.isEmpty()) {
            return data.size();
        }
        long cnt = 0L;
        for (Map<String, Object> o : data) {
            if (!this.matchesQuery(query, o)) continue;
            ++cnt;
        }
        return cnt;
    }

    public List<Map<String, Object>> findByFieldValue(String db, String coll, String field, Object value) {
        Vector<Map<String, Object>> ret = new Vector<Map<String, Object>>();
        List<Map<String, Object>> data = this.getCollection(db, coll);
        for (Map<String, Object> obj : data) {
            if (obj.get(field) == null && value != null || (obj.get(field) != null || value != null) && !obj.get(field).equals(value)) continue;
            ret.add(new HashMap<String, Object>(obj));
        }
        return ret;
    }

    @Override
    public void insert(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        for (Map<String, Object> o : objs) {
            if (o.get("_id") != null && !this.findByFieldValue(db, collection, "_id", o.get("_id")).isEmpty()) {
                throw new MorphiumDriverException("Duplicate _id! " + o.get("_id"), null);
            }
            o.putIfAbsent("_id", new MorphiumId());
        }
        this.getCollection(db, collection).addAll(objs);
        for (Map<String, Object> o : objs) {
            this.notifyWatchers(db, collection, "insert", o);
        }
    }

    @Override
    public Map<String, Object> store(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int upd = 0;
        int total = objs.size();
        for (Map<String, Object> o : objs) {
            if (o.get("_id") == null) {
                o.put("_id", new MorphiumId());
                this.getCollection(db, collection).add(o);
                continue;
            }
            List<Map<String, Object>> srch = this.findByFieldValue(db, collection, "_id", o.get("_id"));
            if (!srch.isEmpty()) {
                this.getCollection(db, collection).remove(srch.get(0));
                ++upd;
                this.notifyWatchers(db, collection, "replace", o);
            } else {
                this.notifyWatchers(db, collection, "insert", o);
            }
            this.getCollection(db, collection).add(o);
        }
        ret.put("matched", upd);
        ret.put("updated", upd);
        return ret;
    }

    private Map<String, List<Map<String, Object>>> getDB(String db) {
        if (this.currentTransaction.get() == null) {
            this.database.putIfAbsent(db, new ConcurrentHashMap());
            return this.database.get(db);
        }
        this.currentTransaction.get().getDatabase().putIfAbsent(db, new ConcurrentHashMap());
        return (Map)this.currentTransaction.get().getDatabase().get(db);
    }

    @Override
    public void closeIteration(MorphiumCursor crs) {
    }

    @Override
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> op, boolean multiple, boolean upsert, WriteConcern wc) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.find(db, collection, query, null, null, 0, multiple ? 0 : 1, true);
        boolean insert = false;
        if (lst == null) {
            lst = new Vector<Map<String, Object>>();
        }
        if (upsert && (lst == null || lst.isEmpty())) {
            lst.add(new HashMap());
            for (String k : query.keySet()) {
                if (k.startsWith("$")) continue;
                lst.get(0).put(k, query.get(k));
            }
            insert = true;
        }
        for (Map<String, Object> obj : lst) {
            block22: for (String operand : op.keySet()) {
                Map cmd = (Map)op.get(operand);
                switch (operand) {
                    case "$set": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            obj.put((String)entry.getKey(), entry.getValue());
                        }
                        continue block22;
                    }
                    case "$unset": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$inc": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value instanceof Integer) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Integer)value + (Integer)entry.getValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Integer)value).intValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Integer)value).intValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (long)((Integer)value).intValue() + (Long)entry.getValue();
                                }
                            } else if (value instanceof Double) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Double)value + (double)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = (Double)value + (double)((Float)entry.getValue()).floatValue();
                                } else if (entry.getValue() instanceof Double) {
                                    value = (Double)value + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Double)value + (double)((Long)entry.getValue()).longValue();
                                }
                            } else if (value instanceof Float) {
                                if (entry.getValue() instanceof Integer) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Integer)entry.getValue()).intValue());
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf(((Float)value).floatValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Float)value).floatValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Long)entry.getValue()).longValue());
                                }
                            } else if (value instanceof Long) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Long)value + (long)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Long)value).longValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Long)value).longValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Long)value + (Long)entry.getValue();
                                }
                            }
                            obj.put((String)entry.getKey(), value);
                        }
                        continue block22;
                    }
                    case "$mul": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value instanceof Integer) {
                                value = (Integer)value * (Integer)entry.getValue();
                            } else if (value instanceof Double) {
                                value = (Double)value * (Double)entry.getValue();
                            } else if (value instanceof Float) {
                                value = Float.valueOf(((Float)value).floatValue() * ((Float)entry.getValue()).floatValue());
                            } else if (value instanceof Long) {
                                value = (Long)value * (Long)entry.getValue();
                            }
                            obj.put((String)entry.getKey(), value);
                        }
                        continue block22;
                    }
                    case "$rename": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            obj.put((String)entry.getValue(), obj.get(entry.getKey()));
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$min": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) <= 0) continue;
                            obj.put((String)entry.getKey(), entry.getValue());
                        }
                        continue block22;
                    }
                    case "$max": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) >= 0) continue;
                            obj.put((String)entry.getKey(), entry.getValue());
                        }
                        continue block22;
                    }
                    case "$push": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            Vector<Object> v = (Vector<Object>)obj.get(entry.getKey());
                            if (v == null) {
                                v = new Vector<Object>();
                                obj.put((String)entry.getKey(), v);
                            }
                            if (entry.getValue() instanceof Map) {
                                if (((Map)entry.getValue()).get("$each") != null) {
                                    for (Object o : (List)((Map)entry.getValue()).get("$each")) {
                                        v.add(o);
                                    }
                                    continue;
                                }
                                v.add(entry.getValue());
                                continue;
                            }
                            v.add(entry.getValue());
                        }
                        continue block22;
                    }
                    default: {
                        throw new RuntimeException("unknown operand " + operand);
                    }
                }
            }
            this.notifyWatchers(db, collection, "update", obj);
        }
        if (insert) {
            this.store(db, collection, lst, wc);
        }
        return new HashMap<String, Object>();
    }

    private void notifyWatchers(String db, String collection, String op, Map doc) {
        List<DriverTailableIterationCallback> w = null;
        if (this.watchersByDb.containsKey(db)) {
            w = this.watchersByDb.get(db);
        } else if (collection != null && this.watchersByDb.containsKey(db + "." + collection)) {
            w = this.watchersByDb.get(db + "." + collection);
        }
        if (w == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("fullDocument", doc);
        data.put("operationType", op);
        Map<String, String> m = Utils.getMap("db", db);
        m.put("coll", collection);
        data.put("ns", m);
        long tx = this.txn.incrementAndGet();
        data.put("txnNumber", tx);
        data.put("clusterTime", System.currentTimeMillis());
        if (doc != null) {
            data.put("documentKey", Utils.getMap("_id", doc.get("_id")));
        }
        for (DriverTailableIterationCallback cb : w) {
            try {
                cb.incomingData(data, System.currentTimeMillis());
            }
            catch (Exception e) {
                this.log.error("Error calling watcher", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, boolean multiple, WriteConcern wc) throws MorphiumDriverException {
        List<Map<String, Object>> toDel = this.find(db, collection, query, null, null, 0, multiple ? 0 : 1, 10000, null, null);
        for (Map<String, Object> o : toDel) {
            this.getCollection(db, collection).remove(o);
            this.notifyWatchers(db, collection, "delete", o);
        }
        return new HashMap<String, Object>();
    }

    private List<Map<String, Object>> getCollection(String db, String collection) {
        this.getDB(db).putIfAbsent(collection, Collections.synchronizedList(new ArrayList()));
        return this.getDB(db).get(collection);
    }

    @Override
    public void drop(String db, String collection, WriteConcern wc) {
        this.getDB(db).remove(collection);
        this.notifyWatchers(db, collection, "drop", null);
    }

    @Override
    public void drop(String db, WriteConcern wc) {
        this.database.remove(db);
        this.notifyWatchers(db, null, "drop", null);
    }

    @Override
    public boolean exists(String db) {
        return this.database.containsKey(db);
    }

    @Override
    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, ReadPreference rp) {
        List<Map<String, Object>> list = this.getDB(db).get(collection);
        HashSet<Object> distinctValues = new HashSet<Object>();
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> doc : list) {
                if (doc == null || doc.isEmpty() || doc.get(field) == null) continue;
                distinctValues.add(doc.get(field));
            }
        }
        Vector<Object> distinctValuesList = new Vector<Object>();
        distinctValuesList.addAll(distinctValues);
        return distinctValuesList;
    }

    @Override
    public boolean exists(String db, String collection) {
        return this.getDB(db) != null && this.getDB(db).containsKey(collection);
    }

    @Override
    public List<Map<String, Object>> getIndexes(String db, String collection) {
        return new Vector<Map<String, Object>>();
    }

    @Override
    public List<String> getCollectionNames(String db) {
        return null;
    }

    @Override
    public Map<String, Object> group(String db, String coll, Map<String, Object> query, Map<String, Object> initial, String jsReduce, String jsFinalize, ReadPreference rp, String ... keys) {
        return null;
    }

    @Override
    public List<Map<String, Object>> aggregate(String db, String collection, List<Map<String, Object>> pipeline, boolean explain, boolean allowDiskUse, ReadPreference readPreference) {
        throw new RuntimeException("Aggregate not possible in memory!");
    }

    @Override
    public boolean isSocketKeepAlive() {
        return false;
    }

    @Override
    public void setSocketKeepAlive(boolean socketKeepAlive) {
    }

    @Override
    public int getHeartbeatConnectTimeout() {
        return 0;
    }

    @Override
    public void setHeartbeatConnectTimeout(int heartbeatConnectTimeout) {
    }

    @Override
    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("not possible in Mem yet");
    }

    @Override
    public int getMaxWaitTime() {
        return 0;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
    }

    @Override
    public boolean isCapped(String db, String coll) {
        return false;
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(m){
            private final List<BulkRequest> requests;
            {
                super(m);
                this.requests = new Vector<BulkRequest>();
            }

            @Override
            public Map<String, Object> execute() {
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InMemoryDriver.this.insert(db, collection, ((InsertBulkRequest)r).getToInsert(), null);
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            InMemoryDriver.this.update(db, collection, up.getQuery(), up.getCmd(), up.isMultiple(), up.isUpsert(), null);
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            InMemoryDriver.this.delete(db, collection, ((DeleteBulkRequest)r).getQuery(), ((DeleteBulkRequest)r).isMultiple(), null);
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    InMemoryDriver.this.log.error("Got exception: ", (Throwable)e);
                }
                return new HashMap<String, Object>();
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public StoreBulkRequest addStoreBulkRequest(List<Map<String, Object>> toStore) {
                StoreBulkRequest store = new StoreBulkRequest(toStore);
                this.requests.add(store);
                return store;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    @Override
    public void createIndex(String db, String collection, Map<String, Object> index, Map<String, Object> options) {
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public void startTransaction() {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("transaction in progress");
        }
        InMemTransactionContext ctx = new InMemTransactionContext();
        Cloner cloner = new Cloner();
        ctx.setDatabase((Map)cloner.deepClone(this.database));
        this.currentTransaction.set(ctx);
    }

    @Override
    public void commitTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        InMemTransactionContext ctx = this.currentTransaction.get();
        this.database.putAll(ctx.getDatabase());
        this.currentTransaction.set(null);
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.currentTransaction.get();
    }

    @Override
    public void abortTransaction() {
        this.currentTransaction.set(null);
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        this.currentTransaction.set((InMemTransactionContext)ctx);
    }

    private class InMemoryCursor {
        private int skip;
        private int limit;
        private int batchSize;
        private int dataRead = 0;
        private String db;
        private String collection;
        private Map<String, Object> query;
        private Map<String, Integer> sort;
        private Map<String, Object> projection;
        private ReadPreference readPreference;
        private Map<String, Object> findMetaData;

        private InMemoryCursor() {
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        public Map<String, Object> getQuery() {
            return this.query;
        }

        public void setQuery(Map<String, Object> query) {
            this.query = query;
        }

        public Map<String, Integer> getSort() {
            return this.sort;
        }

        public void setSort(Map<String, Integer> sort) {
            this.sort = sort;
        }

        public Map<String, Object> getProjection() {
            return this.projection;
        }

        public void setProjection(Map<String, Object> projection) {
            this.projection = projection;
        }

        public ReadPreference getReadPreference() {
            return this.readPreference;
        }

        public void setReadPreference(ReadPreference readPreference) {
            this.readPreference = readPreference;
        }

        public Map<String, Object> getFindMetaData() {
            return this.findMetaData;
        }

        public void setFindMetaData(Map<String, Object> findMetaData) {
            this.findMetaData = findMetaData;
        }

        public int getDataRead() {
            return this.dataRead;
        }

        public void setDataRead(int dataRead) {
            this.dataRead = dataRead;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public int getSkip() {
            return this.skip;
        }

        public void setSkip(int skip) {
            this.skip = skip;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }
    }
}

