/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.changestream;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.changestream.ChangeStreamEvent;
import de.caluga.morphium.changestream.ChangeStreamListener;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriverException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeStreamMonitor
implements Runnable,
ShutdownListener {
    private final Collection<ChangeStreamListener> listeners;
    private final Morphium morphium;
    private final Logger log = LoggerFactory.getLogger(ChangeStreamMonitor.class);
    private final String collectionName;
    private final boolean fullDocument;
    private boolean running = true;
    private long timestamp;
    private Thread changeStreamThread;
    private MorphiumObjectMapper mapper;
    private boolean dbOnly = false;

    public ChangeStreamMonitor(Morphium m) {
        this(m, null, false);
        this.dbOnly = true;
    }

    public ChangeStreamMonitor(Morphium m, Class<?> entity) {
        this(m, m.getMapper().getCollectionName(entity), false);
    }

    public ChangeStreamMonitor(Morphium m, String collectionName, boolean fullDocument) {
        this.morphium = m;
        this.listeners = new ConcurrentLinkedDeque<ChangeStreamListener>();
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.morphium.addShutdownListener(this);
        this.collectionName = collectionName;
        this.fullDocument = fullDocument;
        this.mapper = new ObjectMapperImpl();
        AnnotationAndReflectionHelper hlp = new AnnotationAndReflectionHelper(false);
        this.mapper.setAnnotationHelper(hlp);
    }

    public void addListener(ChangeStreamListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(ChangeStreamListener lst) {
        this.listeners.remove(lst);
    }

    public boolean isFullDocument() {
        return this.fullDocument;
    }

    public void start() {
        if (this.changeStreamThread != null) {
            throw new RuntimeException("Already running!");
        }
        this.changeStreamThread = new Thread(this);
        this.changeStreamThread.setDaemon(true);
        this.changeStreamThread.setName("changeStream");
        this.changeStreamThread.start();
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
        long start = System.currentTimeMillis();
        while (this.changeStreamThread != null && this.changeStreamThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 1000L) continue;
        }
        if (this.changeStreamThread != null && this.changeStreamThread.isAlive()) {
            this.changeStreamThread.interrupt();
        }
        this.changeStreamThread = null;
        this.listeners.clear();
        this.morphium.removeShutdownListener(this);
    }

    public String getcollectionName() {
        return this.collectionName;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                DriverTailableIterationCallback callback = (data, dur) -> {
                    if (!this.running) {
                        return false;
                    }
                    Map obj = (Map)data.get("fullDocument");
                    data.put("fullDocument", null);
                    ChangeStreamEvent evt = this.mapper.deserialize(ChangeStreamEvent.class, data);
                    evt.setFullDocument(obj);
                    for (ChangeStreamListener lst : this.listeners) {
                        try {
                            lst.incomingData(evt);
                        }
                        catch (Exception e) {
                            this.log.error("listener threw exception", (Throwable)e);
                        }
                    }
                    return this.running;
                };
                if (this.dbOnly) {
                    this.morphium.getDriver().watch(this.morphium.getConfig().getDatabase(), this.morphium.getConfig().getMaxWaitTime(), this.fullDocument, callback);
                    continue;
                }
                this.morphium.getDriver().watch(this.morphium.getConfig().getDatabase(), this.collectionName, this.morphium.getConfig().getMaxWaitTime(), this.fullDocument, callback);
            }
            catch (MorphiumDriverException e) {
                this.log.warn("Error in oplogmonitor - restarting", (Throwable)e);
            }
        }
    }

    @Override
    public void onShutdown(Morphium m) {
        this.stop();
    }
}

