/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.Logger;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MorphiumDriverIterator<T>
implements MorphiumIterator<T> {
    private final Logger log = new Logger(MorphiumDriverIterator.class);
    private Query<T> query;
    private MorphiumCursor<T> currentBatch = null;
    private int cursor = 0;
    private int cursorExternal = 0;
    private boolean multithreadded;
    private int windowSize = -1;

    @Override
    public int getWindowSize() {
        if (this.query == null) {
            return 0;
        }
        if (this.windowSize <= 0) {
            this.windowSize = this.query.getMorphium().getConfig().getCursorBatchSize();
        }
        return this.windowSize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.windowSize = sz;
    }

    @Override
    public Query<T> getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(Query<T> q) {
        try {
            this.query = q.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getCurrentBufferSize() {
        return this.currentBatch.getBatch().size();
    }

    @Override
    public List<T> getCurrentBuffer() {
        return null;
    }

    @Override
    public long getCount() {
        return this.query.countAll();
    }

    @Override
    public int getCursor() {
        return this.cursorExternal;
    }

    @Override
    public void ahead(int jump) {
        this.cursor += jump;
        this.cursorExternal += jump;
        while (this.cursor >= this.currentBatch.getBatch().size()) {
            int diff = this.cursor - this.currentBatch.getBatch().size();
            this.cursor = this.currentBatch.getBatch().size() - 1;
            this.next();
            this.cursor += diff;
        }
    }

    @Override
    public void back(int jump) {
        this.cursor -= jump;
        this.cursorExternal -= jump;
        if (this.cursor < 0) {
            throw new IllegalArgumentException("cannot jumb back over batch boundaries!");
        }
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        throw new IllegalArgumentException("not possible");
    }

    @Override
    public int getNumberOfAvailableThreads() {
        return 1;
    }

    @Override
    public int getNumberOfThreads() {
        return 1;
    }

    @Override
    public boolean isMultithreaddedAccess() {
        return this.multithreadded;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.multithreadded = mu;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.multithreadded) {
            MorphiumDriverIterator morphiumDriverIterator = this;
            synchronized (morphiumDriverIterator) {
                return this.doHasNext();
            }
        }
        return this.doHasNext();
    }

    private boolean doHasNext() {
        if (this.currentBatch != null && this.currentBatch.getBatch() != null && this.currentBatch.getBatch().size() > this.cursor) {
            return true;
        }
        if (this.currentBatch == null && this.cursorExternal == 0) {
            try {
                this.currentBatch = this.query.getMorphium().getDriver().initIteration(this.query.getMorphium().getConfig().getDatabase(), this.query.getCollectionName(), this.query.toQueryObject(), this.query.getSort(), this.query.getFieldListForQuery(), this.query.getSkip(), this.query.getLimit(), this.getWindowSize(), this.query.getMorphium().getReadPreferenceForClass(this.query.getType()), null);
            }
            catch (MorphiumDriverException e) {
                this.log.error("error during fetching first batch");
            }
            return this.doHasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (this.currentBatch == null && !this.hasNext()) {
            return null;
        }
        T unmarshall = this.query.getMorphium().getMapper().unmarshall(this.query.getType(), this.currentBatch.getBatch().get(this.cursor));
        this.query.getMorphium().firePostLoadEvent(unmarshall);
        try {
            if (this.currentBatch == null && this.cursorExternal == 0) {
                this.currentBatch = this.query.getMorphium().getDriver().initIteration(this.query.getMorphium().getConfig().getDatabase(), this.query.getCollectionName(), this.query.toQueryObject(), this.query.getSort(), this.query.getFieldListForQuery(), this.query.getSkip(), this.query.getLimit(), this.getWindowSize(), this.query.getMorphium().getReadPreferenceForClass(this.query.getType()), null);
                this.cursor = 0;
            } else if (this.currentBatch != null && this.cursor + 1 < this.currentBatch.getBatch().size()) {
                ++this.cursor;
            } else if (this.currentBatch != null && this.cursor + 1 == this.currentBatch.getBatch().size()) {
                this.currentBatch = this.query.getMorphium().getDriver().nextIteration(this.currentBatch);
                this.cursor = 0;
            } else {
                ++this.cursor;
            }
            if (this.multithreadded && this.currentBatch != null && this.currentBatch.getBatch() != null) {
                this.currentBatch.setBatch(Collections.synchronizedList(this.currentBatch.getBatch()));
            }
        }
        catch (MorphiumDriverException e) {
            this.log.error("Got error during iteration...", e);
        }
        ++this.cursorExternal;
        return unmarshall;
    }
}

