/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.singleconnect;

import de.caluga.morphium.Logger;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.MorphiumDriverOperation;
import java.util.Map;

public class NetworkCallHelper {
    private final Logger logger = new Logger(NetworkCallHelper.class);

    public Map<String, Object> doCall(MorphiumDriverOperation r, int maxRetry, int sleep) throws MorphiumDriverException {
        for (int i = 0; i < maxRetry; ++i) {
            try {
                return r.execute();
            }
            catch (Exception e) {
                this.handleNetworkError(maxRetry, i, sleep, e);
                continue;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNetworkError(int max, int i, int sleep, Throwable e) throws MorphiumDriverException {
        this.logger.info("Handling network error..." + e.getClass().getName());
        if (!(e instanceof MorphiumDriverNetworkException)) throw new MorphiumDriverException("internal error", e);
        if (i + 1 < max) {
            this.logger.warn("Retry because of network error: " + e.getMessage());
            try {
                Thread.sleep(sleep);
                return;
            }
            catch (InterruptedException interruptedException) {}
            return;
        } else {
            this.logger.info("no retries left - re-throwing exception");
            throw new MorphiumDriverNetworkException("Network error error", e);
        }
    }
}

