/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.singleconnect;

import de.caluga.morphium.Logger;
import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bson.MongoJSScript;
import de.caluga.morphium.driver.mongodb.Maximums;
import de.caluga.morphium.driver.singleconnect.NetworkCallHelper;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;

public abstract class DriverBase
implements MorphiumDriver {
    private final Logger log = new Logger(DriverBase.class);
    private volatile int rqid = 10000;
    private int maxWait = 1000;
    private boolean keepAlive = true;
    private int soTimeout = 1000;
    private Map<String, Map<String, char[]>> credentials;
    private int maxBsonObjectSize;
    private int maxMessageSize = 0x1000000;
    private int maxWriteBatchSize = 1000;
    private ReadPreference defaultRP;
    private boolean replicaSet = false;
    private String replicaSetName = null;
    private int retriesOnNetworkError = 5;
    private int sleepBetweenRetries = 100;
    private boolean defaultJ = false;
    private int localThreshold = 0;
    private int heartbeatConnectionTimeout = 1000;
    private List<String> hostSeed;
    private int heartbeatSocketTimeout = 1000;
    private int heartbeatFrequency = 2000;
    private boolean useSSL = false;
    private int maxBlockingThreadsMultiplier = 5;
    private int defaultW = 1;
    private int connectionTimeout = 1000;
    private int maxConnectionIdleTime = 100000;
    private int maxConnectionLifetime = 600000;
    private int minConnectionsPerHost = 1;
    private int maxConnectionsPerHost = 100;
    private int defaultWriteTimeout = 10000;
    private boolean slaveOk = true;

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    @Override
    public void setCredentials(String db, String login, char[] pwd) {
        if (this.credentials == null) {
            this.credentials = new HashMap<String, Map<String, char[]>>();
        }
        HashMap<String, char[]> cred = new HashMap<String, char[]>();
        cred.put(login, pwd);
        this.credentials.put(db, cred);
    }

    @Override
    public boolean isReplicaset() {
        return this.replicaSet;
    }

    @Override
    public List<String> listDatabases() throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        HashMap<String, Object> command = new HashMap<String, Object>();
        command.put("listDatabases", 1);
        Map<String, Object> res = this.runCommand("admin", command);
        ArrayList<String> ret = new ArrayList<String>();
        if (res.get("databases") != null) {
            List lst = (List)res.get("databases");
            for (Map db : lst) {
                if (db.get("name") != null) {
                    ret.add(db.get("name").toString());
                    continue;
                }
                this.log.error("No DB Name for this entry...");
            }
        }
        return ret;
    }

    @Override
    public List<String> listCollections(String db, String pattern) throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        LinkedHashMap<String, Object> command = new LinkedHashMap<String, Object>();
        command.put("listCollections", 1);
        if (pattern != null) {
            HashMap<String, Pattern> query = new HashMap<String, Pattern>();
            query.put("name", Pattern.compile(pattern));
            command.put("filter", query);
        }
        Map<String, Object> res = this.runCommand(db, command);
        ArrayList<Map<String, Object>> colList = new ArrayList<Map<String, Object>>();
        ArrayList<String> colNames = new ArrayList<String>();
        this.addToListFromCursor(db, colList, res);
        for (Map map : colList) {
            colNames.add(map.get("name").toString());
        }
        return colNames;
    }

    private void addToListFromCursor(String db, List<Map<String, Object>> data, Map<String, Object> res) throws MorphiumDriverException {
        boolean valid;
        Map<String, Object> crs = (Map<String, Object>)res.get("cursor");
        do {
            if (crs.get("firstBatch") != null) {
                data.addAll((List)crs.get("firstBatch"));
            } else if (crs.get("nextBatch") != null) {
                data.addAll((List)crs.get("firstBatch"));
            }
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            if (crs.get("id") != null && !crs.get("id").toString().equals("0")) {
                valid = true;
                doc.put("getMore", crs.get("id"));
                crs = this.runCommand(db, doc);
                continue;
            }
            valid = false;
        } while (valid);
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    public Map<String, Map<String, char[]>> getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Map<String, String[]> credentials) {
    }

    @Override
    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    @Override
    public void setRetriesOnNetworkError(int r) {
        if (r < 1) {
            r = 1;
        }
        this.retriesOnNetworkError = r;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenRetries;
    }

    @Override
    public void setSleepBetweenErrorRetries(int s) {
        if (s < 100) {
            s = 100;
        }
        this.sleepBetweenRetries = s;
    }

    public int getMaxBsonObjectSize() {
        return this.maxBsonObjectSize;
    }

    public void setMaxBsonObjectSize(int maxBsonObjectSize) {
        this.maxBsonObjectSize = maxBsonObjectSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
    }

    public boolean isReplicaSet() {
        return this.replicaSet;
    }

    public void setReplicaSet(boolean replicaSet) {
        this.replicaSet = replicaSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        Class<DriverBase> clazz = DriverBase.class;
        synchronized (DriverBase.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ++this.rqid;
        }
    }

    @Override
    public int getDefaultWriteTimeout() {
        return this.defaultWriteTimeout;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
        this.defaultWriteTimeout = wt;
    }

    @Override
    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectionTimeout;
    }

    @Override
    public void setHeartbeatConnectTimeout(int heartbeatConnectTimeout) {
        this.heartbeatConnectionTimeout = heartbeatConnectTimeout;
    }

    @Override
    public int getMaxWaitTime() {
        return this.maxWait;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWait = maxWaitTime;
    }

    @Override
    public boolean isSocketKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.keepAlive = socketKeepAlive;
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public boolean isDefaultFsync() {
        return false;
    }

    @Override
    public void setDefaultFsync(boolean j) {
    }

    @Override
    public String[] getHostSeed() {
        if (this.hostSeed == null) {
            return null;
        }
        return this.hostSeed.toArray(new String[this.hostSeed.size()]);
    }

    @Override
    public void setHostSeed(String ... host) {
        if (this.hostSeed == null) {
            this.hostSeed = new Vector<String>();
        }
        for (String h : host) {
            try {
                this.hostSeed.add(this.getHostAdress(h));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Could not add host", e);
            }
        }
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public void setMaxConnectionsPerHost(int mx) {
        this.maxConnectionsPerHost = mx;
    }

    @Override
    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Override
    public void setMinConnectionsPerHost(int mx) {
        this.minConnectionsPerHost = mx;
    }

    @Override
    public int getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
        this.maxConnectionLifetime = timeout;
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
        this.maxConnectionIdleTime = time;
    }

    @Override
    public int getSocketTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public int getDefaultW() {
        return this.defaultW;
    }

    @Override
    public void setDefaultW(int w) {
        this.defaultW = w;
    }

    @Override
    public int getMaxBlockintThreadMultiplier() {
        return this.maxBlockingThreadsMultiplier;
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
    }

    public abstract Map<String, Object> update(String var1, String var2, List<Map<String, Object>> var3, boolean var4, WriteConcern var5) throws MorphiumDriverException;

    @Override
    public Maximums getMaximums() {
        Maximums max = new Maximums();
        max.setMaxBsonSize(this.maxBsonObjectSize);
        max.setMaxMessageSize(this.maxMessageSize);
        max.setMaxWriteBatchSize(this.maxWriteBatchSize);
        return max;
    }

    public ReadPreference getDefaultReadPreference() {
        return this.defaultRP;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
        this.defaultRP = rp;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
    }

    @Override
    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    @Override
    public void setHeartbeatSocketTimeout(int heartbeatSocketTimeout) {
        this.heartbeatSocketTimeout = heartbeatSocketTimeout;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
    }

    @Override
    public boolean isDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public void setDefaultJ(boolean j) {
        this.defaultJ = j;
    }

    @Override
    public int getWriteTimeout() {
        return this.defaultWriteTimeout;
    }

    @Override
    public void setWriteTimeout(int writeTimeout) {
    }

    @Override
    public int getLocalThreshold() {
        return this.localThreshold;
    }

    @Override
    public void setLocalThreshold(int thr) {
        this.localThreshold = thr;
    }

    @Override
    public void setMaxBlockingThreadMultiplier(int m) {
        this.maxBlockingThreadsMultiplier = m;
    }

    @Override
    public void heartBeatFrequency(int t) {
        this.heartbeatFrequency = t;
    }

    @Override
    public void heartBeatSocketTimeout(int t) {
        this.heartbeatSocketTimeout = t;
    }

    @Override
    public void useSsl(boolean ssl) {
        this.useSSL = ssl;
    }

    public String getHostAdress(String hn) throws UnknownHostException {
        String[] hst = hn.split(":");
        String h = hst[0];
        int port = 27017;
        if (hst.length > 1) {
            port = Integer.valueOf(hst[1]);
        }
        InetAddress in = InetAddress.getByName(h);
        return in.getHostAddress() + ":" + port;
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) throws MorphiumDriverException {
        return this.mapReduce(db, collection, mapping, reducing, query, null);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) throws MorphiumDriverException {
        return this.mapReduce(db, collection, mapping, reducing, null, null);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting) throws MorphiumDriverException {
        Map<String, Object> result;
        LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
        cmd.put("mapReduce", collection);
        cmd.put("map", new MongoJSScript(mapping));
        cmd.put("reduce", new MongoJSScript(reducing));
        cmd.put("out", Utils.getMap("inline", 1));
        if (query != null) {
            cmd.put("query", query);
        }
        if (sorting != null) {
            cmd.put("sort", sorting);
        }
        if ((result = this.runCommand(db, cmd)) == null) {
            throw new MorphiumDriverException("Could not get proper result");
        }
        List results = (List)result.get("results");
        if (results == null) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Map d : results) {
            Map value = (Map)d.get("value");
            ret.add(value);
        }
        return ret;
    }

    protected abstract void sendQuery(OpQuery var1) throws MorphiumDriverException;

    protected abstract OpReply getReply(long var1, int var3) throws MorphiumDriverException;

    protected void killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return;
        }
        OpQuery q = new OpQuery();
        q.setDb(db);
        q.setColl("$cmd");
        q.setLimit(1);
        q.setSkip(0);
        q.setReqId(this.getNextId());
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        doc.put("killCursors", coll);
        doc.put("cursors", cursorIds);
        q.setDoc(doc);
        this.sendQuery(q);
    }

    @Override
    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> s, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        if (s == null) {
            s = new HashMap<String, Integer>();
        }
        Map<String, Integer> sort = s;
        new NetworkCallHelper().doCall(() -> {
            int t;
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setLimit(1);
            q.setSkip(0);
            q.setReqId(this.getNextId());
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            doc.put("find", collection);
            if (limit > 0) {
                doc.put("limit", limit);
            }
            doc.put("skip", skip);
            if (!query.isEmpty()) {
                doc.put("filter", query);
            }
            if (projection != null) {
                doc.put("projection", projection);
            }
            if ((t = timeout) == 0) {
                t = Integer.MAX_VALUE;
            }
            doc.put("sort", sort);
            doc.put("batchSize", batchSize);
            doc.put("maxTimeMS", t);
            doc.put("tailable", true);
            doc.put("awaitData", true);
            q.setDoc(doc);
            q.setInReplyTo(0);
            q.setTailableCursor(true);
            q.setAwaitData(true);
            q.setNoCursorTimeout(true);
            long start = System.currentTimeMillis();
            Object ret = null;
            this.sendQuery(q);
            long waitingfor = q.getReqId();
            this.log.info("Starting...");
            while (true) {
                this.log.debug("reading result");
                OpReply reply = this.getReply(waitingfor, t);
                if ((long)reply.getInReplyTo() != waitingfor) {
                    throw new MorphiumDriverNetworkException("Wrong answer - waiting for " + waitingfor + " but got " + reply.getInReplyTo());
                }
                Map cursor = (Map)reply.getDocuments().get(0).get("cursor");
                if (cursor == null) {
                    this.log.debug("no-cursor result");
                    if (reply.getDocuments().get(0).get("result") != null) {
                        for (Map d : (List)reply.getDocuments().get(0).get("result")) {
                            if (cb.incomingData(d, System.currentTimeMillis() - start)) continue;
                            return null;
                        }
                    }
                    this.log.error("did not get cursor. Data: " + Utils.toJsonString(reply.getDocuments().get(0)));
                    this.log.debug("Retrying");
                    continue;
                }
                if (cursor.get("firstBatch") != null) {
                    this.log.debug("Firstbatch...");
                    for (Map d : (List)cursor.get("firstBatch")) {
                        if (cb.incomingData(d, System.currentTimeMillis() - start)) continue;
                        return null;
                    }
                } else if (cursor.get("nextBatch") != null) {
                    this.log.debug("NextBatch...");
                    for (Map d : (List)cursor.get("nextBatch")) {
                        if (cb.incomingData(d, System.currentTimeMillis() - start)) continue;
                        return null;
                    }
                }
                if ((Long)cursor.get("id") == 0L) {
                    this.log.error("Cursor closed - reviving!");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    q = new OpQuery();
                    q.setDb(db);
                    q.setColl("$cmd");
                    q.setLimit(1);
                    q.setSkip(0);
                    q.setReqId(this.getNextId());
                    doc = new LinkedHashMap();
                    doc.put("find", collection);
                    if (limit > 0) {
                        doc.put("limit", limit);
                    }
                    doc.put("skip", skip);
                    if (!query.isEmpty()) {
                        doc.put("filter", query);
                    }
                    if (projection != null) {
                        doc.put("projection", projection);
                    }
                    doc.put("sort", sort);
                    doc.put("batchSize", 1);
                    doc.put("maxTimeMS", timeout);
                    q.setDoc(doc);
                    q.setInReplyTo(0);
                    q.setTailableCursor(true);
                    q.setAwaitData(true);
                    q.setNoCursorTimeout(true);
                    this.sendQuery(q);
                    continue;
                }
                this.log.debug("CursorID:" + cursor.get("id").toString());
                long cursorId = Long.valueOf(cursor.get("id").toString());
                q = new OpQuery();
                q.setColl("$cmd");
                q.setDb(db);
                q.setReqId(this.getNextId());
                q.setSkip(0);
                q.setTailableCursor(true);
                q.setAwaitData(true);
                q.setNoCursorTimeout(true);
                q.setSlaveOk(false);
                q.setLimit(1);
                doc = new LinkedHashMap();
                doc.put("getMore", cursorId);
                doc.put("collection", collection);
                doc.put("batchSize", batchSize);
                doc.put("maxTimeMS", timeout);
                q.setDoc(doc);
                waitingfor = q.getReqId();
                this.sendQuery(q);
                this.log.debug("sent getmore....");
            }
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }
}

