/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.singleconnect;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.StoreBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.singleconnect.DriverBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BulkContext
extends BulkRequestContext {
    private final DriverBase driver;
    private final boolean ordered;
    private final String db;
    private final String collection;
    private final WriteConcern wc;
    private final List<BulkRequest> requests;

    public BulkContext(Morphium m, String db, String collection, DriverBase driver, boolean ordered, int batchSize, WriteConcern wc) {
        super(m);
        this.driver = driver;
        this.ordered = ordered;
        this.db = db;
        this.collection = collection;
        this.wc = wc;
        this.setBatchSize(batchSize);
        this.requests = new ArrayList<BulkRequest>();
    }

    public void addRequest(BulkRequest br) {
        this.requests.add(br);
    }

    @Override
    public UpdateBulkRequest addUpdateBulkRequest() {
        UpdateBulkRequest up = new UpdateBulkRequest();
        this.addRequest(up);
        return up;
    }

    @Override
    public InsertBulkRequest addInsertBulkReqpest(List<Map<String, Object>> toInsert) {
        InsertBulkRequest in = new InsertBulkRequest(toInsert);
        this.addRequest(in);
        return in;
    }

    @Override
    public StoreBulkRequest addStoreBulkRequest(List<Map<String, Object>> toStore) {
        StoreBulkRequest store = new StoreBulkRequest(toStore);
        this.addRequest(store);
        return store;
    }

    @Override
    public DeleteBulkRequest addDeleteBulkRequest() {
        DeleteBulkRequest del = new DeleteBulkRequest();
        this.addRequest(del);
        return del;
    }

    @Override
    public Map<String, Object> execute() throws MorphiumDriverException {
        int count = 0;
        ArrayList results = new ArrayList();
        ArrayList<Map<String, Object>> inserts = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> stores = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updates = new ArrayList<Map<String, Object>>();
        for (BulkRequest br : this.requests) {
            if (br instanceof StoreBulkRequest) {
                stores.addAll(((StoreBulkRequest)br).getToInsert());
                if (stores.size() >= this.driver.getMaxWriteBatchSize()) {
                    this.driver.store(this.db, this.collection, stores, this.wc);
                    stores.clear();
                }
            } else if (br instanceof InsertBulkRequest) {
                inserts.addAll(((InsertBulkRequest)br).getToInsert());
                if (inserts.size() >= this.driver.getMaxWriteBatchSize()) {
                    this.driver.insert(this.db, this.collection, inserts, this.wc);
                    inserts.clear();
                }
            } else if (br instanceof DeleteBulkRequest) {
                this.driver.delete(this.db, this.collection, ((DeleteBulkRequest)br).getQuery(), ((DeleteBulkRequest)br).isMultiple(), this.wc);
            } else {
                UpdateBulkRequest up = (UpdateBulkRequest)br;
                HashMap<String, Object> cmd = new HashMap<String, Object>();
                cmd.put("q", up.getQuery());
                cmd.put("u", up.getCmd());
                cmd.put("upsert", up.isUpsert());
                cmd.put("multi", up.isMultiple());
                updates.add(cmd);
                if (updates.size() >= this.driver.getMaxWriteBatchSize()) {
                    this.driver.update(this.db, this.collection, updates, this.ordered, this.wc);
                    updates.clear();
                }
            }
            ++count;
        }
        if (!inserts.isEmpty()) {
            this.driver.insert(this.db, this.collection, inserts, this.wc);
        }
        if (!stores.isEmpty()) {
            this.driver.store(this.db, this.collection, stores, this.wc);
        }
        if (!updates.isEmpty()) {
            Map<String, Object> result = null;
            result = this.driver.update(this.db, this.collection, updates, this.ordered, this.wc);
        }
        HashMap res = new HashMap();
        boolean delCount = false;
        boolean matchedCount = false;
        boolean insertCount = false;
        boolean modifiedCount = false;
        boolean upsertCount = false;
        for (Map map : results) {
        }
        return null;
    }
}

