/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.cache.CacheElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheHousekeeper
extends Thread {
    private static final String MONGODBLAYER_CACHE = "mongodblayer.cache";
    private int timeout;
    private Map<Class<?>, Integer> validTimeForClass;
    private int gcTimeout;
    private boolean running = true;
    private Logger log = new Logger(CacheHousekeeper.class);
    private Morphium morphium;
    private AnnotationAndReflectionHelper annotationHelper;

    public CacheHousekeeper(Morphium m, int houseKeepingTimeout, int globalCacheTimout) {
        this.timeout = houseKeepingTimeout;
        this.gcTimeout = globalCacheTimout;
        this.morphium = m;
        this.annotationHelper = m.getARHelper();
        this.validTimeForClass = new HashMap();
        this.setDaemon(true);
    }

    public void setValidCacheTime(Class<?> cls, int timeout) {
        HashMap v = (HashMap)((HashMap)this.validTimeForClass).clone();
        v.put(cls, timeout);
        this.validTimeForClass = v;
    }

    public Integer getValidCacheTime(Class<?> cls) {
        return this.validTimeForClass.get(cls);
    }

    public void end() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                HashMap toDelete = new HashMap();
                Map<Class<?>, Map<String, CacheElement>> cache = this.morphium.getCache().cloneCache();
                for (Map.Entry<Class<?>, Map<String, CacheElement>> es : cache.entrySet()) {
                    Class<?> clz = es.getKey();
                    Map ch = (Map)((HashMap)es.getValue()).clone();
                    int maxEntries = -1;
                    Cache cacheSettings = this.annotationHelper.getAnnotationFromHierarchy(clz, Cache.class);
                    NoCache noCache = this.annotationHelper.getAnnotationFromHierarchy(clz, NoCache.class);
                    int time = this.gcTimeout;
                    HashMap lruTime = new HashMap();
                    HashMap fifoTime = new HashMap();
                    Cache.ClearStrategy strategy = null;
                    if (noCache == null && cacheSettings != null) {
                        time = cacheSettings.timeout();
                        maxEntries = cacheSettings.maxEntries();
                        strategy = cacheSettings.strategy();
                        if (this.validTimeForClass.get(clz) == null) {
                            this.validTimeForClass.put(clz, time);
                        }
                    }
                    if (this.validTimeForClass.get(clz) != null) {
                        time = this.validTimeForClass.get(clz);
                    }
                    int del = 0;
                    for (Map.Entry est : ch.entrySet()) {
                        String k = (String)est.getKey();
                        CacheElement e = (CacheElement)est.getValue();
                        if (e == null || e.getFound() == null || System.currentTimeMillis() - e.getCreated() > (long)time) {
                            if (toDelete.get(clz) == null) {
                                toDelete.put(clz, new ArrayList());
                            }
                            ((List)toDelete.get(clz)).add(k);
                            ++del;
                            continue;
                        }
                        if (lruTime.get(e.getLru()) == null) {
                            lruTime.put(e.getLru(), new ArrayList());
                        }
                        ((List)lruTime.get(e.getLru())).add(k);
                        long fifo = System.currentTimeMillis() - e.getCreated();
                        if (fifoTime.get(fifo) == null) {
                            fifoTime.put(fifo, new ArrayList());
                        }
                        ((List)fifoTime.get(fifo)).add(k);
                    }
                    cache.put(clz, ch);
                    if (maxEntries <= 0 || cache.get(clz).size() - del <= maxEntries) continue;
                    switch (strategy) {
                        case LRU: {
                            Object[] array = lruTime.keySet().toArray(new Long[lruTime.keySet().size()]);
                            Arrays.sort(array);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).size() == 0) continue;
                                if (toDelete.get(clz) == null) {
                                    toDelete.put(clz, new ArrayList());
                                }
                                ((List)toDelete.get(clz)).add(((List)lruTime.get(array[idx])).get(0));
                                ((List)lruTime.get(array[idx])).remove(0);
                                ++del;
                                if (((List)lruTime.get(array[idx])).size() != 0) continue;
                                ++idx;
                            }
                            break;
                        }
                        case FIFO: {
                            Object[] array = fifoTime.keySet().toArray(new Long[fifoTime.keySet().size()]);
                            Arrays.sort(array);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (fifoTime.get(array[array.length - 1 - idx]) == null || ((List)fifoTime.get(array[array.length - 1 - idx])).size() == 0) continue;
                                if (toDelete.get(clz) == null) {
                                    toDelete.put(clz, new ArrayList());
                                }
                                ((List)toDelete.get(clz)).add(((List)fifoTime.get(array[array.length - 1 - idx])).get(0));
                                ((List)fifoTime.get(array[array.length - 1 - idx])).remove(0);
                                ++del;
                                if (((List)fifoTime.get(array[array.length - 1 - idx])).size() != 0) continue;
                                ++idx;
                            }
                            break;
                        }
                        case RANDOM: {
                            Object[] array = fifoTime.keySet().toArray(new Long[fifoTime.keySet().size()]);
                            List<Object> lst = Arrays.asList(array);
                            Collections.shuffle(lst);
                            array = lst.toArray(new Long[lst.size()]);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).size() == 0) continue;
                                if (toDelete.get(clz) == null) {
                                    toDelete.put(clz, new ArrayList());
                                }
                                ((List)toDelete.get(clz)).add(((List)lruTime.get(array[idx])).get(0));
                                ++del;
                                if (((List)lruTime.get(array[idx])).size() != 0) continue;
                                ++idx;
                            }
                            break;
                        }
                    }
                }
                Map<Class<?>, Map<Object, Object>> idCacheClone = this.morphium.getCache().cloneIdCache();
                for (Map.Entry et : toDelete.entrySet()) {
                    Class cls = (Class)et.getKey();
                    boolean inIdCache = idCacheClone.get(cls) != null;
                    for (String k : (List)et.getValue()) {
                        if (k.endsWith("idlist")) continue;
                        if (inIdCache) {
                            for (Object f : cache.get(cls).get(k).getFound()) {
                                idCacheClone.get(cls).remove(this.morphium.getId(f));
                            }
                        }
                        cache.get(cls).remove(k);
                    }
                }
                this.morphium.getCache().setCache(cache);
                this.morphium.getCache().setIdCache(idCacheClone);
            }
            catch (Throwable e) {
                this.log.warn("Error:" + e.getMessage(), e);
            }
            try {
                CacheHousekeeper.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                this.log.info("Ignoring InterruptedException");
            }
        }
    }
}

