/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class LazyDeReferencingProxy<T>
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 3777709000906217075L;
    private final transient Morphium morphium;
    private final String fieldname;
    private final Object container;
    private T deReferenced;
    private Class<? extends T> cls;
    private Object id;
    private static final Logger log = new Logger(LazyDeReferencingProxy.class);

    public LazyDeReferencingProxy(Morphium m, Class<? extends T> type, Object id, Object container, String fieldname) {
        this.cls = type;
        this.id = id;
        this.morphium = m;
        this.container = container;
        this.fieldname = fieldname;
    }

    public T __getPureDeref() {
        return this.deReferenced;
    }

    public T __getDeref() {
        try {
            this.dereference();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return this.deReferenced;
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        if (method.getName().equals("getClass")) {
            return this.cls;
        }
        if (method.getName().equals("__getType")) {
            return this.cls;
        }
        if (method.getName().equals("finalize")) {
            return methodProxy.invokeSuper(o, objects);
        }
        if (method.getName().equals("__getPureDeref")) {
            return this.deReferenced;
        }
        this.dereference();
        if (method.getName().equals("__getDeref")) {
            return this.deReferenced;
        }
        if (this.deReferenced != null) {
            return method.invoke(this.deReferenced, objects);
        }
        return methodProxy.invokeSuper(o, objects);
    }

    private void dereference() {
        if (this.deReferenced == null) {
            if (log.isDebugEnabled()) {
                log.debug("DeReferencing due to first access");
            }
            try {
                this.morphium.fireWouldDereference(this.container, this.fieldname, this.id, this.cls, true);
                this.deReferenced = this.morphium.findById(this.cls, this.id);
                this.morphium.fireDidDereference(this.container, this.fieldname, this.deReferenced, true);
            }
            catch (MorphiumAccessVetoException e) {
                log.info("did not dereference due to VetoException from listener", e);
            }
        }
    }
}

