/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.DB;
import com.mongodb.ServerAddress;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorFactory;
import de.caluga.morphium.aggregation.AggregatorFactoryImpl;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.MorphiumCacheImpl;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MongoFieldImpl;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.MorphiumIteratorImpl;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.query.QueryFactory;
import de.caluga.morphium.query.QueryFactoryImpl;
import de.caluga.morphium.query.QueryImpl;
import de.caluga.morphium.writer.AsyncWriterImpl;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.json.simple.parser.ParseException;

@Embedded
public class MorphiumConfig {
    private String loggingConfigFile;
    @AdditionalData(readOnly=false)
    private Map<String, String> restoreData;
    private int maxConnections;
    private int housekeepingTimeout;
    private int globalCacheValidTime = 5000;
    private int writeCacheTimeout = 5000;
    private String database;
    @Transient
    private DB db = null;
    @Transient
    private MorphiumWriter writer;
    @Transient
    private MorphiumWriter bufferedWriter;
    @Transient
    private MorphiumWriter asyncWriter;
    private int connectionTimeout = 0;
    private int socketTimeout = 0;
    private boolean socketKeepAlive = true;
    private boolean safeMode = false;
    private boolean globalFsync = false;
    private boolean globalJ = false;
    private boolean checkForNew = false;
    private int writeTimeout = 0;
    private int maximumRetriesBufferedWriter = 10;
    private int maximumRetriesWriter = 10;
    private int maximumRetriesAsyncWriter = 10;
    private int retryWaitTimeBufferedWriter = 200;
    private int retryWaitTimeWriter = 200;
    private int retryWaitTimeAsyncWriter = 200;
    private int globalW = 1;
    private int maxWaitTime = 120000;
    private int writeBufferTime = 1000;
    private int writeBufferTimeGranularity = 100;
    private boolean autoreconnect = true;
    private int maxAutoReconnectTime = 0;
    private int blockingThreadsMultiplier = 5;
    @Transient
    private Class<? extends Query> queryClass;
    @Transient
    private Class<? extends Aggregator> aggregatorClass;
    @Transient
    private QueryFactory queryFact;
    @Transient
    private AggregatorFactory aggregatorFactory;
    @Transient
    private MorphiumCache cache;
    private int replicaSetMonitoringTimeout = 5000;
    private int retriesOnNetworkError = 1;
    private int sleepBetweenNetworkErrorRetries = 1000;
    private String mongoLogin = null;
    private String mongoPassword = null;
    private boolean autoValues = true;
    boolean readCacheEnabled = true;
    boolean asyncWritesEnabled = true;
    boolean bufferedWritesEnabled = true;
    @Transient
    private List<ServerAddress> adr = new Vector<ServerAddress>();
    private String mongoAdminUser;
    private String mongoAdminPwd;
    @Transient
    private Class<? extends ObjectMapper> omClass = ObjectMapperImpl.class;
    @Transient
    private Class<? extends MongoField> fieldImplClass = MongoFieldImpl.class;
    @Transient
    private ReadPreferenceLevel defaultReadPreference;
    @Transient
    private Class<? extends MorphiumIterator> iteratorClass;

    public MorphiumConfig(Properties prop) {
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper();
        List<Field> flds = an.getAllFields(MorphiumConfig.class);
        for (Field f : flds) {
            if (f.isAnnotationPresent(Transient.class)) continue;
            f.setAccessible(true);
            if (prop.getProperty(f.getName()) == null) continue;
            try {
                if (f.getType().equals(Integer.TYPE) || f.getType().equals(Integer.class)) {
                    f.set(this, Integer.parseInt((String)prop.get(f.getName())));
                    continue;
                }
                if (f.getType().equals(String.class)) {
                    f.set(this, prop.get(f.getName()));
                    continue;
                }
                if (f.getType().equals(Boolean.TYPE) || f.getType().equals(Boolean.class)) {
                    f.set(this, prop.get(f.getName()).equals("true"));
                    continue;
                }
                if (!f.getType().equals(Long.TYPE) && !f.getType().equals(Long.class)) continue;
                f.set(this, Long.parseLong((String)prop.get(f.getName())));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            MorphiumConfig.parseClassSettings(this, prop);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.configureLogging();
    }

    public MorphiumConfig() {
        this("test", 10, 60000, 10000, (URL)null);
    }

    public MorphiumConfig(String db, int maxConnections, int globalCacheValidTime, int housekeepingTimeout) throws IOException {
        this(db, maxConnections, globalCacheValidTime, housekeepingTimeout, Thread.currentThread().getContextClassLoader().getResource("morphium-log4j.xml"));
    }

    public MorphiumConfig(String db, int maxConnections, int globalCacheValidTime, int housekeepingTimeout, String resourceName) throws IOException {
        this(db, maxConnections, globalCacheValidTime, housekeepingTimeout, Thread.currentThread().getContextClassLoader().getResource(resourceName));
    }

    public MorphiumConfig(String db, int maxConnections, int globalCacheValidTime, int housekeepingTimeout, URL loggingConfigResource) {
        this.database = db;
        this.adr = new Vector<ServerAddress>();
        if (loggingConfigResource != null) {
            this.loggingConfigFile = loggingConfigResource.toString();
        }
        this.maxConnections = maxConnections;
        this.globalCacheValidTime = globalCacheValidTime;
        this.housekeepingTimeout = housekeepingTimeout;
        this.configureLogging();
    }

    public boolean isCheckForNew() {
        return this.checkForNew;
    }

    public void setCheckForNew(boolean checkForNew) {
        this.checkForNew = checkForNew;
    }

    public String getLoggingConfigFile() {
        return this.loggingConfigFile;
    }

    public void setLoggingConfigFile(String loggingConfigFile) {
        this.loggingConfigFile = loggingConfigFile;
    }

    public void configureLogging() {
        if (this.loggingConfigFile == null) {
            System.out.println("Not configuring logging - logging config file not set");
            return;
        }
        if (MorphiumConfig.isLoggingConfigured()) {
            Logger.getLogger(MorphiumConfig.class).info((Object)"Logging already configured");
            return;
        }
        if (this.loggingConfigFile != null && !MorphiumConfig.isLoggingConfigured()) {
            try {
                DOMConfigurator.configure((URL)new URL(this.loggingConfigFile));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean isLoggingConfigured() {
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        if (appenders.hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger c = (Logger)loggers.nextElement();
            if (!c.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public static MorphiumConfig createFromJson(String json) throws ParseException, NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InstantiationException, UnknownHostException, NoSuchMethodException, InvocationTargetException {
        MorphiumConfig cfg = new ObjectMapperImpl().unmarshall(MorphiumConfig.class, json);
        MorphiumConfig.parseClassSettings(cfg, cfg.restoreData);
        cfg.configureLogging();
        return cfg;
    }

    private static void parseClassSettings(MorphiumConfig cfg, Map settings) throws UnknownHostException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        for (Object ko : settings.keySet()) {
            String[] n;
            String k = (String)ko;
            String value = (String)settings.get(k);
            if (k.equals("hosts")) {
                String lst = value;
                for (String adr : lst.split(",")) {
                    String[] a = adr.split(":");
                    cfg.addHost(a[0].trim(), Integer.parseInt(a[1].trim()));
                }
                continue;
            }
            if (!k.endsWith("ClassName") || (n = k.split("_")).length != 3) continue;
            Class<?> cls = Class.forName(value);
            Field f = MorphiumConfig.class.getDeclaredField(n[0]);
            f.setAccessible(true);
            if (n[1].equals("C")) {
                f.set(cfg, cls);
                continue;
            }
            if (!n[1].equals("I")) continue;
            f.set(cfg, cls.newInstance());
        }
        cfg.getAggregatorFactory().setAggregatorClass(cfg.getAggregatorClass());
        cfg.getQueryFact().setQueryImpl(cfg.getQueryClass());
    }

    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    public void setRetriesOnNetworkError(int retriesOnNetworkError) {
        if (retriesOnNetworkError == 0) {
            Logger.getLogger(MorphiumConfig.class).warn((Object)"Cannot set retries on network error to 0 - minimum is 1");
            retriesOnNetworkError = 1;
        }
        this.retriesOnNetworkError = retriesOnNetworkError;
    }

    public int getSleepBetweenNetworkErrorRetries() {
        return this.sleepBetweenNetworkErrorRetries;
    }

    public void setSleepBetweenNetworkErrorRetries(int sleepBetweenNetworkErrorRetries) {
        this.sleepBetweenNetworkErrorRetries = sleepBetweenNetworkErrorRetries;
    }

    public int getReplicaSetMonitoringTimeout() {
        return this.replicaSetMonitoringTimeout;
    }

    public void setReplicaSetMonitoringTimeout(int replicaSetMonitoringTimeout) {
        this.replicaSetMonitoringTimeout = replicaSetMonitoringTimeout;
    }

    public int getWriteBufferTimeGranularity() {
        return this.writeBufferTimeGranularity;
    }

    public void setWriteBufferTimeGranularity(int writeBufferTimeGranularity) {
        this.writeBufferTimeGranularity = writeBufferTimeGranularity;
    }

    public MorphiumCache getCache() {
        if (this.cache == null) {
            this.cache = new MorphiumCacheImpl();
        }
        return this.cache;
    }

    public void setCache(MorphiumCache cache) {
        this.cache = cache;
    }

    public int getWriteBufferTime() {
        return this.writeBufferTime;
    }

    public void setWriteBufferTime(int writeBufferTime) {
        this.writeBufferTime = writeBufferTime;
    }

    public Class<? extends ObjectMapper> getOmClass() {
        return this.omClass;
    }

    public void setOmClass(Class<? extends ObjectMapper> omClass) {
        this.omClass = omClass;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getGlobalW() {
        return this.globalW;
    }

    public void setGlobalW(int globalW) {
        this.globalW = globalW;
    }

    public boolean isGlobalJ() {
        return this.globalJ;
    }

    public void setGlobalJ(boolean globalJ) {
        this.globalJ = globalJ;
    }

    public Class<? extends Query> getQueryClass() {
        if (this.queryClass == null) {
            this.queryClass = QueryImpl.class;
        }
        return this.queryClass;
    }

    public void setQueryClass(Class<Query> queryClass) {
        this.queryClass = queryClass;
    }

    public QueryFactory getQueryFact() {
        if (this.queryFact == null) {
            this.queryFact = new QueryFactoryImpl(this.getQueryClass());
        }
        return this.queryFact;
    }

    public void setQueryFact(QueryFactory queryFact) {
        this.queryFact = queryFact;
    }

    public AggregatorFactory getAggregatorFactory() {
        if (this.aggregatorFactory == null) {
            this.aggregatorFactory = new AggregatorFactoryImpl(this.getAggregatorClass());
        }
        return this.aggregatorFactory;
    }

    public void setAggregatorFactory(AggregatorFactory aggregatorFactory) {
        this.aggregatorFactory = aggregatorFactory;
    }

    public Class<? extends Aggregator> getAggregatorClass() {
        if (this.aggregatorClass == null) {
            this.aggregatorClass = AggregatorImpl.class;
        }
        return this.aggregatorClass;
    }

    public void setAggregatorClass(Class<? extends Aggregator> aggregatorClass) {
        this.aggregatorClass = aggregatorClass;
    }

    public boolean isGlobalFsync() {
        return this.globalFsync;
    }

    public void setGlobalFsync(boolean globalFsync) {
        this.globalFsync = globalFsync;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public int getBlockingThreadsMultiplier() {
        return this.blockingThreadsMultiplier;
    }

    public void setBlockingThreadsMultiplier(int blockingThreadsMultiplier) {
        this.blockingThreadsMultiplier = blockingThreadsMultiplier;
    }

    public MorphiumWriter getBufferedWriter() {
        if (this.bufferedWriter == null) {
            this.bufferedWriter = new BufferedMorphiumWriterImpl();
        }
        return this.bufferedWriter;
    }

    public void setBufferedWriter(MorphiumWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public DB getDb() {
        return this.db;
    }

    public void setDb(DB db) {
        this.db = db;
    }

    public MorphiumWriter getWriter() {
        if (this.writer == null) {
            this.writer = new MorphiumWriterImpl();
        }
        return this.writer;
    }

    public void setWriter(MorphiumWriter writer) {
        this.writer = writer;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Class<? extends MongoField> getFieldImplClass() {
        return this.fieldImplClass;
    }

    public void setFieldImplClass(Class<? extends MongoField> fieldImplClass) {
        this.fieldImplClass = fieldImplClass;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public boolean isAutoreconnect() {
        return this.autoreconnect;
    }

    public void setAutoreconnect(boolean autoreconnect) {
        this.autoreconnect = autoreconnect;
    }

    public int getMaxAutoReconnectTime() {
        return this.maxAutoReconnectTime;
    }

    public void setMaxAutoReconnectTime(int maxAutoReconnectTime) {
        this.maxAutoReconnectTime = maxAutoReconnectTime;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public String getMongoLogin() {
        return this.mongoLogin;
    }

    public void setMongoLogin(String mongoLogin) {
        this.mongoLogin = mongoLogin;
    }

    public String getMongoPassword() {
        return this.mongoPassword;
    }

    public void setMongoPassword(String mongoPassword) {
        this.mongoPassword = mongoPassword;
    }

    public ReadPreferenceLevel getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    public void setDefaultReadPreference(ReadPreferenceLevel defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
    }

    public String getMongoAdminUser() {
        return this.mongoAdminUser;
    }

    public void setMongoAdminUser(String mongoAdminUser) {
        this.mongoAdminUser = mongoAdminUser;
    }

    public String getMongoAdminPwd() {
        return this.mongoAdminPwd;
    }

    public void setMongoAdminPwd(String mongoAdminPwd) {
        this.mongoAdminPwd = mongoAdminPwd;
    }

    public int getWriteCacheTimeout() {
        return this.writeCacheTimeout;
    }

    public void setWriteCacheTimeout(int writeCacheTimeout) {
        this.writeCacheTimeout = writeCacheTimeout;
    }

    public List<ServerAddress> getAdr() {
        return this.adr;
    }

    public void setAdr(List<ServerAddress> adr) {
        this.adr = adr;
    }

    public void setHosts(List<String> str) throws UnknownHostException {
        this.adr.clear();
        for (String s : str) {
            String[] h = (s = s.replaceAll(" ", "")).split(":");
            if (h.length == 1) {
                this.addHost(h[0], 27017);
                continue;
            }
            this.addHost(h[0], Integer.parseInt(h[1]));
        }
    }

    public void setHosts(List<String> str, List<Integer> ports) throws UnknownHostException {
        this.adr.clear();
        for (int i = 0; i < str.size(); ++i) {
            String host = str.get(i).replaceAll(" ", "");
            if (ports.size() < i) {
                this.addHost(host, 27017);
                continue;
            }
            this.addHost(host, ports.get(i));
        }
    }

    public void setHosts(String hostPorts) throws UnknownHostException {
        String[] h;
        this.adr.clear();
        for (String host : h = hostPorts.split(",")) {
            this.addHost(host);
        }
    }

    public void setHosts(String hosts, String ports) throws UnknownHostException {
        this.adr.clear();
        hosts = hosts.replaceAll(" ", "");
        ports = ports.replaceAll(" ", "");
        String[] h = hosts.split(",");
        String[] p = ports.split(",");
        for (int i = 0; i < h.length; ++i) {
            if (p.length < i) {
                this.addHost(h[i], 27017);
                continue;
            }
            this.addHost(h[i], Integer.parseInt(p[i]));
        }
    }

    @Deprecated
    public void addAddress(String host, int port) throws UnknownHostException {
        this.addHost(host, port);
    }

    public void addHost(String host, int port) throws UnknownHostException {
        host = host.replaceAll(" ", "");
        ServerAddress sa = new ServerAddress(host, port);
        this.adr.add(sa);
    }

    @Deprecated
    public void addAddress(String host) throws UnknownHostException {
        this.addHost(host);
    }

    public void addHost(String host) throws UnknownHostException {
        if ((host = host.replaceAll(" ", "")).contains(":")) {
            String[] h = host.split(":");
            this.addHost(h[0], Integer.parseInt(h[1]));
        } else {
            this.addHost(host, 27017);
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getGlobalCacheValidTime() {
        return this.globalCacheValidTime;
    }

    public void setGlobalCacheValidTime(int globalCacheValidTime) {
        this.globalCacheValidTime = globalCacheValidTime;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getHousekeepingTimeout() {
        return this.housekeepingTimeout;
    }

    public void setHousekeepingTimeout(int housekeepingTimeout) {
        this.housekeepingTimeout = housekeepingTimeout;
    }

    public long getValidTime() {
        return this.globalCacheValidTime;
    }

    public void setValidTime(int tm) {
        this.globalCacheValidTime = tm;
    }

    public String toString() {
        this.updateAdditionals();
        try {
            return this.getOmClass().newInstance().marshall(this).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateAdditionals() {
        this.restoreData = new HashMap<String, String>();
        this.addClassSettingsTo(this.restoreData);
    }

    private void addClassSettingsTo(Map p) {
        MorphiumConfig defaults = new MorphiumConfig();
        this.getWriter();
        this.getBufferedWriter();
        this.getAsyncWriter();
        if (!defaults.getWriter().getClass().equals(this.getWriter().getClass())) {
            p.put("writer_I_ClassName", this.getWriter().getClass().getName());
        }
        if (!defaults.getBufferedWriter().getClass().equals(this.getBufferedWriter().getClass())) {
            p.put("bufferedWriter_I_ClassName", this.getBufferedWriter().getClass().getName());
        }
        if (!defaults.getAsyncWriter().getClass().equals(this.getAsyncWriter().getClass())) {
            p.put("asyncWriter_I_ClassName", this.getAsyncWriter().getClass().getName());
        }
        if (!defaults.getCache().getClass().equals(this.getCache().getClass())) {
            p.put("cache_I_ClassName", this.getCache().getClass().getName());
        }
        if (!defaults.getAggregatorClass().equals(this.getAggregatorClass())) {
            p.put("aggregatorClass_C_ClassName", this.getAggregatorClass().getName());
        }
        if (!defaults.getAggregatorFactory().getClass().equals(this.getAggregatorFactory().getClass())) {
            p.put("aggregatorFactory_I_ClassName", this.getAggregatorFactory().getClass().getName());
        }
        if (!defaults.getIteratorClass().equals(this.getIteratorClass())) {
            p.put("iteratorClass_C_ClassName", this.getIteratorClass().getName());
        }
        if (!defaults.getOmClass().equals(this.getOmClass())) {
            p.put("omClass_C_ClassName", this.getOmClass().getName());
        }
        if (!defaults.getQueryClass().equals(this.getQueryClass())) {
            p.put("queryClass_C_ClassName", this.getQueryClass().getName());
        }
        if (!defaults.getQueryFact().getClass().equals(this.getQueryFact().getClass())) {
            p.put("queryFact_I_ClassName", this.getQueryFact().getClass().getName());
        }
        StringBuilder b = new StringBuilder();
        String del = "";
        for (ServerAddress a : this.getAdr()) {
            b.append(del);
            b.append(a.getHost() + ":" + a.getPort());
            del = ", ";
        }
        p.put("hosts", b.toString());
    }

    public Class<? extends MorphiumIterator> getIteratorClass() {
        if (this.iteratorClass == null) {
            this.iteratorClass = MorphiumIteratorImpl.class;
        }
        return this.iteratorClass;
    }

    public void setIteratorClass(Class<? extends MorphiumIterator> iteratorClass) {
        this.iteratorClass = iteratorClass;
    }

    public MorphiumWriter getAsyncWriter() {
        if (this.asyncWriter == null) {
            this.asyncWriter = new AsyncWriterImpl();
        }
        return this.asyncWriter;
    }

    public void setAsyncWriter(MorphiumWriter asyncWriter) {
        this.asyncWriter = asyncWriter;
    }

    public int getMaximumRetriesBufferedWriter() {
        return this.maximumRetriesBufferedWriter;
    }

    public void setMaximumRetriesBufferedWriter(int maximumRetriesBufferedWriter) {
        this.maximumRetriesBufferedWriter = maximumRetriesBufferedWriter;
    }

    public int getMaximumRetriesWriter() {
        return this.maximumRetriesWriter;
    }

    public void setMaximumRetriesWriter(int maximumRetriesWriter) {
        this.maximumRetriesWriter = maximumRetriesWriter;
    }

    public int getMaximumRetriesAsyncWriter() {
        return this.maximumRetriesAsyncWriter;
    }

    public void setMaximumRetriesAsyncWriter(int maximumRetriesAsyncWriter) {
        this.maximumRetriesAsyncWriter = maximumRetriesAsyncWriter;
    }

    public int getRetryWaitTimeBufferedWriter() {
        return this.retryWaitTimeBufferedWriter;
    }

    public void setRetryWaitTimeBufferedWriter(int retryWaitTimeBufferedWriter) {
        this.retryWaitTimeBufferedWriter = retryWaitTimeBufferedWriter;
    }

    public int getRetryWaitTimeWriter() {
        return this.retryWaitTimeWriter;
    }

    public void setRetryWaitTimeWriter(int retryWaitTimeWriter) {
        this.retryWaitTimeWriter = retryWaitTimeWriter;
    }

    public int getRetryWaitTimeAsyncWriter() {
        return this.retryWaitTimeAsyncWriter;
    }

    public void setRetryWaitTimeAsyncWriter(int retryWaitTimeAsyncWriter) {
        this.retryWaitTimeAsyncWriter = retryWaitTimeAsyncWriter;
    }

    public Properties asProperties() {
        MorphiumConfig defaults = new MorphiumConfig();
        Properties p = new Properties();
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper();
        List<Field> flds = an.getAllFields(MorphiumConfig.class);
        for (Field f : flds) {
            if (f.isAnnotationPresent(Transient.class)) continue;
            f.setAccessible(true);
            try {
                if (f.get(this) == null || f.get(this).equals(f.get(defaults))) continue;
                p.put(f.getName(), f.get(this).toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.addClassSettingsTo(p);
        return p;
    }

    public static MorphiumConfig fromProperties(Properties p) throws ClassNotFoundException, NoSuchFieldException, InstantiationException, IllegalAccessException, UnknownHostException {
        return new MorphiumConfig(p);
    }

    public boolean isReadCacheEnabled() {
        return this.readCacheEnabled;
    }

    public void setReadCacheEnabled(boolean readCacheEnabled) {
        this.readCacheEnabled = readCacheEnabled;
    }

    public void disableReadCache() {
        this.readCacheEnabled = false;
    }

    public void enableReadCache() {
        this.readCacheEnabled = true;
    }

    public boolean isAsyncWritesEnabled() {
        return this.asyncWritesEnabled;
    }

    public void setAsyncWritesEnabled(boolean asyncWritesEnabled) {
        this.asyncWritesEnabled = asyncWritesEnabled;
    }

    public void disableAsyncWrites() {
        this.asyncWritesEnabled = false;
    }

    public void enableAsyncWrites() {
        this.asyncWritesEnabled = true;
    }

    public boolean isBufferedWritesEnabled() {
        return this.bufferedWritesEnabled;
    }

    public void setBufferedWritesEnabled(boolean bufferedWritesEnabled) {
        this.bufferedWritesEnabled = bufferedWritesEnabled;
    }

    public void disableBufferedWrites() {
        this.bufferedWritesEnabled = false;
    }

    public void enableBufferedWrites() {
        this.bufferedWritesEnabled = true;
    }

    public void setAutoValuesEnabled(boolean enabled) {
        this.autoValues = enabled;
    }

    public boolean isAutoValuesEnabled() {
        return this.autoValues;
    }

    public void enableAutoValues() {
        this.autoValues = true;
    }

    public void disableAutoValues() {
        this.autoValues = false;
    }
}

