/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;

public class BufferedMorphiumWriterImpl
implements MorphiumWriter {
    private Morphium morphium;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private MorphiumWriter directWriter;
    private Map<Class<?>, List<WriteBufferEntry>> opLog = new Hashtable();
    private Map<Class<?>, Long> lastRun = new Hashtable();
    private Thread housekeeping;
    private boolean running = true;
    private static Logger logger = Logger.getLogger(BufferedMorphiumWriterImpl.class);

    private List<WriteBufferEntry> flushToQueue(List<WriteBufferEntry> localQueue) {
        ArrayList<WriteBufferEntry> didNotWrite = new ArrayList<WriteBufferEntry>();
        for (WriteBufferEntry entry : localQueue) {
            try {
                entry.getToRun().run();
            }
            catch (RejectedExecutionException e) {
                logger.info((Object)"too much load - add write to next run");
                didNotWrite.add(entry);
            }
            catch (Exception e) {
                logger.error((Object)"could not write", (Throwable)e);
            }
        }
        localQueue = null;
        return didNotWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWriteQueue(Class<?> type, Runnable r) {
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            WriteBufferEntry wb = new WriteBufferEntry(r, System.currentTimeMillis());
            if (this.opLog.get(type) == null) {
                this.opLog.put(type, new Vector());
            }
            WriteBuffer w = this.annotationHelper.getAnnotationFromHierarchy(type, WriteBuffer.class);
            int size = 0;
            int timeout = this.morphium.getConfig().getWriteBufferTime();
            WriteBuffer.STRATEGY strategy = WriteBuffer.STRATEGY.JUST_WARN;
            if (w != null) {
                size = w.size();
                timeout = w.timeout();
                strategy = w.strategy();
            }
            if (size > 0 && this.opLog.get(type).size() > size) {
                logger.warn((Object)("WARNING: Write buffer maximum exceeded: " + this.opLog.get(type).size() + " entries now, max is " + size));
                switch (strategy) {
                    case JUST_WARN: {
                        break;
                    }
                    case IGNORE_NEW: {
                        logger.warn((Object)"ignoring new incoming...");
                        return;
                    }
                    case WRITE_NEW: {
                        logger.warn((Object)"directly writing data... due to strategy setting");
                        r.run();
                        return;
                    }
                    case WRITE_OLD: {
                        Collections.sort(this.opLog.get(type), new Comparator<WriteBufferEntry>(){

                            @Override
                            public int compare(WriteBufferEntry o1, WriteBufferEntry o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                        this.opLog.get(type).get(0).getToRun().run();
                        this.opLog.get(type).remove(0);
                        break;
                    }
                    case DEL_OLD: {
                        Collections.sort(this.opLog.get(type), new Comparator<WriteBufferEntry>(){

                            @Override
                            public int compare(WriteBufferEntry o1, WriteBufferEntry o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Deleting oldest entry");
                        }
                        this.opLog.get(type).remove(0);
                    }
                }
            }
            this.opLog.get(type).add(wb);
        }
    }

    @Override
    public <T> void store(final T o, final String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.store(o, collection, callback);
            }
        });
    }

    @Override
    public <T> void store(final List<T> lst, AsyncOperationCallback<T> c) {
        if (lst == null || lst.size() == 0) {
            if (c != null) {
                c.onOperationSucceeded(AsyncOperationType.WRITE, null, 0L, lst, null, new Object[0]);
            }
            return;
        }
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<Object> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(lst.get(0).getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.store(lst, callback);
            }
        });
    }

    @Override
    public <T> void updateUsingFields(final T ent, final String collection, AsyncOperationCallback<T> c, final String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(ent.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.updateUsingFields(ent, collection, callback, fields);
            }
        });
    }

    @Override
    public <T> void set(final T toSet, final String collection, final String field, final Object value, final boolean insertIfNotExists, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toSet.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.set(toSet, collection, field, value, insertIfNotExists, multiple, callback);
            }
        });
    }

    @Override
    public <T> void set(final Query<T> query, final Map<String, Object> values, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.set(query, values, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void inc(final Query<T> query, final Map<String, Double> fieldsToInc, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.inc(query, fieldsToInc, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void inc(final Query<T> query, final String field, final double amount, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.inc(query, field, amount, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void inc(final T toInc, final String collection, final String field, final double amount, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toInc.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.inc(toInc, collection, field, amount, callback);
            }
        });
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m.getARHelper();
        this.directWriter = m.getConfig().getWriter();
        this.housekeeping = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (BufferedMorphiumWriterImpl.this.running) {
                    try {
                        ArrayList<Class> localBuffer = new ArrayList<Class>();
                        Map map = BufferedMorphiumWriterImpl.this.opLog;
                        synchronized (map) {
                            for (Class clz : BufferedMorphiumWriterImpl.this.opLog.keySet()) {
                                localBuffer.add(clz);
                            }
                            for (Class clz : localBuffer) {
                                if (BufferedMorphiumWriterImpl.this.opLog.get(clz) == null || ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() == 0) continue;
                                WriteBuffer w = BufferedMorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(clz, WriteBuffer.class);
                                int size = 0;
                                int timeout = BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTime();
                                WriteBuffer.STRATEGY strategy = WriteBuffer.STRATEGY.JUST_WARN;
                                if (w != null) {
                                    size = w.size();
                                    timeout = w.timeout();
                                    strategy = w.strategy();
                                }
                                if (timeout == -1 && size > 0 && ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() < size || BufferedMorphiumWriterImpl.this.lastRun.get(clz) != null && System.currentTimeMillis() - (Long)BufferedMorphiumWriterImpl.this.lastRun.get(clz) < (long)timeout) continue;
                                BufferedMorphiumWriterImpl.this.lastRun.put(clz, System.currentTimeMillis());
                                List localQueue = (List)BufferedMorphiumWriterImpl.this.opLog.get(clz);
                                BufferedMorphiumWriterImpl.this.opLog.put(clz, new Vector());
                                ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).addAll(BufferedMorphiumWriterImpl.this.flushToQueue(localQueue));
                                localQueue = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)"Got exception during write buffer handling!", (Throwable)e);
                    }
                    try {
                        if (BufferedMorphiumWriterImpl.this.morphium != null) {
                            if (BufferedMorphiumWriterImpl.this.morphium.getConfig() == null) {
                                BufferedMorphiumWriterImpl.this.running = false;
                                break;
                            }
                            Thread.sleep(BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTimeGranularity());
                            continue;
                        }
                        logger.warn((Object)"Morphium not set - assuming timeout of 1sec");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.housekeeping.setDaemon(true);
        this.housekeeping.start();
    }

    @Override
    public <T> void delete(final List<T> lst, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(lst.get(0).getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.delete(lst, callback);
            }
        });
    }

    @Override
    public <T> void delete(final T o, final String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.delete(o, collection, callback);
            }
        });
    }

    @Override
    public <T> void delete(final Query<T> q, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.delete(q, callback);
            }
        });
    }

    @Override
    public <T> void pushPull(final boolean push, final Query<T> query, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.pushPull(push, query, field, value, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void pushPullAll(final boolean push, final Query<T> query, final String field, final List<?> value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.pushPullAll(push, query, field, value, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void unset(final T toSet, final String collection, final String field, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toSet.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.unset(toSet, collection, field, callback);
            }
        });
    }

    @Override
    public <T> void unset(final Query<T> query, final String field, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.unset(query, field, multiple, callback);
            }
        });
    }

    @Override
    public <T> void unset(final Query<T> query, AsyncOperationCallback<T> c, final boolean multiple, final String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.unset(query, callback, multiple, fields);
            }
        });
    }

    @Override
    public <T> void unset(final Query<T> query, AsyncOperationCallback<T> c, final boolean multiple, final Enum ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.unset(query, callback, multiple, fields);
            }
        });
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, final String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.dropCollection(cls, collection, callback);
            }
        });
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, AsyncOperationCallback<T> c) {
        this.ensureIndex(cls, collection, index, null, c);
    }

    @Override
    public <T> void ensureIndex(final Class<T> cls, final String collection, final Map<String, Object> index, final Map<String, Object> options, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.ensureIndex(cls, collection, index, options, callback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBufferCount() {
        int cnt = 0;
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            for (List<WriteBufferEntry> lst : this.opLog.values()) {
                cnt += lst.size();
            }
        }
        return cnt;
    }

    @Override
    public <T> void store(final List<T> lst, final String collectionName, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        if (lst == null || lst.size() == 0) {
            return;
        }
        this.addToWriteQueue(lst.get(0).getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.store(lst, collectionName, callback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ArrayList localBuffer = new ArrayList();
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            for (Class<Object> clz : this.opLog.keySet()) {
                localBuffer.add(clz);
            }
            for (Class<Object> clz : localBuffer) {
                if (this.opLog.get(clz) == null || this.opLog.get(clz).size() == 0) continue;
                this.opLog.get(clz).addAll(this.flushToQueue(this.opLog.get(clz)));
            }
        }
    }

    protected void finalize() throws Throwable {
        logger.info((Object)"Stopping housekeeping thread");
        this.housekeeping.stop();
        super.finalize();
    }

    @Override
    public void setMaximumQueingTries(int n) {
        this.directWriter.setMaximumQueingTries(n);
    }

    @Override
    public void setPauseBetweenTries(int p) {
        this.directWriter.setPauseBetweenTries(p);
    }

    private class AsyncOpAdapter<T>
    implements AsyncOperationCallback<T> {
        private AsyncOpAdapter() {
        }

        @Override
        public void onOperationSucceeded(AsyncOperationType type, Query<T> q, long duration, List<T> result, T entity, Object ... param) {
        }

        @Override
        public void onOperationError(AsyncOperationType type, Query<T> q, long duration, String error, Throwable t, T entity, Object ... param) {
        }
    }

    private class WriteBufferEntry {
        private Runnable toRun;
        private long timestamp;

        private WriteBufferEntry(Runnable toRun, long timestamp) {
            this.toRun = toRun;
            this.timestamp = timestamp;
        }

        public Runnable getToRun() {
            return this.toRun;
        }

        public void setToRun(Runnable toRun) {
            this.toRun = toRun;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

