/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

@Embedded
public class ReplicaSetStatus {
    private static Logger log = Logger.getLogger(ReplicaSetStatus.class);
    private String set;
    private String myState;
    private Date date;
    private List<ReplicaSetNode> members;
    @Transient
    private ReplicaSetConf config;

    public String getSet() {
        return this.set;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public String getMyState() {
        return this.myState;
    }

    public void setMyState(String myState) {
        this.myState = myState;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<ReplicaSetNode> getMembers() {
        return this.members;
    }

    public void setMembers(List<ReplicaSetNode> members) {
        this.members = members;
    }

    public ReplicaSetConf getConfig() {
        return this.config;
    }

    public void setConfig(ReplicaSetConf config) {
        this.config = config;
    }

    public int getActiveNodes() {
        if (this.members == null) {
            return 0;
        }
        int up = 0;
        for (ReplicaSetNode n : this.members) {
            if (n.getState() > 2) continue;
            boolean ignore = false;
            for (ConfNode c : this.config.getMembers()) {
                if (c.getId() != n.getId() || c.getHidden() == null || !c.getHidden().booleanValue()) continue;
                ignore = true;
            }
            if (ignore) continue;
            ++up;
        }
        return up;
    }

    public String toString() {
        String m = "[ \n";
        if (this.members != null) {
            for (ReplicaSetNode n : this.members) {
                m = m + n.toString() + ",\n";
            }
        }
        m = m + "]";
        return "ReplicaSetStatus{active=" + this.getActiveNodes() + ", set='" + this.set + '\'' + ", myState='" + this.myState + '\'' + ", date=" + this.date + ", members=" + m + ", config=" + this.config + '}';
    }
}

