/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.LazyDeReferencingProxy;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumSingleton;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.PartiallyUpdateableProxy;
import de.caluga.morphium.ProfilingListener;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.StatisticValue;
import de.caluga.morphium.Statistics;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.annotations.lifecycle.PostLoad;
import de.caluga.morphium.annotations.lifecycle.PostRemove;
import de.caluga.morphium.annotations.lifecycle.PostStore;
import de.caluga.morphium.annotations.lifecycle.PostUpdate;
import de.caluga.morphium.annotations.lifecycle.PreRemove;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.annotations.lifecycle.PreUpdate;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.cache.CacheHousekeeper;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import de.caluga.morphium.validation.JavaxValidationStorageListener;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.cglib.proxy.Enhancer;
import org.apache.log4j.Logger;
import org.bson.BSONObject;

public class Morphium {
    private static final Logger logger = Logger.getLogger(Morphium.class);
    private MorphiumConfig config;
    private ReplicaSetStatus currentStatus = null;
    private final Map<StatisticKeys, StatisticValue> stats;
    private CacheHousekeeper cacheHousekeeper;
    private List<MorphiumStorageListener> listeners;
    private Vector<ProfilingListener> profilingListeners;
    private Vector<ShutdownListener> shutDownListeners;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private ObjectMapper objectMapper;

    public MorphiumConfig getConfig() {
        return this.config;
    }

    public Morphium() {
        this.stats = new Hashtable<StatisticKeys, StatisticValue>();
        this.shutDownListeners = new Vector();
        this.listeners = new ArrayList<MorphiumStorageListener>();
        this.profilingListeners = new Vector();
    }

    public Morphium(MorphiumConfig cfg) {
        this();
        this.setConfig(cfg);
        this.initializeAndConnect();
    }

    public void setConfig(MorphiumConfig cfg) {
        if (this.config != null) {
            throw new RuntimeException("Cannot change config!");
        }
        this.config = cfg;
    }

    private void initializeAndConnect() {
        if (this.config == null) {
            throw new RuntimeException("Please specify configuration!");
        }
        for (StatisticKeys k : StatisticKeys.values()) {
            this.stats.put(k, new StatisticValue());
        }
        if (this.config.getDb() == null) {
            MongoClientOptions.Builder o = MongoClientOptions.builder();
            o.autoConnectRetry(this.config.isAutoreconnect());
            WriteConcern w = new WriteConcern(this.config.getGlobalW(), this.config.getWriteTimeout(), this.config.isGlobalFsync(), this.config.isGlobalJ(), false);
            o.writeConcern(w);
            o.socketTimeout(this.config.getSocketTimeout());
            o.connectTimeout(this.config.getConnectionTimeout());
            o.connectionsPerHost(this.config.getMaxConnections());
            o.socketKeepAlive(this.config.isSocketKeepAlive());
            o.threadsAllowedToBlockForConnectionMultiplier(this.config.getBlockingThreadsMultiplier());
            o.maxAutoConnectRetryTime((long)this.config.getMaxAutoReconnectTime());
            o.maxWaitTime(this.config.getMaxWaitTime());
            if (this.config.getAdr().isEmpty()) {
                throw new RuntimeException("Error - no server address specified!");
            }
            MongoClient mongo = new MongoClient(this.config.getAdr(), o.build());
            if (this.config.getMongoLogin() != null) {
                MongoCredential cred = MongoCredential.createMongoCRCredential((String)this.config.getMongoLogin(), (String)this.config.getDatabase(), (char[])this.config.getMongoPassword().toCharArray());
                mongo.getDB(this.config.getDatabase()).authenticate(this.config.getMongoLogin(), this.config.getMongoPassword().toCharArray());
            }
            this.config.setDb(mongo.getDB(this.config.getDatabase()));
            if (this.config.getDefaultReadPreference() != null) {
                mongo.setReadPreference(this.config.getDefaultReadPreference().getPref());
            }
        }
        this.cacheHousekeeper = new CacheHousekeeper(this, 5000, this.config.getGlobalCacheValidTime());
        this.cacheHousekeeper.start();
        if (this.config.getWriter() == null) {
            this.config.setWriter(new MorphiumWriterImpl());
        }
        if (this.config.getBufferedWriter() == null) {
            this.config.setBufferedWriter(new BufferedMorphiumWriterImpl());
        }
        this.config.getWriter().setMorphium(this);
        this.config.getWriter().setMaximumQueingTries(this.config.getMaximumRetriesWriter());
        this.config.getWriter().setPauseBetweenTries(this.config.getRetryWaitTimeWriter());
        this.config.getBufferedWriter().setMorphium(this);
        this.config.getBufferedWriter().setMaximumQueingTries(this.config.getMaximumRetriesBufferedWriter());
        this.config.getBufferedWriter().setPauseBetweenTries(this.config.getRetryWaitTimeBufferedWriter());
        this.config.getAsyncWriter().setMorphium(this);
        this.config.getAsyncWriter().setMaximumQueingTries(this.config.getMaximumRetriesAsyncWriter());
        this.config.getAsyncWriter().setPauseBetweenTries(this.config.getRetryWaitTimeAsyncWriter());
        if (this.hasValidationSupport()) {
            logger.info((Object)"Adding javax.validation Support...");
            this.addListener(new JavaxValidationStorageListener());
        }
        try {
            this.objectMapper = this.config.getOmClass().newInstance();
            this.objectMapper.setMorphium(this);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (this.config.getAdr().size() > 1) {
            Thread thr = new Thread(){

                @Override
                public void run() {
                    int nullcounter = 0;
                    while (true) {
                        try {
                            while (true) {
                                Morphium.this.currentStatus = Morphium.this.getReplicaSetStatus(true);
                                nullcounter = Morphium.this.currentStatus == null ? ++nullcounter : 0;
                                if (nullcounter > 10) {
                                    logger.error((Object)"Getting ReplicasetStatus failed 10 times... will gracefully exit thread");
                                    return;
                                }
                                1.sleep(Morphium.this.config.getReplicaSetMonitoringTimeout());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };
            thr.setDaemon(true);
            thr.start();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info((Object)"Initialization successful...");
    }

    public MorphiumCache getCache() {
        return this.config.getCache();
    }

    private boolean hasValidationSupport() {
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass("javax.validation.ValidatorFactory");
        }
        catch (ClassNotFoundException cnf) {
            return false;
        }
        return true;
    }

    public void addListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>();
        newList.addAll(this.listeners);
        newList.add(lst);
        this.listeners = newList;
    }

    public void removeListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>();
        newList.addAll(this.listeners);
        newList.remove(lst);
        this.listeners = newList;
    }

    public Mongo getMongo() {
        return this.config.getDb().getMongo();
    }

    public DB getDatabase() {
        return this.config.getDb();
    }

    public <T> List<T> findByTemplate(T template, String ... fields) {
        Class<?> cls = template.getClass();
        List<Object> flds = new ArrayList<String>();
        if (fields.length > 0) {
            flds.addAll(Arrays.asList(fields));
        } else {
            flds = this.annotationHelper.getFields(cls, new Class[0]);
        }
        Query<?> q = this.createQueryFor(cls);
        for (String string : flds) {
            try {
                q.f(string).eq(this.annotationHelper.getValue(template, string));
            }
            catch (Exception e) {
                logger.error((Object)("Could not read field " + string + " of object " + cls.getName()));
            }
        }
        return q.asList();
    }

    public <T> void unset(T toSet, Enum field) {
        this.unset(toSet, field.name(), null);
    }

    public <T> void unset(T toSet, String field) {
        this.unset(toSet, field, null);
    }

    public <T> void unset(T toSet, String field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, this.getMapper().getCollectionName(toSet.getClass()), callback);
    }

    public <T> void unset(T toSet, String collection, String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.UNSET);
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(toSet.getClass(), Cache.class);
        MorphiumWriter wr = this.getWriterForClass(toSet.getClass());
        wr.unset(toSet, collection, field, callback);
    }

    public <T> void unsetQ(Query<T> q, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    public <T> void unsetQ(Query<T> q, boolean multiple, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> void unsetQ(Query<T> q, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    public <T> void unsetQ(Query<T> q, boolean multiple, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> void unsetQ(Query<T> q, AsyncOperationCallback<T> cb, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> void unsetQ(Query<T> q, AsyncOperationCallback<T> cb, boolean multiple, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> void unsetQ(Query<T> q, AsyncOperationCallback<T> cb, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> void unsetQ(Query<T> q, boolean multiple, AsyncOperationCallback<T> cb, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, multiple, field);
    }

    public <T> void ensureIndicesFor(Class<T> type) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), null);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection) {
        this.ensureIndicesFor(type, onCollection, null);
    }

    public <T> void ensureIndicesFor(Class<T> type, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), callback);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection, AsyncOperationCallback<T> callback) {
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, Index.class)) {
            Object idx;
            List<Annotation> lst = this.annotationHelper.getAllAnnotationsFromHierachy(type, Index.class);
            for (Annotation a : lst) {
                Index i = (Index)a;
                if (i.value().length <= 0) continue;
                List<Map<String, Object>> options = null;
                if (i.options().length > 0) {
                    options = this.createIndexMapFrom(i.options());
                }
                idx = this.createIndexMapFrom(i.value());
                int cnt = 0;
                Iterator<Map<String, Object>> i$ = idx.iterator();
                while (i$.hasNext()) {
                    Map<String, Object> m = i$.next();
                    Map<String, Object> optionsMap = null;
                    if (options != null && options.size() > cnt) {
                        optionsMap = options.get(cnt);
                    }
                    this.getWriterForClass(type).ensureIndex(type, onCollection, m, optionsMap, callback);
                }
            }
            List<String> flds = this.annotationHelper.getFields(type, Index.class);
            if (flds != null && flds.size() > 0) {
                for (String f : flds) {
                    Index i = this.annotationHelper.getField(type, f).getAnnotation(Index.class);
                    idx = new LinkedHashMap();
                    if (i.decrement()) {
                        idx.put(f, -1);
                    } else {
                        idx.put(f, 1);
                    }
                    Map<String, Object> optionsMap = null;
                    if (this.createIndexMapFrom(i.options()) != null) {
                        optionsMap = this.createIndexMapFrom(i.options()).get(0);
                    }
                    this.getWriterForClass(type).ensureIndex(type, onCollection, (Map<String, Object>)idx, optionsMap, callback);
                }
            }
        }
    }

    public DBObject simplifyQueryObject(DBObject q) {
        if (q.keySet().size() == 1 && q.get("$and") != null) {
            BasicDBObject ret = new BasicDBObject();
            BasicDBList lst = (BasicDBList)q.get("$and");
            for (Object o : lst) {
                if (o instanceof DBObject) {
                    ret.putAll((BSONObject)((DBObject)o));
                    continue;
                }
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                return q;
            }
            return ret;
        }
        return q;
    }

    public <T> void set(Query<T> query, Enum field, Object val) {
        this.set((T)query, field, val, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, Enum field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field.name(), val);
        this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public <T> void set(Query<T> query, String field, Object val) {
        this.set((T)query, field, val, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, String field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field, val);
        this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public void setEnum(Query<?> query, Map<Enum, Object> values, boolean insertIfNotExist, boolean multiple) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> est : values.entrySet()) {
            toSet.put(est.getKey().name(), values.get(est.getValue()));
        }
        this.set(query, toSet, insertIfNotExist, multiple);
    }

    public void push(Query<?> query, Enum field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, Enum field, Object value) {
        this.pull(query, field.name(), value, false, true);
    }

    public void push(Query<?> query, String field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, String field, Object value) {
        this.pull(query, field, value, false, true);
    }

    public void push(Query<?> query, Enum field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pull(Query<?> query, Enum field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pushAll(Query<?> query, Enum field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pullAll(Query<?> query, Enum field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field.name(), value, insertIfNotExist, multiple);
    }

    public <T> void push(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void push(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
        this.getWriterForClass(query.getType()).pushPull(true, query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void pull(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void pull(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PULL);
        MorphiumWriter wr = this.config.getWriter();
        if (this.annotationHelper.isBufferedWrite(query.getType())) {
            wr = this.config.getBufferedWriter();
        }
        wr.pushPull(false, query, field, value, insertIfNotExist, multiple, callback);
    }

    public void pushAll(Query<?> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple) {
        this.pushAll(query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void pushAll(Query<T> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
        MorphiumWriter wr = !this.annotationHelper.isBufferedWrite(query.getType()) ? this.config.getWriter() : this.config.getBufferedWriter();
        wr.pushPullAll(true, query, field, value, insertIfNotExist, multiple, callback);
    }

    public void pullAll(Query<?> query, String field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field, value, insertIfNotExist, multiple);
    }

    public <T> void set(Query<T> query, String field, Object val, boolean insertIfNotExist, boolean multiple) {
        this.set((T)query, field, val, insertIfNotExist, multiple, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, String field, Object val, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(field, val);
        this.set(query, map, insertIfNotExist, multiple, callback);
    }

    public void set(Query<?> query, Map<String, Object> map, boolean insertIfNotExist, boolean multiple) {
        this.set(query, map, insertIfNotExist, multiple, null);
    }

    public <T> void set(Query<T> query, Map<String, Object> map, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).set(query, map, insertIfNotExist, multiple, callback);
    }

    public void dec(Query<?> query, Enum field, double amount, boolean insertIfNotExist, boolean multiple) {
        this.dec(query, field.name(), amount, insertIfNotExist, multiple);
    }

    public void dec(Query<?> query, String field, double amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, field, -amount, insertIfNotExist, multiple);
    }

    public void dec(Query<?> query, String field, double amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, Enum field, double amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void inc(Query<?> query, String field, double amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, double amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, double amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, field.name(), amount, insertIfNotExist, multiple);
    }

    public <T> void inc(Query<T> query, Map<String, Double> toUptad, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
        this.getWriterForClass(query.getType()).inc(query, toUptad, insertIfNotExist, multiple, callback);
    }

    public void inc(Query<?> query, String name, double amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, name, amount, insertIfNotExist, multiple, null);
    }

    public <T> void inc(Query<T> query, String name, double amount, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
        this.getWriterForClass(query.getType()).inc(query, name, amount, insertIfNotExist, multiple, callback);
    }

    public <T> void set(T toSet, Enum field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field.name(), value, callback);
    }

    public void set(Object toSet, Enum field, Object value) {
        this.set(toSet, field.name(), value, null);
    }

    public void set(Object toSet, String field, Object value) {
        this.set(toSet, field, value, null);
    }

    public <T> void set(T toSet, String field, Object value, boolean insertIfNotExists, boolean multiple, AsyncOperationCallback<T> callback) {
        this.set(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, value, insertIfNotExists, multiple, callback);
    }

    public <T> void set(T toSet, String collection, String field, Object value, boolean insertIfNotExists, boolean multiple, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.annotationHelper.callLifecycleMethod(PreUpdate.class, toSet);
        this.getWriterForClass(toSet.getClass()).set(toSet, collection, field, value, insertIfNotExists, multiple, callback);
        this.annotationHelper.callLifecycleMethod(PostUpdate.class, toSet);
    }

    public <T> void set(T toSet, String field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field, value, false, false, callback);
    }

    public MorphiumWriter getWriterForClass(Class<?> cls) {
        if (this.annotationHelper.isBufferedWrite(cls)) {
            return this.config.getBufferedWriter();
        }
        if (this.annotationHelper.isAsyncWrite(cls)) {
            return this.config.getAsyncWriter();
        }
        return this.config.getWriter();
    }

    public void dec(Object toDec, String field, double amount) {
        this.inc(toDec, field, -amount);
    }

    public void inc(Object toSet, String field, double i) {
        this.inc(toSet, field, i, null);
    }

    public <T> void inc(T toSet, String field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, double i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void delete(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (T o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        this.config.getBufferedWriter().delete(bufferedDel, callback);
        this.config.getWriter().delete(directDel, callback);
    }

    public void inc(StatisticKeys k) {
        this.stats.get((Object)k).inc();
    }

    public String toJsonString(Object o) {
        return this.objectMapper.marshall(o).toString();
    }

    public void updateUsingFields(Object ent, String ... fields) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback<T>)null, fields);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, String ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, String ... fields) {
        if (ent == null) {
            return;
        }
        if (fields.length == 0) {
            return;
        }
        if (this.annotationHelper.isAnnotationPresentInHierarchy(ent.getClass(), NoCache.class)) {
            this.config.getWriter().updateUsingFields(ent, collection, null, fields);
            return;
        }
        this.getWriterForClass(ent.getClass()).updateUsingFields(ent, collection, null, fields);
    }

    public ObjectMapper getMapper() {
        return this.objectMapper;
    }

    public AnnotationAndReflectionHelper getARHelper() {
        return this.annotationHelper;
    }

    public <T> T reread(T o) {
        return this.reread(o, this.objectMapper.getCollectionName(o.getClass()));
    }

    public <T> T reread(T o, String collection) {
        BasicDBObject srch;
        if (o == null) {
            throw new RuntimeException("Cannot re read null!");
        }
        Object id = this.getId(o);
        if (id == null) {
            return null;
        }
        DBCollection col = this.config.getDb().getCollection(collection);
        DBCursor crs = col.find((DBObject)(srch = new BasicDBObject("_id", id))).limit(1);
        if (crs.hasNext()) {
            DBObject dbo = crs.next();
            Object fromDb = this.objectMapper.unmarshall(o.getClass(), dbo);
            if (fromDb == null) {
                throw new RuntimeException("could not reread from db");
            }
            List<String> flds = this.annotationHelper.getFields(o.getClass(), new Class[0]);
            for (String f : flds) {
                Field fld = this.annotationHelper.getField(o.getClass(), f);
                if (Modifier.isStatic(fld.getModifiers())) continue;
                try {
                    fld.set(o, fld.get(fromDb));
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("Could not set Value: " + fld));
                }
            }
        } else {
            logger.info((Object)("Did not find object with id " + id));
            return null;
        }
        this.firePostLoadEvent(o);
        return o;
    }

    public void firePreStoreEvent(Object o, boolean isNew) {
        if (o == null) {
            return;
        }
        for (MorphiumStorageListener l : this.listeners) {
            l.preStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PreStore.class, o);
    }

    public void firePostStoreEvent(Object o, boolean isNew) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PostStore.class, o);
    }

    public void firePreDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDrop(this, cls);
        }
    }

    public void firePostDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postDrop(this, cls);
        }
    }

    public void firePostUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postUpdate(this, cls, t);
        }
    }

    public void firePreUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preUpdate(this, cls, t);
        }
    }

    public void firePostRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostRemove.class, o);
    }

    public void firePostRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, q);
        }
    }

    public void firePreRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDelete(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PreRemove.class, o);
    }

    public void firePreRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preRemove(this, q);
        }
    }

    public <T> T deReference(T obj) {
        if (obj instanceof LazyDeReferencingProxy) {
            obj = ((LazyDeReferencingProxy)obj).__getDeref();
        }
        if (obj instanceof PartiallyUpdateableProxy) {
            obj = ((PartiallyUpdateableProxy)obj).__getDeref();
        }
        List<Field> flds = this.getARHelper().getAllFields(obj.getClass());
        for (Field fld : flds) {
            fld.setAccessible(true);
            Reference r = fld.getAnnotation(Reference.class);
            if (r != null && r.lazyLoading()) {
                try {
                    LazyDeReferencingProxy v = (LazyDeReferencingProxy)fld.get(obj);
                    Object value = v.__getDeref();
                    fld.set(obj, value);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("dereferencing of field " + fld.getName() + " failed"), (Throwable)e);
                }
            }
            try {
                if (fld.get(obj) == null || !this.getARHelper().isAnnotationPresentInHierarchy(fld.getType(), Entity.class) || !(fld.get(obj) instanceof PartiallyUpdateableProxy)) continue;
                fld.set(obj, ((PartiallyUpdateableProxy)fld.get(obj)).__getDeref());
            }
            catch (IllegalAccessException e) {}
        }
        return obj;
    }

    public void firePostLoadEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postLoad(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostLoad.class, o);
    }

    private ReplicaSetStatus getReplicaSetStatus() {
        return this.getReplicaSetStatus(false);
    }

    public ReplicaSetStatus getCurrentStatus() {
        return this.currentStatus;
    }

    private ReplicaSetStatus getReplicaSetStatus(boolean full) {
        if (this.config.getAdr().size() > 1) {
            try {
                DB adminDB = this.getMongo().getDB("admin");
                if (this.config.getMongoAdminUser() != null && !adminDB.authenticate(this.config.getMongoAdminUser(), this.config.getMongoAdminPwd().toCharArray())) {
                    logger.error((Object)"Authentication as admin failed!");
                    return null;
                }
                CommandResult res = adminDB.command("replSetGetStatus");
                ReplicaSetStatus status = this.objectMapper.unmarshall(ReplicaSetStatus.class, (DBObject)res);
                if (full) {
                    DBCursor rpl = this.getMongo().getDB("local").getCollection("system.replset").find();
                    DBObject stat = rpl.next();
                    ReplicaSetConf cfg = this.objectMapper.unmarshall(ReplicaSetConf.class, stat);
                    List mem = cfg.getMemberList();
                    ArrayList<ConfNode> cmembers = new ArrayList<ConfNode>();
                    for (Object o : mem) {
                        DBObject dbo = (DBObject)o;
                        ConfNode cn = this.objectMapper.unmarshall(ConfNode.class, dbo);
                        cmembers.add(cn);
                    }
                    cfg.setMembers(cmembers);
                    status.setConfig(cfg);
                }
                List<ReplicaSetNode> lst = status.getMembers();
                ArrayList<ReplicaSetNode> members = new ArrayList<ReplicaSetNode>();
                for (ReplicaSetNode l : lst) {
                    DBObject o = (DBObject)l;
                    ReplicaSetNode n = this.objectMapper.unmarshall(ReplicaSetNode.class, o);
                    members.add(n);
                }
                status.setMembers(members);
                return status;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not get Replicaset status: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public boolean isReplicaSet() {
        return this.config.getAdr().size() > 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleNetworkError(int i, Throwable e) {
        logger.info((Object)("Handling network error..." + e.getClass().getName()));
        if (e.getClass().getName().equals("javax.validation.ConstraintViolationException")) {
            throw (RuntimeException)e;
        }
        if (!(e.getMessage().equals("can't find a master") || e.getMessage().startsWith("No replica set members available in") || e.getMessage().equals("not talking to master and retries used up") || e instanceof WriteConcernException && e.getMessage().contains("not master") || e instanceof MongoException.Network)) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
        if (i + 1 >= this.getConfig().getRetriesOnNetworkError()) {
            logger.info((Object)"no retries left - re-throwing exception");
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
        logger.warn((Object)("Retry because of network error: " + e.getMessage()));
        try {
            Thread.sleep(this.getConfig().getSleepBetweenNetworkErrorRetries());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public WriteConcern getWriteConcernForClass(Class<?> cls) {
        WriteSafety safety;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returning write concern for " + cls.getSimpleName()));
        }
        if ((safety = this.annotationHelper.getAnnotationFromHierarchy(cls, WriteSafety.class)) == null) {
            return null;
        }
        boolean fsync = safety.waitForSync();
        boolean j = safety.waitForJournalCommit();
        if (j && fsync) {
            fsync = false;
        }
        int w = safety.level().getValue();
        if (!this.isReplicaSet() && w > 1) {
            w = 1;
        }
        int timeout = safety.timeout();
        if (this.isReplicaSet() && w > 2) {
            ReplicaSetStatus s = this.currentStatus;
            if (s == null || s.getActiveNodes() == 0) {
                logger.warn((Object)"ReplicaSet status is null or no node active! Assuming default write concern");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Active nodes now: " + s.getActiveNodes()));
            }
            int activeNodes = s.getActiveNodes();
            int masterOpTime = 0;
            int maxReplLag = 0;
            for (ReplicaSetNode node : s.getMembers()) {
                if (node.getState() != 1) continue;
                masterOpTime = node.getOptime().getTime();
            }
            for (ReplicaSetNode node : s.getMembers()) {
                int tm;
                if (node.getState() != 2 || maxReplLag >= (tm = node.getOptime().getTime() - masterOpTime)) continue;
                maxReplLag = tm;
            }
            if (timeout < 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Setting timeout to replication lag*3");
                }
                if (maxReplLag < 0) {
                    maxReplLag = -maxReplLag;
                }
                if (maxReplLag == 0) {
                    maxReplLag = 1;
                }
                timeout = maxReplLag * 3000;
                if (maxReplLag > 10) {
                    logger.warn((Object)("Warning: replication lag too high! timeout set to " + timeout + "ms - replication Lag is " + maxReplLag + "s - write should take place in Background!"));
                }
            }
            w = activeNodes;
            if (timeout > 0 && timeout < maxReplLag * 1000) {
                logger.warn((Object)"Timeout is set smaller than replication lag - increasing to replication_lag time * 3");
                timeout = maxReplLag * 3000;
            }
        }
        if (w == -99) {
            return new WriteConcern("majority", timeout, fsync, j);
        }
        return new WriteConcern(w, timeout, fsync, j);
    }

    public void addProfilingListener(ProfilingListener l) {
        this.profilingListeners.add(l);
    }

    public void removeProfilingListener(ProfilingListener l) {
        this.profilingListeners.remove(l);
    }

    public void fireProfilingWriteEvent(Class type, Object data, long time, boolean isNew, WriteAccessType wt) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.writeAccess(type, data, time, isNew, wt);
            }
            catch (Throwable e) {
                logger.error((Object)"Error during profiling: ", e);
            }
        }
    }

    public void fireProfilingReadEvent(Query q, long time, ReadAccessType t) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.readAccess(q, time, t);
            }
            catch (Throwable e) {
                logger.error((Object)"Error during profiling", e);
            }
        }
    }

    public void clearCollection(Class<?> cls) {
        this.delete(this.createQueryFor(cls));
    }

    public void clearCollection(Class<?> cls, String colName) {
        Query<?> q = this.createQueryFor(cls);
        q.setCollectionName(colName);
        this.delete(q);
    }

    public void clearCollectionOneByOne(Class<?> cls) {
        this.inc(StatisticKeys.WRITES);
        List<?> lst = this.readAll(cls);
        for (Object r : lst) {
            this.delete(r);
        }
        this.getCache().clearCacheIfNecessary(cls);
    }

    public <T> List<T> readAll(Class<? extends T> cls) {
        this.inc(StatisticKeys.READS);
        Query<T> qu = this.createQueryFor(cls);
        return qu.asList();
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type) {
        Query<T> q = this.config.getQueryFact().createQuery(this, type);
        q.setMorphium(this);
        return q;
    }

    public <T> List<T> find(Query<T> q) {
        return q.asList();
    }

    public List<Object> distinct(Enum key, Class c) {
        return this.distinct(key.name(), c);
    }

    public List<Object> distinct(Enum key, Query q) {
        return this.distinct(key.name(), q);
    }

    public List<Object> distinct(String key, Query q) {
        return this.config.getDb().getCollection(this.objectMapper.getCollectionName(q.getType())).distinct(key, q.toQueryObject());
    }

    public List<Object> distinct(String key, Class cls) {
        DBCollection collection = this.config.getDb().getCollection(this.objectMapper.getCollectionName(cls));
        this.setReadPreference(collection, cls);
        return collection.distinct(key, (DBObject)new BasicDBObject());
    }

    private void setReadPreference(DBCollection c, Class type) {
        DefaultReadPreference pr = this.annotationHelper.getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            c.setReadPreference(pr.value().getPref());
        } else {
            c.setReadPreference(null);
        }
    }

    public DBObject group(Query q, Map<String, Object> initial, String jsReduce, String jsFinalize, String ... keys) {
        BasicDBObject k = new BasicDBObject();
        BasicDBObject ini = new BasicDBObject();
        ini.putAll(initial);
        for (String ks : keys) {
            if (ks.startsWith("-")) {
                k.append(ks.substring(1), (Object)"false");
                continue;
            }
            if (ks.startsWith("+")) {
                k.append(ks.substring(1), (Object)"true");
                continue;
            }
            k.append(ks, (Object)"true");
        }
        if (!jsReduce.trim().startsWith("function(")) {
            jsReduce = "function (obj,data) { " + jsReduce + " }";
        }
        if (jsFinalize == null) {
            jsFinalize = "";
        }
        if (!jsFinalize.trim().startsWith("function(")) {
            jsFinalize = "function (data) {" + jsFinalize + "}";
        }
        GroupCommand cmd = new GroupCommand(this.config.getDb().getCollection(this.objectMapper.getCollectionName(q.getType())), (DBObject)k, q.toQueryObject(), (DBObject)ini, jsReduce, jsFinalize);
        return this.config.getDb().getCollection(this.objectMapper.getCollectionName(q.getType())).group(cmd);
    }

    public <T> T findById(Class<? extends T> type, Object id) {
        T ret = this.getCache().getFromIDCache(type, id);
        if (ret != null) {
            return ret;
        }
        List<String> ls = this.annotationHelper.getFields(type, Id.class);
        if (ls.size() == 0) {
            throw new RuntimeException("Cannot find by ID on non-Entity");
        }
        return this.createQueryFor(type).f(ls.get(0)).eq(id).get();
    }

    public <T> List<T> findByField(Class<? extends T> cls, String fld, Object val) {
        Query<T> q = this.createQueryFor(cls);
        q = q.f(fld).eq(val);
        return q.asList();
    }

    public <T> List<T> findByField(Class<? extends T> cls, Enum fld, Object val) {
        return this.findByField(cls, fld.name(), val);
    }

    public void clearCachefor(Class<?> cls) {
        this.getCache().clearCachefor(cls);
    }

    public <T> void storeNoCache(T lst) {
        this.storeNoCache(lst, this.getMapper().getCollectionName(lst.getClass()), null);
    }

    public <T> void storeNoCache(T o, AsyncOperationCallback<T> callback) {
        this.storeNoCache(o, this.getMapper().getCollectionName(o.getClass()), callback);
    }

    public <T> void storeNoCache(T o, String collection) {
        this.storeNoCache(o, collection, null);
    }

    public <T> void storeNoCache(T o, String collection, AsyncOperationCallback<T> callback) {
        this.config.getWriter().store(o, collection, callback);
    }

    public <T> void storeBuffered(T lst) {
        this.storeBuffered(lst, null);
    }

    public <T> void storeBuffered(T lst, AsyncOperationCallback<T> callback) {
        this.storeBuffered(lst, this.getMapper().getCollectionName(lst.getClass()), callback);
    }

    public <T> void storeBuffered(T lst, String collection, AsyncOperationCallback<T> callback) {
        this.config.getBufferedWriter().store(lst, collection, callback);
    }

    public void flush() {
        this.config.getBufferedWriter().flush();
        this.config.getWriter().flush();
    }

    public Object getId(Object o) {
        return this.annotationHelper.getId(o);
    }

    public <T> void dropCollection(Class<T> cls, AsyncOperationCallback<T> callback) {
        this.dropCollection(cls, this.getMapper().getCollectionName(cls), callback);
    }

    public <T> void dropCollection(Class<T> cls, String collection, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).dropCollection(cls, collection, callback);
    }

    public void dropCollection(Class<?> cls) {
        this.getWriterForClass(cls).dropCollection(cls, this.getMapper().getCollectionName(cls), null);
    }

    public <T> void ensureIndex(Class<T> cls, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), index, callback);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, Map<String, Object> options, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, options, callback);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, null, callback);
    }

    public int writeBufferCount() {
        return this.config.getWriter().writeBufferCount() + this.config.getBufferedWriter().writeBufferCount();
    }

    public <T> void store(List<T> lst, String collectionName, AsyncOperationCallback<T> callback) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        this.getWriterForClass(lst.get(0).getClass()).store(lst, collectionName, callback);
    }

    public void ensureIndex(Class<?> cls, Map<String, Object> index) {
        this.getWriterForClass(cls).ensureIndex(cls, this.getMapper().getCollectionName(cls), index, null, null);
    }

    public void ensureIndex(Class<?> cls, String collection, Map<String, Object> index, Map<String, Object> options) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, options, null);
    }

    public void ensureIndex(Class<?> cls, String collection, Map<String, Object> index) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, null, null);
    }

    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), callback, fldStr);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Enum e : fldStr) {
            String f = e.name();
            m.put(f, 1);
        }
        this.getWriterForClass(cls).ensureIndex(cls, collection, m, null, callback);
    }

    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, String ... fldStr) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), callback, fldStr);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, AsyncOperationCallback<T> callback, String ... fldStr) {
        List<Map<String, Object>> m = this.createIndexMapFrom(fldStr);
        for (Map<String, Object> idx : m) {
            this.getWriterForClass(cls).ensureIndex(cls, collection, idx, null, callback);
        }
    }

    public List<Map<String, Object>> createIndexMapFrom(String[] fldStr) {
        if (fldStr.length == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
        for (String f : fldStr) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (String idx : f.split(",")) {
                if (idx.contains(":")) {
                    String[] i = idx.split(":");
                    m.put(i[0].replaceAll(" ", ""), i[1].replaceAll(" ", ""));
                    continue;
                }
                if ((idx = idx.replaceAll(" ", "")).startsWith("-")) {
                    m.put(idx.substring(1), -1);
                    continue;
                }
                idx = idx.replaceAll("^\\+", "").replaceAll(" ", "");
                m.put(idx, 1);
            }
            lst.add(m);
        }
        return lst;
    }

    public void ensureIndex(Class<?> cls, String ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public void ensureIndex(Class<?> cls, Enum ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public <T> void store(T o) {
        this.store(o, null);
    }

    public <T> void store(T o, AsyncOperationCallback<T> callback) {
        this.store(o, this.getMapper().getCollectionName(o.getClass()), callback);
    }

    public <T> void store(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            throw new RuntimeException("Lists need to be stored with storeList");
        }
        this.getWriterForClass(o.getClass()).store(o, collection, callback);
    }

    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.storeList(lst, callback);
    }

    public <T> void storeList(List<T> lst, String collection) {
    }

    public <T> void storeList(List<T> lst, String collection, AsyncOperationCallback<T> callback) {
    }

    public <T> void storeList(List<T> lst) {
        this.storeList(lst, (AsyncOperationCallback)null);
    }

    public <T> void storeList(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> storeDirect = new ArrayList<T>();
        ArrayList<T> storeInBg = new ArrayList<T>();
        for (T o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                storeInBg.add(o);
                continue;
            }
            storeDirect.add(o);
        }
        this.config.getBufferedWriter().store(storeInBg, callback);
        this.config.getWriter().store(storeDirect, callback);
    }

    public <T> void delete(Query<T> o) {
        this.getWriterForClass(o.getType()).delete(o, (AsyncOperationCallback)null);
    }

    public <T> void delete(Query<T> o, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(o.getType()).delete(o, callback);
    }

    public <T> void pushPull(boolean push, Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPull(push, query, field, value, insertIfNotExist, multiple, callback);
    }

    public <T> void pushPullAll(boolean push, Query<T> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPullAll(push, query, field, value, insertIfNotExist, multiple, callback);
    }

    public <T> void pullAll(Query<T> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPullAll(false, query, field, value, insertIfNotExist, multiple, callback);
    }

    public void delete(Object o) {
        this.delete(o, this.getMapper().getCollectionName(o.getClass()));
    }

    public void delete(Object o, String collection) {
        this.getWriterForClass(o.getClass()).delete(o, collection, null);
    }

    public <T> void delete(T lo, AsyncOperationCallback<T> callback) {
        if (lo instanceof Query) {
            this.delete((T)((Query)lo), callback);
            return;
        }
        this.getWriterForClass(lo.getClass()).delete(lo, this.getMapper().getCollectionName(lo.getClass()), callback);
    }

    public <T> void delete(T lo, String collection, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(lo.getClass()).delete(lo, collection, callback);
    }

    public Map<String, Double> getStatistics() {
        return new Statistics(this);
    }

    public Map<StatisticKeys, StatisticValue> getStats() {
        return this.stats;
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutDownListeners.add(l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutDownListeners.remove(l);
    }

    public void close() {
        this.cacheHousekeeper.end();
        for (ShutdownListener l : this.shutDownListeners) {
            l.onShutdown(this);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            logger.debug((Object)"Ignoring interrupted-exception");
        }
        if (this.cacheHousekeeper.isAlive()) {
            this.cacheHousekeeper.interrupt();
        }
        this.config.getDb().getMongo().close();
        this.config = null;
        MorphiumSingleton.reset();
    }

    public String createCamelCase(String n) {
        return this.annotationHelper.createCamelCase(n, false);
    }

    public <T, R> Aggregator<T, R> createAggregator(Class<? extends T> type, Class<? extends R> resultType) {
        Aggregator<T, R> aggregator = this.config.getAggregatorFactory().createAggregator(type, resultType);
        aggregator.setMorphium(this);
        return aggregator;
    }

    public <T, R> List<R> aggregate(Aggregator<T, R> a) {
        DBCollection coll = null;
        for (int i = 0; i < this.getConfig().getRetriesOnNetworkError(); ++i) {
            try {
                coll = this.config.getDb().getCollection(this.objectMapper.getCollectionName(a.getSearchType()));
                break;
            }
            catch (Throwable e) {
                this.handleNetworkError(i, e);
                continue;
            }
        }
        List<DBObject> agList = a.toAggregationList();
        DBObject first = agList.get(0);
        agList.remove(0);
        AggregationOutput resp = null;
        for (int i = 0; i < this.getConfig().getRetriesOnNetworkError(); ++i) {
            try {
                resp = coll.aggregate(first, agList.toArray(new DBObject[agList.size()]));
                break;
            }
            catch (Throwable t) {
                this.handleNetworkError(i, t);
                continue;
            }
        }
        ArrayList<R> ret = new ArrayList<R>();
        for (DBObject o : resp.results()) {
            R obj = this.getMapper().unmarshall(a.getResultType(), o);
            if (obj == null) continue;
            ret.add(obj);
        }
        return ret;
    }

    public <T> T createPartiallyUpdateableEntity(T o) {
        return (T)Enhancer.create(o.getClass(), (Class[])new Class[]{PartiallyUpdateable.class, Serializable.class}, new PartiallyUpdateableProxy<T>(this, o));
    }

    public <T> T createLazyLoadedEntity(Class<? extends T> cls, Object id) {
        return (T)Enhancer.create(cls, (Class[])new Class[]{Serializable.class}, new LazyDeReferencingProxy<T>(this, cls, id));
    }

    public <T> MongoField<T> createMongoField() {
        try {
            return this.config.getFieldImplClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public int getWriteBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount() + this.config.getWriter().writeBufferCount() + this.config.getAsyncWriter().writeBufferCount();
    }

    public int getBufferedWriterBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount();
    }

    public int getAsyncWriterBufferCount() {
        return this.config.getAsyncWriter().writeBufferCount();
    }

    public int getWriterBufferCount() {
        return this.config.getWriter().writeBufferCount();
    }
}

