/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.WriteConcern;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.ConfigManager;
import de.caluga.morphium.ConfigManagerImpl;
import de.caluga.morphium.LazyDeReferencingProxy;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumSingleton;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.PartiallyUpdateableProxy;
import de.caluga.morphium.ProfilingListener;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.StatisticValue;
import de.caluga.morphium.Statistics;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.annotations.lifecycle.PostLoad;
import de.caluga.morphium.annotations.lifecycle.PostRemove;
import de.caluga.morphium.annotations.lifecycle.PostStore;
import de.caluga.morphium.annotations.lifecycle.PostUpdate;
import de.caluga.morphium.annotations.lifecycle.PreRemove;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.annotations.lifecycle.PreUpdate;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.cache.CacheHousekeeper;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import de.caluga.morphium.validation.JavaxValidationStorageListener;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.cglib.proxy.Enhancer;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public final class Morphium
implements MorphiumWriter {
    private static final Logger logger = Logger.getLogger(Morphium.class);
    private MorphiumConfig config;
    private Mongo mongo;
    private DB database;
    private final Map<StatisticKeys, StatisticValue> stats;
    private CacheHousekeeper cacheHousekeeper;
    private List<MorphiumStorageListener> listeners;
    private Vector<ProfilingListener> profilingListeners;
    private Vector<ShutdownListener> shutDownListeners;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private MorphiumCache cache;
    private ObjectMapper objectMapper;

    public MorphiumConfig getConfig() {
        return this.config;
    }

    public Morphium(MorphiumConfig cfg) {
        if (cfg == null) {
            throw new RuntimeException("Please specify configuration!");
        }
        this.config = cfg;
        this.shutDownListeners = new Vector();
        this.listeners = new ArrayList<MorphiumStorageListener>();
        this.profilingListeners = new Vector();
        this.stats = new Hashtable<StatisticKeys, StatisticValue>();
        for (StatisticKeys k : StatisticKeys.values()) {
            this.stats.put(k, new StatisticValue());
        }
        MongoOptions o = new MongoOptions();
        o.setAutoConnectRetry(this.config.isAutoreconnect());
        o.setSafe(this.config.isSafeMode());
        o.setFsync(this.config.isGlobalFsync());
        o.setSocketTimeout(this.config.getSocketTimeout());
        o.setConnectTimeout(this.config.getConnectionTimeout());
        o.setConnectionsPerHost(this.config.getMaxConnections());
        o.setSocketKeepAlive(this.config.isSocketKeepAlive());
        o.setThreadsAllowedToBlockForConnectionMultiplier(this.config.getBlockingThreadsMultiplier());
        o.setJ(this.config.isGlobalJ());
        o.setW(this.config.getGlobalW());
        o.setWtimeout(this.config.getWriteTimeout());
        o.setMaxAutoConnectRetryTime((long)this.config.getMaxAutoReconnectTime());
        o.setMaxWaitTime(this.config.getMaxWaitTime());
        if (this.config.getAdr().isEmpty()) {
            throw new RuntimeException("Error - no server address specified!");
        }
        this.mongo = new Mongo(this.config.getAdr(), o);
        this.database = this.mongo.getDB(this.config.getDatabase());
        if (this.config.getDefaultReadPreference() != null) {
            this.mongo.setReadPreference(this.config.getDefaultReadPreference().getPref());
        }
        if (this.config.getMongoLogin() != null && !this.database.authenticate(this.config.getMongoLogin(), this.config.getMongoPassword().toCharArray())) {
            throw new RuntimeException("Authentication failed!");
        }
        if (this.config.getConfigManager() == null) {
            this.config.setConfigManager(new ConfigManagerImpl());
        }
        this.config.getConfigManager().setMorphium(this);
        this.cacheHousekeeper = new CacheHousekeeper(this, 5000, this.config.getGlobalCacheValidTime());
        this.cacheHousekeeper.start();
        this.config.getConfigManager().startCleanupThread();
        if (this.config.getWriter() == null) {
            this.config.setWriter(new MorphiumWriterImpl());
        }
        if (this.config.getBufferedWriter() == null) {
            this.config.setBufferedWriter(new BufferedMorphiumWriterImpl());
        }
        this.config.getWriter().setMorphium(this);
        this.config.getBufferedWriter().setMorphium(this);
        this.cache = this.config.getCache();
        if (this.hasValidationSupport()) {
            logger.info((Object)"Adding javax.validation Support...");
            this.addListener(new JavaxValidationStorageListener());
        }
        try {
            this.objectMapper = this.config.getOmClass().newInstance();
            this.objectMapper.setMorphium(this);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        logger.info((Object)"Initialization successful...");
    }

    public MorphiumCache getCache() {
        return this.config.getCache();
    }

    private boolean hasValidationSupport() {
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass("javax.validation.ValidatorFactory");
        }
        catch (ClassNotFoundException cnf) {
            return false;
        }
        return true;
    }

    public void addListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>();
        newList.addAll(this.listeners);
        newList.add(lst);
        this.listeners = newList;
    }

    public void removeListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>();
        newList.addAll(this.listeners);
        newList.remove(lst);
        this.listeners = newList;
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public DB getDatabase() {
        return this.database;
    }

    public ConfigManager getConfigManager() {
        return this.config.getConfigManager();
    }

    public <T> List<T> findByTemplate(T template, String ... fields) {
        Class<?> cls = template.getClass();
        List<Object> flds = new ArrayList<String>();
        if (fields.length > 0) {
            flds.addAll(Arrays.asList(fields));
        } else {
            flds = this.annotationHelper.getFields(cls, new Class[0]);
        }
        Query<?> q = this.createQueryFor(cls);
        for (String string : flds) {
            try {
                q.f(string).eq(this.annotationHelper.getValue(template, string));
            }
            catch (Exception e) {
                logger.error((Object)("Could not read field " + string + " of object " + cls.getName()));
            }
        }
        return q.asList();
    }

    public <T> void unset(T toSet, Enum field) {
        this.unset(toSet, field.name(), null);
    }

    public <T> void unset(T toSet, String field) {
        this.unset(toSet, field, null);
    }

    @Override
    public <T> void unset(T toSet, String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.UNSET);
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(toSet.getClass(), Cache.class);
        MorphiumWriter wr = this.config.getWriter();
        if (this.annotationHelper.isBufferedWrite(toSet.getClass())) {
            this.config.getBufferedWriter();
        }
        wr.unset(toSet, field, callback);
    }

    public void ensureIndicesFor(Class type) {
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, Index.class)) {
            List<Annotation> lst = this.annotationHelper.getAllAnnotationsFromHierachy(type, Index.class);
            for (Annotation a : lst) {
                Index i = (Index)a;
                if (i.value().length <= 0) continue;
                for (String idx : i.value()) {
                    String[] idxStr = idx.replaceAll(" +", "").split(",");
                    this.ensureIndex(type, idxStr);
                }
            }
            List<String> flds = this.annotationHelper.getFields(type, Index.class);
            if (flds != null && flds.size() > 0) {
                for (String f : flds) {
                    Index i = this.annotationHelper.getField(type, f).getAnnotation(Index.class);
                    if (i.decrement()) {
                        this.ensureIndex(type, "-" + f);
                        continue;
                    }
                    this.ensureIndex(type, f);
                }
            }
        }
    }

    public DBObject simplifyQueryObject(DBObject q) {
        if (q.keySet().size() == 1 && q.get("$and") != null) {
            BasicDBObject ret = new BasicDBObject();
            BasicDBList lst = (BasicDBList)q.get("$and");
            for (Object o : lst) {
                if (o instanceof DBObject) {
                    ret.putAll((BSONObject)((DBObject)o));
                    continue;
                }
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                return q;
            }
            return ret;
        }
        return q;
    }

    public <T> void set(Query<T> query, Enum field, Object val) {
        this.set((T)query, field, val, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, Enum field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field.name(), val);
        this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public <T> void set(Query<T> query, String field, Object val) {
        this.set((T)query, field, val, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, String field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field, val);
        this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public void setEnum(Query<?> query, Map<Enum, Object> values, boolean insertIfNotExist, boolean multiple) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> est : values.entrySet()) {
            toSet.put(est.getKey().name(), values.get(est.getValue()));
        }
        this.set(query, toSet, insertIfNotExist, multiple);
    }

    public void push(Query<?> query, Enum field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, Enum field, Object value) {
        this.pull(query, field.name(), value, false, true);
    }

    public void push(Query<?> query, String field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, String field, Object value) {
        this.pull(query, field, value, false, true);
    }

    public void push(Query<?> query, Enum field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pull(Query<?> query, Enum field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pushAll(Query<?> query, Enum field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pullAll(Query<?> query, Enum field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field.name(), value, insertIfNotExist, multiple);
    }

    public <T> void push(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void push(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
        this.getWriterForClass(query.getType()).pushPull(true, query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void pull(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void pull(Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PULL);
        MorphiumWriter wr = this.config.getWriter();
        if (this.annotationHelper.isBufferedWrite(query.getType())) {
            wr = this.config.getBufferedWriter();
        }
        wr.pushPull(false, query, field, value, insertIfNotExist, multiple, callback);
    }

    public void pushAll(Query<?> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple) {
        this.pushAll(query, field, value, insertIfNotExist, multiple, null);
    }

    public <T> void pushAll(Query<T> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
        MorphiumWriter wr = !this.annotationHelper.isBufferedWrite(query.getType()) ? this.config.getWriter() : this.config.getBufferedWriter();
        wr.pushPullAll(true, query, field, value, insertIfNotExist, multiple, callback);
    }

    public void pullAll(Query<?> query, String field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field, value, insertIfNotExist, multiple);
    }

    public <T> void set(Query<T> query, String field, Object val, boolean insertIfNotExist, boolean multiple) {
        this.set((T)query, field, val, insertIfNotExist, multiple, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, String field, Object val, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(field, val);
        this.set(query, map, insertIfNotExist, multiple, callback);
    }

    public void set(Query<?> query, Map<String, Object> map, boolean insertIfNotExist, boolean multiple) {
        this.set(query, map, insertIfNotExist, multiple, null);
    }

    @Override
    public <T> void set(Query<T> query, Map<String, Object> map, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).set(query, map, insertIfNotExist, multiple, callback);
    }

    public void dec(Query<?> query, Enum field, int amount, boolean insertIfNotExist, boolean multiple) {
        this.dec(query, field.name(), amount, insertIfNotExist, multiple);
    }

    public void dec(Query<?> query, String field, int amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, field, -amount, insertIfNotExist, multiple);
    }

    public void dec(Query<?> query, String field, int amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, Enum field, int amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void inc(Query<?> query, String field, int amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, int amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, int amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, field.name(), amount, insertIfNotExist, multiple);
    }

    public void inc(Query<?> query, String name, int amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, name, amount, insertIfNotExist, multiple, null);
    }

    @Override
    public <T> void inc(Query<T> query, String name, int amount, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
        this.getWriterForClass(query.getType()).inc(query, name, amount, insertIfNotExist, multiple, callback);
    }

    public <T> void set(T toSet, Enum field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field.name(), value, callback);
    }

    public void set(Object toSet, Enum field, Object value) {
        this.set(toSet, field.name(), value, null);
    }

    public void set(Object toSet, String field, Object value) {
        this.set(toSet, field, value, null);
    }

    @Override
    public <T> void set(T toSet, String field, Object value, boolean insertIfNotExists, boolean multiple, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.annotationHelper.callLifecycleMethod(PreUpdate.class, toSet);
        this.getWriterForClass(toSet.getClass()).set(toSet, field, value, insertIfNotExists, multiple, callback);
        this.annotationHelper.callLifecycleMethod(PostUpdate.class, toSet);
    }

    public <T> void set(T toSet, String field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field, value, false, false, callback);
    }

    public MorphiumWriter getWriterForClass(Class<?> cls) {
        if (this.annotationHelper.isBufferedWrite(cls)) {
            return this.config.getBufferedWriter();
        }
        return this.config.getWriter();
    }

    public void dec(Object toDec, String field, int amount) {
        this.inc(toDec, field, -amount);
    }

    public void inc(Object toSet, String field, int i) {
        this.inc(toSet, field, i, null);
    }

    @Override
    public <T> void inc(T toSet, String field, int i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, field, i, callback);
    }

    @Override
    public void setMorphium(Morphium m) {
        throw new RuntimeException("Does not make sense");
    }

    @Override
    public <T> void delete(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (T o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        this.config.getBufferedWriter().delete(bufferedDel, callback);
        this.config.getWriter().delete(directDel, callback);
    }

    public void inc(StatisticKeys k) {
        this.stats.get((Object)k).inc();
    }

    public String toJsonString(Object o) {
        return this.objectMapper.marshall(o).toString();
    }

    public void updateUsingFields(Object ent, String ... fields) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback<T>)null, fields);
    }

    @Override
    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, String ... fields) {
        if (ent == null) {
            return;
        }
        if (fields.length == 0) {
            return;
        }
        if (this.annotationHelper.isAnnotationPresentInHierarchy(ent.getClass(), NoCache.class)) {
            this.config.getWriter().updateUsingFields(ent, null, fields);
            return;
        }
        this.getWriterForClass(ent.getClass()).updateUsingFields(ent, null, fields);
    }

    public ObjectMapper getMapper() {
        return this.objectMapper;
    }

    public AnnotationAndReflectionHelper getARHelper() {
        return this.annotationHelper;
    }

    public <T> T reread(T o) {
        BasicDBObject srch;
        if (o == null) {
            throw new RuntimeException("Cannot re read null!");
        }
        ObjectId id = this.getId(o);
        if (id == null) {
            return null;
        }
        DBCollection col = this.database.getCollection(this.objectMapper.getCollectionName(o.getClass()));
        DBCursor crs = col.find((DBObject)(srch = new BasicDBObject("_id", (Object)id))).limit(1);
        if (crs.hasNext()) {
            DBObject dbo = crs.next();
            Object fromDb = this.objectMapper.unmarshall(o.getClass(), dbo);
            List<String> flds = this.annotationHelper.getFields(o.getClass(), new Class[0]);
            for (String f : flds) {
                Field fld = this.annotationHelper.getField(o.getClass(), f);
                if (Modifier.isStatic(fld.getModifiers())) continue;
                try {
                    fld.set(o, fld.get(fromDb));
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("Could not set Value: " + fld));
                }
            }
        } else {
            logger.info((Object)("Did not find object with id " + id));
            return null;
        }
        this.firePostLoadEvent(o);
        return o;
    }

    public void firePreStoreEvent(Object o, boolean isNew) {
        if (o == null) {
            return;
        }
        for (MorphiumStorageListener l : this.listeners) {
            l.preStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PreStore.class, o);
    }

    public void firePostStoreEvent(Object o, boolean isNew) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PostStore.class, o);
    }

    public void firePreDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDrop(this, cls);
        }
    }

    public void firePostDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postDrop(this, cls);
        }
    }

    public void firePostUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postUpdate(this, cls, t);
        }
    }

    public void firePreUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preUpdate(this, cls, t);
        }
    }

    public void firePostRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostRemove.class, o);
    }

    public void firePostRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, q);
        }
    }

    public void firePreRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDelete(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PreRemove.class, o);
    }

    public void firePreRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preRemove(this, q);
        }
    }

    public void firePostLoadEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postLoad(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostLoad.class, o);
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        return this.getReplicaSetStatus(false);
    }

    public ReplicaSetStatus getReplicaSetStatus(boolean full) {
        if (this.config.getAdr().size() > 1) {
            try {
                DB adminDB = this.getMongo().getDB("admin");
                if (this.config.getMongoAdminUser() != null && !adminDB.authenticate(this.config.getMongoAdminUser(), this.config.getMongoAdminPwd().toCharArray())) {
                    logger.error((Object)"Authentication for admin db failed!");
                    return null;
                }
                CommandResult res = adminDB.command("replSetGetStatus");
                ReplicaSetStatus status = this.objectMapper.unmarshall(ReplicaSetStatus.class, (DBObject)res);
                if (full) {
                    DBCursor rpl = this.getMongo().getDB("local").getCollection("system.replset").find();
                    DBObject stat = rpl.next();
                    ReplicaSetConf cfg = this.objectMapper.unmarshall(ReplicaSetConf.class, stat);
                    List mem = cfg.getMemberList();
                    ArrayList<ConfNode> cmembers = new ArrayList<ConfNode>();
                    for (Object o : mem) {
                        DBObject dbo = (DBObject)o;
                        ConfNode cn = this.objectMapper.unmarshall(ConfNode.class, dbo);
                        cmembers.add(cn);
                    }
                    cfg.setMembers(cmembers);
                    status.setConfig(cfg);
                }
                List<ReplicaSetNode> lst = status.getMembers();
                ArrayList<ReplicaSetNode> members = new ArrayList<ReplicaSetNode>();
                for (ReplicaSetNode l : lst) {
                    DBObject o = (DBObject)l;
                    ReplicaSetNode n = this.objectMapper.unmarshall(ReplicaSetNode.class, o);
                    members.add(n);
                }
                status.setMembers(members);
                return status;
            }
            catch (Exception e) {
                logger.error((Object)"Could not get Replicaset status", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isReplicaSet() {
        return this.config.getAdr().size() > 1;
    }

    public WriteConcern getWriteConcernForClass(Class<?> cls) {
        WriteSafety safety;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returning write concern for " + cls.getSimpleName()));
        }
        if ((safety = this.annotationHelper.getAnnotationFromHierarchy(cls, WriteSafety.class)) == null) {
            return null;
        }
        boolean fsync = safety.waitForSync();
        boolean j = safety.waitForJournalCommit();
        if (j && fsync) {
            fsync = false;
        }
        int w = safety.level().getValue();
        if (!this.isReplicaSet() && w > 1) {
            w = 1;
        }
        int timeout = safety.timeout();
        if (this.isReplicaSet() && w > 2) {
            ReplicaSetStatus s = this.getReplicaSetStatus();
            if (s == null || s.getActiveNodes() == 0) {
                logger.warn((Object)"ReplicaSet status is null or no node active! Assuming default write concern");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Active nodes now: " + s.getActiveNodes()));
            }
            int activeNodes = s.getActiveNodes();
            int masterOpTime = 0;
            int maxReplLag = 0;
            for (ReplicaSetNode node : s.getMembers()) {
                if (node.getState() != 1) continue;
                masterOpTime = node.getOptime().getTime();
            }
            for (ReplicaSetNode node : s.getMembers()) {
                int tm;
                if (node.getState() != 2 || maxReplLag >= (tm = node.getOptime().getTime() - masterOpTime)) continue;
                maxReplLag = tm;
            }
            if (timeout < 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Setting timeout to replication lag*3");
                }
                if (maxReplLag < 0) {
                    maxReplLag = -maxReplLag;
                }
                if (maxReplLag == 0) {
                    maxReplLag = 1;
                }
                timeout = maxReplLag * 3000;
                if (maxReplLag > 10) {
                    logger.warn((Object)("Warning: replication lag too high! timeout set to " + timeout + "ms - replication Lag is " + maxReplLag + "s - write should take place in Background!"));
                }
            }
            w = activeNodes;
            if (timeout > 0 && timeout < maxReplLag * 1000) {
                logger.warn((Object)"Timeout is set smaller than replication lag - increasing to replication_lag time * 3");
                timeout = maxReplLag * 3000;
            }
        }
        if (w == -99) {
            return new WriteConcern("majority", timeout, fsync, j);
        }
        return new WriteConcern(w, timeout, fsync, j);
    }

    public void addProfilingListener(ProfilingListener l) {
        this.profilingListeners.add(l);
    }

    public void removeProfilingListener(ProfilingListener l) {
        this.profilingListeners.remove(l);
    }

    public void fireProfilingWriteEvent(Class type, Object data, long time, boolean isNew, WriteAccessType wt) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.writeAccess(type, data, time, isNew, wt);
            }
            catch (Throwable e) {
                logger.error((Object)"Error during profiling: ", e);
            }
        }
    }

    public void fireProfilingReadEvent(Query q, long time, ReadAccessType t) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.readAccess(q, time, t);
            }
            catch (Throwable e) {
                logger.error((Object)"Error during profiling", e);
            }
        }
    }

    public void clearCollection(Class<?> cls) {
        this.delete(this.createQueryFor(cls));
    }

    public void clearCollectionOneByOne(Class<?> cls) {
        this.inc(StatisticKeys.WRITES);
        List<?> lst = this.readAll(cls);
        for (Object r : lst) {
            this.delete(r);
        }
        this.cache.clearCacheIfNecessary(cls);
    }

    public <T> List<T> readAll(Class<? extends T> cls) {
        this.inc(StatisticKeys.READS);
        Query<T> qu = this.createQueryFor(cls);
        return qu.asList();
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type) {
        Query<T> q = this.config.getQueryFact().createQuery(this, type);
        q.setMorphium(this);
        return q;
    }

    public <T> List<T> find(Query<T> q) {
        return q.asList();
    }

    public List<Object> distinct(Enum key, Class c) {
        return this.distinct(key.name(), c);
    }

    public List<Object> distinct(Enum key, Query q) {
        return this.distinct(key.name(), q);
    }

    public List<Object> distinct(String key, Query q) {
        return this.database.getCollection(this.objectMapper.getCollectionName(q.getType())).distinct(key, q.toQueryObject());
    }

    public List<Object> distinct(String key, Class cls) {
        DBCollection collection = this.database.getCollection(this.objectMapper.getCollectionName(cls));
        this.setReadPreference(collection, cls);
        return collection.distinct(key, (DBObject)new BasicDBObject());
    }

    private void setReadPreference(DBCollection c, Class type) {
        DefaultReadPreference pr = this.annotationHelper.getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            c.setReadPreference(pr.value().getPref());
        } else {
            c.setReadPreference(null);
        }
    }

    public DBObject group(Query q, Map<String, Object> initial, String jsReduce, String jsFinalize, String ... keys) {
        BasicDBObject k = new BasicDBObject();
        BasicDBObject ini = new BasicDBObject();
        ini.putAll(initial);
        for (String ks : keys) {
            if (ks.startsWith("-")) {
                k.append(ks.substring(1), (Object)"false");
                continue;
            }
            if (ks.startsWith("+")) {
                k.append(ks.substring(1), (Object)"true");
                continue;
            }
            k.append(ks, (Object)"true");
        }
        if (!jsReduce.trim().startsWith("function(")) {
            jsReduce = "function (obj,data) { " + jsReduce + " }";
        }
        if (jsFinalize == null) {
            jsFinalize = "";
        }
        if (!jsFinalize.trim().startsWith("function(")) {
            jsFinalize = "function (data) {" + jsFinalize + "}";
        }
        GroupCommand cmd = new GroupCommand(this.database.getCollection(this.objectMapper.getCollectionName(q.getType())), (DBObject)k, q.toQueryObject(), (DBObject)ini, jsReduce, jsFinalize);
        return this.database.getCollection(this.objectMapper.getCollectionName(q.getType())).group(cmd);
    }

    public <T> T findById(Class<? extends T> type, ObjectId id) {
        T ret = this.cache.getFromIDCache(type, id);
        if (ret != null) {
            return ret;
        }
        List<String> ls = this.annotationHelper.getFields(type, Id.class);
        if (ls.size() == 0) {
            throw new RuntimeException("Cannot find by ID on non-Entity");
        }
        return this.createQueryFor(type).f(ls.get(0)).eq(id).get();
    }

    public <T> List<T> findByField(Class<? extends T> cls, String fld, Object val) {
        Query<T> q = this.createQueryFor(cls);
        q = q.f(fld).eq(val);
        return q.asList();
    }

    public <T> List<T> findByField(Class<? extends T> cls, Enum fld, Object val) {
        return this.findByField(cls, fld.name(), val);
    }

    public void clearCachefor(Class<?> cls) {
        this.cache.clearCachefor(cls);
    }

    public <T> void storeNoCache(T lst) {
        this.storeNoCache(lst, null);
    }

    public <T> void storeNoCache(T lst, AsyncOperationCallback<T> callback) {
        this.config.getWriter().store(lst, callback);
    }

    public <T> void storeInBackground(T lst) {
        this.storeInBackground(lst, null);
    }

    public <T> void storeInBackground(T lst, AsyncOperationCallback<T> callback) {
        this.config.getBufferedWriter().store(lst, callback);
    }

    public ObjectId getId(Object o) {
        return this.annotationHelper.getId(o);
    }

    @Override
    public <T> void dropCollection(Class<T> cls, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).dropCollection(cls, callback);
    }

    public void dropCollection(Class<?> cls) {
        this.getWriterForClass(cls).dropCollection(cls, null);
    }

    @Override
    public <T> void ensureIndex(Class<T> cls, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).ensureIndex(cls, index, callback);
    }

    @Override
    public int writeBufferCount() {
        return this.config.getWriter().writeBufferCount() + this.config.getBufferedWriter().writeBufferCount();
    }

    public void ensureIndex(Class<?> cls, Map<String, Object> index) {
        this.getWriterForClass(cls).ensureIndex(cls, index, null);
    }

    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Enum e : fldStr) {
            String f = e.name();
            m.put(f, 1);
        }
        this.getWriterForClass(cls).ensureIndex(cls, m, callback);
    }

    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, String ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (String f : fldStr) {
            int idx = 1;
            if (f.contains(":")) {
                String[] fs = f.split(":");
                m.put(fs[0], fs[1]);
                continue;
            }
            if (f.startsWith("-")) {
                idx = -1;
                f = f.substring(1);
            } else if (f.startsWith("+")) {
                f = f.substring(1);
            }
            m.put(f, idx);
        }
        this.getWriterForClass(cls).ensureIndex(cls, m, callback);
    }

    public void ensureIndex(Class<?> cls, String ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public void ensureIndex(Class<?> cls, Enum ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public <T> void store(T o) {
        this.store(o, null);
    }

    @Override
    public <T> void store(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            throw new RuntimeException("Lists need to be stored with storeList");
        }
        this.getWriterForClass(o.getClass()).store(o, callback);
    }

    @Override
    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.storeList(lst, callback);
    }

    public <T> void storeList(List<T> lst) {
        this.storeList(lst, null);
    }

    public <T> void storeList(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> storeDirect = new ArrayList<T>();
        ArrayList<T> storeInBg = new ArrayList<T>();
        for (T o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                storeInBg.add(o);
                continue;
            }
            storeDirect.add(o);
        }
        this.config.getBufferedWriter().store(storeInBg, callback);
        this.config.getWriter().store(storeDirect, callback);
    }

    public <T> void delete(Query<T> o) {
        this.getWriterForClass(o.getType()).delete(o, (AsyncOperationCallback)null);
    }

    @Override
    public <T> void delete(Query<T> o, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(o.getType()).delete(o, callback);
    }

    @Override
    public <T> void pushPull(boolean push, Query<T> query, String field, Object value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPull(push, query, field, value, insertIfNotExist, multiple, callback);
    }

    @Override
    public <T> void pushPullAll(boolean push, Query<T> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPullAll(push, query, field, value, insertIfNotExist, multiple, callback);
    }

    public <T> void pullAll(Query<T> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPullAll(false, query, field, value, insertIfNotExist, multiple, callback);
    }

    public void delete(Object o) {
        this.getWriterForClass(o.getClass()).delete(o, null);
    }

    @Override
    public <T> void delete(T lo, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(lo.getClass()).delete(lo, callback);
    }

    public Map<String, Double> getStatistics() {
        return new Statistics(this);
    }

    public Map<StatisticKeys, StatisticValue> getStats() {
        return this.stats;
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutDownListeners.add(l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutDownListeners.remove(l);
    }

    public void close() {
        this.cacheHousekeeper.end();
        for (ShutdownListener l : this.shutDownListeners) {
            l.onShutdown(this);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            logger.debug((Object)"Ignoring interrupted-exception");
        }
        if (this.cacheHousekeeper.isAlive()) {
            this.cacheHousekeeper.interrupt();
        }
        this.database = null;
        this.config = null;
        this.mongo.close();
        MorphiumSingleton.reset();
    }

    public String createCamelCase(String n) {
        return this.annotationHelper.createCamelCase(n, false);
    }

    public <T, R> Aggregator<T, R> createAggregator(Class<? extends T> type, Class<? extends R> resultType) {
        Aggregator<T, R> aggregator = this.config.getAggregatorFactory().createAggregator(type, resultType);
        aggregator.setMorphium(this);
        return aggregator;
    }

    public <T, R> List<R> aggregate(Aggregator<T, R> a) {
        DBCollection coll = this.database.getCollection(this.objectMapper.getCollectionName(a.getSearchType()));
        List<DBObject> agList = a.toAggregationList();
        DBObject first = agList.get(0);
        agList.remove(0);
        AggregationOutput resp = coll.aggregate(first, agList.toArray(new DBObject[agList.size()]));
        ArrayList<R> ret = new ArrayList<R>();
        for (DBObject o : resp.results()) {
            ret.add(this.getMapper().unmarshall(a.getResultType(), o));
        }
        return ret;
    }

    public <T> T createPartiallyUpdateableEntity(T o) {
        return (T)Enhancer.create(o.getClass(), (Class[])new Class[]{PartiallyUpdateable.class, Serializable.class}, new PartiallyUpdateableProxy<T>(this, o));
    }

    public <T> T createLazyLoadedEntity(Class<? extends T> cls, ObjectId id) {
        return (T)Enhancer.create(cls, (Class[])new Class[]{Serializable.class}, new LazyDeReferencingProxy<T>(this, cls, id));
    }

    public <T> MongoField<T> createMongoField() {
        try {
            return this.config.getFieldImplClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public int getWriteBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount() + this.config.getWriter().writeBufferCount();
    }

    public int getBufferedWriterBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount();
    }

    public int getWriterBufferCount() {
        return this.config.getWriter().writeBufferCount();
    }
}

