/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.ConfigElement;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.CacheSyncListener;
import de.caluga.morphium.cache.CacheSyncVetoException;
import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.Msg;
import de.caluga.morphium.messaging.MsgType;
import de.caluga.morphium.query.Query;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class CacheSynchronizer
implements MorphiumStorageListener<Object>,
MessageListener {
    private static final Logger log = Logger.getLogger(CacheSynchronizer.class);
    private Messaging messaging;
    private Morphium morphium;
    public static final String CACHE_SYNC_TYPE = "cacheSyncType";
    public static final String CACHE_SYNC_RECORD = "cacheSyncRecord";
    private Vector<CacheSyncListener> listeners = new Vector();
    private Hashtable<Class<?>, Vector<CacheSyncListener>> listenerForType = new Hashtable();

    public CacheSynchronizer(Messaging msg, Morphium morphium) {
        this.messaging = msg;
        this.morphium = morphium;
        morphium.addListener(this);
        this.messaging.addListenerForMessageNamed(CACHE_SYNC_TYPE, this);
        this.messaging.addListenerForMessageNamed(CACHE_SYNC_RECORD, this);
    }

    public void addSyncListener(CacheSyncListener cl) {
        this.listeners.add(cl);
    }

    public void removeSyncListener(CacheSyncListener cl) {
        this.listeners.remove(cl);
    }

    public void addSyncListener(Class type, CacheSyncListener cl) {
        if (this.listenerForType.get(type) == null) {
            this.listenerForType.put(type, new Vector());
        }
        this.listenerForType.get(type).add(cl);
    }

    public void removeSyncListener(Class type, CacheSyncListener cl) {
        if (this.listenerForType.get(type) == null) {
            return;
        }
        this.listenerForType.get(type).remove(cl);
    }

    public void firePostSendEvent(Class type, Msg m) {
        for (CacheSyncListener cl : this.listeners) {
            cl.postSendClearMsg(type, m);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (CacheSyncListener cl : this.listenerForType.get(type)) {
                cl.postSendClearMsg(type, m);
            }
        }
    }

    public void firePreSendEvent(Class type, Msg m) throws CacheSyncVetoException {
        for (CacheSyncListener cl : this.listeners) {
            cl.preSendClearMsg(type, m);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (CacheSyncListener cl : this.listenerForType.get(type)) {
                cl.preSendClearMsg(type, m);
            }
        }
    }

    private void firePreClearEvent(Class type, Msg m) throws CacheSyncVetoException {
        for (CacheSyncListener cl : this.listeners) {
            cl.preClear(type, m);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (CacheSyncListener cl : this.listenerForType.get(type)) {
                cl.preClear(type, m);
            }
        }
    }

    public void firePostClearEvent(Class type, Msg m) {
        for (CacheSyncListener cl : this.listeners) {
            cl.postClear(type, m);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (CacheSyncListener cl : this.listenerForType.get(type)) {
                cl.postClear(type, m);
            }
        }
    }

    public void sendClearMessage(Object record, String reason, boolean isNew) {
        if (record.equals(Msg.class)) {
            return;
        }
        ObjectId id = this.morphium.getId(record);
        Msg m = new Msg(CACHE_SYNC_RECORD, MsgType.MULTI, reason, record.getClass().getName(), 30000L);
        if (id != null) {
            m.addAdditional(id.toString());
        }
        if (record.equals(ConfigElement.class)) {
            this.messaging.queueMessage(m);
            return;
        }
        Cache c = this.morphium.getAnnotationFromHierarchy(record.getClass(), Cache.class);
        if (c == null) {
            return;
        }
        if (c.readCache() && c.clearOnWrite()) {
            if (c.syncCache().equals((Object)Cache.SyncCacheStrategy.UPDATE_ENTRY) || c.syncCache().equals((Object)Cache.SyncCacheStrategy.REMOVE_ENTRY_FROM_TYPE_CACHE)) {
                if (!isNew) {
                    try {
                        this.firePreSendEvent(record.getClass(), m);
                        this.messaging.queueMessage(m);
                        this.firePostSendEvent(record.getClass(), m);
                    }
                    catch (CacheSyncVetoException e) {
                        log.error((Object)"could not send clear cache message: Veto by listener!", (Throwable)e);
                    }
                }
            } else if (c.syncCache().equals((Object)Cache.SyncCacheStrategy.CLEAR_TYPE_CACHE)) {
                m.setName(CACHE_SYNC_TYPE);
                try {
                    this.firePreSendEvent(record.getClass(), m);
                    this.messaging.queueMessage(m);
                    this.firePostSendEvent(record.getClass(), m);
                }
                catch (CacheSyncVetoException e) {
                    log.error((Object)"could not send clear cache message: Veto by listener!", (Throwable)e);
                }
            }
        }
    }

    public void sendClearMessage(Class type, String reason) {
        if (type.equals(Msg.class)) {
            return;
        }
        Msg m = new Msg(CACHE_SYNC_TYPE, MsgType.MULTI, reason, type.getName(), 30000L);
        if (type.equals(ConfigElement.class)) {
            try {
                this.firePreSendEvent(type, m);
                this.messaging.queueMessage(m);
                this.firePostSendEvent(type, m);
            }
            catch (CacheSyncVetoException e) {
                log.error((Object)"could not send clear cache message: Veto by listener!", (Throwable)e);
            }
            return;
        }
        Cache c = this.morphium.getAnnotationFromHierarchy(type, Cache.class);
        if (c == null) {
            return;
        }
        if (c.readCache() && c.clearOnWrite() && !c.syncCache().equals((Object)Cache.SyncCacheStrategy.NONE)) {
            try {
                this.firePreSendEvent(type, m);
                this.messaging.queueMessage(m);
                this.firePostSendEvent(type, m);
            }
            catch (CacheSyncVetoException e) {
                log.error((Object)"could not send clear message: Veto!", (Throwable)e);
            }
        }
    }

    public void detach() {
        this.morphium.removeListener(this);
        this.messaging.removeListenerForMessageNamed(CACHE_SYNC_TYPE, this);
        this.messaging.removeListenerForMessageNamed(CACHE_SYNC_RECORD, this);
    }

    public void sendClearAllMessage(String reason) {
        Msg m = new Msg(CACHE_SYNC_TYPE, MsgType.MULTI, reason, "ALL", 30000L);
        try {
            this.firePreSendEvent(null, m);
            this.messaging.queueMessage(m);
            this.firePostSendEvent(null, m);
        }
        catch (CacheSyncVetoException e) {
            log.error((Object)"Got veto before clearing cache", (Throwable)e);
        }
    }

    @Override
    public void preStore(Object r, boolean isNew) {
    }

    @Override
    public void postStore(Object r, boolean isNew) {
        this.sendClearMessage(r, "store", isNew);
    }

    @Override
    public void postRemove(Object r) {
        this.sendClearMessage(r.getClass(), "remove");
    }

    @Override
    public void preDelete(Object r) {
    }

    @Override
    public void postDrop(Class cls) {
        this.sendClearMessage(cls, "drop");
    }

    @Override
    public void preDrop(Class cls) {
    }

    @Override
    public void preRemove(Query q) {
    }

    @Override
    public void postRemove(Query q) {
        this.sendClearMessage(q.getType(), "remove");
    }

    @Override
    public void postLoad(Object o) {
    }

    @Override
    public void preUpdate(Class cls, Enum updateType) {
    }

    @Override
    public void postUpdate(Class cls, Enum updateType) {
        this.sendClearMessage(cls, "Update: " + updateType.name());
    }

    @Override
    public Msg onMessage(Msg m) {
        Msg answer;
        block25: {
            answer = new Msg("clearCacheAnswer", "processed", this.messaging.getSenderId());
            try {
                Cache c;
                Class<?> cls;
                if (log.isDebugEnabled()) {
                    String action = m.getMsg();
                    String sender = m.getSender();
                    log.debug((Object)("Got message " + m.getName() + " from " + sender + " - Action: " + action + " Class: " + m.getValue()));
                }
                if (m.getName().equals(CACHE_SYNC_TYPE)) {
                    if (m.getValue().equals("ALL")) {
                        try {
                            this.firePreClearEvent(null, m);
                            this.morphium.resetCache();
                            this.firePostClearEvent(null, m);
                            answer.setMsg("cache completely cleared");
                            log.info((Object)"Cache completely cleared");
                        }
                        catch (CacheSyncVetoException e) {
                            log.error((Object)"Could not clear whole cache - Veto!", (Throwable)e);
                        }
                        return answer;
                    }
                    cls = Class.forName(m.getValue());
                    if (cls.equals(ConfigElement.class)) {
                        try {
                            this.firePreClearEvent(ConfigElement.class, m);
                            this.morphium.getConfigManager().reinitSettings();
                            this.firePostClearEvent(ConfigElement.class, m);
                            answer.setMsg("config reread");
                        }
                        catch (CacheSyncVetoException e) {
                            log.error((Object)"Veto during cache clearance of config", (Throwable)e);
                        }
                        return answer;
                    }
                    if (this.morphium.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                        c = this.morphium.getAnnotationFromHierarchy(cls, Cache.class);
                        if (c != null) {
                            if (c.readCache()) {
                                try {
                                    this.firePreClearEvent(cls, m);
                                    this.morphium.clearCachefor(cls);
                                    answer.setMsg("cache cleared for type: " + m.getValue());
                                    this.firePostClearEvent(cls, m);
                                }
                                catch (CacheSyncVetoException e) {
                                    log.error((Object)"Could not clear cache! Got Veto", (Throwable)e);
                                }
                            } else {
                                log.warn((Object)"trying to clear cache for uncached enitity or one where clearOnWrite is false");
                                answer.setMsg("type is uncached or clearOnWrite is false: " + m.getValue());
                            }
                        }
                    } else {
                        log.warn((Object)"Trying to clear cache for none-Entity?????");
                        answer.setMsg("cannot clear cache for non-entyty type: " + m.getValue());
                    }
                    break block25;
                }
                cls = Class.forName(m.getValue());
                if (this.morphium.isAnnotationPresentInHierarchy(cls, Entity.class) && (c = this.morphium.getAnnotationFromHierarchy(cls, Cache.class)) != null) {
                    if (c.readCache()) {
                        try {
                            this.firePreClearEvent(cls, m);
                            Hashtable<Class<? extends Object>, Hashtable<ObjectId, Object>> idCache = this.morphium.cloneIdCache();
                            for (String a : m.getAdditional()) {
                                ObjectId id = new ObjectId(a);
                                if (idCache.get(cls) == null || idCache.get(cls).get(id) == null) continue;
                                if (c.syncCache().equals((Object)Cache.SyncCacheStrategy.REMOVE_ENTRY_FROM_TYPE_CACHE)) {
                                    this.morphium.removeEntryFromCache(cls, id);
                                    continue;
                                }
                                this.morphium.reread(idCache.get(cls).get(id));
                            }
                            this.morphium.setIdCache(idCache);
                            answer.setMsg("cache cleared for type: " + m.getValue());
                            this.firePostClearEvent(cls, m);
                        }
                        catch (CacheSyncVetoException e) {
                            log.error((Object)"Not clearing id cache: Veto", (Throwable)e);
                        }
                    } else {
                        log.warn((Object)"trying to clear cache for uncached enitity or one where clearOnWrite is false");
                        answer.setMsg("type is uncached or clearOnWrite is false: " + m.getValue());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("Could not process message for class " + m.getValue() + " - not found!"));
                answer.setMsg("class not found: " + m.getValue());
            }
            catch (Throwable t) {
                log.error((Object)"Could not process message: ", t);
                answer.setMsg("Error processing message: " + t.getMessage());
            }
        }
        return answer;
    }

    @Override
    public void setMessaging(Messaging msg) {
    }
}

