/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.logging;

import de.caluga.morphium.MorphiumSingleton;
import de.caluga.morphium.logging.Log;
import java.util.Arrays;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class MongoAppender
implements Appender {
    private Filter filter;
    private ErrorHandler errorHandler;
    private Layout layout;
    private String name;

    public void addFilter(Filter newFilter) {
        this.filter = newFilter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
    }

    public void doAppend(LoggingEvent event) {
        if (!MorphiumSingleton.isConfigured() || !MorphiumSingleton.isInitialized()) {
            return;
        }
        Log l = new Log();
        if (event.getMessage() != null) {
            l.setMessage(event.getMessage().toString());
        }
        if (event.getRenderedMessage() != null) {
            l.setMessage(event.getRenderedMessage());
        }
        l.setTimestamp(event.getTimeStamp());
        l.setLevel(event.getLevel().toString());
        l.setThreadName(event.getThreadName());
        l.setThreadId((int)Thread.currentThread().getId());
        if (event.getThrowableInformation() != null) {
            ThrowableInformation thr = event.getThrowableInformation();
            Throwable t = thr.getThrowable();
            l.setExceptionMessage(t.getMessage());
            l.setExceptionName(t.getClass().getName());
            l.setCausedBy(t.getCause().getClass().getName() + "(" + t.getCause().getMessage() + ")");
            l.setExceptionStacktrace(Arrays.asList(thr.getThrowableStrRep()));
        }
        MorphiumSingleton.get().store(l);
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean requiresLayout() {
        return false;
    }
}

