/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.cache.CacheElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class CacheHousekeeper
extends Thread {
    private static final String MONGODBLAYER_CACHE = "mongodblayer.cache";
    private int timeout;
    private Map<Class<?>, Integer> validTimeForClass;
    private int gcTimeout;
    private boolean running = true;
    private Logger log = Logger.getLogger(CacheHousekeeper.class);
    private Morphium morphium;

    public CacheHousekeeper(Morphium m, int houseKeepingTimeout, int globalCacheTimout) {
        this.timeout = houseKeepingTimeout;
        this.gcTimeout = globalCacheTimout;
        this.morphium = m;
        this.validTimeForClass = new Hashtable();
        this.setDaemon(true);
    }

    public void setValidCacheTime(Class<?> cls, int timeout) {
        this.validTimeForClass.put(cls, timeout);
    }

    public Integer getValidCacheTime(Class<?> cls) {
        return this.validTimeForClass.get(cls);
    }

    public void end() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Hashtable toDelete = new Hashtable();
                Hashtable<Class<?>, Hashtable<String, CacheElement>> cache = this.morphium.cloneCache();
                for (Map.Entry<Class<?>, Hashtable<String, CacheElement>> es : cache.entrySet()) {
                    Class<?> clz = es.getKey();
                    Hashtable ch = (Hashtable)es.getValue().clone();
                    int maxEntries = -1;
                    Cache cacheSettings = this.morphium.getAnnotationFromHierarchy(clz, Cache.class);
                    NoCache noCache = this.morphium.getAnnotationFromHierarchy(clz, NoCache.class);
                    int time = this.gcTimeout;
                    Hashtable lruTime = new Hashtable();
                    Hashtable fifoTime = new Hashtable();
                    Cache.ClearStrategy strategy = null;
                    if (noCache == null && cacheSettings != null) {
                        time = cacheSettings.timeout();
                        maxEntries = cacheSettings.maxEntries();
                        strategy = cacheSettings.strategy();
                        if (this.validTimeForClass.get(clz) == null) {
                            this.validTimeForClass.put(clz, time);
                        }
                    }
                    if (this.validTimeForClass.get(clz) != null) {
                        time = this.validTimeForClass.get(clz);
                    }
                    int del = 0;
                    for (Map.Entry est : ch.entrySet()) {
                        String k = (String)est.getKey();
                        CacheElement e = (CacheElement)est.getValue();
                        if (e == null || e.getFound() == null || System.currentTimeMillis() - e.getCreated() > (long)time) {
                            if (toDelete.get(clz) == null) {
                                toDelete.put(clz, new Vector());
                            }
                            ((Vector)toDelete.get(clz)).add(k);
                            ++del;
                            continue;
                        }
                        if (lruTime.get(e.getLru()) == null) {
                            lruTime.put(e.getLru(), new Vector());
                        }
                        ((List)lruTime.get(e.getLru())).add(k);
                        long fifo = System.currentTimeMillis() - e.getCreated();
                        if (fifoTime.get(fifo) == null) {
                            fifoTime.put(fifo, new Vector());
                        }
                        ((List)fifoTime.get(fifo)).add(k);
                    }
                    cache.put(clz, ch);
                    if (maxEntries <= 0 || cache.get(clz).size() - del <= maxEntries) continue;
                    switch (strategy) {
                        case LRU: {
                            Object[] array = lruTime.keySet().toArray(new Long[lruTime.keySet().size()]);
                            Arrays.sort(array);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).size() == 0) continue;
                                if (toDelete.get(clz) == null) {
                                    toDelete.put(clz, new Vector());
                                }
                                ((Vector)toDelete.get(clz)).add(((List)lruTime.get(array[idx])).get(0));
                                ((List)lruTime.get(array[idx])).remove(0);
                                ++del;
                                if (((List)lruTime.get(array[idx])).size() != 0) continue;
                                ++idx;
                            }
                            break;
                        }
                        case FIFO: {
                            Object[] array = fifoTime.keySet().toArray(new Long[fifoTime.keySet().size()]);
                            Arrays.sort(array);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (fifoTime.get(array[array.length - 1 - idx]) == null || ((List)fifoTime.get(array[array.length - 1 - idx])).size() == 0) continue;
                                if (toDelete.get(clz) == null) {
                                    toDelete.put(clz, new Vector());
                                }
                                ((Vector)toDelete.get(clz)).add(((List)fifoTime.get(array[array.length - 1 - idx])).get(0));
                                ((List)fifoTime.get(array[array.length - 1 - idx])).remove(0);
                                ++del;
                                if (((List)fifoTime.get(array[array.length - 1 - idx])).size() != 0) continue;
                                ++idx;
                            }
                            break;
                        }
                        case RANDOM: {
                            Object[] array = fifoTime.keySet().toArray(new Long[fifoTime.keySet().size()]);
                            List<Object> lst = Arrays.asList(array);
                            Collections.shuffle(lst);
                            array = lst.toArray(new Long[lst.size()]);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).size() == 0) continue;
                                if (toDelete.get(clz) == null) {
                                    toDelete.put(clz, new Vector());
                                }
                                ((Vector)toDelete.get(clz)).add(((List)lruTime.get(array[idx])).get(0));
                                ++del;
                                if (((List)lruTime.get(array[idx])).size() != 0) continue;
                                ++idx;
                            }
                            break;
                        }
                    }
                }
                Hashtable<Class<?>, Hashtable<ObjectId, Object>> idCacheClone = this.morphium.cloneIdCache();
                for (Map.Entry et : toDelete.entrySet()) {
                    Class cls = (Class)et.getKey();
                    boolean inIdCache = idCacheClone.get(cls) != null;
                    for (String k : (Vector)et.getValue()) {
                        if (inIdCache) {
                            for (Object f : cache.get(cls).get(k).getFound()) {
                                idCacheClone.get(cls).remove(this.morphium.getId(f));
                            }
                        }
                        cache.get(cls).remove(k);
                    }
                }
                this.morphium.setCache(cache);
                this.morphium.setIdCache(idCacheClone);
            }
            catch (Throwable e) {
                this.log.warn((Object)("Error:" + e.getMessage()), e);
            }
            try {
                CacheHousekeeper.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                this.log.info((Object)"Ignoring InterruptedException");
            }
        }
    }
}

