/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.annotations.caching;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Cache {
    public int timeout() default 60000;

    public boolean clearOnWrite() default true;

    public int maxEntries() default -1;

    public ClearStrategy strategy() default ClearStrategy.FIFO;

    public boolean writeCache() default false;

    public boolean readCache() default true;

    public SyncCacheStrategy syncCache() default SyncCacheStrategy.NONE;

    public static enum SyncCacheStrategy {
        NONE,
        CLEAR_TYPE_CACHE,
        REMOVE_ENTRY_FROM_TYPE_CACHE,
        UPDATE_ENTRY;

    }

    public static enum ClearStrategy {
        LRU,
        FIFO,
        RANDOM;

    }
}

