/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.ServerAddress;
import de.caluga.morphium.ConfigManager;
import de.caluga.morphium.ConfigManagerImpl;
import de.caluga.morphium.MongoDbMode;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Writer;
import de.caluga.morphium.WriterImpl;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorFactory;
import de.caluga.morphium.aggregation.AggregatorFactoryImpl;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MongoFieldImpl;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.MorphiumIteratorImpl;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.query.QueryFactory;
import de.caluga.morphium.query.QueryFactoryImpl;
import de.caluga.morphium.query.QueryImpl;
import de.caluga.morphium.secure.DefaultSecurityManager;
import de.caluga.morphium.secure.MongoSecurityManager;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class MorphiumConfig {
    private MongoDbMode mode;
    private int maxConnections;
    private int housekeepingTimeout;
    private int globalCacheValidTime = 5000;
    private int writeCacheTimeout = 5000;
    private String database;
    private Writer writer = new WriterImpl();
    private int connectionTimeout = 0;
    private int socketTimeout = 0;
    private boolean socketKeepAlive = true;
    private int maxWaitTime = 120000;
    private boolean autoreconnect = true;
    private int maxAutoReconnectTime = 0;
    private Class<? extends Query> queryClass;
    private Class<? extends Aggregator> aggregatorClass;
    private QueryFactory queryFact;
    private AggregatorFactory aggregatorFactory;
    private boolean timeoutBugWorkAroundEnabled = false;
    private String mongoLogin = null;
    private String mongoPassword = null;
    private int configManagerCacheTimeout = 3600000;
    private List<ServerAddress> adr;
    private Map<String, Integer> validTimeByClassName;
    private ConfigManager configManager;
    private String superUserLogin;
    private String superUserPassword;
    private String adminGroupName;
    private MongoSecurityManager securityMgr;
    private ObjectMapper mapper = new ObjectMapperImpl();
    private Class<? extends MongoField> fieldImplClass = MongoFieldImpl.class;
    private ReadPreferenceLevel defaultReadPreference;
    private Class<? extends MorphiumIterator> iteratorClass;

    public boolean isTimeoutBugWorkAroundEnabled() {
        return this.timeoutBugWorkAroundEnabled;
    }

    public void setTimeoutBugWorkAroundEnabled(boolean timeoutBugWorkAroundEnabled) {
        this.timeoutBugWorkAroundEnabled = timeoutBugWorkAroundEnabled;
    }

    public Class<? extends Query> getQueryClass() {
        if (this.queryClass == null) {
            this.queryClass = QueryImpl.class;
        }
        return this.queryClass;
    }

    public void setQueryClass(Class<Query> queryClass) {
        this.queryClass = queryClass;
    }

    public QueryFactory getQueryFact() {
        if (this.queryFact == null) {
            this.queryFact = new QueryFactoryImpl(this.getQueryClass());
        }
        return this.queryFact;
    }

    public void setQueryFact(QueryFactory queryFact) {
        this.queryFact = queryFact;
    }

    public AggregatorFactory getAggregatorFactory() {
        if (this.aggregatorFactory == null) {
            this.aggregatorFactory = new AggregatorFactoryImpl(this.getAggregatorClass());
        }
        return this.aggregatorFactory;
    }

    public void setAggregatorFactory(AggregatorFactory aggregatorFactory) {
        this.aggregatorFactory = aggregatorFactory;
    }

    public Class<? extends Aggregator> getAggregatorClass() {
        if (this.aggregatorClass == null) {
            this.aggregatorClass = AggregatorImpl.class;
        }
        return this.aggregatorClass;
    }

    public void setAggregatorClass(Class<? extends Aggregator> aggregatorClass) {
        this.aggregatorClass = aggregatorClass;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Class<? extends MongoField> getFieldImplClass() {
        return this.fieldImplClass;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public boolean isAutoreconnect() {
        return this.autoreconnect;
    }

    public void setAutoreconnect(boolean autoreconnect) {
        this.autoreconnect = autoreconnect;
    }

    public int getMaxAutoReconnectTime() {
        return this.maxAutoReconnectTime;
    }

    public void setMaxAutoReconnectTime(int maxAutoReconnectTime) {
        this.maxAutoReconnectTime = maxAutoReconnectTime;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String getMongoLogin() {
        return this.mongoLogin;
    }

    public void setMongoLogin(String mongoLogin) {
        this.mongoLogin = mongoLogin;
    }

    public String getMongoPassword() {
        return this.mongoPassword;
    }

    public void setMongoPassword(String mongoPassword) {
        this.mongoPassword = mongoPassword;
    }

    public MongoSecurityManager getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(MongoSecurityManager securityMgr) {
        this.securityMgr = securityMgr;
    }

    public ReadPreferenceLevel getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    public void setDefaultReadPreference(ReadPreferenceLevel defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
    }

    public String getAdminGroupName() {
        return this.adminGroupName;
    }

    public void setAdminGroupName(String adminGroupName) {
        this.adminGroupName = adminGroupName;
    }

    public String getSuperUserLogin() {
        return this.superUserLogin;
    }

    public void setSuperUserLogin(String superUserLogin) {
        this.superUserLogin = superUserLogin;
    }

    public String getSuperUserPassword() {
        return this.superUserPassword;
    }

    public void setSuperUserPassword(String superUserPassword) {
        this.superUserPassword = superUserPassword;
    }

    public int getConfigManagerCacheTimeout() {
        return this.configManagerCacheTimeout;
    }

    public void setConfigManagerCacheTimeout(int configManagerCacheTimeout) {
        this.configManagerCacheTimeout = configManagerCacheTimeout;
    }

    public void setMode(MongoDbMode mode) {
        this.mode = mode;
    }

    public int getWriteCacheTimeout() {
        return this.writeCacheTimeout;
    }

    public void setWriteCacheTimeout(int writeCacheTimeout) {
        this.writeCacheTimeout = writeCacheTimeout;
    }

    public Map<String, Integer> getValidTimeByClassName() {
        return this.validTimeByClassName;
    }

    public void setValidTimeByClassName(Map<String, Integer> validTimeByClassName) {
        this.validTimeByClassName = validTimeByClassName;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setHousekeepingTimeout(int housekeepingTimeout) {
        this.housekeepingTimeout = housekeepingTimeout;
    }

    public void setGlobalCacheValidTime(int globalCacheValidTime) {
        this.globalCacheValidTime = globalCacheValidTime;
    }

    public MongoDbMode getMode() {
        return this.mode;
    }

    public List<ServerAddress> getAdr() {
        return this.adr;
    }

    public void setAdr(List<ServerAddress> adr) {
        this.adr = adr;
    }

    public void addAddress(String host, int port) throws UnknownHostException {
        ServerAddress sa = new ServerAddress(host, port);
        this.adr.add(sa);
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getGlobalCacheValidTime() {
        return this.globalCacheValidTime;
    }

    public MorphiumConfig(String db, MongoDbMode mode, int maxConnections, int globalCacheValidTime, int housekeepingTimeout) throws IOException {
        this(db, mode, maxConnections, globalCacheValidTime, housekeepingTimeout, new DefaultSecurityManager());
    }

    public MorphiumConfig(String db, MongoDbMode mode, int maxConnections, int globalCacheValidTime, int housekeepingTimeout, MongoSecurityManager mgr) throws IOException {
        this(db, mode, maxConnections, globalCacheValidTime, housekeepingTimeout, mgr, Thread.currentThread().getContextClassLoader().getResource("morphium-log4j.xml"));
    }

    public MorphiumConfig(String db, MongoDbMode mode, int maxConnections, int globalCacheValidTime, int housekeepingTimeout, MongoSecurityManager mgr, String resourceName) throws IOException {
        this(db, mode, maxConnections, globalCacheValidTime, housekeepingTimeout, mgr, Thread.currentThread().getContextClassLoader().getResource(resourceName));
    }

    public MorphiumConfig(String db, MongoDbMode mode, int maxConnections, int globalCacheValidTime, int housekeepingTimeout, MongoSecurityManager mgr, URL loggingConfigResource) {
        this.securityMgr = mgr;
        if (this.securityMgr == null) {
            this.securityMgr = new DefaultSecurityManager();
        }
        this.validTimeByClassName = new Hashtable<String, Integer>();
        this.database = db;
        this.adr = new Vector<ServerAddress>();
        this.mode = mode;
        this.maxConnections = maxConnections;
        this.globalCacheValidTime = globalCacheValidTime;
        this.housekeepingTimeout = housekeepingTimeout;
        if (loggingConfigResource != null && !MorphiumConfig.isLoggingConfigured()) {
            DOMConfigurator.configure((URL)loggingConfigResource);
        }
    }

    private static boolean isLoggingConfigured() {
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        if (appenders.hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger c = (Logger)loggers.nextElement();
            if (!c.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getHousekeepingTimeout() {
        return this.housekeepingTimeout;
    }

    public void setValidTime(int tm) {
        this.globalCacheValidTime = tm;
    }

    public void setValidTimeForClass(String cls, int tm) {
        this.validTimeByClassName.put(cls, tm);
    }

    public long getValidTimeForClass(String cls) {
        return this.validTimeByClassName.get(cls).intValue();
    }

    public long getValidTime() {
        return this.globalCacheValidTime;
    }

    public String toString() {
        return "MorphiumConfig{mode=" + (Object)((Object)this.mode) + ", maxConnections=" + this.maxConnections + ", housekeepingTimeout=" + this.housekeepingTimeout + ", globalCacheValidTime=" + this.globalCacheValidTime + ", writeCacheTimeout=" + this.writeCacheTimeout + ", database='" + this.database + '\'' + ", connectionTimeout=" + this.connectionTimeout + ", socketTimeout=" + this.socketTimeout + ", socketKeepAlive=" + this.socketKeepAlive + ", slaveOk=" + this.defaultReadPreference.toString() + ", mongoLogin='" + this.mongoLogin + '\'' + ", mongoPassword='" + this.mongoPassword + '\'' + ", configManagerCacheTimeout=" + this.configManagerCacheTimeout + ", adr=" + this.adr + ", validTimeByClassName=" + this.validTimeByClassName + ", configManager=" + this.configManager + ", superUserLogin='" + this.superUserLogin + '\'' + ", superUserPassword='" + this.superUserPassword + '\'' + ", adminGroupName='" + this.adminGroupName + '\'' + ", securityMgr=" + this.securityMgr + ", mapper=" + this.mapper + ", fieldImplClass='" + this.fieldImplClass + '\'' + '}';
    }

    public Properties getProperties() {
        Properties p = new Properties();
        this.fillProperties(p, "morphium");
        return p;
    }

    public void fillProperties(Properties p, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (!prefix.isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        p.setProperty(prefix + "mode", this.mode.name());
        p.setProperty(prefix + "maxConnections", "" + this.maxConnections);
        p.setProperty(prefix + "housekeepingTimeout", "" + this.housekeepingTimeout);
        p.setProperty(prefix + "globalCacheValidTime", "" + this.globalCacheValidTime);
        p.setProperty(prefix + "writeCacheTimeout", "" + this.writeCacheTimeout);
        p.setProperty(prefix + "database", this.database);
        p.setProperty(prefix + "connectionTimeout", "" + this.connectionTimeout);
        p.setProperty(prefix + "socketTimeout", "" + this.socketTimeout);
        p.setProperty(prefix + "socketKeepAlive", "" + this.socketKeepAlive);
        p.setProperty(prefix + "readPreferenceLevel", "" + this.defaultReadPreference.name());
        p.setProperty(prefix + "mongoLogin", this.mongoLogin);
        p.setProperty(prefix + "mongoPassword", this.mongoPassword);
        p.setProperty(prefix + "configManagerCacheTimeout", "" + this.configManagerCacheTimeout);
        String a = "";
        for (ServerAddress s : this.adr) {
            if (!a.isEmpty()) {
                a = a + ",";
            }
            a = a + s.getHost() + ":" + s.getPort();
        }
        p.setProperty(prefix + "adr", a);
        p.setProperty(prefix + "configManagerClass", this.configManager.getClass().getName());
        p.setProperty(prefix + "superUserLogin", this.superUserLogin);
        p.setProperty(prefix + "superUserPassword", this.superUserPassword);
        p.setProperty(prefix + "adminGroupName", this.adminGroupName);
        p.setProperty(prefix + "fieldImplClass", this.fieldImplClass.getName());
        p.setProperty(prefix + "mapperClass", this.mapper.getClass().getName());
        p.setProperty(prefix + "securityManagerClass", this.securityMgr.getClass().getName());
    }

    public void initFromProperty(Properties p) {
        this.initFromProperty(p, "");
    }

    public void initFromProperty(Properties p, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (!prefix.isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String fieldImplClassStr = p.getProperty(prefix + "fieldImplClass", MongoFieldImpl.class.getName());
        try {
            this.fieldImplClass = Class.forName(fieldImplClassStr);
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        String mapperCls = p.getProperty(prefix + "mapperClass", ObjectMapperImpl.class.getName());
        try {
            this.mapper = (ObjectMapper)Class.forName(mapperCls).newInstance();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String securityMgrCls = p.getProperty(prefix + "securityManagerClass", DefaultSecurityManager.class.getName());
        try {
            this.securityMgr = (MongoSecurityManager)Class.forName(securityMgrCls).newInstance();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.adminGroupName = p.getProperty(prefix + "adminGroupName");
        this.superUserLogin = p.getProperty(prefix + "superUserLogin");
        this.superUserPassword = p.getProperty(prefix + "superUserPassword");
        String configMgrCls = p.getProperty(prefix + "configManagerClass", ConfigManagerImpl.class.getName());
        try {
            this.configManager = (ConfigManager)Class.forName(configMgrCls).newInstance();
        }
        catch (Exception e) {
            System.out.println("could not instanciate Config Manager: ");
            e.printStackTrace();
        }
        String srv = p.getProperty(prefix + "servers", "localhost:27017");
        String[] sp = srv.split(",");
        this.adr = new ArrayList<ServerAddress>();
        for (String s : sp) {
            String[] a = s.split(":");
            try {
                if (a.length == 1) {
                    this.adr.add(new ServerAddress(a[0]));
                    continue;
                }
                int port = Integer.valueOf(a[1]);
            }
            catch (Exception e) {
                System.err.println("Could not add Host: " + s);
                throw new RuntimeException("Could not add host " + s, e);
            }
        }
        if (this.adr.isEmpty()) {
            throw new IllegalArgumentException("No valid host specified!");
        }
        this.timeoutBugWorkAroundEnabled = p.getProperty(prefix + "timeoutBugWorkaroundEnabled", "false").equals("true");
        this.configManagerCacheTimeout = Integer.valueOf(p.getProperty(prefix + "configManagerCacheTimeout", "60000"));
        this.mongoPassword = p.getProperty(prefix + "password");
        this.mongoLogin = p.getProperty(prefix + "login");
        this.defaultReadPreference = ReadPreferenceLevel.valueOf(p.getProperty(prefix + "readPreferenceLevel", "NEAREST"));
        if (this.timeoutBugWorkAroundEnabled) {
            this.defaultReadPreference = ReadPreferenceLevel.PRIMARY;
        }
        this.socketKeepAlive = p.getProperty(prefix + "socketKeepAlive", "true").equalsIgnoreCase("true");
        this.socketTimeout = Integer.valueOf(p.getProperty(prefix + "socketTimeout", "0"));
        this.database = p.getProperty(prefix + "database", "morphium");
        this.connectionTimeout = Integer.valueOf(p.getProperty(prefix + "connectionTimeout", "0"));
        this.writeCacheTimeout = Integer.valueOf(p.getProperty(prefix + "writeCacheTimeout", "5000"));
        this.globalCacheValidTime = Integer.valueOf(p.getProperty(prefix + "globalCacheValidTime", "10000"));
        this.mode = MongoDbMode.valueOf(p.getProperty(prefix + "mode", "SINGLE"));
        this.housekeepingTimeout = Integer.valueOf(p.getProperty(prefix + "housekeepingTimeout", "5000"));
        this.maxConnections = Integer.valueOf(p.getProperty(prefix + "maxConnections", "100"));
    }

    public Class<? extends MorphiumIterator> getIteratorClass() {
        if (this.iteratorClass == null) {
            this.iteratorClass = MorphiumIteratorImpl.class;
        }
        return this.iteratorClass;
    }

    public void setIteratorClass(Class<? extends MorphiumIterator> iteratorClass) {
        this.iteratorClass = iteratorClass;
    }

    public void setFieldImplClass(Class<? extends MongoField> fieldImplClass) {
        this.fieldImplClass = fieldImplClass;
    }
}

