/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import com.mongodb.BasicDBList;
import com.mongodb.DBRef;
import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.MongoType;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class MongoFieldImpl<T>
implements MongoField<T> {
    private Query<T> query;
    private ObjectMapper mapper;
    private String fldStr;
    private FilterExpression fe;

    public MongoFieldImpl() {
    }

    public MongoFieldImpl(Query<T> q, ObjectMapper map) {
        this.query = q;
        this.mapper = map;
    }

    @Override
    public String getFieldString() {
        return this.fldStr;
    }

    @Override
    public void setFieldString(String fldStr) {
        this.fe = new FilterExpression();
        this.fe.setField(fldStr);
        this.fldStr = fldStr;
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Query<T> eq(Object val) {
        if (val != null) {
            Field field;
            Class<?> cls = val.getClass();
            if ((this.mapper.getMorphium().isAnnotationPresentInHierarchy(cls, Entity.class) || val instanceof ObjectId) && (field = this.mapper.getField(this.query.getType(), this.fldStr)).isAnnotationPresent(Reference.class)) {
                ObjectId id = null;
                id = val instanceof ObjectId ? (ObjectId)val : this.mapper.getId(val);
                val = field.getType().isAssignableFrom(List.class) ? new DBRef(null, val.getClass().getName(), (Object)id) : id;
            }
        }
        this.fe.setValue(val);
        this.fe.setField(this.mapper.getFieldName(this.query.getType(), this.fldStr));
        this.query.addChild(this.fe);
        return this.query;
    }

    private void add(String op, Object value) {
        this.fe.setField(this.mapper.getFieldName(this.query.getType(), this.fldStr));
        FilterExpression child = new FilterExpression();
        child.setField(op);
        child.setValue(value);
        this.fe.addChild(child);
        this.query.addChild(this.fe);
    }

    private void add(List<FilterExpression> expressionList) {
        this.fe.setField(this.mapper.getFieldName(this.query.getType(), this.fldStr));
        this.fe.setChildren(expressionList);
        this.query.addChild(this.fe);
    }

    @Override
    public Query<T> ne(Object val) {
        this.add("$ne", val);
        return this.query;
    }

    @Override
    public Query<T> lt(Object val) {
        this.add("$lt", val);
        return this.query;
    }

    @Override
    public Query<T> lte(Object val) {
        this.add("$lte", val);
        return this.query;
    }

    @Override
    public Query<T> gt(Object val) {
        this.add("$gt", val);
        return this.query;
    }

    @Override
    public Query<T> gte(Object val) {
        this.add("$gte", val);
        return this.query;
    }

    @Override
    public Query<T> exists() {
        this.add("$exists", true);
        return this.query;
    }

    @Override
    public Query<T> notExists() {
        this.add("$exists", false);
        return this.query;
    }

    @Override
    public Query<T> mod(int base, int val) {
        BasicDBList lst = new BasicDBList();
        lst.add((Object)base);
        lst.add((Object)val);
        this.add("$mod", lst);
        return this.query;
    }

    @Override
    public Query<T> matches(Pattern p) {
        this.add("$regex", p.toString());
        return this.query;
    }

    @Override
    public Query<T> matches(String ptrn) {
        return this.matches(Pattern.compile(ptrn));
    }

    @Override
    public Query<T> type(MongoType t) {
        this.add("$type", t.getNumber());
        return this.query;
    }

    @Override
    public Query<T> in(Collection<?> vals) {
        BasicDBList lst = new BasicDBList();
        lst.addAll(vals);
        this.add("$in", lst);
        return this.query;
    }

    @Override
    public Query<T> nin(Collection<?> vals) {
        BasicDBList lst = new BasicDBList();
        lst.addAll(vals);
        this.add("$nin", lst);
        return this.query;
    }

    @Override
    public Query<T> near(double x, double y) {
        BasicDBList lst = new BasicDBList();
        lst.add((Object)x);
        lst.add((Object)y);
        this.add("$near", lst);
        return this.query;
    }

    @Override
    public Query<T> near(double x, double y, double maxDistance) {
        BasicDBList location = new BasicDBList();
        location.add((Object)x);
        location.add((Object)y);
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$near");
        nearExpression.setValue(location);
        expressionList.add(nearExpression);
        FilterExpression maxDistanceExpression = new FilterExpression();
        maxDistanceExpression.setField("$maxDistance");
        maxDistanceExpression.setValue(maxDistance);
        expressionList.add(maxDistanceExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(Query<T> q) {
        this.query = q;
    }
}

