/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.Writer;
import de.caluga.morphium.annotations.CreatedBy;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.LastChangeBy;
import de.caluga.morphium.annotations.PartialUpdate;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class WriterImpl
implements Writer {
    private static Logger logger = Logger.getLogger(WriterImpl.class);
    private Morphium morphium;

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
    }

    @Override
    public void store(Object o) {
        Cache ch;
        WriteConcern wc;
        Field f;
        Field f2;
        List<String> lst;
        if (o instanceof List) {
            this.store((List)o);
        }
        long start = System.currentTimeMillis();
        Class<?> type = this.morphium.getRealClass(o.getClass());
        if (!this.morphium.isAnnotationPresentInHierarchy(type, Entity.class)) {
            throw new RuntimeException("Not an entity: " + type.getSimpleName() + " Storing not possible!");
        }
        this.morphium.inc(StatisticKeys.WRITES);
        ObjectId id = this.morphium.getMapper().getId(o);
        if (this.morphium.isAnnotationPresentInHierarchy(type, PartialUpdate.class) && o instanceof PartiallyUpdateable) {
            this.morphium.updateUsingFields(o, ((PartiallyUpdateable)o).getAlteredFields().toArray(new String[((PartiallyUpdateable)o).getAlteredFields().size()]));
            ((PartiallyUpdateable)o).clearAlteredFields();
            return;
        }
        if ((o = this.morphium.getRealObject(o)) == null) {
            logger.warn((Object)"Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
            return;
        }
        boolean isNew = id == null;
        this.morphium.firePreStoreEvent(o, isNew);
        long dur = System.currentTimeMillis() - start;
        DBObject marshall = this.morphium.getMapper().marshall(o);
        if (isNew && this.morphium.isAnnotationPresentInHierarchy(type, CreationTime.class)) {
            lst = this.morphium.getMapper().getFields(type, CreationTime.class);
            if (lst == null || lst.size() == 0) {
                logger.error((Object)"Unable to store creation time as @CreationTime is missing");
            } else {
                long now = System.currentTimeMillis();
                for (String ctf : lst) {
                    f2 = this.morphium.getField(type, ctf);
                    if (f2 != null) {
                        try {
                            f2.set(o, now);
                        }
                        catch (IllegalAccessException e) {
                            logger.error((Object)"Could not set creation time", (Throwable)e);
                        }
                    }
                    marshall.put(ctf, (Object)now);
                }
            }
            lst = this.morphium.getMapper().getFields(type, CreatedBy.class);
            if (lst != null && lst.size() > 0) {
                for (String ctf : lst) {
                    f = this.morphium.getField(type, ctf);
                    if (f != null) {
                        try {
                            f.set(o, this.morphium.getSecurityManager().getCurrentUserId());
                        }
                        catch (IllegalAccessException e) {
                            logger.error((Object)"Could not set created by", (Throwable)e);
                        }
                    }
                    marshall.put(ctf, this.morphium.getSecurityManager().getCurrentUserId());
                }
            }
        }
        if (this.morphium.isAnnotationPresentInHierarchy(type, LastChange.class)) {
            lst = this.morphium.getMapper().getFields(type, LastChange.class);
            if (lst != null && lst.size() > 0) {
                for (String ctf : lst) {
                    long now = System.currentTimeMillis();
                    f2 = this.morphium.getField(type, ctf);
                    if (f2 != null) {
                        try {
                            f2.set(o, now);
                        }
                        catch (IllegalAccessException e) {
                            logger.error((Object)"Could not set modification time", (Throwable)e);
                        }
                    }
                    marshall.put(ctf, (Object)now);
                }
            } else {
                logger.warn((Object)"Could not store last change - @LastChange missing!");
            }
            lst = this.morphium.getMapper().getFields(type, LastChangeBy.class);
            if (lst != null && lst.size() > 0) {
                for (String ctf : lst) {
                    f = this.morphium.getField(type, ctf);
                    if (f != null) {
                        try {
                            f.set(o, this.morphium.getSecurityManager().getCurrentUserId());
                        }
                        catch (IllegalAccessException e) {
                            logger.error((Object)"Could not set changed by", (Throwable)e);
                        }
                    }
                    marshall.put(ctf, this.morphium.getSecurityManager().getCurrentUserId());
                }
            }
        }
        String coll = this.morphium.getMapper().getCollectionName(type);
        if (!this.morphium.getDatabase().collectionExists(coll)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Collection does not exist - ensuring indices");
            }
            this.morphium.ensureIndicesFor(type);
        }
        if ((wc = this.morphium.getWriteConcernForClass(type)) != null) {
            this.morphium.getDatabase().getCollection(coll).save(marshall, wc);
        } else {
            this.morphium.getDatabase().getCollection(coll).save(marshall);
        }
        dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(o.getClass(), marshall, dur, true, WriteAccessType.SINGLE_INSERT);
        if (logger.isDebugEnabled()) {
            String n = "";
            if (isNew) {
                n = "NEW ";
            }
            logger.debug((Object)(n + "stored " + type.getSimpleName() + " after " + dur + " ms length:" + marshall.toString().length()));
        }
        if (isNew) {
            List<String> flds = this.morphium.getMapper().getFields(o.getClass(), Id.class);
            if (flds == null) {
                throw new RuntimeException("Object does not have an ID field!");
            }
            try {
                this.morphium.getField(o.getClass(), flds.get(0)).set(o, marshall.get("_id"));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if ((ch = this.morphium.getAnnotationFromHierarchy(o.getClass(), Cache.class)) != null && ch.clearOnWrite()) {
            this.morphium.clearCachefor(o.getClass());
        }
        this.morphium.firePostStoreEvent(o, isNew);
    }

    @Override
    public void store(List lst) {
        if (!lst.isEmpty()) {
            HashMap sorted = new HashMap();
            HashMap isNew = new HashMap();
            for (Object e : lst) {
                Class<?> type = this.morphium.getRealClass(e.getClass());
                if (!this.morphium.isAnnotationPresentInHierarchy(type, Entity.class)) {
                    logger.error((Object)"Not an entity! Storing not possible! Even not in list!");
                    continue;
                }
                this.morphium.inc(StatisticKeys.WRITES);
                ObjectId id = this.morphium.getMapper().getId(e);
                if (this.morphium.isAnnotationPresentInHierarchy(type, PartialUpdate.class) && e instanceof PartiallyUpdateable) {
                    this.morphium.updateUsingFields(e, ((PartiallyUpdateable)e).getAlteredFields().toArray(new String[((PartiallyUpdateable)e).getAlteredFields().size()]));
                    ((PartiallyUpdateable)e).clearAlteredFields();
                    continue;
                }
                Object e2 = this.morphium.getRealObject(e);
                if (e2 == null) {
                    logger.warn((Object)"Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                    return;
                }
                if (sorted.get(e2.getClass()) == null) {
                    sorted.put(e2.getClass(), new ArrayList());
                }
                ((List)sorted.get(e2.getClass())).add(e2);
                if (this.morphium.getId(e2) == null) {
                    isNew.put(e2, true);
                } else {
                    isNew.put(e2, false);
                }
                this.morphium.firePreStoreEvent(e2, (Boolean)isNew.get(e2));
            }
            for (Map.Entry entry : sorted.entrySet()) {
                Class c = (Class)entry.getKey();
                ArrayList<DBObject> dbLst = new ArrayList<DBObject>();
                WriteConcern wc = this.morphium.getWriteConcernForClass(c);
                String coll = this.morphium.getMapper().getCollectionName(c);
                DBCollection collection = this.morphium.getDatabase().getCollection(coll);
                if (!this.morphium.getDatabase().collectionExists(coll)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Collection does not exist - ensuring indices");
                    }
                    this.morphium.ensureIndicesFor(c);
                }
                for (Object record : (List)entry.getValue()) {
                    DBObject marshall = this.morphium.getMapper().marshall(record);
                    if (((Boolean)isNew.get(record)).booleanValue()) {
                        dbLst.add(marshall);
                        continue;
                    }
                    long start = System.currentTimeMillis();
                    if (wc == null) {
                        collection.save(marshall);
                    } else {
                        collection.save(marshall, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    this.morphium.fireProfilingWriteEvent(c, marshall, dur, false, WriteAccessType.SINGLE_INSERT);
                    this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
                }
                long start = System.currentTimeMillis();
                if (wc == null) {
                    collection.insert(dbLst);
                } else {
                    collection.insert(dbLst, wc);
                }
                long dur = System.currentTimeMillis() - start;
                this.morphium.fireProfilingWriteEvent(c, dbLst, dur, true, WriteAccessType.BULK_INSERT);
                for (Object record : (List)entry.getValue()) {
                    if (!((Boolean)isNew.get(record)).booleanValue()) continue;
                    this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
                }
            }
        }
    }

    @Override
    public void set(Object toSet, String field, Object value) {
        Class<?> cls = toSet.getClass();
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
        value = this.marshallIfNecessary(value);
        String coll = this.morphium.getMapper().getCollectionName(cls);
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)this.morphium.getId(toSet));
        Field f = this.morphium.getField(cls, field);
        if (f == null) {
            throw new RuntimeException("Unknown field: " + field);
        }
        String fieldName = this.morphium.getFieldName(cls, field);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject(fieldName, value));
        WriteConcern wc = this.morphium.getWriteConcernForClass(toSet.getClass());
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
        } else {
            this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, false, WriteAccessType.SINGLE_UPDATE);
        this.morphium.clearCacheIfNecessary(cls);
        try {
            f.set(toSet, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.morphium.firePostUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
    }

    @Override
    public void storeUsingFields(Object ent, String ... fields) {
        ObjectId id = this.morphium.getId(ent);
        if (ent == null) {
            return;
        }
        if (id == null) {
            logger.warn((Object)"trying to partially update new object - storing it in full!");
            this.store(ent);
            return;
        }
        this.morphium.firePreStoreEvent(ent, false);
        this.morphium.inc(StatisticKeys.WRITES);
        BasicDBObject find = new BasicDBObject();
        find.put("_id", (Object)id);
        BasicDBObject update = new BasicDBObject();
        for (String f : fields) {
            try {
                Object value = this.morphium.getValue(ent, f);
                if (this.morphium.isAnnotationPresentInHierarchy(value.getClass(), Entity.class)) {
                    value = this.morphium.getMapper().marshall(value);
                }
                update.put(f, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> type = this.morphium.getRealClass(ent.getClass());
        LastChange t = this.morphium.getAnnotationFromHierarchy(type, LastChange.class);
        if (t != null) {
            Field f;
            List<String> lst = this.morphium.getMapper().getFields(ent.getClass(), LastChange.class);
            long now = System.currentTimeMillis();
            for (String ctf : lst) {
                f = this.morphium.getField(type, ctf);
                if (f != null) {
                    try {
                        f.set(ent, now);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)"Could not set modification time", (Throwable)e);
                    }
                }
                update.put(ctf, (Object)now);
            }
            lst = this.morphium.getMapper().getFields(ent.getClass(), LastChangeBy.class);
            if (lst != null && lst.size() != 0) {
                for (String ctf : lst) {
                    f = this.morphium.getField(type, ctf);
                    if (f != null) {
                        try {
                            f.set(ent, this.morphium.getSecurityManager().getCurrentUserId());
                        }
                        catch (IllegalAccessException e) {
                            logger.error((Object)"Could not set changed by", (Throwable)e);
                        }
                    }
                    update.put(ctf, this.morphium.getSecurityManager().getCurrentUserId());
                }
            }
        }
        update = new BasicDBObject("$set", (Object)update);
        WriteConcern wc = this.morphium.getWriteConcernForClass(type);
        long start = System.currentTimeMillis();
        if (wc != null) {
            this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(ent.getClass())).update((DBObject)find, (DBObject)update, false, false, wc);
        } else {
            this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(ent.getClass())).update((DBObject)find, (DBObject)update, false, false);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(ent.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
        this.morphium.clearCacheIfNecessary(this.morphium.getRealClass(ent.getClass()));
        this.morphium.firePostStoreEvent(ent, false);
    }

    @Override
    public void delete(List lst) {
        for (Object o : lst) {
            this.delete(o);
        }
    }

    @Override
    public void delete(Query q) {
        this.morphium.firePreRemoveEvent(q);
        WriteConcern wc = this.morphium.getWriteConcernForClass(q.getType());
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(q.getType())).remove(q.toQueryObject());
        } else {
            this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(q.getType())).remove(q.toQueryObject(), wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(q.getType(), q.toQueryObject(), dur, false, WriteAccessType.BULK_DELETE);
        this.morphium.clearCacheIfNecessary(q.getType());
        this.morphium.firePostRemoveEvent(q);
    }

    @Override
    public void delete(Object o) {
        if (o instanceof List) {
            this.delete((List)o);
            return;
        }
        if (o instanceof Query) {
            this.delete((Query)o);
            return;
        }
        ObjectId id = this.morphium.getMapper().getId(o);
        BasicDBObject db = new BasicDBObject();
        db.append("_id", (Object)id);
        WriteConcern wc = this.morphium.getWriteConcernForClass(o.getClass());
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(o.getClass())).remove((DBObject)db);
        } else {
            this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(o.getClass())).remove((DBObject)db, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(o.getClass(), o, dur, false, WriteAccessType.SINGLE_DELETE);
        this.morphium.clearCachefor(o.getClass());
        this.morphium.inc(StatisticKeys.WRITES);
        this.morphium.firePostRemoveEvent(o);
    }

    @Override
    public void inc(Object toInc, String field, int amount) {
        Class<?> cls = toInc.getClass();
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
        String coll = this.morphium.getMapper().getCollectionName(cls);
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)this.morphium.getId(toInc));
        Field f = this.morphium.getField(cls, field);
        if (f == null) {
            throw new RuntimeException("Unknown field: " + field);
        }
        String fieldName = this.morphium.getFieldName(cls, field);
        BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject(fieldName, (Object)amount));
        WriteConcern wc = this.morphium.getWriteConcernForClass(toInc.getClass());
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
        } else {
            this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
        }
        this.morphium.clearCacheIfNecessary(cls);
        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
            try {
                f.set(toInc, (Integer)f.get(toInc) + amount);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
            try {
                f.set(toInc, (Double)f.get(toInc) + (double)amount);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
            try {
                f.set(toInc, Float.valueOf(((Float)f.get(toInc)).floatValue() + (float)amount));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
            try {
                f.set(toInc, (Long)f.get(toInc) + (long)amount);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            logger.error((Object)("Could not set increased value - unsupported type " + cls.getName()));
        }
        this.morphium.firePostUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
    }

    @Override
    public void inc(Query<?> query, String field, int amount, boolean insertIfNotExist, boolean multiple) {
        Class<?> cls = query.getType();
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
        String coll = this.morphium.getMapper().getCollectionName(cls);
        String fieldName = this.morphium.getFieldName(cls, field);
        BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject(fieldName, (Object)amount));
        DBObject qobj = query.toQueryObject();
        if (insertIfNotExist) {
            qobj = this.morphium.simplifyQueryObject(qobj);
        }
        if (insertIfNotExist && !this.morphium.getDatabase().collectionExists(coll)) {
            this.morphium.ensureIndicesFor(cls);
        }
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
        } else {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
        this.morphium.clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
    }

    @Override
    public void set(Query<?> query, Map<String, Object> values, boolean insertIfNotExist, boolean multiple) {
        Class<?> cls = query.getType();
        String coll = this.morphium.getMapper().getCollectionName(cls);
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
        BasicDBObject toSet = new BasicDBObject();
        for (Map.Entry<String, Object> ef : values.entrySet()) {
            String fieldName = this.morphium.getFieldName(cls, ef.getKey());
            toSet.put(fieldName, this.marshallIfNecessary(ef.getValue()));
        }
        DBObject qobj = query.toQueryObject();
        if (insertIfNotExist) {
            qobj = this.morphium.simplifyQueryObject(qobj);
        }
        if (insertIfNotExist && !this.morphium.getDatabase().collectionExists(coll)) {
            this.morphium.ensureIndicesFor(cls);
        }
        BasicDBObject update = new BasicDBObject("$set", (Object)toSet);
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
        } else {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
        this.morphium.clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
    }

    @Override
    public void unset(Object toSet, String field) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.morphium.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
        }
        Class<?> cls = toSet.getClass();
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
        String coll = this.morphium.getMapper().getCollectionName(cls);
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)this.morphium.getId(toSet));
        Field f = this.morphium.getField(cls, field);
        if (f == null) {
            throw new RuntimeException("Unknown field: " + field);
        }
        String fieldName = this.morphium.getFieldName(cls, field);
        BasicDBObject update = new BasicDBObject("$unset", (Object)new BasicDBObject(fieldName, (Object)1));
        WriteConcern wc = this.morphium.getWriteConcernForClass(toSet.getClass());
        if (!this.morphium.getDatabase().collectionExists(coll)) {
            this.morphium.ensureIndicesFor(cls);
        }
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
        } else {
            this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(toSet.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
        this.morphium.clearCacheIfNecessary(cls);
        try {
            f.set(toSet, null);
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        this.morphium.firePostUpdateEvent(this.morphium.getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
    }

    @Override
    public void pushPull(boolean push, Query<?> query, String field, Object value, boolean insertIfNotExist, boolean multiple) {
        Class<?> cls = query.getType();
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
        String coll = this.morphium.getMapper().getCollectionName(cls);
        DBObject qobj = query.toQueryObject();
        if (insertIfNotExist) {
            qobj = this.morphium.simplifyQueryObject(qobj);
        }
        value = this.marshallIfNecessary(value);
        field = this.morphium.getMapper().getFieldName(cls, field);
        BasicDBObject set = new BasicDBObject(field, value);
        BasicDBObject update = new BasicDBObject(push ? "$push" : "$pull", (Object)set);
        this.pushIt(push, insertIfNotExist, multiple, cls, coll, qobj, update);
    }

    private Object marshallIfNecessary(Object value) {
        if (value != null) {
            if (this.morphium.isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.morphium.isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
                DBObject marshall = this.morphium.getMapper().marshall(value);
                marshall.put("class_name", (Object)this.morphium.getRealClass(value.getClass()).getName());
                value = marshall;
            } else if (List.class.isAssignableFrom(value.getClass())) {
                ArrayList<Object> lst = new ArrayList<Object>();
                for (Object o : (List)value) {
                    if (this.morphium.isAnnotationPresentInHierarchy(o.getClass(), Embedded.class) || this.morphium.isAnnotationPresentInHierarchy(o.getClass(), Entity.class)) {
                        DBObject marshall = this.morphium.getMapper().marshall(o);
                        marshall.put("class_name", (Object)this.morphium.getRealClass(o.getClass()).getName());
                        lst.add(marshall);
                        continue;
                    }
                    lst.add(o);
                }
                value = lst;
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                Iterator i$ = ((Map)((Object)value)).entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry e;
                    Map.Entry en = e = i$.next();
                    if (!String.class.isAssignableFrom(e.getKey().getClass())) {
                        throw new IllegalArgumentException("Can't push maps with Key not of type String!");
                    }
                    if (!this.morphium.isAnnotationPresentInHierarchy(en.getValue().getClass(), Entity.class) && !this.morphium.isAnnotationPresentInHierarchy(en.getValue().getClass(), Embedded.class)) continue;
                    DBObject marshall = this.morphium.getMapper().marshall(en.getValue());
                    marshall.put("class_name", (Object)this.morphium.getRealClass(en.getValue().getClass()).getName());
                    ((Map)((Object)value)).put(en.getKey(), marshall);
                }
            }
        }
        return value;
    }

    private void pushIt(boolean push, boolean insertIfNotExist, boolean multiple, Class<?> cls, String coll, DBObject qobj, BasicDBObject update) {
        if (!this.morphium.getDatabase().collectionExists(coll) && insertIfNotExist) {
            this.morphium.ensureIndicesFor(cls);
        }
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
        } else {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
        this.morphium.clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.morphium.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
    }

    @Override
    public void pushPullAll(boolean push, Query<?> query, String field, List<?> value, boolean insertIfNotExist, boolean multiple) {
        Class<?> cls = query.getType();
        String coll = this.morphium.getMapper().getCollectionName(cls);
        this.morphium.firePreUpdateEvent(this.morphium.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
        ArrayList lst = new ArrayList();
        for (Object o : value) {
            lst.add(this.marshallIfNecessary(o));
        }
        value = lst;
        BasicDBList dbl = new BasicDBList();
        dbl.addAll(value);
        DBObject qobj = query.toQueryObject();
        if (insertIfNotExist) {
            qobj = this.morphium.simplifyQueryObject(qobj);
        }
        field = this.morphium.getMapper().getFieldName(cls, field);
        BasicDBObject set = new BasicDBObject(field, value);
        BasicDBObject update = new BasicDBObject(push ? "$pushAll" : "$pullAll", (Object)set);
        this.pushIt(push, insertIfNotExist, multiple, cls, coll, qobj, update);
    }
}

