/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import de.caluga.morphium.ConfigManager;
import de.caluga.morphium.ConfigManagerImpl;
import de.caluga.morphium.LazyDeReferencingProxy;
import de.caluga.morphium.MongoDbMode;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumSingleton;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.PartiallyUpdateableProxy;
import de.caluga.morphium.ProfilingListener;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.StatisticValue;
import de.caluga.morphium.Statistics;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.WriterImpl;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.annotations.CreatedBy;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.LastAccessBy;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.LastChangeBy;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.annotations.lifecycle.PostLoad;
import de.caluga.morphium.annotations.lifecycle.PostRemove;
import de.caluga.morphium.annotations.lifecycle.PostStore;
import de.caluga.morphium.annotations.lifecycle.PreRemove;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.annotations.security.NoProtection;
import de.caluga.morphium.cache.CacheElement;
import de.caluga.morphium.cache.CacheHousekeeper;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import de.caluga.morphium.secure.MongoSecurityException;
import de.caluga.morphium.secure.MongoSecurityManager;
import de.caluga.morphium.secure.Permission;
import de.caluga.morphium.validation.JavaxValidationStorageListener;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.cglib.proxy.Enhancer;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public final class Morphium {
    private static final Logger logger = Logger.getLogger(Morphium.class);
    private MorphiumConfig config;
    private Mongo mongo;
    private DB database;
    private ThreadPoolExecutor writers = new ThreadPoolExecutor(10, 50, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private Hashtable<Class<?>, Hashtable<String, CacheElement>> cache;
    private Hashtable<Class<?>, Hashtable<ObjectId, Object>> idCache;
    private final Map<StatisticKeys, StatisticValue> stats;
    private Map<Class<?>, Map<Class<? extends Annotation>, Method>> lifeCycleMethods;
    private String currentUser;
    private CacheHousekeeper cacheHousekeeper;
    private List<MorphiumStorageListener> listeners;
    private Vector<ProfilingListener> profilingListeners;
    private Vector<Thread> privileged;
    private Vector<ShutdownListener> shutDownListeners;

    public MorphiumConfig getConfig() {
        return this.config;
    }

    public Morphium(MorphiumConfig cfg) {
        if (cfg == null) {
            throw new RuntimeException("Please specify configuration!");
        }
        this.config = cfg;
        this.privileged = new Vector();
        this.shutDownListeners = new Vector();
        this.listeners = new ArrayList<MorphiumStorageListener>();
        this.profilingListeners = new Vector();
        this.cache = new Hashtable();
        this.idCache = new Hashtable();
        this.stats = new Hashtable<StatisticKeys, StatisticValue>();
        this.lifeCycleMethods = new Hashtable();
        for (StatisticKeys k : StatisticKeys.values()) {
            this.stats.put(k, new StatisticValue());
        }
        MongoOptions o = new MongoOptions();
        o.autoConnectRetry = true;
        o.fsync = true;
        o.socketTimeout = this.config.getSocketTimeout();
        o.connectTimeout = this.config.getConnectionTimeout();
        o.connectionsPerHost = this.config.getMaxConnections();
        o.socketKeepAlive = this.config.isSocketKeepAlive();
        o.threadsAllowedToBlockForConnectionMultiplier = 5;
        o.safe = false;
        this.writers.setCorePoolSize(this.config.getMaxConnections() / 2);
        this.writers.setMaximumPoolSize(this.config.getMaxConnections());
        if (this.config.getAdr().isEmpty()) {
            throw new RuntimeException("Error - no server address specified!");
        }
        switch (this.config.getMode()) {
            case REPLICASET: {
                if (this.config.getAdr().size() < 2) {
                    throw new RuntimeException("at least 2 Server Adresses needed for MongoDB in ReplicaSet Mode!");
                }
                this.mongo = new Mongo(this.config.getAdr(), o);
                break;
            }
            case PAIRED: {
                throw new RuntimeException("PAIRED Mode not available anymore!!!!");
            }
            default: {
                if (this.config.getAdr().size() > 1) {
                    // empty if block
                }
                this.mongo = new Mongo(this.config.getAdr().get(0), o);
            }
        }
        this.database = this.mongo.getDB(this.config.getDatabase());
        if (this.config.isTimeoutBugWorkAroundEnabled()) {
            this.mongo.setReadPreference(ReadPreference.primary());
        } else if (this.config.getDefaultReadPreference() != null) {
            this.mongo.setReadPreference(this.config.getDefaultReadPreference().getPref());
        }
        if (this.config.getMongoLogin() != null && !this.database.authenticate(this.config.getMongoLogin(), this.config.getMongoPassword().toCharArray())) {
            throw new RuntimeException("Authentication failed!");
        }
        if (this.config.getConfigManager() == null) {
            this.config.setConfigManager(new ConfigManagerImpl());
        }
        this.config.getConfigManager().setMorphium(this);
        this.cacheHousekeeper = new CacheHousekeeper(this, 5000, this.config.getGlobalCacheValidTime());
        this.cacheHousekeeper.start();
        this.config.getConfigManager().startCleanupThread();
        if (this.config.getMapper() == null) {
            this.config.setMapper(new ObjectMapperImpl(this));
        } else {
            this.config.getMapper().setMorphium(this);
        }
        if (this.config.getWriter() == null) {
            this.config.setWriter(new WriterImpl());
        }
        this.config.getWriter().setMorphium(this);
        if (this.hasValidationSupport()) {
            logger.info((Object)"Adding javax.validation Support...");
            this.addListener(new JavaxValidationStorageListener());
        }
        logger.info((Object)"Initialization successful...");
    }

    private boolean hasValidationSupport() {
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass("javax.validation.ValidatorFactory");
        }
        catch (ClassNotFoundException cnf) {
            return false;
        }
        return true;
    }

    public void addListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>();
        newList.addAll(this.listeners);
        newList.add(lst);
        this.listeners = newList;
    }

    public void removeListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>();
        newList.addAll(this.listeners);
        newList.remove(lst);
        this.listeners = newList;
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public DB getDatabase() {
        return this.database;
    }

    public ConfigManager getConfigManager() {
        return this.config.getConfigManager();
    }

    public <T> List<T> findByTemplate(T template, String ... fields) {
        Class<?> cls = template.getClass();
        List<Object> flds = new ArrayList<String>();
        if (fields.length > 0) {
            flds.addAll(Arrays.asList(fields));
        } else {
            flds = this.getFields(cls);
        }
        Query<?> q = this.createQueryFor(cls);
        for (String string : flds) {
            try {
                q.f(string).eq(this.getValue(template, string));
            }
            catch (Exception e) {
                logger.error((Object)("Could not read field " + string + " of object " + cls.getName()));
            }
        }
        return q.asList();
    }

    public void unset(Object toSet, Enum field) {
        this.unset(toSet, field.name());
    }

    public void unset(final Object toSet, final String field) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (!this.isAnnotationPresentInHierarchy(toSet.getClass(), NoProtection.class) && this.accessDenied(toSet.getClass(), Permission.UPDATE)) {
            throw new SecurityException("Update of Object denied!");
        }
        this.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.UNSET);
        Cache c = this.getAnnotationFromHierarchy(toSet.getClass(), Cache.class);
        if (this.isAnnotationPresentInHierarchy(toSet.getClass(), NoCache.class) || c == null || !c.writeCache()) {
            this.config.getWriter().unset(toSet, field);
            this.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.UNSET);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().unset(toSet, field);
                Morphium.this.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.UNSET);
            }
        });
    }

    public void ensureIndicesFor(Class type) {
        if (this.isAnnotationPresentInHierarchy(type, Index.class)) {
            List<Annotation> lst = this.getAllAnnotationsFromHierachy(type, Index.class);
            for (Annotation a : lst) {
                Index i = (Index)a;
                if (i.value().length <= 0) continue;
                for (String idx : i.value()) {
                    String[] idxStr = idx.replaceAll(" +", "").split(",");
                    this.ensureIndex(type, idxStr);
                }
            }
            List<String> flds = this.config.getMapper().getFields(type, Index.class);
            if (flds != null && flds.size() > 0) {
                for (String f : flds) {
                    Index i = this.config.getMapper().getField(type, f).getAnnotation(Index.class);
                    if (i.decrement()) {
                        this.ensureIndex(type, "-" + f);
                        continue;
                    }
                    this.ensureIndex(type, f);
                }
            }
        }
    }

    public void clearCacheIfNecessary(Class cls) {
        Cache c = this.getAnnotationFromHierarchy(cls, Cache.class);
        if (c != null && c.clearOnWrite()) {
            this.clearCachefor(cls);
        }
    }

    public DBObject simplifyQueryObject(DBObject q) {
        if (q.keySet().size() == 1 && q.get("$and") != null) {
            BasicDBObject ret = new BasicDBObject();
            BasicDBList lst = (BasicDBList)q.get("$and");
            for (Object o : lst) {
                if (o instanceof DBObject) {
                    ret.putAll((BSONObject)((DBObject)o));
                    continue;
                }
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                return q;
            }
            return ret;
        }
        return q;
    }

    public void set(Query<?> query, Enum field, Object val) {
        this.set(query, field.name(), val);
    }

    public void set(Query<?> query, String field, Object val) {
        this.set(query, field, val, false, false);
    }

    public void setEnum(Query<?> query, Map<Enum, Object> values, boolean insertIfNotExist, boolean multiple) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> est : values.entrySet()) {
            toSet.put(est.getKey().name(), values.get(est.getValue()));
        }
        this.set(query, toSet, insertIfNotExist, multiple);
    }

    public void push(Query<?> query, Enum field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, Enum field, Object value) {
        this.pull(query, field.name(), value, false, true);
    }

    public void push(Query<?> query, String field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, String field, Object value) {
        this.pull(query, field, value, false, true);
    }

    public void push(Query<?> query, Enum field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pull(Query<?> query, Enum field, Object value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pushAll(Query<?> query, Enum field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.push(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void pullAll(Query<?> query, Enum field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field.name(), value, insertIfNotExist, multiple);
    }

    public void push(final Query<?> query, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.accessDenied(query.getType(), Permission.UPDATE)) {
            throw new SecurityException("Update of Object denied!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
        if (!this.isWriteCached(query.getType())) {
            this.config.getWriter().pushPull(true, query, field, value, insertIfNotExist, multiple);
            this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().pushPull(true, query, field, value, insertIfNotExist, multiple);
                Morphium.this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            }
        });
    }

    public void pull(final Query<?> query, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.accessDenied(query.getType(), Permission.UPDATE)) {
            throw new SecurityException("Update of Object denied!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PULL);
        if (!this.isWriteCached(query.getType())) {
            this.config.getWriter().pushPull(false, query, field, value, insertIfNotExist, multiple);
            this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PULL);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().pushPull(false, query, field, value, insertIfNotExist, multiple);
                Morphium.this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PULL);
            }
        });
    }

    public void pushAll(final Query<?> query, final String field, final List<?> value, final boolean insertIfNotExist, final boolean multiple) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.accessDenied(query.getType(), Permission.UPDATE)) {
            throw new SecurityException("Update of Object denied!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
        if (!this.isWriteCached(query.getType())) {
            this.config.getWriter().pushPullAll(true, query, field, value, insertIfNotExist, multiple);
            this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().pushPullAll(true, query, field, value, insertIfNotExist, multiple);
                Morphium.this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            }
        });
    }

    public void pullAll(Query<?> query, String field, List<Object> value, boolean insertIfNotExist, boolean multiple) {
        this.pull(query, field, value, insertIfNotExist, multiple);
    }

    public void set(Query<?> query, String field, Object val, boolean insertIfNotExist, boolean multiple) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(field, val);
        this.set(query, map, insertIfNotExist, multiple);
    }

    public void set(final Query<?> query, final Map<String, Object> map, final boolean insertIfNotExist, final boolean multiple) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.accessDenied(query.getType(), Permission.UPDATE)) {
            throw new SecurityException("Update of Object denied!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
        Cache c = this.getAnnotationFromHierarchy(query.getType(), Cache.class);
        if (this.isAnnotationPresentInHierarchy(query.getType(), NoCache.class) || c == null || !c.writeCache()) {
            this.config.getWriter().set(query, map, insertIfNotExist, multiple);
            this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().set(query, map, insertIfNotExist, multiple);
                Morphium.this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
            }
        });
    }

    public void dec(Query<?> query, Enum field, int amount, boolean insertIfNotExist, boolean multiple) {
        this.dec(query, field.name(), amount, insertIfNotExist, multiple);
    }

    public void dec(Query<?> query, String field, int amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, field, -amount, insertIfNotExist, multiple);
    }

    public void dec(Query<?> query, String field, int amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, Enum field, int amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void inc(Query<?> query, String field, int amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, int amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, int amount, boolean insertIfNotExist, boolean multiple) {
        this.inc(query, field.name(), amount, insertIfNotExist, multiple);
    }

    public void inc(final Query<?> query, final String name, final int amount, final boolean insertIfNotExist, final boolean multiple) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (!this.isAnnotationPresentInHierarchy(query.getType(), NoProtection.class) && this.accessDenied(query.getType(), Permission.UPDATE)) {
            throw new SecurityException("Update of Object denied!");
        }
        this.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
        Cache c = this.getAnnotationFromHierarchy(query.getType(), Cache.class);
        if (this.isAnnotationPresentInHierarchy(query.getType(), NoCache.class) || c == null || !c.writeCache()) {
            this.config.getWriter().inc(query, name, amount, insertIfNotExist, multiple);
            this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().inc(query, name, amount, insertIfNotExist, multiple);
                Morphium.this.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
            }
        });
    }

    public void set(Object toSet, Enum field, Object value) {
        this.set(toSet, field.name(), value);
    }

    public void set(final Object toSet, final String field, final Object value) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (!this.isAnnotationPresentInHierarchy(toSet.getClass(), NoProtection.class)) {
            if (this.getId(toSet) == null) {
                if (this.accessDenied(toSet, Permission.INSERT)) {
                    throw new SecurityException("Insert of new Object denied!");
                }
            } else if (this.accessDenied(toSet, Permission.UPDATE)) {
                throw new SecurityException("Update of Object denied!");
            }
        }
        if (this.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
        Cache c = this.getAnnotationFromHierarchy(toSet.getClass(), Cache.class);
        if (this.isAnnotationPresentInHierarchy(toSet.getClass(), NoCache.class) || c == null || !c.writeCache()) {
            this.config.getWriter().set(toSet, field, value);
            this.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().set(toSet, field, value);
                Morphium.this.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            }
        });
    }

    public void dec(Object toDec, String field, int amount) {
        this.inc(toDec, field, -amount);
    }

    public void inc(final Object toSet, final String field, final int i) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (!this.isAnnotationPresentInHierarchy(toSet.getClass(), NoProtection.class)) {
            if (this.getId(toSet) == null) {
                if (this.accessDenied(toSet, Permission.INSERT)) {
                    throw new SecurityException("Insert of new Object denied!");
                }
            } else if (this.accessDenied(toSet, Permission.UPDATE)) {
                throw new SecurityException("Update of Object denied!");
            }
        }
        if (this.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.INC);
        Cache c = this.getAnnotationFromHierarchy(toSet.getClass(), Cache.class);
        if (this.isAnnotationPresentInHierarchy(toSet.getClass(), NoCache.class) || c == null || !c.writeCache()) {
            this.config.getWriter().inc(toSet, field, i);
            this.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.INC);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().set(toSet, field, i);
                Morphium.this.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.INC);
            }
        });
    }

    public void setIdCache(Hashtable<Class<?>, Hashtable<ObjectId, Object>> c) {
        this.idCache = c;
    }

    public <T> void addToCache(String k, Class<?> type, List<T> ret) {
        if (k == null) {
            return;
        }
        if (ret != null) {
            Hashtable<Class<?>, Hashtable<ObjectId, Object>> idCacheClone = this.cloneIdCache();
            for (T record : ret) {
                if (idCacheClone.get(type) == null) {
                    idCacheClone.put(type, new Hashtable());
                }
                idCacheClone.get(type).put(this.config.getMapper().getId(record), record);
            }
            this.setIdCache(idCacheClone);
        }
        CacheElement<T> e = new CacheElement<T>(ret);
        e.setLru(System.currentTimeMillis());
        Hashtable cl = (Hashtable)this.cache.clone();
        if (cl.get(type) == null) {
            cl.put(type, new Hashtable());
        }
        ((Hashtable)cl.get(type)).put(k, e);
        this.cache = cl;
    }

    public void setPrivilegedThread(Thread thr) {
    }

    public void inc(StatisticKeys k) {
        this.stats.get((Object)k).inc();
    }

    public String toJsonString(Object o) {
        return this.config.getMapper().marshall(o).toString();
    }

    public int writeBufferCount() {
        return this.writers.getQueue().size();
    }

    public String getCacheKey(DBObject qo, Map<String, Integer> sort, int skip, int limit) {
        StringBuffer b = new StringBuffer();
        b.append(qo.toString());
        b.append(" l:");
        b.append(limit);
        b.append(" s:");
        b.append(skip);
        if (sort != null) {
            b.append(" sort:");
            b.append(new BasicDBObject(sort).toString());
        }
        return b.toString();
    }

    public String getCacheKey(Query q) {
        return this.getCacheKey(q.toQueryObject(), q.getOrder(), q.getSkip(), q.getLimit());
    }

    public void updateUsingFields(final Object ent, final String ... fields) {
        if (ent == null) {
            return;
        }
        if (fields.length == 0) {
            return;
        }
        if (!this.isAnnotationPresentInHierarchy(ent.getClass(), NoProtection.class)) {
            if (this.getId(ent) == null) {
                if (this.accessDenied(ent, Permission.INSERT)) {
                    throw new SecurityException("Insert of new Object denied!");
                }
            } else if (this.accessDenied(ent, Permission.UPDATE)) {
                throw new SecurityException("Update of Object denied!");
            }
        }
        if (this.isAnnotationPresentInHierarchy(ent.getClass(), NoCache.class)) {
            this.config.getWriter().storeUsingFields(ent, fields);
            return;
        }
        this.firePreUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
        Cache c = this.getAnnotationFromHierarchy(ent.getClass(), Cache.class);
        if (this.isAnnotationPresentInHierarchy(ent.getClass(), NoCache.class) || c == null || !c.writeCache()) {
            this.config.getWriter().storeUsingFields(ent, fields);
            this.firePostUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            return;
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().storeUsingFields(ent, fields);
                Morphium.this.firePostUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            }
        });
    }

    public List<Annotation> getAllAnnotationsFromHierachy(Class<?> cls, Class<? extends Annotation> ... anCls) {
        cls = this.getRealClass(cls);
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        Class<?> z = cls;
        while (!z.equals(Object.class)) {
            if (z.getAnnotations() != null && z.getAnnotations().length != 0) {
                if (anCls.length == 0) {
                    ret.addAll(Arrays.asList(z.getAnnotations()));
                } else {
                    for (Annotation a : z.getAnnotations()) {
                        for (Class<? extends Annotation> ac : anCls) {
                            if (!a.annotationType().equals(ac)) continue;
                            ret.add(a);
                        }
                    }
                }
            }
            if ((z = z.getSuperclass()) != null) continue;
            break;
        }
        return ret;
    }

    public <T extends Annotation> T getAnnotationFromHierarchy(Class<?> cls, Class<? extends T> anCls) {
        if ((cls = this.getRealClass(cls)).isAnnotationPresent(anCls)) {
            return cls.getAnnotation(anCls);
        }
        Class<?> z = cls;
        while (!z.equals(Object.class)) {
            if (z.isAnnotationPresent(anCls)) {
                return z.getAnnotation(anCls);
            }
            if ((z = z.getSuperclass()) != null) continue;
            break;
        }
        return null;
    }

    public ObjectMapper getMapper() {
        return this.config.getMapper();
    }

    Class<?> getRealClass(Class<?> cls) {
        return this.config.getMapper().getRealClass(cls);
    }

    <T> T getRealObject(T o) {
        return this.config.getMapper().getRealObject(o);
    }

    public <T extends Annotation> boolean isAnnotationPresentInHierarchy(Class<?> cls, Class<? extends T> anCls) {
        return this.getAnnotationFromHierarchy(cls, anCls) != null;
    }

    public void callLifecycleMethod(Class<? extends Annotation> type, Object on) {
        if (on == null) {
            return;
        }
        Class<?> cls = on.getClass();
        if (!this.isAnnotationPresentInHierarchy(cls, Lifecycle.class)) {
            return;
        }
        if (this.lifeCycleMethods.get(cls) != null) {
            if (this.lifeCycleMethods.get(cls).get(type) != null) {
                try {
                    this.lifeCycleMethods.get(cls).get(type).invoke(on, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        HashMap<Class<? extends Annotation>, Method> methods = new HashMap<Class<? extends Annotation>, Method>();
        for (Method m : cls.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                methods.put(a.annotationType(), m);
            }
        }
        this.lifeCycleMethods.put(cls, methods);
        if (methods.get(type) != null) {
            try {
                ((Method)methods.get(type)).invoke(on, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T> T reread(T o) {
        BasicDBObject srch;
        if (o == null) {
            throw new RuntimeException("Cannot re read null!");
        }
        ObjectId id = this.getId(o);
        if (id == null) {
            return null;
        }
        DBCollection col = this.database.getCollection(this.getConfig().getMapper().getCollectionName(o.getClass()));
        DBCursor crs = col.find((DBObject)(srch = new BasicDBObject("_id", (Object)id))).limit(1);
        if (crs.hasNext()) {
            DBObject dbo = crs.next();
            Object fromDb = this.getConfig().getMapper().unmarshall(o.getClass(), dbo);
            List<String> flds = this.getFields(o.getClass());
            for (String f : flds) {
                Field fld = this.getConfig().getMapper().getField(o.getClass(), f);
                if (Modifier.isStatic(fld.getModifiers())) continue;
                try {
                    fld.set(o, fld.get(fromDb));
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("Could not set Value: " + fld));
                }
            }
        } else {
            logger.info((Object)("Did not find object with id " + id));
            return null;
        }
        this.firePostLoadEvent(o);
        return o;
    }

    public void firePreStoreEvent(Object o, boolean isNew) {
        if (o == null) {
            return;
        }
        for (MorphiumStorageListener l : this.listeners) {
            l.preStore(o, isNew);
        }
        this.callLifecycleMethod(PreStore.class, o);
    }

    public void firePostStoreEvent(Object o, boolean isNew) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postStore(o, isNew);
        }
        this.callLifecycleMethod(PostStore.class, o);
    }

    public void firePreDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDrop(cls);
        }
    }

    public void firePostDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postDrop(cls);
        }
    }

    public void firePostUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postUpdate(cls, t);
        }
    }

    public void firePreUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preUpdate(cls, t);
        }
    }

    public void firePostRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(o);
        }
        this.callLifecycleMethod(PostRemove.class, o);
    }

    public void firePostRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(q);
        }
    }

    public void firePreRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDelete(o);
        }
        this.callLifecycleMethod(PreRemove.class, o);
    }

    public void firePreRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preRemove(q);
        }
    }

    public void firePostLoadEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postLoad(o);
        }
        this.callLifecycleMethod(PostLoad.class, o);
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        return this.getReplicaSetStatus(false);
    }

    public ReplicaSetStatus getReplicaSetStatus(boolean full) {
        if (this.config.getMode().equals((Object)MongoDbMode.REPLICASET)) {
            try {
                CommandResult res = this.getMongo().getDB("admin").command("replSetGetStatus");
                ReplicaSetStatus status = this.getConfig().getMapper().unmarshall(ReplicaSetStatus.class, (DBObject)res);
                if (full) {
                    DBCursor rpl = this.getMongo().getDB("local").getCollection("system.replset").find();
                    DBObject stat = rpl.next();
                    ReplicaSetConf cfg = this.getConfig().getMapper().unmarshall(ReplicaSetConf.class, stat);
                    List mem = cfg.getMemberList();
                    ArrayList<ConfNode> cmembers = new ArrayList<ConfNode>();
                    for (Object o : mem) {
                        DBObject dbo = (DBObject)o;
                        ConfNode cn = this.getConfig().getMapper().unmarshall(ConfNode.class, dbo);
                        cmembers.add(cn);
                    }
                    cfg.setMembers(cmembers);
                    status.setConfig(cfg);
                }
                List<ReplicaSetNode> lst = status.getMembers();
                ArrayList<ReplicaSetNode> members = new ArrayList<ReplicaSetNode>();
                for (ReplicaSetNode l : lst) {
                    DBObject o = (DBObject)l;
                    ReplicaSetNode n = this.getConfig().getMapper().unmarshall(ReplicaSetNode.class, o);
                    members.add(n);
                }
                status.setMembers(members);
                return status;
            }
            catch (Exception e) {
                logger.error((Object)"Could not get Replicaset status", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isReplicaSet() {
        return this.config.getMode().equals((Object)MongoDbMode.REPLICASET);
    }

    public WriteConcern getWriteConcernForClass(Class<?> cls) {
        WriteSafety safety;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returning write concern for " + cls.getSimpleName()));
        }
        if ((safety = this.getAnnotationFromHierarchy(cls, WriteSafety.class)) == null) {
            return null;
        }
        boolean fsync = safety.waitForSync();
        boolean j = safety.waitForJournalCommit();
        if (j && fsync) {
            fsync = false;
        }
        int w = safety.level().getValue();
        if (!this.isReplicaSet() && w > 1 || this.config.isTimeoutBugWorkAroundEnabled()) {
            w = 1;
        }
        int timeout = safety.timeout();
        if (this.isReplicaSet() && w > 2) {
            ReplicaSetStatus s = this.getReplicaSetStatus();
            if (s == null || s.getActiveNodes() == 0) {
                logger.warn((Object)"ReplicaSet status is null or no node active! Assuming default write concern");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Active nodes now: " + s.getActiveNodes()));
            }
            int activeNodes = s.getActiveNodes();
            int masterOpTime = 0;
            int maxReplLag = 0;
            for (ReplicaSetNode node : s.getMembers()) {
                if (node.getState() != 1) continue;
                masterOpTime = node.getOptime().getTime();
            }
            for (ReplicaSetNode node : s.getMembers()) {
                int tm;
                if (node.getState() != 2 || maxReplLag >= (tm = node.getOptime().getTime() - masterOpTime)) continue;
                maxReplLag = tm;
            }
            if (timeout < 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Setting timeout to replication lag*3");
                }
                if (maxReplLag < 0) {
                    maxReplLag = -maxReplLag;
                }
                if (maxReplLag == 0) {
                    maxReplLag = 1;
                }
                timeout = maxReplLag * 3000;
                if (maxReplLag > 10) {
                    logger.warn((Object)("Warning: replication lag too high! timeout set to " + timeout + "ms - replication Lag is " + maxReplLag + "s - write should take place in Background!"));
                }
            }
            w = activeNodes;
            if (timeout > 0 && timeout < maxReplLag * 1000) {
                logger.warn((Object)"Timeout is set smaller than replication lag - increasing to replication_lag time * 3");
                timeout = maxReplLag * 3000;
            }
        }
        if (w == -99) {
            return new WriteConcern("majority", timeout, fsync, j);
        }
        return new WriteConcern(w, timeout, fsync, j);
    }

    public void addProfilingListener(ProfilingListener l) {
        this.profilingListeners.add(l);
    }

    public void removeProfilingListener(ProfilingListener l) {
        this.profilingListeners.remove(l);
    }

    public void fireProfilingWriteEvent(Class type, Object data, long time, boolean isNew, WriteAccessType wt) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.writeAccess(type, data, time, isNew, wt);
            }
            catch (Throwable e) {
                logger.error((Object)"Error during profiling: ", e);
            }
        }
    }

    public void fireProfilingReadEvent(Query q, long time, ReadAccessType t) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.readAccess(q, time, t);
            }
            catch (Throwable e) {
                logger.error((Object)"Error during profiling", e);
            }
        }
    }

    public boolean isCached(Class<?> type, String k) {
        Cache c = this.getAnnotationFromHierarchy(type, Cache.class);
        if (c != null) {
            if (!c.readCache()) {
                return false;
            }
        } else {
            return false;
        }
        return this.cache.get(type) != null && this.cache.get(type).get(k) != null && this.cache.get(type).get(k).getFound() != null;
    }

    public <T> List<T> getFromCache(Class<? extends T> type, String k) {
        if (this.cache.get(type) == null || this.cache.get(type).get(k) == null) {
            return null;
        }
        CacheElement cacheElement = this.cache.get(type).get(k);
        cacheElement.setLru(System.currentTimeMillis());
        return cacheElement.getFound();
    }

    public Hashtable<Class<?>, Hashtable<String, CacheElement>> cloneCache() {
        return (Hashtable)this.cache.clone();
    }

    public Hashtable<Class<?>, Hashtable<ObjectId, Object>> cloneIdCache() {
        return (Hashtable)this.idCache.clone();
    }

    public void clearCollection(Class<?> cls) {
        if (!this.isAnnotationPresentInHierarchy(cls, NoProtection.class)) {
            try {
                if (this.accessDenied(cls.newInstance(), Permission.DROP)) {
                    throw new SecurityException("Drop / clear of Collection denied!");
                }
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Morphium.class).error((Object)ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Morphium.class).error((Object)ex);
            }
        }
        this.firePreDropEvent(cls);
        this.delete(this.createQueryFor(cls));
        this.firePostDropEvent(cls);
    }

    public void clearCollectionOneByOne(Class<?> cls) {
        if (!this.isAnnotationPresentInHierarchy(cls, NoProtection.class)) {
            try {
                if (this.accessDenied(cls.newInstance(), Permission.DROP)) {
                    throw new SecurityException("Drop / clear of Collection denied!");
                }
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Morphium.class).error((Object)ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Morphium.class).error((Object)ex);
            }
        }
        this.inc(StatisticKeys.WRITES);
        List<?> lst = this.readAll(cls);
        for (Object r : lst) {
            this.delete(r);
        }
        this.clearCacheIfNecessary(cls);
    }

    public <T> List<T> readAll(Class<? extends T> cls) {
        this.inc(StatisticKeys.READS);
        Query<T> qu = this.createQueryFor(cls);
        return qu.asList();
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type) {
        Query<T> q = this.config.getQueryFact().createQuery(this, type);
        q.setMorphium(this);
        return q;
    }

    public <T> List<T> find(Query<T> q) {
        return q.asList();
    }

    private <T> T getFromIDCache(Class<? extends T> type, ObjectId id) {
        if (this.idCache.get(type) != null) {
            return (T)this.idCache.get(type).get(id);
        }
        return null;
    }

    public List<Object> distinct(Enum key, Class c) {
        return this.distinct(key.name(), c);
    }

    public List<Object> distinct(Enum key, Query q) {
        return this.distinct(key.name(), q);
    }

    public List<Object> distinct(String key, Query q) {
        return this.database.getCollection(this.config.getMapper().getCollectionName(q.getType())).distinct(key, q.toQueryObject());
    }

    public List<Object> distinct(String key, Class cls) {
        DBCollection collection = this.database.getCollection(this.config.getMapper().getCollectionName(cls));
        this.setReadPreference(collection, cls);
        return collection.distinct(key, (DBObject)new BasicDBObject());
    }

    private void setReadPreference(DBCollection c, Class type) {
        DefaultReadPreference pr = this.getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            c.setReadPreference(pr.value().getPref());
        } else {
            c.setReadPreference(null);
        }
    }

    public DBObject group(Query q, Map<String, Object> initial, String jsReduce, String jsFinalize, String ... keys) {
        BasicDBObject k = new BasicDBObject();
        BasicDBObject ini = new BasicDBObject();
        ini.putAll(initial);
        for (String ks : keys) {
            if (ks.startsWith("-")) {
                k.append(ks.substring(1), (Object)"false");
                continue;
            }
            if (ks.startsWith("+")) {
                k.append(ks.substring(1), (Object)"true");
                continue;
            }
            k.append(ks, (Object)"true");
        }
        if (!jsReduce.trim().startsWith("function(")) {
            jsReduce = "function (obj,data) { " + jsReduce + " }";
        }
        if (jsFinalize == null) {
            jsFinalize = "";
        }
        if (!jsFinalize.trim().startsWith("function(")) {
            jsFinalize = "function (data) {" + jsFinalize + "}";
        }
        GroupCommand cmd = new GroupCommand(this.database.getCollection(this.config.getMapper().getCollectionName(q.getType())), (DBObject)k, q.toQueryObject(), (DBObject)ini, jsReduce, jsFinalize);
        return this.database.getCollection(this.config.getMapper().getCollectionName(q.getType())).group(cmd);
    }

    public <T> T findById(Class<? extends T> type, ObjectId id) {
        T ret = this.getFromIDCache(type, id);
        if (ret != null) {
            return ret;
        }
        List<String> ls = this.config.getMapper().getFields(type, Id.class);
        if (ls.size() == 0) {
            throw new RuntimeException("Cannot find by ID on non-Entity");
        }
        return this.createQueryFor(type).f(ls.get(0)).eq(id).get();
    }

    public void setValueIn(Object toSetValueIn, String fld, Object value) {
        this.config.getMapper().setValue(toSetValueIn, value, fld);
    }

    public void setValueIn(Object toSetValueIn, Enum fld, Object value) {
        this.config.getMapper().setValue(toSetValueIn, value, fld.name());
    }

    public Object getValueOf(Object toGetValueFrom, String fld) {
        return this.config.getMapper().getValue(toGetValueFrom, fld);
    }

    public Object getValueOf(Object toGetValueFrom, Enum fld) {
        return this.config.getMapper().getValue(toGetValueFrom, fld.name());
    }

    public <T> List<T> findByField(Class<? extends T> cls, String fld, Object val) {
        Query<T> q = this.createQueryFor(cls);
        q = q.f(fld).eq(val);
        return q.asList();
    }

    public <T> List<T> findByField(Class<? extends T> cls, Enum fld, Object val) {
        Query<T> q = this.createQueryFor(cls);
        q = q.f(fld).eq(val);
        return q.asList();
    }

    public final List<String> getFields(Class<?> cls) {
        return this.config.getMapper().getFields(cls, new Class[0]);
    }

    public final Class getTypeOfField(Class<?> cls, String fld) {
        Field f = this.getField(cls, fld);
        if (f == null) {
            return null;
        }
        return f.getType();
    }

    public boolean storesLastChange(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastChange.class);
    }

    public boolean storesLastChangeBy(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastChangeBy.class);
    }

    public boolean storesLastAccess(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastAccess.class);
    }

    public boolean storesLastAccessBy(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastAccessBy.class);
    }

    public boolean storesCreation(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, CreationTime.class);
    }

    public boolean storesCreatedBy(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, CreatedBy.class);
    }

    public String getFieldName(Class<?> cls, String fld) {
        return this.config.getMapper().getFieldName(cls, fld);
    }

    public Field getField(Class cls, String fld) {
        return this.config.getMapper().getField(cls, fld);
    }

    public void setValue(Object in, String fld, Object val) {
        this.config.getMapper().setValue(in, val, fld);
    }

    public Object getValue(Object o, String fld) {
        return this.config.getMapper().getValue(o, fld);
    }

    public Long getLongValue(Object o, String fld) {
        return (Long)this.getValue(o, fld);
    }

    public String getStringValue(Object o, String fld) {
        return (String)this.getValue(o, fld);
    }

    public Date getDateValue(Object o, String fld) {
        return (Date)this.getValue(o, fld);
    }

    public Double getDoubleValue(Object o, String fld) {
        return (Double)this.getValue(o, fld);
    }

    public void clearCachefor(Class<?> cls) {
        if (this.cache.get(cls) != null) {
            this.cache.get(cls).clear();
        }
        if (this.idCache.get(cls) != null) {
            this.idCache.get(cls).clear();
        }
    }

    public void storeNoCache(Object lst) {
        this.config.getWriter().store(lst);
    }

    public void storeInBackground(final Object lst) {
        this.inc(StatisticKeys.WRITES_CACHED);
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                boolean isNew = Morphium.this.getId(lst) == null;
                Morphium.this.firePreStoreEvent(lst, isNew);
                Morphium.this.config.getWriter().store(lst);
                Morphium.this.firePostStoreEvent(lst, isNew);
            }
        });
    }

    public ObjectId getId(Object o) {
        return this.config.getMapper().getId(o);
    }

    public void dropCollection(Class<?> cls) {
        if (!this.isAnnotationPresentInHierarchy(cls, NoProtection.class)) {
            try {
                if (this.accessDenied(cls.newInstance(), Permission.DROP)) {
                    throw new SecurityException("Drop of Collection denied!");
                }
            }
            catch (InstantiationException ex) {
                Logger.getLogger((String)Morphium.class.getName()).fatal((Object)ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger((String)Morphium.class.getName()).fatal((Object)ex);
            }
        }
        if (!this.isAnnotationPresentInHierarchy(cls, Entity.class)) {
            throw new RuntimeException("No entity class: " + cls.getName());
        }
        this.firePreDropEvent(cls);
        long start = System.currentTimeMillis();
        DBCollection coll = this.database.getCollection(this.config.getMapper().getCollectionName(cls));
        coll.drop();
        long dur = System.currentTimeMillis() - start;
        this.fireProfilingWriteEvent(cls, null, dur, false, WriteAccessType.DROP);
        this.firePostDropEvent(cls);
    }

    public void ensureIndex(Class<?> cls, Map<String, Object> index) {
        List<String> fields = this.getFields(cls);
        LinkedHashMap<String, Object> idx = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> es : index.entrySet()) {
            String k = es.getKey();
            if (!fields.contains(k) && !fields.contains(this.config.getMapper().convertCamelCase(k))) {
                throw new IllegalArgumentException("Field unknown for type " + cls.getSimpleName() + ": " + k);
            }
            String fn = this.config.getMapper().getFieldName(cls, k);
            idx.put(fn, es.getValue());
        }
        long start = System.currentTimeMillis();
        BasicDBObject keys = new BasicDBObject(idx);
        this.database.getCollection(this.config.getMapper().getCollectionName(cls)).ensureIndex((DBObject)keys);
        long dur = System.currentTimeMillis() - start;
        this.fireProfilingWriteEvent(cls, keys, dur, false, WriteAccessType.ENSURE_INDEX);
    }

    public void ensureIndex(Class<?> cls, String ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (String f : fldStr) {
            int idx = 1;
            if (f.contains(":")) {
                String[] fs = f.split(":");
                m.put(fs[0], fs[1]);
                continue;
            }
            if (f.startsWith("-")) {
                idx = -1;
                f = f.substring(1);
            } else if (f.startsWith("+")) {
                f = f.substring(1);
            }
            m.put(f, idx);
        }
        this.ensureIndex(cls, m);
    }

    public void ensureIndex(Class<?> cls, Enum ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Enum e : fldStr) {
            String f = e.name();
            m.put(f, 1);
        }
        this.ensureIndex(cls, m);
    }

    public void store(Object o) {
        boolean isNew;
        if (o instanceof List) {
            throw new RuntimeException("Lists need to be stored with storeList");
        }
        Class<?> type = this.getRealClass(o.getClass());
        boolean bl = isNew = this.getId(o) == null;
        if (!this.isAnnotationPresentInHierarchy(type, NoProtection.class)) {
            if (isNew) {
                if (this.accessDenied(o, Permission.INSERT)) {
                    throw new SecurityException("Insert of new Object denied!");
                }
            } else if (this.accessDenied(o, Permission.UPDATE)) {
                throw new SecurityException("Update of Object denied!");
            }
        }
        this.firePreStoreEvent(o, isNew);
        Cache cc = this.getAnnotationFromHierarchy(type, Cache.class);
        if (cc == null || this.isAnnotationPresentInHierarchy(o.getClass(), NoCache.class) || !cc.writeCache()) {
            this.config.getWriter().store(o);
            this.firePostStoreEvent(o, isNew);
            return;
        }
        final Object fo = o;
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().store(fo);
                Morphium.this.firePostStoreEvent(fo, isNew);
            }
        });
        this.inc(StatisticKeys.WRITES_CACHED);
    }

    public <T> void storeList(List<T> lst) {
        ArrayList<T> storeDirect = new ArrayList<T>();
        final ArrayList storeInBg = new ArrayList();
        for (T o : lst) {
            if (this.getId(o) == null) {
                if (this.accessDenied(o, Permission.INSERT)) {
                    throw new SecurityException("Insert of new Object denied!");
                }
            } else if (this.accessDenied(o, Permission.UPDATE)) {
                throw new SecurityException("Update of Object denied!");
            }
            Cache c = this.getAnnotationFromHierarchy(o.getClass(), Cache.class);
            if (this.isAnnotationPresentInHierarchy(o.getClass(), NoCache.class) || c == null || !c.writeCache()) {
                storeDirect.add(o);
                continue;
            }
            storeDirect.add(o);
        }
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.callLifecycleMethod(PreStore.class, storeInBg);
                Morphium.this.config.getWriter().store(storeInBg);
                Morphium.this.callLifecycleMethod(PostStore.class, storeInBg);
            }
        });
        this.callLifecycleMethod(PreStore.class, storeDirect);
        this.config.getWriter().store(storeDirect);
        this.callLifecycleMethod(PostStore.class, storeDirect);
    }

    public void delete(Query o) {
        if (!this.isAnnotationPresentInHierarchy(o.getClass(), NoProtection.class) && this.accessDenied(o, Permission.DELETE)) {
            throw new SecurityException("Deletion of Object denied!");
        }
        this.callLifecycleMethod(PreRemove.class, o);
        this.firePreRemoveEvent(o);
        Cache cc = this.getAnnotationFromHierarchy(o.getType(), Cache.class);
        if (cc == null || this.isAnnotationPresentInHierarchy(o.getType(), NoCache.class) || !cc.writeCache()) {
            this.config.getWriter().delete(o);
            this.callLifecycleMethod(PostRemove.class, o);
            this.firePostRemoveEvent(o);
            return;
        }
        final Query fo = o;
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().delete(fo);
                Morphium.this.firePostRemoveEvent(fo);
            }
        });
        this.inc(StatisticKeys.WRITES_CACHED);
        this.firePostRemoveEvent(o);
    }

    public void delete(Object o) {
        if (o instanceof Query) {
            this.delete((Query)o);
            return;
        }
        if (!this.isAnnotationPresentInHierarchy((o = this.getRealObject(o)).getClass(), NoProtection.class) && this.accessDenied(o, Permission.DELETE)) {
            throw new SecurityException("Deletion of Object denied!");
        }
        this.firePreRemoveEvent(o);
        Cache cc = this.getAnnotationFromHierarchy(o.getClass(), Cache.class);
        if (cc == null || this.isAnnotationPresentInHierarchy(o.getClass(), NoCache.class) || !cc.writeCache()) {
            this.config.getWriter().delete(o);
            this.firePostRemoveEvent(o);
            return;
        }
        final Object fo = o;
        this.writers.execute(new Runnable(){

            @Override
            public void run() {
                Morphium.this.config.getWriter().delete(fo);
                Morphium.this.firePostRemoveEvent(fo);
            }
        });
        this.inc(StatisticKeys.WRITES_CACHED);
    }

    public void resetCache() {
        this.setCache(new Hashtable());
    }

    public void setCache(Hashtable<Class<?>, Hashtable<String, CacheElement>> cache) {
        this.cache = cache;
    }

    public Map<String, Double> getStatistics() {
        return new Statistics(this);
    }

    public void removeEntryFromCache(Class cls, ObjectId id) {
        Hashtable<Class<?>, Hashtable<String, CacheElement>> c = this.cloneCache();
        Hashtable<Class<?>, Hashtable<ObjectId, Object>> idc = this.cloneIdCache();
        idc.get(cls).remove(id);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : c.get(cls).keySet()) {
            for (Object el : c.get(cls).get(key).getFound()) {
                ObjectId lid = this.config.getMapper().getId(el);
                if (lid == null) {
                    logger.error((Object)"Null id in CACHE?");
                    toRemove.add(key);
                }
                if (!lid.equals((Object)id)) continue;
                toRemove.add(key);
            }
        }
        for (String k : toRemove) {
            c.get(cls).remove(k);
        }
        this.setCache(c);
        this.setIdCache(idc);
    }

    public Map<StatisticKeys, StatisticValue> getStats() {
        return this.stats;
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutDownListeners.add(l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutDownListeners.remove(l);
    }

    public void close() {
        this.cacheHousekeeper.end();
        for (ShutdownListener l : this.shutDownListeners) {
            l.onShutdown(this);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            logger.debug((Object)"Ignoring interrupted-exception");
        }
        if (this.cacheHousekeeper.isAlive()) {
            this.cacheHousekeeper.interrupt();
        }
        this.database = null;
        this.config = null;
        this.mongo.close();
        MorphiumSingleton.reset();
    }

    public String createCamelCase(String n) {
        return this.config.getMapper().createCamelCase(n, false);
    }

    public boolean isWriteCached(Class<?> cls) {
        Cache c = this.getAnnotationFromHierarchy(cls, Cache.class);
        return !this.isAnnotationPresentInHierarchy(cls, NoCache.class) && c != null && c.writeCache();
    }

    public <T, R> Aggregator<T, R> createAggregator(Class<? extends T> type, Class<? extends R> resultType) {
        Aggregator<T, R> aggregator = this.config.getAggregatorFactory().createAggregator(type, resultType);
        aggregator.setMorphium(this);
        return aggregator;
    }

    public <T, R> List<R> aggregate(Aggregator<T, R> a) {
        DBCollection coll = this.database.getCollection(this.config.getMapper().getCollectionName(a.getSearchType()));
        List<DBObject> agList = a.toAggregationList();
        DBObject first = agList.get(0);
        agList.remove(0);
        AggregationOutput resp = coll.aggregate(first, agList.toArray(new DBObject[agList.size()]));
        ArrayList<R> ret = new ArrayList<R>();
        for (DBObject o : resp.results()) {
            ret.add(this.getMapper().unmarshall(a.getResultType(), o));
        }
        return ret;
    }

    public <T> T createPartiallyUpdateableEntity(T o) {
        return (T)Enhancer.create(o.getClass(), (Class[])new Class[]{PartiallyUpdateable.class, Serializable.class}, new PartiallyUpdateableProxy<T>(this, o));
    }

    public <T> T createLazyLoadedEntity(Class<? extends T> cls, ObjectId id) {
        return (T)Enhancer.create(cls, (Class[])new Class[]{Serializable.class}, new LazyDeReferencingProxy<T>(this, cls, id));
    }

    public <T> MongoField<T> createMongoField() {
        try {
            return this.config.getFieldImplClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLastChangeField(Class<?> cls) {
        if (!this.storesLastChange(cls)) {
            return null;
        }
        List<String> lst = this.config.getMapper().getFields(cls, LastChange.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getLastChangeByField(Class<?> cls) {
        if (!this.storesLastChangeBy(cls)) {
            return null;
        }
        List<String> lst = this.config.getMapper().getFields(cls, LastChangeBy.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getLastAccessField(Class<?> cls) {
        if (!this.storesLastAccess(cls)) {
            return null;
        }
        List<String> lst = this.config.getMapper().getFields(cls, LastAccess.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getLastAccessByField(Class<?> cls) {
        if (!this.storesLastAccessBy(cls)) {
            return null;
        }
        List<String> lst = this.config.getMapper().getFields(cls, LastAccessBy.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getCreationTimeField(Class<?> cls) {
        if (!this.storesCreation(cls)) {
            return null;
        }
        List<String> lst = this.config.getMapper().getFields(cls, CreationTime.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getCreatedByField(Class<?> cls) {
        if (!this.storesCreatedBy(cls)) {
            return null;
        }
        List<String> lst = this.config.getMapper().getFields(cls, CreatedBy.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public MongoSecurityManager getSecurityManager() {
        return this.config.getSecurityMgr();
    }

    public void setPrivileged() {
        this.privileged.add(Thread.currentThread());
    }

    public boolean checkAccess(String domain, Permission p) throws MongoSecurityException {
        if (this.privileged.contains(Thread.currentThread())) {
            this.privileged.remove(Thread.currentThread());
            return true;
        }
        return this.getSecurityManager().checkAccess(domain, p);
    }

    public boolean accessDenied(Class<?> cls, Permission p) throws MongoSecurityException {
        if (this.isAnnotationPresentInHierarchy(cls, NoProtection.class)) {
            return false;
        }
        if (this.privileged.contains(Thread.currentThread())) {
            this.privileged.remove(Thread.currentThread());
            return false;
        }
        return !this.getSecurityManager().checkAccess(cls, p);
    }

    public boolean accessDenied(Object r, Permission p) throws MongoSecurityException {
        if (this.isAnnotationPresentInHierarchy(r.getClass(), NoProtection.class)) {
            return false;
        }
        if (this.privileged.contains(Thread.currentThread())) {
            this.privileged.remove(Thread.currentThread());
            return false;
        }
        return !this.getSecurityManager().checkAccess(this.config.getMapper().getRealObject(r), p);
    }
}

