/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.backend.MongoCollection;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.memory.index.Index;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.ObjectId;

public class MemoryCollection
extends MongoCollection {
    private List<Index> indexes = new ArrayList<Index>();
    private QueryMatcher matcher = new DefaultQueryMatcher();
    private AtomicLong dataSize = new AtomicLong();
    private List<BSONObject> documents = new ArrayList<BSONObject>();
    private Queue<Integer> emptyPositions = new LinkedList<Integer>();
    private String idField;

    public MemoryCollection(String databaseName, String collectionName, String idField) {
        super(databaseName, collectionName);
        this.idField = idField;
    }

    @Override
    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    private Iterable<Integer> matchDocuments(BSONObject query, Iterable<Integer> positions) throws MongoServerException {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        for (Integer pos : positions) {
            BSONObject document = this.documents.get(pos);
            if (!this.matcher.matches(document, query)) continue;
            answer.add(pos);
        }
        return answer;
    }

    private Iterable<Integer> matchDocuments(BSONObject query) throws MongoServerException {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        for (int i = 0; i < this.documents.size(); ++i) {
            BSONObject document = this.documents.get(i);
            if (document == null || !this.matcher.matches(document, query)) continue;
            answer.add(i);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Integer> queryDocuments(BSONObject query) throws MongoServerException {
        List<Index> list = this.indexes;
        synchronized (list) {
            for (Index index : this.indexes) {
                if (!index.canHandle(query)) continue;
                return this.matchDocuments(query, index.getPositions(query));
            }
        }
        return this.matchDocuments(query);
    }

    private void changeSubdocumentValue(Object document, String key, Object newValue, Integer matchPos) throws MongoServerException {
        this.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>(matchPos));
    }

    private void changeSubdocumentValue(Object document, String key, Object newValue, AtomicReference<Integer> matchPos) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getListSafe(document, mainKey);
            if (subObject instanceof BSONObject || subObject instanceof List) {
                this.changeSubdocumentValue(subObject, subKey, newValue, matchPos);
            } else {
                BasicBSONObject obj = new BasicBSONObject();
                this.changeSubdocumentValue((Object)obj, subKey, newValue, matchPos);
                Utils.setListSafe(document, mainKey, obj);
            }
        } else {
            Utils.setListSafe(document, key, newValue);
        }
    }

    protected String getSubkey(String key, int dotPos, AtomicReference<Integer> matchPos) throws MongoServerError {
        String subKey = key.substring(dotPos + 1);
        if (subKey.matches("\\$(\\..+)?")) {
            if (matchPos == null || matchPos.get() == null) {
                throw new MongoServerError(16650, "Cannot apply the positional operator without a corresponding query field containing an array.");
            }
            Integer pos = matchPos.getAndSet(null);
            return subKey.replaceFirst("\\$", String.valueOf(pos));
        }
        return subKey;
    }

    private void removeSubdocumentValue(Object document, String key, Integer matchPos) throws MongoServerException {
        this.removeSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getListSafe(document, mainKey);
            if (!(subObject instanceof BSONObject) && !(subObject instanceof List)) throw new MongoServerException("failed to remove subdocument");
            this.removeSubdocumentValue(subObject, subKey, matchPos);
            return;
        } else {
            Utils.removeListSafe(document, key);
        }
    }

    private Object getSubdocumentValue(Object document, String key, Integer matchPos) throws MongoServerException {
        return this.getSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    private Object getSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getListSafe(document, mainKey);
            if (subObject instanceof BSONObject || subObject instanceof List) {
                return this.getSubdocumentValue(subObject, subKey, matchPos);
            }
            return null;
        }
        return Utils.getListSafe(document, key);
    }

    private void modifyField(BSONObject document, String modifier, BSONObject change, Integer matchPos, boolean isUpsert) throws MongoServerException {
        if (!modifier.equals("$unset")) {
            for (String key : change.keySet()) {
                if (!key.startsWith("$")) continue;
                throw new MongoServerError(15896, "Modified field name may not start with $");
            }
        }
        if (modifier.equals("$set") || modifier.equals("$setOnInsert") && isUpsert) {
            for (String key : change.keySet()) {
                Object oldValue;
                Object newValue = change.get(key);
                if (Utils.nullAwareEquals(newValue, oldValue = this.getSubdocumentValue((Object)document, key, matchPos))) continue;
                this.assertNotKeyField(key);
                this.changeSubdocumentValue((Object)document, key, newValue, matchPos);
            }
        } else if (!modifier.equals("$setOnInsert")) {
            if (modifier.equals("$unset")) {
                for (String key : change.keySet()) {
                    this.assertNotKeyField(key);
                    this.removeSubdocumentValue((Object)document, key, matchPos);
                }
            } else if (modifier.equals("$push") || modifier.equals("$pushAll") || modifier.equals("$addToSet")) {
                this.updatePushAllAddToSet(document, modifier, change, matchPos);
            } else if (modifier.equals("$pull") || modifier.equals("$pullAll")) {
                for (String key : change.keySet()) {
                    Object value = this.getSubdocumentValue((Object)document, key, matchPos);
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof List)) {
                        throw new MongoServerError(10142, "Cannot apply " + modifier + " modifier to non-array");
                    }
                    List<Object> list = Utils.asList(value);
                    Object pushValue = change.get(key);
                    if (modifier.equals("$pullAll")) {
                        if (!(pushValue instanceof Collection)) {
                            throw new MongoServerError(10153, "Modifier " + modifier + " allowed for arrays only");
                        }
                        Collection valueList = (Collection)pushValue;
                        while (list.removeAll(valueList)) {
                        }
                        continue;
                    }
                    while (list.remove(pushValue)) {
                    }
                }
            } else if (modifier.equals("$pop")) {
                for (String key : change.keySet()) {
                    Object value = this.getSubdocumentValue((Object)document, key, matchPos);
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof List)) {
                        throw new MongoServerError(10143, "Cannot apply " + modifier + " modifier to non-array");
                    }
                    List<Object> list = Utils.asList(value);
                    Object pushValue = change.get(key);
                    if (list.isEmpty()) continue;
                    if (pushValue != null && Utils.normalizeValue(pushValue).equals(-1.0)) {
                        list.remove(0);
                        continue;
                    }
                    list.remove(list.size() - 1);
                }
            } else if (modifier.equals("$inc")) {
                for (String key : change.keySet()) {
                    Number number;
                    this.assertNotKeyField(key);
                    Object value = this.getSubdocumentValue((Object)document, key, matchPos);
                    if (value == null) {
                        number = 0;
                    } else if (value instanceof Number) {
                        number = (Number)value;
                    } else {
                        throw new MongoServerException("can not increment '" + value + "'");
                    }
                    this.changeSubdocumentValue((Object)document, key, (Object)Utils.addNumbers(number, (Number)change.get(key)), matchPos);
                }
            } else {
                throw new MongoServerError(10147, "Invalid modifier specified: " + modifier);
            }
        }
    }

    private void updatePushAllAddToSet(BSONObject document, String modifier, BSONObject change, Integer matchPos) throws MongoServerException {
        for (String key : change.keySet()) {
            List<Object> list;
            Object value = this.getSubdocumentValue((Object)document, key, matchPos);
            if (value == null) {
                list = new ArrayList();
            } else if (value instanceof List) {
                list = Utils.asList(value);
            } else {
                throw new MongoServerError(10141, "Cannot apply " + modifier + " modifier to non-array");
            }
            Object changeValue = change.get(key);
            if (modifier.equals("$pushAll")) {
                if (!(changeValue instanceof Collection)) {
                    throw new MongoServerError(10153, "Modifier " + modifier + " allowed for arrays only");
                }
                Collection valueList = (Collection)changeValue;
                list.addAll(valueList);
            } else {
                ArrayList<Object> pushValues = new ArrayList<Object>();
                if (changeValue instanceof BSONObject && ((BSONObject)changeValue).keySet().equals(Collections.singleton("$each"))) {
                    Collection values = (Collection)((BSONObject)changeValue).get("$each");
                    pushValues.addAll(values);
                } else {
                    pushValues.add(changeValue);
                }
                for (Object e : pushValues) {
                    if (modifier.equals("$push")) {
                        list.add(e);
                        continue;
                    }
                    if (modifier.equals("$addToSet")) {
                        if (list.contains(e)) continue;
                        list.add(e);
                        continue;
                    }
                    throw new MongoServerException("internal server error. illegal modifier here: " + modifier);
                }
            }
            this.changeSubdocumentValue((Object)document, key, list, matchPos);
        }
    }

    private void assertNotKeyField(String key) throws MongoServerError {
        if (key.equals(this.idField)) {
            throw new MongoServerError(10148, "Mod on " + this.idField + " not allowed");
        }
    }

    private void applyUpdate(BSONObject oldDocument, BSONObject newDocument) throws MongoServerException {
        if (newDocument.equals(oldDocument)) {
            return;
        }
        Object oldId = oldDocument.get(this.idField);
        Object newId = newDocument.get(this.idField);
        if (newId != null && !Utils.nullAwareEquals(oldId, newId)) {
            oldId = new BasicBSONObject(this.idField, oldId);
            newId = new BasicBSONObject(this.idField, newId);
            throw new MongoServerError(13596, "cannot change _id of a document old:" + oldId + " new:" + newId);
        }
        if (newId == null && oldId != null) {
            newDocument.put(this.idField, oldId);
        }
        this.cloneInto(oldDocument, newDocument);
    }

    Object deriveDocumentId(BSONObject selector) {
        Object value = selector.get(this.idField);
        if (value != null) {
            if (!Utils.containsQueryExpression(value)) {
                return value;
            }
            return this.deriveIdFromExpression(value);
        }
        return new ObjectId();
    }

    private Object deriveIdFromExpression(Object value) {
        BSONObject expression = (BSONObject)value;
        for (String key : expression.keySet()) {
            Collection list;
            Object expressionValue = expression.get(key);
            if (!key.equals("$in") || (list = (Collection)expressionValue).isEmpty()) continue;
            return list.iterator().next();
        }
        return new ObjectId();
    }

    private BSONObject calculateUpdateDocument(BSONObject oldDocument, BSONObject update, Integer matchPos, boolean isUpsert) throws MongoServerException {
        int numStartsWithDollar = 0;
        for (String key : update.keySet()) {
            if (!key.startsWith("$")) continue;
            ++numStartsWithDollar;
        }
        BasicBSONObject newDocument = new BasicBSONObject(this.idField, oldDocument.get(this.idField));
        if (numStartsWithDollar == update.keySet().size()) {
            this.cloneInto((BSONObject)newDocument, oldDocument);
            for (String key : update.keySet()) {
                this.modifyField((BSONObject)newDocument, key, (BSONObject)update.get(key), matchPos, isUpsert);
            }
        } else if (numStartsWithDollar == 0) {
            this.applyUpdate((BSONObject)newDocument, update);
        } else {
            throw new MongoServerException("illegal update: " + update);
        }
        return newDocument;
    }

    @Override
    public synchronized void addDocument(BSONObject document) throws MongoServerException {
        Integer pos = this.emptyPositions.poll();
        if (pos == null) {
            pos = this.documents.size();
        }
        for (Index index : this.indexes) {
            index.checkAdd(document);
        }
        for (Index index : this.indexes) {
            index.add(document, pos);
        }
        this.dataSize.addAndGet(Utils.calculateSize(document));
        if (pos.intValue() == this.documents.size()) {
            this.documents.add(document);
        } else {
            this.documents.set(pos, document);
        }
    }

    @Override
    public synchronized void removeDocument(BSONObject document) throws MongoServerException {
        Integer pos = null;
        if (!this.indexes.isEmpty()) {
            for (Index index : this.indexes) {
                pos = index.remove(document);
            }
        } else {
            int idx = this.documents.indexOf(document);
            if (idx >= 0) {
                pos = idx;
            }
        }
        if (pos == null) {
            return;
        }
        this.dataSize.addAndGet(-Utils.calculateSize(document));
        this.documents.set(pos, null);
        this.emptyPositions.add(pos);
    }

    @Override
    public synchronized int count() {
        return this.documents.size() - this.emptyPositions.size();
    }

    @Override
    public synchronized BSONObject findAndModify(BSONObject query) throws MongoServerException {
        boolean returnNew = Utils.isTrue(query.get("new"));
        if (!query.containsField("remove") && !query.containsField("update")) {
            throw new MongoServerException("need remove or update");
        }
        BasicBSONObject queryObject = new BasicBSONObject();
        if (query.containsField("query")) {
            queryObject.put("query", query.get("query"));
        } else {
            queryObject.put("query", (Object)new BasicBSONObject());
        }
        if (query.containsField("sort")) {
            queryObject.put("orderby", query.get("sort"));
        }
        BasicBSONObject lastErrorObject = null;
        Object returnDocument = null;
        int num = 0;
        for (BSONObject document : this.handleQuery((BSONObject)queryObject, 0, 1)) {
            ++num;
            if (Utils.isTrue(query.get("remove"))) {
                this.removeDocument(document);
                returnDocument = document;
                continue;
            }
            if (query.get("update") == null) continue;
            BSONObject updateQuery = (BSONObject)query.get("update");
            Integer matchPos = this.matcher.matchPosition(document, (BSONObject)queryObject.get("query"));
            BSONObject oldDocument = this.updateDocument(document, updateQuery, matchPos);
            returnDocument = returnNew ? document : oldDocument;
            lastErrorObject = new BasicBSONObject("updatedExisting", (Object)Boolean.TRUE);
            lastErrorObject.put("n", (Object)1);
        }
        if (num == 0 && Utils.isTrue(query.get("upsert"))) {
            BSONObject selector = (BSONObject)query.get("query");
            BSONObject updateQuery = (BSONObject)query.get("update");
            BSONObject newDocument = this.handleUpsert(updateQuery, selector);
            returnDocument = returnNew ? newDocument : new BasicBSONObject();
            ++num;
        }
        if (query.get("fields") != null) {
            BSONObject fields = (BSONObject)query.get("fields");
            returnDocument = this.projectDocument((BSONObject)returnDocument, fields);
        }
        BasicBSONObject result = new BasicBSONObject();
        if (lastErrorObject != null) {
            result.put("lastErrorObject", lastErrorObject);
        }
        result.put("value", returnDocument);
        Utils.markOkay((BSONObject)result);
        return result;
    }

    private BSONObject projectDocument(BSONObject document, BSONObject fields) {
        if (document == null) {
            return null;
        }
        BasicBSONObject newDocument = new BasicBSONObject();
        for (String key : fields.keySet()) {
            if (!Utils.isTrue(fields.get(key))) continue;
            newDocument.put(key, document.get(key));
        }
        if (!fields.containsField(this.idField)) {
            newDocument.put(this.idField, document.get(this.idField));
        }
        return newDocument;
    }

    public synchronized Iterable<BSONObject> handleQuery(BSONObject queryObject, int numberToSkip, int numberToReturn) throws MongoServerException {
        return this.handleQuery(queryObject, numberToSkip, numberToReturn, null);
    }

    @Override
    public synchronized Iterable<BSONObject> handleQuery(BSONObject queryObject, int numberToSkip, int numberToReturn, BSONObject fieldSelector) throws MongoServerException {
        BSONObject query;
        BSONObject orderBy = null;
        if (numberToReturn < 0) {
            numberToReturn = -numberToReturn;
        }
        if (queryObject.containsField("query")) {
            query = (BSONObject)queryObject.get("query");
            orderBy = (BSONObject)queryObject.get("orderby");
        } else if (queryObject.containsField("$query")) {
            query = (BSONObject)queryObject.get("$query");
            orderBy = (BSONObject)queryObject.get("$orderby");
        } else {
            query = queryObject;
        }
        if (this.documents.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable<Integer> keys = this.queryDocuments(query);
        List<Object> objs = new ArrayList<BSONObject>();
        for (Integer pos : keys) {
            if (numberToSkip > 0) {
                --numberToSkip;
                continue;
            }
            objs.add(this.documents.get(pos));
        }
        if (orderBy != null && !orderBy.keySet().isEmpty()) {
            if (((String)orderBy.keySet().iterator().next()).equals("$natural")) {
                if (!orderBy.get("$natural").equals(1) && orderBy.get("$natural").equals(-1)) {
                    Collections.reverse(objs);
                }
            } else {
                Collections.sort(objs, new DocumentComparator(orderBy));
            }
        }
        if (numberToReturn > 0 && objs.size() > numberToReturn) {
            objs = objs.subList(0, numberToReturn);
        }
        if (fieldSelector != null && !fieldSelector.keySet().isEmpty()) {
            for (int i = 0; i < objs.size(); ++i) {
                objs.set(i, this.projectDocument((BSONObject)objs.get(i), fieldSelector));
            }
        }
        return objs;
    }

    @Override
    public synchronized BSONObject handleDistinct(BSONObject query) throws MongoServerException {
        String key = query.get("key").toString();
        BSONObject q = (BSONObject)query.get("query");
        TreeSet<Object> values = new TreeSet<Object>(new ValueComparator());
        for (Integer pos : this.queryDocuments(q)) {
            BSONObject document = this.documents.get(pos);
            if (!document.containsField(key)) continue;
            values.add(document.get(key));
        }
        BasicBSONObject response = new BasicBSONObject("values", new ArrayList<Object>(values));
        Utils.markOkay((BSONObject)response);
        return response;
    }

    @Override
    public synchronized int handleInsert(MongoInsert insert) throws MongoServerException {
        int n = 0;
        for (BSONObject document : insert.getDocuments()) {
            this.addDocument(document);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized int handleDelete(MongoDelete delete) throws MongoServerException {
        int n = 0;
        for (BSONObject document : this.handleQuery(delete.getSelector(), 0, Integer.MAX_VALUE)) {
            this.removeDocument(document);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized BSONObject handleUpdate(MongoUpdate update) throws MongoServerException {
        BSONObject updateQuery = update.getUpdate();
        int n = 0;
        boolean updatedExisting = false;
        BSONObject selector = update.getSelector();
        if (update.isMulti()) {
            for (String key : updateQuery.keySet()) {
                if (key.startsWith("$")) continue;
                throw new MongoServerError(10158, "multi update only works with $ operators");
            }
        }
        for (Integer position : this.queryDocuments(selector)) {
            BSONObject document = this.documents.get(position);
            Integer matchPos = this.matcher.matchPosition(document, selector);
            this.updateDocument(document, updateQuery, matchPos);
            updatedExisting = true;
            ++n;
            if (update.isMulti()) continue;
            break;
        }
        BasicBSONObject result = new BasicBSONObject();
        if (n == 0 && update.isUpsert()) {
            BSONObject newDocument = this.handleUpsert(updateQuery, selector);
            if (!selector.containsField(this.idField)) {
                result.put("upserted", newDocument.get(this.idField));
            }
            ++n;
        }
        result.put("n", (Object)n);
        result.put("updatedExisting", (Object)updatedExisting);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BSONObject updateDocument(BSONObject document, BSONObject updateQuery, Integer matchPos) throws MongoServerException {
        BSONObject bSONObject = document;
        synchronized (bSONObject) {
            BasicBSONObject oldDocument = new BasicBSONObject();
            this.cloneInto((BSONObject)oldDocument, document);
            BSONObject newDocument = this.calculateUpdateDocument(document, updateQuery, matchPos, false);
            if (!newDocument.equals(oldDocument)) {
                for (Index index : this.indexes) {
                    index.checkUpdate((BSONObject)oldDocument, newDocument);
                }
                for (Index index : this.indexes) {
                    index.updateInPlace((BSONObject)oldDocument, newDocument);
                }
                long oldSize = Utils.calculateSize((BSONObject)oldDocument);
                long newSize = Utils.calculateSize(newDocument);
                this.dataSize.addAndGet(newSize - oldSize);
                HashSet fields = new HashSet(document.keySet());
                fields.removeAll(newDocument.keySet());
                for (String key : fields) {
                    document.removeField(key);
                }
                for (String key : newDocument.keySet()) {
                    if (key.contains(".")) {
                        throw new MongoServerException("illegal field name. must not happen as it must be catched by the driver");
                    }
                    document.put(key, newDocument.get(key));
                }
            }
            return oldDocument;
        }
    }

    private void cloneInto(BSONObject targetDocument, BSONObject sourceDocument) {
        for (String key : sourceDocument.keySet()) {
            targetDocument.put(key, this.cloneValue(sourceDocument.get(key)));
        }
    }

    protected Object cloneValue(Object value) {
        if (value instanceof BSONObject) {
            BasicBSONObject newValue = new BasicBSONObject();
            this.cloneInto((BSONObject)newValue, (BSONObject)value);
            return newValue;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> newValue = new ArrayList<Object>();
            for (Object v : list) {
                newValue.add(this.cloneValue(v));
            }
            return newValue;
        }
        return value;
    }

    private BSONObject handleUpsert(BSONObject updateQuery, BSONObject selector) throws MongoServerException {
        BSONObject document = this.convertSelectorToDocument(selector);
        BSONObject newDocument = this.calculateUpdateDocument(document, updateQuery, null, true);
        if (newDocument.get(this.idField) == null) {
            newDocument.put(this.idField, this.deriveDocumentId(selector));
        }
        this.addDocument(newDocument);
        return newDocument;
    }

    BSONObject convertSelectorToDocument(BSONObject selector) throws MongoServerException {
        BasicBSONObject document = new BasicBSONObject();
        for (String key : selector.keySet()) {
            Object value;
            if (key.startsWith("$") || Utils.containsQueryExpression(value = selector.get(key))) continue;
            this.changeSubdocumentValue((Object)document, key, value, (AtomicReference<Integer>)null);
        }
        return document;
    }

    @Override
    public int getNumIndexes() {
        return this.indexes.size();
    }

    @Override
    public int count(BSONObject query) throws MongoServerException {
        if (query.keySet().isEmpty()) {
            return this.count();
        }
        int count = 0;
        Iterator<Integer> it = this.queryDocuments(query).iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public BSONObject getStats() {
        BasicBSONObject response = new BasicBSONObject("ns", (Object)this.getFullName());
        response.put("count", (Object)this.documents.size());
        response.put("size", (Object)this.dataSize.get());
        double averageSize = 0.0;
        if (!this.documents.isEmpty()) {
            averageSize = (double)this.dataSize.get() / (double)this.documents.size();
        }
        response.put("avgObjSize", (Object)averageSize);
        response.put("storageSize", (Object)0);
        response.put("numExtents", (Object)0);
        response.put("nindexes", (Object)this.indexes.size());
        BasicBSONObject indexSizes = new BasicBSONObject();
        for (Index index : this.indexes) {
            indexSizes.put(index.getName(), (Object)index.getDataSize());
        }
        response.put("indexSize", (Object)indexSizes);
        Utils.markOkay((BSONObject)response);
        return response;
    }

    @Override
    public BSONObject validate() {
        BasicBSONObject response = new BasicBSONObject("ns", (Object)this.getFullName());
        response.put("extentCount", (Object)0);
        response.put("datasize", (Object)this.dataSize.get());
        response.put("nrecords", (Object)this.documents.size());
        response.put("padding", (Object)1);
        response.put("deletedCount", (Object)this.emptyPositions.size());
        response.put("deletedSize", (Object)0);
        response.put("nIndexes", (Object)this.indexes.size());
        BasicBSONObject keysPerIndex = new BasicBSONObject();
        for (Index index : this.indexes) {
            keysPerIndex.put(index.getName(), (Object)index.getCount());
        }
        response.put("keysPerIndex", (Object)keysPerIndex);
        response.put("valid", (Object)Boolean.TRUE);
        response.put("errors", Arrays.asList(new Object[0]));
        Utils.markOkay((BSONObject)response);
        return response;
    }
}

