/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire.message;

import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import io.netty.channel.Channel;
import org.bson.BSONObject;

public class MongoQuery
extends ClientRequest {
    private final BSONObject query;
    private final BSONObject returnFieldSelector;
    private boolean slaveOk;
    private int numberToSkip;
    private int numberToReturn;

    public MongoQuery(Channel channel, MessageHeader header, String fullCollectionName, int numberToSkip, int numberToReturn, BSONObject query, BSONObject returnFieldSelector) {
        super(channel, header, fullCollectionName);
        this.numberToSkip = numberToSkip;
        this.numberToReturn = numberToReturn;
        this.query = query;
        this.returnFieldSelector = returnFieldSelector;
    }

    public int getNumberToSkip() {
        return this.numberToSkip;
    }

    public int getNumberToReturn() {
        return this.numberToReturn;
    }

    public BSONObject getQuery() {
        return this.query;
    }

    public BSONObject getReturnFieldSelector() {
        return this.returnFieldSelector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(");
        sb.append("header: ").append(this.getHeader());
        sb.append(", collection: ").append(this.getFullCollectionName());
        sb.append(", query: ").append(this.query);
        sb.append(", returnFieldSelector: ").append(this.returnFieldSelector);
        sb.append(")");
        return sb.toString();
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    public boolean isSlaveOk() {
        return this.slaveOk;
    }
}

