/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.QueryFlag;
import de.bwaldvogel.mongo.wire.UpdateFlag;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;

public class MongoWireProtocolHandler
extends LengthFieldBasedFrameDecoder {
    public static final int MAX_BSON_OBJECT_SIZE = 0x1000000;
    public static final int MAX_MESSAGE_SIZE_BYTES = 48000000;
    private static final Logger log = Logger.getLogger(MongoWireProtocolHandler.class);
    private static final int maxFrameLength = Integer.MAX_VALUE;
    private static final int lengthFieldOffset = 0;
    private static final int lengthFieldLength = 4;
    private static final int lengthAdjustment = -4;
    private static final int initialBytesToStrip = 0;

    public MongoWireProtocolHandler() {
        super(Integer.MAX_VALUE, 0, 4, -4, 0);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.error((Object)("exception for client " + e.getChannel().getId()), e.getCause());
        e.getChannel().close();
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        Object ret;
        if (buffer.readableBytes() < 4) {
            return null;
        }
        buffer.markReaderIndex();
        int totalLength = buffer.readInt();
        if (totalLength > 48000000) {
            throw new IOException("message too large: " + totalLength + " bytes");
        }
        if (buffer.readableBytes() < totalLength - 4) {
            buffer.resetReaderIndex();
            return null;
        }
        int readable = (buffer = buffer.readSlice(totalLength - 4)).readableBytes();
        if (readable != totalLength - 4) {
            throw new IllegalStateException();
        }
        int requestID = buffer.readInt();
        int responseTo = buffer.readInt();
        MessageHeader header = new MessageHeader(requestID, responseTo);
        int opCodeId = buffer.readInt();
        OpCode opCode = OpCode.getById(opCodeId);
        if (opCode == null) {
            throw new IOException("opCode " + opCodeId + " not supported");
        }
        switch (opCode) {
            case OP_QUERY: {
                ret = this.handleQuery(channel, header, buffer);
                break;
            }
            case OP_INSERT: {
                ret = this.handleInsert(channel, header, buffer);
                break;
            }
            case OP_DELETE: {
                ret = this.handleDelete(channel, header, buffer);
                break;
            }
            case OP_UPDATE: {
                ret = this.handleUpdate(channel, header, buffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported opcode: " + (Object)((Object)opCode));
            }
        }
        if (buffer.readable()) {
            throw new IOException();
        }
        return ret;
    }

    private Object handleDelete(Channel channel, MessageHeader header, ChannelBuffer buffer) throws IOException {
        buffer.skipBytes(4);
        String fullCollectionName = this.readCString(buffer);
        int flags = buffer.readInt();
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        BSONObject selector = this.readBSON(buffer);
        log.debug((Object)("delete " + selector + " from " + fullCollectionName));
        return new MongoDelete(channel, header, fullCollectionName, selector);
    }

    private Object handleUpdate(Channel channel, MessageHeader header, ChannelBuffer buffer) throws IOException {
        buffer.skipBytes(4);
        String fullCollectionName = this.readCString(buffer);
        int flags = buffer.readInt();
        boolean upsert = UpdateFlag.UPSERT.isSet(flags);
        boolean multi = UpdateFlag.MULTI_UPDATE.isSet(flags);
        BSONObject selector = this.readBSON(buffer);
        BSONObject update = this.readBSON(buffer);
        log.debug((Object)("update " + selector + " in " + fullCollectionName));
        return new MongoUpdate(channel, header, fullCollectionName, selector, update, upsert, multi);
    }

    private Object handleInsert(Channel channel, MessageHeader header, ChannelBuffer buffer) throws IOException {
        int flags = buffer.readInt();
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        String fullCollectionName = this.readCString(buffer);
        ArrayList<BSONObject> documents = new ArrayList<BSONObject>();
        while (buffer.readable()) {
            BSONObject document = this.readBSON(buffer);
            if (document == null) {
                return null;
            }
            documents.add(document);
        }
        log.debug((Object)("insert " + documents + " in " + fullCollectionName));
        return new MongoInsert(channel, header, fullCollectionName, documents);
    }

    private Object handleQuery(Channel channel, MessageHeader header, ChannelBuffer buffer) throws IOException {
        int flags = buffer.readInt();
        String fullCollectionName = this.readCString(buffer);
        int numberToSkip = buffer.readInt();
        int numberToReturn = buffer.readInt();
        BSONObject query = this.readBSON(buffer);
        BSONObject returnFieldSelector = null;
        if (buffer.readable()) {
            returnFieldSelector = this.readBSON(buffer);
        }
        MongoQuery mongoQuery = new MongoQuery(channel, header, fullCollectionName, numberToSkip, numberToReturn, query, returnFieldSelector);
        if (QueryFlag.SLAVE_OK.isSet(flags)) {
            flags = QueryFlag.SLAVE_OK.removeFrom(flags);
        }
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        log.debug((Object)("query " + query + " from " + fullCollectionName));
        return mongoQuery;
    }

    private BSONObject readBSON(ChannelBuffer buffer) throws IOException {
        int length = buffer.readInt() - 4;
        if (buffer.readableBytes() < length) {
            throw new IOException();
        }
        if (length > 0x1000000) {
            throw new IOException("BSON object too large: " + length + " bytes");
        }
        BasicBSONObject object = new BasicBSONObject();
        int start = buffer.readerIndex();
        while (buffer.readerIndex() - start < length) {
            Object value;
            byte type = buffer.readByte();
            if (type == 0) {
                return object;
            }
            String name = this.readCString(buffer);
            block0 : switch (type) {
                case 1: {
                    value = buffer.readDouble();
                    break;
                }
                case 2: {
                    value = this.readString(buffer);
                    break;
                }
                case 3: {
                    value = this.readBSON(buffer);
                    break;
                }
                case 4: {
                    value = this.readArray(buffer);
                    break;
                }
                case 5: {
                    value = this.readBinary(buffer);
                    break;
                }
                case 6: {
                    value = null;
                    break;
                }
                case 7: {
                    value = this.readObjectId(buffer);
                    break;
                }
                case 8: {
                    switch (buffer.readByte()) {
                        case 0: {
                            value = Boolean.FALSE;
                            break block0;
                        }
                        case 1: {
                            value = Boolean.TRUE;
                            break block0;
                        }
                    }
                    throw new IOException("illegal boolean value");
                }
                case 9: {
                    value = new Date(buffer.readLong());
                    break;
                }
                case 10: {
                    value = null;
                    break;
                }
                case 11: {
                    value = this.readPattern(buffer);
                    break;
                }
                case 16: {
                    value = buffer.readInt();
                    break;
                }
                case 17: {
                    value = new BSONTimestamp(buffer.readInt(), buffer.readInt());
                    break;
                }
                case 18: {
                    value = buffer.readLong();
                    break;
                }
                default: {
                    throw new IOException("unknown type: " + type);
                }
            }
            object.put(name, value);
        }
        throw new IOException("illegal BSON object");
    }

    private Pattern readPattern(ChannelBuffer buffer) throws IOException {
        String regex = this.readCString(buffer);
        String options = this.readCString(buffer);
        return Utils.createPattern(regex, options);
    }

    private List<Object> readArray(ChannelBuffer buffer) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        BSONObject arrayObject = this.readBSON(buffer);
        for (String key : arrayObject.keySet()) {
            array.add(arrayObject.get(key));
        }
        return array;
    }

    private ObjectId readObjectId(ChannelBuffer buffer) {
        byte[] b = new byte[12];
        buffer.readBytes(b);
        return new ObjectId(b);
    }

    private String readString(ChannelBuffer buffer) throws IOException {
        int length = buffer.readInt();
        byte[] data = new byte[length - 1];
        buffer.readBytes(data);
        String s = new String(data, "UTF-8");
        byte trail = buffer.readByte();
        if (trail != 0) {
            throw new IOException();
        }
        return s;
    }

    String readCString(ChannelBuffer buffer) throws IOException {
        int length = buffer.bytesBefore((byte)0);
        if (length < 0) {
            throw new IOException("string termination not found");
        }
        String result = buffer.toString(buffer.readerIndex(), length, Charset.forName("UTF-8"));
        buffer.skipBytes(length + 1);
        return result;
    }

    private Object readBinary(ChannelBuffer buffer) throws IOException {
        int length = buffer.readInt();
        byte subtype = buffer.readByte();
        switch (subtype) {
            case 0: 
            case 128: {
                byte[] data = new byte[length];
                buffer.readBytes(data);
                return data;
            }
            case 3: 
            case 4: {
                if (length != 16) {
                    throw new IOException();
                }
                return new UUID(buffer.readLong(), buffer.readLong());
            }
        }
        throw new IOException();
    }
}

