/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory.index;

import de.bwaldvogel.mongo.backend.AbstractUniqueIndex;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.KeyValue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryUniqueIndex
extends AbstractUniqueIndex<Integer> {
    private final Map<KeyValue, Integer> index = new ConcurrentHashMap<KeyValue, Integer>();

    public MemoryUniqueIndex(String name, List<IndexKey> keys, boolean sparse) {
        super(name, keys, sparse);
    }

    public long getCount() {
        return this.index.size();
    }

    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    public long getDataSize() {
        return this.getCount();
    }

    protected Integer removeDocument(KeyValue keyValue) {
        return this.index.remove(keyValue);
    }

    protected boolean putKeyPosition(KeyValue keyValue, Integer position) {
        Integer oldValue = this.index.putIfAbsent(keyValue, position);
        return oldValue == null;
    }

    protected Integer getPosition(KeyValue keyValue) {
        return this.index.get(keyValue);
    }

    protected Iterable<Map.Entry<KeyValue, Integer>> getIterable() {
        return this.index.entrySet();
    }
}

