/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class Expression {
    public static Object evaluate(Object expression, Document document) {
        if (expression instanceof String && ((String)expression).startsWith("$")) {
            String value = ((String)expression).substring(1);
            return Utils.getSubdocumentValue(document, value);
        }
        if (expression instanceof Document) {
            return Expression.evaluateDocumentExpression((Document)expression, document);
        }
        return expression;
    }

    private static Object evaluateDocumentExpression(Document expression, Document document) {
        Document result = new Document();
        for (Map.Entry<String, Object> entry : expression.entrySet()) {
            String expressionKey = entry.getKey();
            Object expressionValue = entry.getValue();
            if (expressionKey.startsWith("$")) {
                if (expression.keySet().size() > 1) {
                    throw new MongoServerError(15983, "An object representing an expression must have exactly one field: " + expression);
                }
                switch (expressionKey) {
                    case "$abs": {
                        return Expression.evaluateAbsValue(expressionValue, document);
                    }
                    case "$add": {
                        return Expression.evaluateAddValue(expressionValue, document);
                    }
                    case "$and": {
                        return Expression.evaluateAndValue(expressionValue, document);
                    }
                    case "$anyElementTrue": {
                        return Expression.evaluateAnyElementTrue(expressionValue, document);
                    }
                    case "$allElementsTrue": {
                        return Expression.evaluateAllElementsTrue(expressionValue, document);
                    }
                    case "$sum": {
                        return Expression.evaluateSumValue(expressionValue, document);
                    }
                    case "$subtract": {
                        return Expression.evaluateSubtractValue(expressionValue, document);
                    }
                    case "$year": {
                        return Expression.evaluateYearValue(expressionValue, document);
                    }
                    case "$dayOfYear": {
                        return Expression.evaluateDayOfYearValue(expressionValue, document);
                    }
                    case "$ceil": {
                        return Expression.evaluateCeilValue(expressionValue, document);
                    }
                    case "$literal": {
                        return expressionValue;
                    }
                }
                throw new MongoServerError(168, "InvalidPipelineOperator", "Unrecognized expression '" + expressionKey + "'");
            }
            result.put(expressionKey, Expression.evaluate(expressionValue, document));
        }
        return result;
    }

    private static boolean evaluateAndValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object v : collection) {
                if (Utils.isTrue(v)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean evaluateAllElementsTrue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            throw new MongoServerError(17040, "$allElementsTrue's argument must be an array, but is null");
        }
        if (!(value instanceof Collection)) {
            throw new MongoServerError(17040, "$allElementsTrue's argument must be an array, but is " + value.getClass().getName());
        }
        Collection collection = (Collection)value;
        if (collection.size() != 1) {
            throw new MongoServerError(16020, "Expression $allElementsTrue takes exactly 1 arguments. " + collection.size() + " were passed in.");
        }
        Object valueInCollection = collection.iterator().next();
        if (valueInCollection == null) {
            throw new MongoServerError(17040, "$allElementsTrue's argument must be an array, but is null");
        }
        if (!(valueInCollection instanceof Collection)) {
            throw new MongoServerError(17040, "$allElementsTrue's argument must be an array, but is " + value.getClass().getName());
        }
        Collection collectionInCollection = (Collection)valueInCollection;
        for (Object v : collectionInCollection) {
            if (Utils.isTrue(v)) continue;
            return false;
        }
        return true;
    }

    private static boolean evaluateAnyElementTrue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            throw new MongoServerError(17041, "$anyElementTrue's argument must be an array, but is null");
        }
        if (!(value instanceof Collection)) {
            throw new MongoServerError(17041, "$anyElementTrue's argument must be an array, but is " + value.getClass().getName());
        }
        Collection collection = (Collection)value;
        if (collection.size() != 1) {
            throw new MongoServerError(16020, "Expression $anyElementTrue takes exactly 1 arguments. " + collection.size() + " were passed in.");
        }
        Object valueInCollection = collection.iterator().next();
        if (valueInCollection == null) {
            throw new MongoServerError(17041, "$anyElementTrue's argument must be an array, but is null");
        }
        if (!(valueInCollection instanceof Collection)) {
            throw new MongoServerError(17041, "$anyElementTrue's argument must be an array, but is " + value.getClass().getName());
        }
        Collection collectionInCollection = (Collection)valueInCollection;
        for (Object v : collectionInCollection) {
            if (!Utils.isTrue(v)) continue;
            return true;
        }
        return false;
    }

    private static Number evaluateAbsValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return Math.abs((Double)value);
        }
        if (value instanceof Long) {
            return Math.abs((Long)value);
        }
        if (value instanceof Integer) {
            return Math.abs((Integer)value);
        }
        throw new MongoServerError(28765, "$abs only supports numeric types, not " + value.getClass());
    }

    private static Number evaluateCeilValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            long ceilValue = (long)Math.ceil((Double)value);
            if (ceilValue <= Integer.MAX_VALUE && ceilValue >= Integer.MIN_VALUE) {
                return Math.toIntExact(ceilValue);
            }
            return ceilValue;
        }
        if (value instanceof Long || value instanceof Integer) {
            return (Number)value;
        }
        throw new MongoServerError(28765, "$ceil only supports numeric types, not " + value.getClass());
    }

    private static Number evaluateSumValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Collection) {
            Number sum = 0;
            Collection collection = (Collection)value;
            for (Object v : collection) {
                Object evaluatedValue = Expression.evaluate(v, document);
                if (!(evaluatedValue instanceof Number)) continue;
                sum = Utils.addNumbers(sum, (Number)evaluatedValue);
            }
            return sum;
        }
        return 0;
    }

    private static Number evaluateAddValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (!(value instanceof Collection)) {
            throw new MongoServerError(16020, "Expression $add takes exactly 2 arguments. 1 were passed in.");
        }
        Collection values = (Collection)value;
        if (values.size() != 2) {
            throw new MongoServerError(16020, "Expression $add takes exactly 2 arguments. " + values.size() + " were passed in.");
        }
        Iterator iterator = values.iterator();
        Object one = Expression.evaluate(iterator.next(), document);
        Object other = Expression.evaluate(iterator.next(), document);
        if (!(one instanceof Number) || !(other instanceof Number)) {
            throw new MongoServerError(16556, "cant $add a " + one.getClass().getName() + " and a " + other.getClass().getName());
        }
        return Utils.addNumbers((Number)one, (Number)other);
    }

    private static Number evaluateSubtractValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (!(value instanceof Collection)) {
            throw new MongoServerError(16020, "Expression $subtract takes exactly 2 arguments. 1 were passed in.");
        }
        Collection values = (Collection)value;
        if (values.size() != 2) {
            throw new MongoServerError(16020, "Expression $subtract takes exactly 2 arguments. " + values.size() + " were passed in.");
        }
        Iterator iterator = values.iterator();
        Object one = Expression.evaluate(iterator.next(), document);
        Object other = Expression.evaluate(iterator.next(), document);
        if (!(one instanceof Number) || !(other instanceof Number)) {
            throw new MongoServerError(16556, "cant $subtract a " + one.getClass().getName() + " from a " + other.getClass().getName());
        }
        return Utils.subtractNumbers((Number)one, (Number)other);
    }

    private static Integer evaluateYearValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = Expression.getZonedDateTime(value);
        return zonedDateTime.toLocalDate().getYear();
    }

    private static Integer evaluateDayOfYearValue(Object expressionValue, Document document) {
        Object value = Expression.evaluate(expressionValue, document);
        if (value == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = Expression.getZonedDateTime(value);
        return zonedDateTime.toLocalDate().getDayOfYear();
    }

    private static ZonedDateTime getZonedDateTime(Object value) {
        if (!(value instanceof Date)) {
            throw new MongoServerError(16006, "can't convert from " + value.getClass() + " to Date");
        }
        Instant instant = ((Date)value).toInstant();
        return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
    }
}

