/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.UpdateOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractMongoCollection<P>
implements MongoCollection<P> {
    private String collectionName;
    private String databaseName;
    private final List<Index<P>> indexes = new ArrayList<Index<P>>();
    private final QueryMatcher matcher = new DefaultQueryMatcher();
    protected final String idField;

    protected AbstractMongoCollection(String databaseName, String collectionName, String idField) {
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.idField = idField;
    }

    protected boolean documentMatchesQuery(Document document, Document query) {
        return this.matcher.matches(document, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Document> queryDocuments(Document query, Document orderBy, int numberToSkip, int numberToReturn) {
        List<Index<P>> list = this.indexes;
        synchronized (list) {
            for (Index<P> index : this.indexes) {
                if (!index.canHandle(query)) continue;
                Iterable<P> positions = index.getPositions(query);
                return this.matchDocuments(query, positions, orderBy, numberToSkip, numberToReturn);
            }
        }
        return this.matchDocuments(query, orderBy, numberToSkip, numberToReturn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sortDocumentsInMemory(List<Document> documents, Document orderBy) {
        if (orderBy == null || orderBy.keySet().isEmpty()) return;
        if (orderBy.keySet().iterator().next().equals("$natural")) {
            int sortValue = (Integer)orderBy.get("$natural");
            if (sortValue == 1) return;
            if (sortValue != -1) throw new IllegalArgumentException("Illegal sort value: " + sortValue);
            Collections.reverse(documents);
            return;
        } else {
            documents.sort(new DocumentComparator(orderBy));
        }
    }

    protected abstract Iterable<Document> matchDocuments(Document var1, Document var2, int var3, int var4);

    protected abstract Iterable<Document> matchDocuments(Document var1, Iterable<P> var2, Document var3, int var4, int var5);

    protected abstract Document getDocument(P var1);

    protected abstract void updateDataSize(long var1);

    protected abstract long getDataSize();

    protected abstract P addDocumentInternal(Document var1);

    @Override
    public synchronized void addDocument(Document document) {
        for (Index<P> index : this.indexes) {
            index.checkAdd(document);
        }
        P position = this.addDocumentInternal(document);
        for (Index<P> index : this.indexes) {
            index.add(document, position);
        }
        this.updateDataSize(Utils.calculateSize(document));
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getFullName() {
        return this.getDatabaseName() + "." + this.getCollectionName();
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFullName() + ")";
    }

    @Override
    public void addIndex(Index<P> index) {
        this.indexes.add(index);
    }

    private void assertNotKeyField(String key) {
        if (key.equals(this.idField)) {
            throw new MongoServerError(10148, "Mod on " + this.idField + " not allowed");
        }
    }

    private void changeSubdocumentValue(Object document, String key, Object newValue, Integer matchPos) {
        this.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>(matchPos));
    }

    private void changeSubdocumentValue(Object document, String key, Object newValue, AtomicReference<Integer> matchPos) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                this.changeSubdocumentValue(subObject, subKey, newValue, matchPos);
            } else {
                Document obj = new Document();
                this.changeSubdocumentValue((Object)obj, subKey, newValue, matchPos);
                Utils.setListSafe(document, mainKey, obj);
            }
        } else {
            Utils.setListSafe(document, key, newValue);
        }
    }

    private Object removeSubdocumentValue(Object document, String key, Integer matchPos) {
        return this.removeSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    private Object removeSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                return this.removeSubdocumentValue(subObject, subKey, matchPos);
            }
            throw new MongoServerException("failed to remove subdocument");
        }
        return Utils.removeListSafe(document, key);
    }

    private Object getSubdocumentValue(Object document, String key, Integer matchPos) {
        return this.getSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    private Object getSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                return this.getSubdocumentValue(subObject, subKey, matchPos);
            }
            return null;
        }
        return Utils.getFieldValueListSafe(document, key);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifyField(Document document, String modifier, Document change, Integer matchPos, boolean isUpsert) {
        UpdateOperator op = this.getUpdateOperator(modifier, change);
        switch (op) {
            case SET_ON_INSERT: {
                if (!isUpsert) {
                    return;
                }
            }
            case SET: {
                for (String key : change.keySet()) {
                    Object object;
                    Object newValue = change.get(key);
                    if (Utils.nullAwareEquals(newValue, object = this.getSubdocumentValue((Object)document, key, matchPos))) continue;
                    this.assertNotKeyField(key);
                    this.changeSubdocumentValue((Object)document, key, newValue, matchPos);
                }
                return;
            }
            case UNSET: {
                for (String key : change.keySet()) {
                    this.assertNotKeyField(key);
                    this.removeSubdocumentValue((Object)document, key, matchPos);
                }
                return;
            }
            case PUSH: 
            case PUSH_ALL: 
            case ADD_TO_SET: {
                this.updatePushAllAddToSet(document, op, change, matchPos);
                return;
            }
            case PULL: 
            case PULL_ALL: {
                for (String key : change.keySet()) {
                    Object value = this.getSubdocumentValue((Object)document, key, matchPos);
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof List)) {
                        throw new MongoServerError(10142, "Cannot apply " + modifier + " modifier to non-array");
                    }
                    List<Object> list = AbstractMongoCollection.asList(value);
                    Object object = change.get(key);
                    if (modifier.equals("$pullAll")) {
                        if (!(object instanceof Collection)) {
                            throw new MongoServerError(10153, "Modifier " + modifier + " allowed for arrays only");
                        }
                        Collection collection = (Collection)object;
                        while (list.removeAll(collection)) {
                        }
                        continue;
                    }
                    Iterator<Object> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!this.matcher.matchesValue(object, obj)) continue;
                        iterator.remove();
                    }
                }
                return;
            }
            case POP: {
                for (String key : change.keySet()) {
                    Object value = this.getSubdocumentValue((Object)document, key, matchPos);
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof List)) {
                        throw new MongoServerError(10143, "Cannot apply " + modifier + " modifier to non-array");
                    }
                    List<Object> list = AbstractMongoCollection.asList(value);
                    Object object = change.get(key);
                    if (list.isEmpty()) continue;
                    if (object != null && Utils.normalizeValue(object).equals(-1.0)) {
                        list.remove(0);
                        continue;
                    }
                    list.remove(list.size() - 1);
                }
                return;
            }
            case INC: 
            case MUL: {
                for (String key : change.keySet()) {
                    Number newValue;
                    void var11_39;
                    this.assertNotKeyField(key);
                    String operation = op == UpdateOperator.INC ? "increment" : "multiply";
                    Object object = this.getSubdocumentValue((Object)document, key, matchPos);
                    if (object == null) {
                        Integer n = 0;
                    } else {
                        if (!(object instanceof Number)) throw new MongoServerException("cannot " + operation + " value '" + object + "'");
                        Number number = (Number)object;
                    }
                    Object object2 = change.get(key);
                    if (!(object2 instanceof Number)) {
                        throw new MongoServerException("cannot " + operation + " with non-numeric value: " + change);
                    }
                    Number changeValue = (Number)object2;
                    if (op == UpdateOperator.INC) {
                        newValue = Utils.addNumbers((Number)var11_39, changeValue);
                    } else {
                        if (op != UpdateOperator.MUL) throw new RuntimeException();
                        newValue = Utils.multiplyNumbers((Number)var11_39, changeValue);
                    }
                    this.changeSubdocumentValue((Object)document, key, (Object)newValue, matchPos);
                }
                return;
            }
            case MIN: 
            case MAX: {
                ValueComparator comparator = new ValueComparator();
                for (String key : change.keySet()) {
                    boolean shouldChange;
                    this.assertNotKeyField(key);
                    Object object = change.get(key);
                    Object object3 = this.getSubdocumentValue((Object)document, key, matchPos);
                    int n = comparator.compare(object, object3);
                    if (object3 == null && !Utils.hasSubdocumentValue(document, key)) {
                        shouldChange = true;
                    } else if (op == UpdateOperator.MAX) {
                        shouldChange = n > 0;
                    } else {
                        if (op != UpdateOperator.MIN) throw new RuntimeException();
                        shouldChange = n < 0;
                    }
                    if (!shouldChange) continue;
                    this.changeSubdocumentValue((Object)document, key, object, matchPos);
                }
                return;
            }
            case CURRENT_DATE: {
                for (String key : change.keySet()) {
                    void var12_52;
                    boolean bl;
                    this.assertNotKeyField(key);
                    Object object = change.get(key);
                    if (object instanceof Boolean && Utils.isTrue(object)) {
                        bl = true;
                    } else if (object instanceof Document) {
                        Object object4 = ((Document)object).get("$type");
                        if (object4.equals("timestamp")) {
                            bl = false;
                        } else {
                            if (!object4.equals("date")) throw new BadValueException("The '$type' string field is required to be 'date' or 'timestamp': " + change);
                            bl = true;
                        }
                    } else {
                        void var12_56;
                        if (object != null) {
                            String string = object.getClass().getSimpleName();
                            throw new BadValueException((String)var12_56 + " is not a valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'})");
                        } else {
                            String string = "NULL";
                        }
                        throw new BadValueException((String)var12_56 + " is not a valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'})");
                    }
                    if (bl) {
                        Date date = new Date();
                    } else {
                        BsonTimestamp bsonTimestamp = new BsonTimestamp(System.currentTimeMillis());
                    }
                    this.changeSubdocumentValue((Object)document, key, (Object)var12_52, matchPos);
                }
                return;
            }
            case RENAME: {
                LinkedHashMap<String, String> renames = new LinkedHashMap<String, String>();
                for (String string : change.keySet()) {
                    this.assertNotKeyField(string);
                    Object object = change.get(string);
                    if (!(object instanceof String)) {
                        throw new BadValueException("The 'to' field for $rename must be a string: " + object);
                    }
                    String string2 = (String)object;
                    this.assertNotKeyField(string2);
                    if (renames.containsKey(string) || renames.containsValue(string)) {
                        throw new MongoServerError(16837, "Cannot update '" + string + "' and '" + string + "' at the same time");
                    }
                    if (renames.containsKey(string2) || renames.containsValue(string2)) {
                        throw new MongoServerError(16837, "Cannot update '" + string2 + "' and '" + string2 + "' at the same time");
                    }
                    renames.put(string, string2);
                }
                for (Map.Entry entry : renames.entrySet()) {
                    Object object = this.removeSubdocumentValue((Object)document, (String)entry.getKey(), matchPos);
                    this.changeSubdocumentValue((Object)document, (String)entry.getValue(), object, matchPos);
                }
                return;
            }
            default: {
                throw new MongoServerError(10147, "Unsupported modifier: " + modifier);
            }
        }
    }

    private UpdateOperator getUpdateOperator(String modifier, Document change) {
        UpdateOperator op;
        try {
            op = UpdateOperator.fromValue(modifier);
        }
        catch (IllegalArgumentException e) {
            throw new MongoServerError(10147, "Invalid modifier specified: " + modifier);
        }
        if (op != UpdateOperator.UNSET) {
            for (String key : change.keySet()) {
                if (!key.startsWith("$")) continue;
                throw new MongoServerError(15896, "Modified field name may not start with $");
            }
        }
        return op;
    }

    private void updatePushAllAddToSet(Document document, UpdateOperator updateOperator, Document change, Integer matchPos) {
        for (String key : change.keySet()) {
            List<Object> list;
            Object value = this.getSubdocumentValue((Object)document, key, matchPos);
            if (value == null) {
                list = new ArrayList();
            } else if (value instanceof List) {
                list = AbstractMongoCollection.asList(value);
            } else {
                throw new MongoServerError(10141, "Cannot apply " + (Object)((Object)updateOperator) + " modifier to non-array");
            }
            Object changeValue = change.get(key);
            if (updateOperator == UpdateOperator.PUSH_ALL) {
                if (!(changeValue instanceof Collection)) {
                    throw new MongoServerError(10153, "Modifier " + (Object)((Object)updateOperator) + " allowed for arrays only");
                }
                Collection valueList = (Collection)changeValue;
                list.addAll(valueList);
            } else {
                ArrayList<Object> pushValues = new ArrayList<Object>();
                if (changeValue instanceof Document && ((Document)changeValue).keySet().equals(Collections.singleton("$each"))) {
                    Collection values = (Collection)((Document)changeValue).get("$each");
                    pushValues.addAll(values);
                } else {
                    pushValues.add(changeValue);
                }
                for (Object e : pushValues) {
                    if (updateOperator == UpdateOperator.PUSH) {
                        list.add(e);
                        continue;
                    }
                    if (updateOperator == UpdateOperator.ADD_TO_SET) {
                        if (list.contains(e)) continue;
                        list.add(e);
                        continue;
                    }
                    throw new MongoServerException("internal server error. illegal modifier here: " + (Object)((Object)updateOperator));
                }
            }
            this.changeSubdocumentValue((Object)document, key, list, matchPos);
        }
    }

    private void applyUpdate(Document oldDocument, Document newDocument) {
        if (newDocument.equals(oldDocument)) {
            return;
        }
        Object oldId = oldDocument.get(this.idField);
        Object newId = newDocument.get(this.idField);
        if (newId != null && !Utils.nullAwareEquals(oldId, newId)) {
            throw new MongoServerError(13596, "cannot change _id of a document old: " + oldId + ", new: " + newId);
        }
        if (newId == null && oldId != null) {
            newDocument.put(this.idField, oldId);
        }
        this.cloneInto(oldDocument, newDocument);
    }

    Object deriveDocumentId(Document selector) {
        Object value = selector.get(this.idField);
        if (value != null) {
            if (!Utils.containsQueryExpression(value)) {
                return value;
            }
            return this.deriveIdFromExpression(value);
        }
        return new ObjectId();
    }

    private Object deriveIdFromExpression(Object value) {
        Document expression = (Document)value;
        for (String key : expression.keySet()) {
            Collection list;
            Object expressionValue = expression.get(key);
            if (!key.equals("$in") || (list = (Collection)expressionValue).isEmpty()) continue;
            return list.iterator().next();
        }
        return new ObjectId();
    }

    private Document calculateUpdateDocument(Document oldDocument, Document update, Integer matchPos, boolean isUpsert) {
        int numStartsWithDollar = 0;
        for (String key : update.keySet()) {
            if (!key.startsWith("$")) continue;
            ++numStartsWithDollar;
        }
        Document newDocument = new Document(this.idField, oldDocument.get(this.idField));
        if (numStartsWithDollar == update.keySet().size()) {
            this.cloneInto(newDocument, oldDocument);
            for (String key : update.keySet()) {
                this.modifyField(newDocument, key, (Document)update.get(key), matchPos, isUpsert);
            }
        } else if (numStartsWithDollar == 0) {
            this.applyUpdate(newDocument, update);
        } else {
            throw new MongoServerException("illegal update: " + update);
        }
        return newDocument;
    }

    @Override
    public synchronized Document findAndModify(Document query) {
        boolean returnNew = Utils.isTrue(query.get("new"));
        if (!query.containsKey("remove") && !query.containsKey("update")) {
            throw new MongoServerException("need remove or update");
        }
        Document queryObject = new Document();
        if (query.containsKey("query")) {
            queryObject.put("query", query.get("query"));
        } else {
            queryObject.put("query", (Object)new Document());
        }
        if (query.containsKey("sort")) {
            queryObject.put("orderby", query.get("sort"));
        }
        Document lastErrorObject = null;
        Document returnDocument = null;
        int num = 0;
        for (Document document : this.handleQuery(queryObject, 0, 1)) {
            ++num;
            if (Utils.isTrue(query.get("remove"))) {
                this.removeDocument(document);
                returnDocument = document;
                continue;
            }
            if (query.get("update") == null) continue;
            Document updateQuery = (Document)query.get("update");
            Integer matchPos = this.matcher.matchPosition(document, (Document)queryObject.get("query"));
            Document oldDocument = this.updateDocument(document, updateQuery, matchPos);
            returnDocument = returnNew ? document : oldDocument;
            lastErrorObject = new Document("updatedExisting", Boolean.TRUE);
            lastErrorObject.put("n", (Object)1);
        }
        if (num == 0 && Utils.isTrue(query.get("upsert"))) {
            Document selector = (Document)query.get("query");
            Document updateQuery = (Document)query.get("update");
            Document newDocument = this.handleUpsert(updateQuery, selector);
            returnDocument = returnNew ? newDocument : new Document();
            ++num;
        }
        if (query.get("fields") != null) {
            Document fields = (Document)query.get("fields");
            returnDocument = AbstractMongoCollection.projectDocument(returnDocument, fields, this.idField);
        }
        Document result = new Document();
        if (lastErrorObject != null) {
            result.put("lastErrorObject", (Object)lastErrorObject);
        }
        result.put("value", (Object)returnDocument);
        Utils.markOkay(result);
        return result;
    }

    private static Document projectDocument(Document document, Document fields, String idField) {
        if (document == null) {
            return null;
        }
        Document newDocument = new Document();
        if (AbstractMongoCollection.onlyExclusions(fields)) {
            newDocument.putAll(document);
            for (String excludedField : fields.keySet()) {
                newDocument.remove(excludedField);
            }
        } else {
            for (String key : fields.keySet()) {
                if (!Utils.isTrue(fields.get(key))) continue;
                AbstractMongoCollection.projectField(document, newDocument, key);
            }
        }
        if (!fields.containsKey(idField)) {
            newDocument.put(idField, document.get(idField));
        }
        return newDocument;
    }

    private static boolean onlyExclusions(Document fields) {
        for (String key : fields.keySet()) {
            if (!Utils.isTrue(fields.get(key))) continue;
            return false;
        }
        return true;
    }

    private static void projectField(Document document, Document newDocument, String key) {
        if (document == null) {
            return;
        }
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = key.substring(dotPos + 1);
            Object object = document.get(mainKey);
            if (object instanceof Document) {
                if (!newDocument.containsKey(mainKey)) {
                    newDocument.put(mainKey, (Object)new Document());
                }
                AbstractMongoCollection.projectField((Document)object, (Document)newDocument.get(mainKey), subKey);
            }
        } else {
            newDocument.put(key, document.get(key));
        }
    }

    @Override
    public synchronized Iterable<Document> handleQuery(Document queryObject, int numberToSkip, int numberToReturn, Document fieldSelector) {
        Document orderBy;
        Document query;
        if (numberToReturn < 0) {
            numberToReturn = -numberToReturn;
        }
        if (queryObject.containsKey("query")) {
            query = (Document)queryObject.get("query");
            orderBy = (Document)queryObject.get("orderby");
        } else if (queryObject.containsKey("$query")) {
            query = (Document)queryObject.get("$query");
            orderBy = (Document)queryObject.get("$orderby");
        } else {
            query = queryObject;
            orderBy = null;
        }
        if (this.count() == 0) {
            return Collections.emptyList();
        }
        Iterable<Document> objs = this.queryDocuments(query, orderBy, numberToSkip, numberToReturn);
        if (fieldSelector != null && !fieldSelector.keySet().isEmpty()) {
            return new ProjectingIterable(objs, fieldSelector, this.idField);
        }
        return objs;
    }

    @Override
    public synchronized Document handleDistinct(Document query) {
        String key = query.get("key").toString();
        Document filter = (Document)query.get("query");
        if (filter == null) {
            filter = new Document();
        }
        TreeSet<Object> values = new TreeSet<Object>(new ValueComparator());
        for (Document document : this.queryDocuments(filter, null, 0, 0)) {
            if (!document.containsKey(key)) continue;
            values.add(document.get(key));
        }
        Document response = new Document("values", new ArrayList<Object>(values));
        Utils.markOkay(response);
        return response;
    }

    @Override
    public synchronized int insertDocuments(List<Document> documents) {
        for (Document document : documents) {
            this.addDocument(document);
        }
        return documents.size();
    }

    @Override
    public synchronized int deleteDocuments(Document selector, int limit) {
        int n = 0;
        for (Document document : this.handleQuery(selector, 0, limit)) {
            if (limit > 0 && n >= limit) {
                throw new MongoServerException("internal error: too many elements (" + n + " >= " + limit + ")");
            }
            this.removeDocument(document);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized Document updateDocuments(Document selector, Document updateQuery, boolean isMulti, boolean isUpsert) {
        if (isMulti) {
            for (String key : updateQuery.keySet()) {
                if (key.startsWith("$")) continue;
                throw new MongoServerError(10158, "multi update only works with $ operators");
            }
        }
        int nMatched = 0;
        int nModified = 0;
        for (Document document : this.queryDocuments(selector, null, 0, 0)) {
            Integer matchPos;
            Document oldDocument = this.updateDocument(document, updateQuery, matchPos = this.matcher.matchPosition(document, selector));
            if (!Utils.nullAwareEquals(oldDocument, document)) {
                ++nModified;
            }
            ++nMatched;
            if (isMulti) continue;
            break;
        }
        Document result = new Document();
        if (nMatched == 0 && isUpsert) {
            Document newDocument = this.handleUpsert(updateQuery, selector);
            if (!selector.containsKey(this.idField)) {
                result.put("upserted", newDocument.get(this.idField));
            }
        }
        result.put("n", (Object)nMatched);
        result.put("nModified", (Object)nModified);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document updateDocument(Document document, Document updateQuery, Integer matchPos) {
        Document document2 = document;
        synchronized (document2) {
            Document oldDocument = new Document();
            this.cloneInto(oldDocument, document);
            Document newDocument = this.calculateUpdateDocument(document, updateQuery, matchPos, false);
            if (!newDocument.equals(oldDocument)) {
                for (Index<P> index : this.indexes) {
                    index.checkUpdate(oldDocument, newDocument);
                }
                for (Index<P> index : this.indexes) {
                    index.updateInPlace(oldDocument, newDocument);
                }
                long oldSize = Utils.calculateSize(oldDocument);
                long newSize = Utils.calculateSize(newDocument);
                this.updateDataSize(newSize - oldSize);
                LinkedHashSet<String> fields = new LinkedHashSet<String>(document.keySet());
                fields.removeAll(newDocument.keySet());
                for (String key : fields) {
                    document.remove(key);
                }
                for (String key : newDocument.keySet()) {
                    if (key.contains(".")) {
                        throw new MongoServerException("illegal field name. must not happen as it must be caught by the driver");
                    }
                    document.put(key, newDocument.get(key));
                }
                this.handleUpdate(document);
            }
            return oldDocument;
        }
    }

    protected abstract void handleUpdate(Document var1);

    private void cloneInto(Document targetDocument, Document sourceDocument) {
        for (String key : sourceDocument.keySet()) {
            targetDocument.put(key, this.cloneValue(sourceDocument.get(key)));
        }
    }

    private Object cloneValue(Object value) {
        if (value instanceof Document) {
            Document newValue = new Document();
            this.cloneInto(newValue, (Document)value);
            return newValue;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> newValue = new ArrayList<Object>();
            for (Object v : list) {
                newValue.add(this.cloneValue(v));
            }
            return newValue;
        }
        return value;
    }

    private Document handleUpsert(Document updateQuery, Document selector) {
        Document document = this.convertSelectorToDocument(selector);
        Document newDocument = this.calculateUpdateDocument(document, updateQuery, null, true);
        if (newDocument.get(this.idField) == null) {
            newDocument.put(this.idField, this.deriveDocumentId(selector));
        }
        this.addDocument(newDocument);
        return newDocument;
    }

    Document convertSelectorToDocument(Document selector) {
        Document document = new Document();
        for (String key : selector.keySet()) {
            Object value;
            if (key.startsWith("$") || Utils.containsQueryExpression(value = selector.get(key))) continue;
            this.changeSubdocumentValue((Object)document, key, value, (AtomicReference<Integer>)null);
        }
        return document;
    }

    @Override
    public int getNumIndexes() {
        return this.indexes.size();
    }

    @Override
    public int count(Document query, int skip, int limit) {
        if (query.keySet().isEmpty()) {
            int count = this.count();
            if (skip > 0) {
                count = Math.max(0, count - skip);
            }
            if (limit > 0) {
                return Math.min(limit, count);
            }
            return count;
        }
        int numberToReturn = limit >= 0 ? limit : 0;
        int count = 0;
        Iterator<Document> it = this.queryDocuments(query, null, skip, numberToReturn).iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Document getStats() {
        long dataSize = this.getDataSize();
        Document response = new Document("ns", this.getFullName());
        response.put("count", (Object)this.count());
        response.put("size", (Object)dataSize);
        double averageSize = 0.0;
        if (this.count() > 0) {
            averageSize = (double)dataSize / (double)this.count();
        }
        response.put("avgObjSize", (Object)averageSize);
        response.put("storageSize", (Object)0);
        response.put("numExtents", (Object)0);
        response.put("nindexes", (Object)this.indexes.size());
        Document indexSizes = new Document();
        for (Index<P> index : this.indexes) {
            indexSizes.put(index.getName(), (Object)index.getDataSize());
        }
        response.put("indexSize", (Object)indexSizes);
        Utils.markOkay(response);
        return response;
    }

    @Override
    public synchronized void removeDocument(Document document) {
        P position = null;
        if (!this.indexes.isEmpty()) {
            for (Index<P> index : this.indexes) {
                position = index.remove(document);
            }
        } else {
            position = this.findDocumentPosition(document);
        }
        if (position == null) {
            return;
        }
        this.updateDataSize(-Utils.calculateSize(document));
        this.removeDocument(position);
    }

    @Override
    public Document validate() {
        Document response = new Document("ns", this.getFullName());
        response.put("extentCount", (Object)0);
        response.put("datasize", (Object)this.getDataSize());
        response.put("nrecords", (Object)this.count());
        response.put("nIndexes", (Object)this.indexes.size());
        Document keysPerIndex = new Document();
        for (Index<P> index : this.indexes) {
            keysPerIndex.put(index.getName(), (Object)index.getCount());
        }
        response.put("keysPerIndex", (Object)keysPerIndex);
        response.put("valid", (Object)Boolean.TRUE);
        response.put("errors", (Object)Collections.emptyList());
        Utils.markOkay(response);
        return response;
    }

    @Override
    public void renameTo(String newDatabaseName, String newCollectionName) {
        this.databaseName = newDatabaseName;
        this.collectionName = newCollectionName;
    }

    protected abstract void removeDocument(P var1);

    protected abstract P findDocumentPosition(Document var1);

    private static List<Object> asList(Object value) {
        return (List)value;
    }

    private static class ProjectingIterable
    implements Iterable<Document> {
        private Iterable<Document> iterable;
        private Document fieldSelector;
        private String idField;

        ProjectingIterable(Iterable<Document> iterable, Document fieldSelector, String idField) {
            this.iterable = iterable;
            this.fieldSelector = fieldSelector;
            this.idField = idField;
        }

        @Override
        public Iterator<Document> iterator() {
            return new ProjectingIterator(this.iterable.iterator(), this.fieldSelector, this.idField);
        }
    }

    private static class ProjectingIterator
    implements Iterator<Document> {
        private Iterator<Document> iterator;
        private Document fieldSelector;
        private String idField;

        ProjectingIterator(Iterator<Document> iterator, Document fieldSelector, String idField) {
            this.iterator = iterator;
            this.fieldSelector = fieldSelector;
            this.idField = idField;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Document next() {
            Document document = this.iterator.next();
            return AbstractMongoCollection.projectDocument(document, this.fieldSelector, this.idField);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

