/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.DuplicateKeyError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;

public abstract class AbstractUniqueIndex<P>
extends Index<P> {
    protected AbstractUniqueIndex(String key, boolean ascending) {
        super(key, ascending);
    }

    protected abstract P removeDocument(Object var1);

    protected abstract boolean containsKey(Object var1);

    protected abstract boolean putKeyPosition(Object var1, P var2);

    protected abstract Iterable<Map.Entry<Object, P>> getIterable();

    protected abstract P getPosition(Object var1);

    @Override
    public synchronized P remove(Document document) {
        Object key = this.getKey(document);
        return this.removeDocument(key);
    }

    @Override
    public synchronized void checkAdd(Document document) throws MongoServerError {
        if (!Utils.hasSubdocumentValue(document, this.key)) {
            return;
        }
        Object key = this.getKey(document);
        if (this.containsKey(key)) {
            throw new DuplicateKeyError(this, key);
        }
    }

    @Override
    public synchronized void add(Document document, P position) throws MongoServerError {
        this.checkAdd(document);
        if (!Utils.hasSubdocumentValue(document, this.key)) {
            return;
        }
        Object key = this.getKey(document);
        boolean added = this.putKeyPosition(key, position);
        if (!added) {
            throw new IllegalStateException("Position " + position + " already exists. Concurrency issue?");
        }
    }

    @Override
    public void checkUpdate(Document oldDocument, Document newDocument) throws MongoServerError {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
        this.checkAdd(newDocument);
    }

    @Override
    public void updateInPlace(Document oldDocument, Document newDocument) throws KeyConstraintError {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
    }

    @Override
    public synchronized boolean canHandle(Document query) {
        if (!query.keySet().equals(Collections.singleton(this.key))) {
            return false;
        }
        Object queryValue = query.get(this.key);
        if (queryValue instanceof Document) {
            for (String key : ((Document)queryValue).keySet()) {
                if (AbstractUniqueIndex.isInQuery(key) || !key.startsWith("$")) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInQuery(String key) {
        return key.equals(QueryOperator.IN.getValue());
    }

    @Override
    public synchronized Iterable<P> getPositions(Document query) {
        P position;
        Object keyValue = Utils.normalizeValue(query.get(this.key));
        if (keyValue instanceof Document) {
            Document keyObj = (Document)keyValue;
            if (Utils.containsQueryExpression(keyObj)) {
                if (keyObj.keySet().size() != 1) {
                    throw new UnsupportedOperationException("illegal query key: " + keyValue);
                }
                String expression = keyObj.keySet().iterator().next();
                if (expression.startsWith("$")) {
                    return this.getPositionsForExpression(keyObj, expression);
                }
            }
        } else if (keyValue instanceof BsonRegularExpression) {
            ArrayList<P> positions = new ArrayList<P>();
            for (Map.Entry<Object, P> entry : this.getIterable()) {
                Object obj = entry.getKey();
                Matcher matcher = ((BsonRegularExpression)keyValue).matcher(obj.toString());
                if (!matcher.find()) continue;
                positions.add(entry.getValue());
            }
            return positions;
        }
        if ((position = this.getPosition(keyValue)) == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(position);
    }

    private boolean nullAwareEqualsKeys(Document oldDocument, Document newDocument) {
        Object oldKey = this.getKey(oldDocument);
        Object newKey = this.getKey(newDocument);
        return Utils.nullAwareEquals(oldKey, newKey);
    }

    private Iterable<P> getPositionsForExpression(Document keyObj, String operator) {
        if (AbstractUniqueIndex.isInQuery(operator)) {
            TreeSet queriedObjects = new TreeSet((Collection)keyObj.get(operator));
            ArrayList<P> allKeys = new ArrayList<P>();
            for (Object object : queriedObjects) {
                Object keyValue = Utils.normalizeValue(object);
                P key = this.getPosition(keyValue);
                if (key == null) continue;
                allKeys.add(key);
            }
            return allKeys;
        }
        throw new UnsupportedOperationException("unsupported query expression: " + operator);
    }
}

