/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.backend.Utils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

class BsonDecoder {
    BsonDecoder() {
    }

    public BSONObject decodeBson(ByteBuf buffer) throws IOException {
        int totalObjectLength = buffer.readInt();
        int length = totalObjectLength - 4;
        if (buffer.readableBytes() < length) {
            throw new IOException("Too few bytes to read: " + buffer.readableBytes() + ". Expected: " + length);
        }
        if (length > 0x1000000) {
            throw new IOException("BSON object too large: " + length + " bytes");
        }
        BasicBSONObject object = new BasicBSONObject();
        int start = buffer.readerIndex();
        while (buffer.readerIndex() - start < length) {
            byte type = buffer.readByte();
            if (type == 0) {
                return object;
            }
            String name = this.decodeCString(buffer);
            Object value = this.decodeValue(type, buffer);
            object.put(name, value);
        }
        throw new IOException("illegal BSON object");
    }

    private Object decodeValue(byte type, ByteBuf buffer) throws IOException {
        Object value;
        switch (type) {
            case 1: {
                value = buffer.readDouble();
                break;
            }
            case 2: {
                value = this.decodeString(buffer);
                break;
            }
            case 3: {
                value = this.decodeBson(buffer);
                break;
            }
            case 4: {
                value = this.decodeArray(buffer);
                break;
            }
            case 5: {
                value = this.decodeBinary(buffer);
                break;
            }
            case 6: {
                value = null;
                break;
            }
            case 7: {
                value = this.decodeObjectId(buffer);
                break;
            }
            case 8: {
                value = this.decodeBoolean(buffer);
                break;
            }
            case 9: {
                value = new Date(buffer.readLong());
                break;
            }
            case 10: {
                value = null;
                break;
            }
            case 11: {
                value = this.decodePattern(buffer);
                break;
            }
            case 16: {
                value = buffer.readInt();
                break;
            }
            case 17: {
                value = new BSONTimestamp(buffer.readInt(), buffer.readInt());
                break;
            }
            case 18: {
                value = buffer.readLong();
                break;
            }
            case 127: {
                value = new MaxKey();
                break;
            }
            case -1: {
                value = new MinKey();
                break;
            }
            case 13: 
            case 15: {
                throw new IOException("unhandled type: 0x" + Integer.toHexString(type));
            }
            default: {
                throw new IOException("unknown type: 0x" + Integer.toHexString(type));
            }
        }
        return value;
    }

    private Pattern decodePattern(ByteBuf buffer) throws IOException {
        String regex = this.decodeCString(buffer);
        String options = this.decodeCString(buffer);
        return Utils.createPattern(regex, options);
    }

    private List<Object> decodeArray(ByteBuf buffer) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        BSONObject arrayObject = this.decodeBson(buffer);
        for (String key : arrayObject.keySet()) {
            array.add(arrayObject.get(key));
        }
        return array;
    }

    private ObjectId decodeObjectId(ByteBuf buffer) {
        byte[] b = new byte[12];
        buffer.readBytes(b);
        return new ObjectId(b);
    }

    private String decodeString(ByteBuf buffer) throws IOException {
        int length = buffer.readInt();
        byte[] data = new byte[length - 1];
        buffer.readBytes(data);
        String s = new String(data, "UTF-8");
        byte trail = buffer.readByte();
        if (trail != 0) {
            throw new IOException();
        }
        return s;
    }

    String decodeCString(ByteBuf buffer) throws IOException {
        int length = buffer.bytesBefore((byte)0);
        if (length < 0) {
            throw new IOException("string termination not found");
        }
        String result = buffer.toString(buffer.readerIndex(), length, Charset.forName("UTF-8"));
        buffer.skipBytes(length + 1);
        return result;
    }

    private Object decodeBinary(ByteBuf buffer) throws IOException {
        int length = buffer.readInt();
        byte subtype = buffer.readByte();
        switch (subtype) {
            case -128: 
            case 0: {
                byte[] data = new byte[length];
                buffer.readBytes(data);
                return data;
            }
            case 3: 
            case 4: {
                if (length != 16) {
                    throw new IOException();
                }
                return new UUID(buffer.readLong(), buffer.readLong());
            }
        }
        throw new IOException();
    }

    private Object decodeBoolean(ByteBuf buffer) throws IOException {
        switch (buffer.readByte()) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new IOException("illegal boolean value");
    }
}

