/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.wire.BsonDecoder;
import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.QueryFlag;
import de.bwaldvogel.mongo.wire.UpdateFlag;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoWireProtocolHandler
extends LengthFieldBasedFrameDecoder {
    public static final int MAX_MESSAGE_SIZE_BYTES = 48000000;
    public static final int MAX_WIRE_VERSION = 2;
    public static final int MIN_WIRE_VERSION = 0;
    public static final int MAX_WRITE_BATCH_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private static final int maxFrameLength = Integer.MAX_VALUE;
    private static final int lengthFieldOffset = 0;
    private static final int lengthFieldLength = 4;
    private static final int lengthAdjustment = -4;
    private static final int initialBytesToStrip = 0;
    private final BsonDecoder bsonDecoder = new BsonDecoder();

    public MongoWireProtocolHandler() {
        super(Integer.MAX_VALUE, 0, 4, -4, 0);
    }

    protected ClientRequest decode(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        ClientRequest ret;
        ByteBuf in = buf.order(ByteOrder.LITTLE_ENDIAN);
        if (in.readableBytes() < 4) {
            return null;
        }
        in.markReaderIndex();
        int totalLength = in.readInt();
        if (totalLength > 48000000) {
            throw new IOException("message too large: " + totalLength + " bytes");
        }
        if (in.readableBytes() < totalLength - 4) {
            in.resetReaderIndex();
            return null;
        }
        int readable = (in = in.readSlice(totalLength - 4)).readableBytes();
        if (readable != totalLength - 4) {
            throw new IllegalStateException();
        }
        int requestID = in.readInt();
        int responseTo = in.readInt();
        MessageHeader header = new MessageHeader(requestID, responseTo);
        int opCodeId = in.readInt();
        OpCode opCode = OpCode.getById(opCodeId);
        if (opCode == null) {
            throw new IOException("opCode " + opCodeId + " not supported");
        }
        Channel channel = ctx.channel();
        switch (opCode) {
            case OP_QUERY: {
                ret = this.handleQuery(channel, header, in);
                break;
            }
            case OP_INSERT: {
                ret = this.handleInsert(channel, header, in);
                break;
            }
            case OP_DELETE: {
                ret = this.handleDelete(channel, header, in);
                break;
            }
            case OP_UPDATE: {
                ret = this.handleUpdate(channel, header, in);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported opcode: " + (Object)((Object)opCode));
            }
        }
        if (in.isReadable()) {
            throw new IOException();
        }
        return ret;
    }

    private ClientRequest handleDelete(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        buffer.skipBytes(4);
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        int flags = buffer.readInt();
        boolean singleRemove = false;
        if (flags != 0) {
            if (flags == 1) {
                singleRemove = true;
            } else {
                throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
            }
        }
        BSONObject selector = this.bsonDecoder.decodeBson(buffer);
        log.debug("delete {} from {}", (Object)selector, (Object)fullCollectionName);
        return new MongoDelete(channel, header, fullCollectionName, selector, singleRemove);
    }

    private ClientRequest handleUpdate(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        buffer.skipBytes(4);
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        int flags = buffer.readInt();
        boolean upsert = UpdateFlag.UPSERT.isSet(flags);
        boolean multi = UpdateFlag.MULTI_UPDATE.isSet(flags);
        BSONObject selector = this.bsonDecoder.decodeBson(buffer);
        BSONObject update = this.bsonDecoder.decodeBson(buffer);
        log.debug("update {} in {}", (Object)selector, (Object)fullCollectionName);
        return new MongoUpdate(channel, header, fullCollectionName, selector, update, upsert, multi);
    }

    private ClientRequest handleInsert(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        int flags = buffer.readInt();
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        ArrayList<BSONObject> documents = new ArrayList<BSONObject>();
        while (buffer.isReadable()) {
            BSONObject document = this.bsonDecoder.decodeBson(buffer);
            if (document == null) {
                return null;
            }
            documents.add(document);
        }
        log.debug("insert {} in {}", documents, (Object)fullCollectionName);
        return new MongoInsert(channel, header, fullCollectionName, documents);
    }

    private ClientRequest handleQuery(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        int flags = buffer.readInt();
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        int numberToSkip = buffer.readInt();
        int numberToReturn = buffer.readInt();
        BSONObject query = this.bsonDecoder.decodeBson(buffer);
        BSONObject returnFieldSelector = null;
        if (buffer.isReadable()) {
            returnFieldSelector = this.bsonDecoder.decodeBson(buffer);
        }
        MongoQuery mongoQuery = new MongoQuery(channel, header, fullCollectionName, numberToSkip, numberToReturn, query, returnFieldSelector);
        if (QueryFlag.SLAVE_OK.isSet(flags)) {
            flags = QueryFlag.SLAVE_OK.removeFrom(flags);
        }
        if (QueryFlag.NO_CURSOR_TIMEOUT.isSet(flags)) {
            flags = QueryFlag.NO_CURSOR_TIMEOUT.removeFrom(flags);
        }
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        log.debug("query {} from {}", (Object)query, (Object)fullCollectionName);
        return mongoQuery;
    }
}

