/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.AsyncMongoBackend;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.ServerVersion;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.util.FutureUtils;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoGetMore;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoKillCursors;
import de.bwaldvogel.mongo.wire.message.MongoMessage;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.Channel;
import java.time.Clock;
import java.util.Collection;
import java.util.concurrent.CompletionStage;

public interface MongoBackend
extends AsyncMongoBackend {
    public void handleClose(Channel var1);

    @Override
    default public CompletionStage<Void> handleCloseAsync(Channel channel) {
        return FutureUtils.wrap(() -> {
            this.handleClose(channel);
            return null;
        });
    }

    public Document handleCommand(Channel var1, String var2, String var3, Document var4);

    @Override
    default public CompletionStage<Document> handleCommandAsync(Channel channel, String database, String command, Document query) {
        return FutureUtils.wrap(() -> this.handleCommand(channel, database, command, query));
    }

    public QueryResult handleQuery(MongoQuery var1);

    @Override
    default public CompletionStage<QueryResult> handleQueryAsync(MongoQuery query) {
        return FutureUtils.wrap(() -> this.handleQuery(query));
    }

    public QueryResult handleGetMore(long var1, int var3);

    public QueryResult handleGetMore(MongoGetMore var1);

    @Override
    default public CompletionStage<QueryResult> handleGetMoreAsync(MongoGetMore getMore) {
        return FutureUtils.wrap(() -> this.handleGetMore(getMore));
    }

    public void handleInsert(MongoInsert var1);

    @Override
    default public CompletionStage<Void> handleInsertAsync(MongoInsert insert) {
        return FutureUtils.wrap(() -> {
            this.handleInsert(insert);
            return null;
        });
    }

    public void handleDelete(MongoDelete var1);

    @Override
    default public CompletionStage<Void> handleDeleteAsync(MongoDelete delete) {
        return FutureUtils.wrap(() -> {
            this.handleDelete(delete);
            return null;
        });
    }

    public void handleUpdate(MongoUpdate var1);

    @Override
    default public CompletionStage<Void> handleUpdateAsync(MongoUpdate update) {
        return FutureUtils.wrap(() -> {
            this.handleUpdate(update);
            return null;
        });
    }

    public void handleKillCursors(MongoKillCursors var1);

    @Override
    default public CompletionStage<Void> handleKillCursorsAsync(MongoKillCursors mongoKillCursors) {
        return FutureUtils.wrap(() -> {
            this.handleKillCursors(mongoKillCursors);
            return null;
        });
    }

    public Document handleMessage(MongoMessage var1);

    @Override
    default public CompletionStage<Document> handleMessageAsync(MongoMessage message) {
        return FutureUtils.wrap(() -> this.handleMessage(message));
    }

    public void dropDatabase(String var1);

    @Override
    default public CompletionStage<Void> dropDatabaseAsync(String database) {
        return FutureUtils.wrap(() -> {
            this.dropDatabase(database);
            return null;
        });
    }

    public Collection<Document> getCurrentOperations(MongoQuery var1);

    public Document getServerStatus();

    public void close();

    @Override
    default public CompletionStage<Void> closeAsync() {
        return FutureUtils.wrap(() -> {
            this.close();
            return null;
        });
    }

    public Clock getClock();

    public void enableOplog();

    public void disableOplog();

    public MongoDatabase resolveDatabase(String var1);

    public MongoBackend version(ServerVersion var1);
}

